/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.rdbms.ojb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.TransactionAbortedException;
import org.apache.ojb.broker.TransactionInProgressException;
import org.apache.ojb.broker.TransactionNotInProgressException;
import org.apache.ojb.broker.accesslayer.ConnectionFactory;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryFactory;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.accesslayer.OJBBatchUpdateException;
import org.apache.ojb.broker.metadata.ConnectionPoolDescriptor;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.platforms.PlatformFactory;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.batch.BatchConnection;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ConnectionManagerImpl
implements ConnectionManagerIF {
    private Logger log = LoggerFactory.getLogger(ConnectionManagerImpl.class);
    private PersistenceBroker broker = null;
    private ConnectionFactory connectionFactory;
    private JdbcConnectionDescriptor jcd;
    private Platform platform;
    private Connection con = null;
    private PBKey pbKey;
    private boolean originalAutoCommitState;
    private boolean isInLocalTransaction;
    private boolean batchMode;
    private BatchConnection batchCon = null;
    private static Map connectionFactories = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionManagerImpl(PersistenceBroker broker) {
        this.broker = broker;
        this.pbKey = broker.getPBKey();
        this.jcd = MetadataManager.getInstance().connectionRepository().getDescriptor(this.pbKey);
        ConnectionPoolDescriptor cpd = this.jcd.getConnectionPoolDescriptor();
        if (cpd != null && cpd.getConnectionFactory() != null) {
            this.connectionFactory = (ConnectionFactory)connectionFactories.get(cpd.getConnectionFactory());
            if (this.connectionFactory == null) {
                try {
                    if (Boolean.valueOf(this.jcd.getAttribute("org.apache.jetspeed.engineScoped", "false")).booleanValue()) {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                            this.connectionFactory = (ConnectionFactory)ClassHelper.newInstance((Class)cpd.getConnectionFactory(), (boolean)true);
                            connectionFactories.put(cpd.getConnectionFactory(), this.connectionFactory);
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(cl);
                            connectionFactories.put(cpd.getConnectionFactory(), this.connectionFactory);
                        }
                    }
                    this.connectionFactory = (ConnectionFactory)ClassHelper.newInstance((Class)cpd.getConnectionFactory(), (boolean)true);
                }
                catch (InstantiationException e) {
                    String err = "Can't instantiate class " + cpd.getConnectionFactory();
                    this.log.error((Object)err, (Throwable)e);
                    throw (IllegalStateException)new IllegalStateException(err).initCause(e);
                }
                catch (IllegalAccessException e) {
                    String err = "Can't instantiate class " + cpd.getConnectionFactory();
                    this.log.error((Object)err, (Throwable)e);
                    throw (IllegalStateException)new IllegalStateException(err).initCause(e);
                }
            }
        } else {
            this.connectionFactory = ConnectionFactoryFactory.getInstance().createConnectionFactory();
        }
        this.platform = PlatformFactory.getPlatformFor((JdbcConnectionDescriptor)this.jcd);
        this.setBatchMode(false);
    }

    public JdbcConnectionDescriptor getConnectionDescriptor() {
        return this.jcd;
    }

    public Platform getSupportedPlatform() {
        return this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws LookupException {
        if (this.con != null && !this.isInLocalTransaction() && !this.isAlive(this.con)) {
            this.releaseConnection();
        }
        if (this.con == null) {
            if (Boolean.valueOf(this.jcd.getAttribute("org.apache.jetspeed.engineScoped", "false")).booleanValue()) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    this.con = this.connectionFactory.lookupConnection(this.jcd);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            } else {
                this.con = this.connectionFactory.lookupConnection(this.jcd);
            }
            if (this.con == null) {
                throw new PersistenceBrokerException("Cannot get connection for " + this.jcd);
            }
            if (this.jcd.getUseAutoCommit() == 1) {
                try {
                    this.originalAutoCommitState = this.con.getAutoCommit();
                }
                catch (SQLException e) {
                    throw new PersistenceBrokerException("Cannot request autoCommit state on the connection", (Throwable)e);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Request new connection from ConnectionFactory: " + this.con));
            }
        }
        if (this.isBatchMode()) {
            if (this.batchCon == null) {
                this.batchCon = new BatchConnection(this.con, this.broker);
            }
            return this.batchCon;
        }
        return this.con;
    }

    public void localBegin() {
        if (this.isInLocalTransaction) {
            throw new TransactionInProgressException("Connection is already in transaction");
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (LookupException e) {
            throw new PersistenceBrokerException("Can't lookup a connection", (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("localBegin was called for con " + connection));
        }
        if (this.jcd.getUseAutoCommit() == 1) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Try to change autoCommit state to 'false'");
            }
            this.platform.changeAutoCommitState(this.jcd, connection, false);
        }
        this.isInLocalTransaction = true;
    }

    public void localCommit() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"commit was called");
        }
        if (!this.isInLocalTransaction) {
            throw new TransactionNotInProgressException("Not in transaction, call begin() before commit()");
        }
        try {
            if (this.batchCon != null) {
                this.batchCon.commit();
            } else if (this.con != null) {
                this.con.commit();
            }
        }
        catch (SQLException e) {
            this.log.error((Object)"Commit on underlying connection failed, try to rollback connection", (Throwable)e);
            this.localRollback();
            throw new TransactionAbortedException("Commit on connection failed", (Throwable)e);
        }
        finally {
            this.isInLocalTransaction = false;
            this.restoreAutoCommitState();
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localRollback() {
        this.log.info((Object)("Rollback was called, do rollback on current connection " + this.con));
        if (!this.isInLocalTransaction) {
            throw new PersistenceBrokerException("Not in transaction, cannot abort");
        }
        try {
            this.isInLocalTransaction = false;
            if (this.batchCon != null) {
                this.batchCon.rollback();
            } else if (this.con != null && !this.con.isClosed()) {
                this.con.rollback();
            }
        }
        catch (SQLException e) {
            this.log.error((Object)"Rollback on the underlying connection failed", (Throwable)e);
        }
        finally {
            try {
                this.restoreAutoCommitState();
            }
            catch (OJBRuntimeException oJBRuntimeException) {}
            this.releaseConnection();
        }
    }

    protected void restoreAutoCommitState() {
        try {
            if (this.jcd.getUseAutoCommit() == 1 && this.originalAutoCommitState && this.con != null && !this.con.isClosed()) {
                this.platform.changeAutoCommitState(this.jcd, this.con, true);
            }
        }
        catch (SQLException e) {
            throw new OJBRuntimeException("Restore of connection autocommit state failed", (Throwable)e);
        }
    }

    public boolean isAlive(Connection conn) {
        try {
            return this.con != null ? !this.con.isClosed() : false;
        }
        catch (SQLException e) {
            this.log.error((Object)"IsAlive check failed, running connection was invalid!!", (Throwable)e);
            return false;
        }
    }

    public boolean isInLocalTransaction() {
        return this.isInLocalTransaction;
    }

    public void releaseConnection() {
        if (this.con == null) {
            return;
        }
        if (this.isInLocalTransaction()) {
            this.log.error((Object)"Release connection: connection is in local transaction, missing 'localCommit' or 'localRollback' call - try to rollback the connection");
            this.localRollback();
        } else {
            this.connectionFactory.releaseConnection(this.jcd, this.con);
            this.con = null;
            this.batchCon = null;
        }
    }

    public ConnectionFactory getUnderlyingConnectionFactory() {
        return this.connectionFactory;
    }

    public void setBatchMode(boolean mode) {
        this.batchMode = mode && this.jcd.getBatchMode();
    }

    public boolean isBatchMode() {
        return this.batchMode && this.platform.supportsBatchOperations();
    }

    public void executeBatch() throws OJBBatchUpdateException {
        if (this.batchCon != null) {
            try {
                this.batchCon.executeBatch();
            }
            catch (Throwable th) {
                throw new OJBBatchUpdateException(th);
            }
        }
    }

    public void executeBatchIfNecessary() throws OJBBatchUpdateException {
        if (this.batchCon != null) {
            try {
                this.batchCon.executeBatchIfNecessary();
            }
            catch (Throwable th) {
                throw new OJBBatchUpdateException(th);
            }
        }
    }

    public void clearBatch() {
        if (this.batchCon != null) {
            this.batchCon.clearBatch();
        }
    }
}

