/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.jndi;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.jetspeed.util.DelegatingObjectProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.jndi.JndiObjectFactoryBean;

public class DebuggingDataSourceJndiObjectFactoryBean
extends JndiObjectFactoryBean
implements DisposableBean {
    private static final Logger statisticsLog = LoggerFactory.getLogger((String)"org.apache.jetspeed.ds.statistics");
    private static final Logger openConnectionsLog = LoggerFactory.getLogger((String)"org.apache.jetspeed.ds.connections");
    private Object mutex = new Object();
    private DataSourceWrapper cachedWrapper;
    private int connectionSequence;
    private boolean debug;
    private HashMap<Integer, ConnectionWrapper> cachedConnections = new HashMap();
    private HashMap<Integer, ConnectionCallStatistics> connectionsCallStatistics = new HashMap();
    private String[] debugCallStackPackages = new String[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        System.out.print("*** FLUSHING Datasource Wrapper now....");
        Object object = this.mutex;
        synchronized (object) {
            this.debug = true;
            this.dumpLog();
            openConnectionsLog.info("-------------------------------------------------------------------------------");
            openConnectionsLog.info("open connections log flushed.");
            statisticsLog.info("-------------------------------------------------------------------------------");
            statisticsLog.info("data source statistics log flushed.");
        }
        System.out.println("...flush completed. ***");
    }

    public void setDebugCallStackPackages(List list) {
        if (list != null && !list.isEmpty()) {
            this.debugCallStackPackages = list.toArray(new String[list.size()]);
        }
    }

    public void afterPropertiesSet() throws IllegalArgumentException, NamingException {
        super.afterPropertiesSet();
        this.debug = statisticsLog.isDebugEnabled();
        if (this.debug) {
            statisticsLog.debug("Starting collecting Datasource connection call statistics");
            if (openConnectionsLog.isDebugEnabled()) {
                openConnectionsLog.debug("Starting monitoring open Datasource connections");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        DataSource ds = (DataSource)super.getObject();
        if (this.debug) {
            DebuggingDataSourceJndiObjectFactoryBean debuggingDataSourceJndiObjectFactoryBean = this;
            synchronized (debuggingDataSourceJndiObjectFactoryBean) {
                if (this.cachedWrapper == null || this.cachedWrapper.ds != ds) {
                    this.cachedWrapper = new DataSourceWrapper(ds);
                }
                DataSource dsProxy = (DataSource)DelegatingObjectProxy.createProxy((Class[])new Class[]{DataSource.class}, (Object[])new Object[]{this.cachedWrapper, ds});
                return dsProxy;
            }
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection recordConnection(Connection connection) {
        long startTime = System.currentTimeMillis();
        Object object = this.mutex;
        synchronized (object) {
            String callStack;
            if (this.debug && (callStack = this.getJetspeedCallStack(Thread.currentThread().getStackTrace())) != null) {
                Integer statisticsKey = new Integer(callStack.hashCode());
                ConnectionCallStatistics statistics = this.connectionsCallStatistics.get(statisticsKey);
                if (statistics == null) {
                    statistics = new ConnectionCallStatistics();
                    statistics.callStack = callStack;
                    this.connectionsCallStatistics.put(statisticsKey, statistics);
                }
                ++statistics.callCount;
                Integer connectionKey = new Integer(this.connectionSequence++);
                ConnectionWrapper cw = new ConnectionWrapper(connection, connectionKey, statisticsKey, startTime);
                connection = (Connection)DelegatingObjectProxy.createProxy((Class[])new Class[]{Connection.class}, (Object[])new Object[]{cw, connection});
                this.cachedConnections.put(connectionKey, cw);
            }
        }
        return connection;
    }

    private void dumpLog() {
        long currentTime = System.currentTimeMillis();
        ConnectionCallStatistics[] statistics = this.connectionsCallStatistics.values().toArray(new ConnectionCallStatistics[this.connectionsCallStatistics.size()]);
        if (statistics.length > 1) {
            Arrays.sort(statistics, new Comparator<ConnectionCallStatistics>(){

                @Override
                public int compare(ConnectionCallStatistics o1, ConnectionCallStatistics o2) {
                    return o1.callCount == o2.callCount ? 0 : (o1.callCount > o2.callCount ? -1 : 1);
                }
            });
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("The following " + statistics.length + " DataSource connection call stacks where recorded, sorted by number of calls: \n");
        int index = 1;
        for (ConnectionCallStatistics ccs : statistics) {
            buffer.append("\n");
            buffer.append("  call stack nr: ");
            buffer.append(index++);
            buffer.append(", calls: ");
            buffer.append(ccs.callCount);
            buffer.append(", min.duration: ");
            buffer.append(DebuggingDataSourceJndiObjectFactoryBean.formatDuration(ccs.minDuration));
            buffer.append(", max.duration: ");
            buffer.append(DebuggingDataSourceJndiObjectFactoryBean.formatDuration(ccs.maxDuration));
            buffer.append(", acc.duration: ");
            buffer.append(DebuggingDataSourceJndiObjectFactoryBean.formatDuration(ccs.accumulatedDuration));
            buffer.append(", avg.duration: ");
            buffer.append(DebuggingDataSourceJndiObjectFactoryBean.formatDuration(ccs.accumulatedDuration / (long)ccs.callCount));
            buffer.append(", tot.overhead: ");
            buffer.append(DebuggingDataSourceJndiObjectFactoryBean.formatDuration(ccs.totalOverhead));
            buffer.append(", avg.overhead: ");
            buffer.append(DebuggingDataSourceJndiObjectFactoryBean.formatDuration(ccs.totalOverhead / (long)ccs.callCount));
            buffer.append("\n");
            buffer.append(ccs.callStack);
            buffer.append("\n");
        }
        statisticsLog.debug(buffer.toString());
        if (openConnectionsLog.isDebugEnabled()) {
            ConnectionWrapper[] connectionWrappers;
            for (ConnectionWrapper cw : connectionWrappers = this.cachedConnections.values().toArray(new ConnectionWrapper[this.cachedConnections.size()])) {
                cw.duration = currentTime - cw.duration;
            }
            if (connectionWrappers.length > 1) {
                Arrays.sort(connectionWrappers, new Comparator<ConnectionWrapper>(){

                    @Override
                    public int compare(ConnectionWrapper o1, ConnectionWrapper o2) {
                        return o1.duration == o2.duration ? 0 : (o1.duration > o2.duration ? -1 : 1);
                    }
                });
            }
            buffer.setLength(0);
            buffer.append("The following " + connectionWrappers.length + " connections where still active, sorted by the duration since creation: \n");
            index = 1;
            for (ConnectionWrapper cw : connectionWrappers) {
                buffer.append("\n");
                buffer.append("  connection nr: ");
                buffer.append(index++);
                buffer.append(", duration: ");
                buffer.append(DebuggingDataSourceJndiObjectFactoryBean.formatDuration(cw.duration));
                buffer.append("\n");
                buffer.append(this.connectionsCallStatistics.get((Object)((ConnectionWrapper)cw).statisticsKey).callStack);
                buffer.append("\n");
            }
            openConnectionsLog.debug(buffer.toString());
        }
        this.connectionsCallStatistics.clear();
        this.cachedConnections.clear();
    }

    private static String formatDuration(long duration) {
        long seconds = duration / 1000L;
        long millis = duration - seconds;
        return "" + seconds + "." + (millis < 100L ? (millis < 10L ? "00" : "0") : "") + millis + "s";
    }

    private String getJetspeedCallStack(StackTraceElement[] ste) {
        String callStack = null;
        block0: for (int i = 1; ste != null && i < ste.length; ++i) {
            if (!ste[i].getClassName().startsWith("org.apache.jetspeed.components.jndi.DebuggingDataSourceJndiObjectFactoryBean$DataSourceWrapper")) continue;
            ++i;
            while (i < ste.length) {
                if (!(ste[i].getClassName().equals("org.apache.jetspeed.util.DelegatingObjectProxy") && ste[i].getMethodName().equals("invoke") || ste[i].getClassName().equals("org.apache.jetspeed.components.rdbms.ojb.ConnectionManagerImpl") && ste[i].getMethodName().equals("getConnection") || !ste[i].getClassName().startsWith("org.apache.jetspeed"))) {
                    StringBuffer b = new StringBuffer();
                    boolean inJ2 = true;
                    while (i < ste.length) {
                        boolean logSTE = this.isDebugCallStackPackage(ste[i].getClassName());
                        if (inJ2) {
                            if (!logSTE) {
                                b.append("    ...\n");
                                inJ2 = false;
                            }
                        } else if (logSTE) {
                            inJ2 = true;
                        }
                        if (inJ2) {
                            if (ste[i].getClassName().equals("org.apache.jetspeed.pipeline.JetspeedPipeline$Invocation") && ste[i].getMethodName().equals("invokeNext")) {
                                b.append("    ...\n");
                                break;
                            }
                            b.append("    ");
                            b.append(ste[i].toString());
                            b.append("\n");
                            if (ste[i].getClassName().equals("org.apache.jetspeed.factory.JetspeedPortletInstance")) {
                                b.append("    ...\n");
                                break;
                            }
                            if (ste[i].getClassName().equals("org.apache.jetspeed.engine.JetspeedEngine")) {
                                b.append("    ...\n");
                                break;
                            }
                        }
                        ++i;
                    }
                    callStack = b.toString();
                    break block0;
                }
                ++i;
            }
            break;
        }
        return callStack;
    }

    private boolean isDebugCallStackPackage(String className) {
        if (!className.startsWith("org.apache.jetspeed")) {
            for (int i = 0; i < this.debugCallStackPackages.length; ++i) {
                if (!className.startsWith(this.debugCallStackPackages[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void destroy() throws Exception {
        this.dumpLog();
    }

    public class DataSourceWrapper {
        DataSource ds;

        public DataSourceWrapper(DataSource ds) {
            this.ds = ds;
        }

        public void flush() {
            DebuggingDataSourceJndiObjectFactoryBean.this.flush();
        }

        private void checkHandleTimeoutException(SQLException e) {
            if (DebuggingDataSourceJndiObjectFactoryBean.this.debug) {
                DebuggingDataSourceJndiObjectFactoryBean.this.dumpLog();
            }
        }

        public Connection getConnection() throws SQLException {
            try {
                return DebuggingDataSourceJndiObjectFactoryBean.this.recordConnection(this.ds.getConnection());
            }
            catch (SQLException e) {
                this.checkHandleTimeoutException(e);
                throw e;
            }
        }

        public Connection getConnection(String username, String password) throws SQLException {
            try {
                return DebuggingDataSourceJndiObjectFactoryBean.this.recordConnection(this.ds.getConnection(username, password));
            }
            catch (SQLException e) {
                this.checkHandleTimeoutException(e);
                throw e;
            }
        }
    }

    public class ConnectionWrapper {
        private Connection connection;
        private Integer connectionKey;
        private Integer statisticsKey;
        private long duration;
        private long overhead;
        private boolean closed;

        private ConnectionWrapper(Connection connection, Integer connectionKey, Integer statisticsKey, long startTime) {
            this.connection = connection;
            this.connectionKey = connectionKey;
            this.statisticsKey = statisticsKey;
            this.duration = System.currentTimeMillis();
            this.overhead = startTime;
        }

        public void clearWarnings() throws SQLException {
            this.connection.clearWarnings();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws SQLException {
            long endTime = System.currentTimeMillis();
            this.connection.close();
            if (!this.closed) {
                this.closed = true;
                Object object = DebuggingDataSourceJndiObjectFactoryBean.this.mutex;
                synchronized (object) {
                    if (DebuggingDataSourceJndiObjectFactoryBean.this.debug) {
                        this.duration = endTime - this.duration;
                        this.overhead = endTime - this.overhead - this.duration;
                        ConnectionCallStatistics statistics = (ConnectionCallStatistics)DebuggingDataSourceJndiObjectFactoryBean.this.connectionsCallStatistics.get(this.statisticsKey);
                        if (statistics == null) {
                            System.out.println("failed to find " + this.statisticsKey);
                            return;
                        }
                        statistics.accumulatedDuration += this.duration;
                        statistics.totalOverhead += this.overhead;
                        if (this.duration < statistics.minDuration) {
                            statistics.minDuration = this.duration;
                        }
                        if (this.duration > statistics.maxDuration) {
                            statistics.maxDuration = this.duration;
                        }
                        DebuggingDataSourceJndiObjectFactoryBean.this.cachedConnections.remove(this.connectionKey);
                    }
                }
            }
        }
    }

    class ConnectionCallStatistics {
        String callStack;
        int callCount;
        long accumulatedDuration;
        long minDuration;
        long maxDuration;
        long totalOverhead;

        ConnectionCallStatistics() {
        }
    }
}

