/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.jndi;

import java.util.Map;
import org.apache.jetspeed.components.SpringComponentManager;
import org.apache.jetspeed.components.datasource.BoundDBCPDatasourceComponent;
import org.apache.jetspeed.components.jndi.JNDIComponent;
import org.apache.jetspeed.components.jndi.TyrexJNDIComponent;

public class SpringJNDIStarter {
    public static final String JNDI_DS_NAME = "jetspeed";
    public static final String DATASOURCE_DRIVER = "org.apache.jetspeed.database.driver".intern();
    public static final String DATASOURCE_URL = "org.apache.jetspeed.database.url".intern();
    public static final String DATASOURCE_USERNAME = "org.apache.jetspeed.database.user".intern();
    public static final String DATASOURCE_PASSWORD = "org.apache.jetspeed.database.password".intern();
    private final Map context;
    protected BoundDBCPDatasourceComponent datasourceComponent;
    protected JNDIComponent jndi;
    String appRoot = null;
    String[] bootConfig = null;
    String[] appConfig = null;
    SpringComponentManager scm = null;

    public SpringJNDIStarter(Map context, String appRoot, String[] bootConfig, String[] appConfig) {
        this.context = context;
        this.appRoot = appRoot;
        this.bootConfig = bootConfig;
        this.appConfig = appConfig;
    }

    public void setUp() throws Exception {
        this.setupJNDI();
        this.scm = new SpringComponentManager(this.bootConfig, this.appConfig, this.appRoot);
    }

    public void tearDown() throws Exception {
        try {
            this.datasourceComponent.stop();
        }
        catch (Exception e) {
            System.out.println("datasourceComponent stop failed with " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        try {
            this.scm.stop();
        }
        catch (Exception e) {
            System.out.println("SpringComponentManager stop failed with " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        try {
            this.jndi.unbindFromCurrentThread();
        }
        catch (Exception e) {
            System.out.println("JNDI  unbindFromCurrentThread failed with " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    String getProperty(String name) {
        String s = null;
        try {
            if (this.context != null) {
                s = (String)this.context.get(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (s == null) {
            s = System.getProperty(name);
        }
        return s;
    }

    public void setupJNDI() throws Exception {
        this.jndi = new TyrexJNDIComponent();
        String url = this.getProperty("org.apache.jetspeed.database.url");
        String driver = this.getProperty("org.apache.jetspeed.database.driver");
        String user = this.getProperty("org.apache.jetspeed.database.user");
        String password = this.getProperty("org.apache.jetspeed.database.password");
        this.datasourceComponent = new BoundDBCPDatasourceComponent(user, password, driver, url, 20, 5000, 2, true, JNDI_DS_NAME, this.jndi);
        this.datasourceComponent.start();
    }

    public SpringComponentManager getComponentManager() {
        return this.scm;
    }

    public Map getContext() {
        return this.context;
    }
}

