/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public class SchemaAwareDataSourceProxy
extends TransactionAwareDataSourceProxy {
    private static final Log log = LogFactory.getLog((Class)SchemaAwareDataSourceProxy.class);
    private String schemaSql = null;

    public void setSchemaSql(String schemaSql) {
        this.schemaSql = schemaSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Connection con = super.getConnection();
        if (this.schemaSql != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting schema by executing sql '" + this.schemaSql + "' on connection " + con));
            }
            Statement stmt = con.createStatement();
            try {
                stmt.execute(this.schemaSql);
            }
            catch (Exception e) {
                log.error((Object)("Error executing table schema setting sql: '" + this.schemaSql + "'."), (Throwable)e);
            }
            finally {
                stmt.close();
            }
        }
        return con;
    }
}

