/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.cache.JetspeedCacheEventListener;
import org.apache.jetspeed.om.folder.impl.FolderImpl;
import org.apache.jetspeed.om.page.FragmentProperty;
import org.apache.jetspeed.om.page.impl.BaseFragmentElementImpl;
import org.apache.jetspeed.om.page.impl.FragmentPropertyImpl;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.impl.NodeImpl;
import org.apache.jetspeed.page.impl.DatabasePageManager;
import org.apache.jetspeed.page.impl.DatabasePageManagerCacheObject;
import org.apache.jetspeed.page.impl.DatabasePageManagerCachedFragmentPropertyList;
import org.apache.jetspeed.page.impl.DatabasePageManagerFragmentKeyCacheObject;
import org.apache.jetspeed.page.impl.DatabasePageManagerPrincipalKeyCacheObject;
import org.apache.jetspeed.page.impl.TransactionedOperation;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePageManagerCache
implements ObjectCache {
    private static Logger log = LoggerFactory.getLogger(DatabasePageManagerCache.class);
    private static final String EOL = System.getProperty("line.separator");
    private static JetspeedCache oidCache;
    private static JetspeedCache pathCache;
    private static Map<String, Identity> pathToOidMap;
    private static JetspeedCache propertiesCache;
    private static JetspeedCache propertiesPathCache;
    private static JetspeedCache principalPropertiesCache;
    private static JetspeedCache principalPropertiesPathCache;
    private static Map<String, Set<String>> propertiesCacheIndexMap;
    private static boolean constraintsEnabled;
    private static boolean permissionsEnabled;
    private static PageManager pageManager;
    private static List<String> updatePathsList;
    private static ThreadLocal<List<TransactionedOperation>> transactionedOperations;

    public static synchronized void cacheInit(JetspeedCache oidCache, JetspeedCache pathCache, JetspeedCache propertiesCache, JetspeedCache propertiesPathCache, JetspeedCache principalPropertiesCache, JetspeedCache principalPropertiesPathCache, DatabasePageManager pageManager) {
        DatabasePageManagerCache.oidCache = oidCache;
        DatabasePageManagerCache.pathCache = pathCache;
        pathToOidMap = new HashMap<String, Identity>();
        DatabasePageManagerCache.propertiesCache = propertiesCache;
        DatabasePageManagerCache.propertiesPathCache = propertiesPathCache;
        DatabasePageManagerCache.principalPropertiesCache = principalPropertiesCache;
        DatabasePageManagerCache.principalPropertiesPathCache = principalPropertiesPathCache;
        propertiesCacheIndexMap = new HashMap<String, Set<String>>();
        constraintsEnabled = pageManager.getConstraintsEnabled();
        permissionsEnabled = pageManager.getPermissionsEnabled();
        DatabasePageManagerCache.pageManager = pageManager;
        final DatabasePageManager databasePageManager = pageManager;
        oidCache.addEventListener(new JetspeedCacheEventListener(){

            public void notifyElementAdded(JetspeedCache cache, boolean local, Object key, Object element) {
                NodeImpl node = (NodeImpl)element;
                pathToOidMap.put(node.getPath(), (Identity)key);
                node.setConstraintsEnabled(constraintsEnabled);
                node.setPermissionsEnabled(permissionsEnabled);
                node.setPageManager(databasePageManager);
            }

            public void notifyElementChanged(JetspeedCache cache, boolean local, Object key, Object element) {
                this.notifyElementAdded(cache, local, key, element);
            }

            public void notifyElementEvicted(JetspeedCache cache, boolean local, Object key, Object element) {
                this.notifyElementRemoved(cache, local, key, element);
            }

            public void notifyElementExpired(JetspeedCache cache, boolean local, Object key, Object element) {
                this.notifyElementRemoved(cache, local, key, element);
            }

            public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
                NodeImpl node = (NodeImpl)element;
                pathToOidMap.remove(node.getPath());
                node.setStale(true);
                if (node instanceof FolderImpl) {
                    ((FolderImpl)node).resetAll(false);
                }
            }
        }, true);
        pathCache.addEventListener(new JetspeedCacheEventListener(){

            public void notifyElementAdded(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            public void notifyElementChanged(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            public void notifyElementEvicted(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            public void notifyElementExpired(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
                String path;
                DatabasePageManagerCacheObject cacheObject = (DatabasePageManagerCacheObject)element;
                Identity oid = cacheObject != null ? cacheObject.getId() : null;
                String string = path = cacheObject != null ? cacheObject.getPath() : (String)key;
                if (oid == null && path == null) return;
                Class<DatabasePageManagerCache> clazz = DatabasePageManagerCache.class;
                synchronized (DatabasePageManagerCache.class) {
                    Set index;
                    if (oid != null) {
                        NodeImpl node = DatabasePageManagerCache.cacheLookup(oid, false);
                        if (node instanceof FolderImpl) {
                            ((FolderImpl)node).resetAll(false);
                        }
                        pageManager.notifyUpdatedNode((Node)node);
                        oidCache.remove((Object)oid);
                    }
                    if (path == null) return;
                    int pathLastSeparatorIndex = path.lastIndexOf("/");
                    String parentPath = pathLastSeparatorIndex > 0 ? path.substring(0, pathLastSeparatorIndex) : "/";
                    NodeImpl parentNode = DatabasePageManagerCache.cacheLookup(parentPath, false);
                    if (parentNode instanceof FolderImpl) {
                        ((FolderImpl)parentNode).resetAll(false);
                    }
                    if ((index = (Set)propertiesCacheIndexMap.get(path)) == null) return;
                    for (String fragmentKey : new ArrayList(index)) {
                        int fragmentId = DatabasePageManagerCache.getFragmentIdFromFragmentKey(fragmentKey);
                        if (fragmentId > 0) {
                            DatabasePageManagerCache.clearPrincipalPropertiesCache(fragmentId);
                        }
                        propertiesCache.removeQuiet((Object)fragmentKey);
                        propertiesPathCache.removeQuiet((Object)fragmentKey);
                    }
                    propertiesCacheIndexMap.remove(path);
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return;
                }
            }
        }, false);
        propertiesCache.addEventListener(new JetspeedCacheEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void notifyElementAdded(JetspeedCache cache, boolean local, Object key, Object element) {
                String fragmentKey = (String)key;
                DatabasePageManagerCachedFragmentPropertyList fragmentPropertyList = (DatabasePageManagerCachedFragmentPropertyList)element;
                if (fragmentPropertyList == null) return;
                String path = fragmentPropertyList.getBaseFragmentsElementPath();
                Class<DatabasePageManagerCache> clazz = DatabasePageManagerCache.class;
                synchronized (DatabasePageManagerCache.class) {
                    HashSet<String> index = (HashSet<String>)propertiesCacheIndexMap.get(path);
                    if (index == null) {
                        index = new HashSet<String>();
                        propertiesCacheIndexMap.put(path, index);
                    }
                    index.add(fragmentKey);
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return;
                }
            }

            public void notifyElementChanged(JetspeedCache cache, boolean local, Object key, Object element) {
                this.notifyElementAdded(cache, local, key, element);
            }

            public void notifyElementEvicted(JetspeedCache cache, boolean local, Object key, Object element) {
                this.notifyElementRemoved(cache, local, key, element);
            }

            public void notifyElementExpired(JetspeedCache cache, boolean local, Object key, Object element) {
                this.notifyElementRemoved(cache, local, key, element);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
                String fragmentKeyOrPath = (String)key;
                DatabasePageManagerCachedFragmentPropertyList fragmentPropertyList = (DatabasePageManagerCachedFragmentPropertyList)element;
                if (fragmentPropertyList != null) {
                    String path = fragmentPropertyList.getBaseFragmentsElementPath();
                    Class<DatabasePageManagerCache> clazz = DatabasePageManagerCache.class;
                    synchronized (DatabasePageManagerCache.class) {
                        Set index = (Set)propertiesCacheIndexMap.get(path);
                        if (index == null) return;
                        index.remove(fragmentKeyOrPath);
                        if (!index.isEmpty()) return;
                        propertiesCacheIndexMap.remove(path);
                        // ** MonitorExit[var8_10] (shouldn't be in output)
                        return;
                    }
                }
                if (fragmentKeyOrPath != null) {
                    Class<DatabasePageManagerCache> clazz = DatabasePageManagerCache.class;
                    synchronized (DatabasePageManagerCache.class) {
                        Set index = (Set)propertiesCacheIndexMap.get(fragmentKeyOrPath);
                        if (index == null) return;
                        for (String fragmentKey : index) {
                            propertiesCache.removeQuiet((Object)fragmentKey);
                        }
                        propertiesCacheIndexMap.remove(fragmentKeyOrPath);
                        // ** MonitorExit[var7_8] (shouldn't be in output)
                        return;
                    }
                }
                if (fragmentKeyOrPath != null) return;
                Class<DatabasePageManagerCache> clazz = DatabasePageManagerCache.class;
                synchronized (DatabasePageManagerCache.class) {
                    propertiesCacheIndexMap.clear();
                    // ** MonitorExit[var7_9] (shouldn't be in output)
                    return;
                }
            }
        }, true);
        propertiesPathCache.addEventListener(new JetspeedCacheEventListener(){

            public void notifyElementAdded(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            public void notifyElementChanged(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            public void notifyElementEvicted(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            public void notifyElementExpired(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
                String fragmentKey;
                DatabasePageManagerFragmentKeyCacheObject cacheObject = (DatabasePageManagerFragmentKeyCacheObject)element;
                String string = fragmentKey = cacheObject != null ? cacheObject.getFragmentKey() : (String)key;
                if (fragmentKey == null) return;
                int fragmentId = DatabasePageManagerCache.getFragmentIdFromFragmentKey(fragmentKey);
                Class<DatabasePageManagerCache> clazz = DatabasePageManagerCache.class;
                synchronized (DatabasePageManagerCache.class) {
                    if (fragmentId > 0) {
                        DatabasePageManagerCache.clearPrincipalPropertiesCache(fragmentId);
                    }
                    propertiesCache.remove((Object)fragmentKey);
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return;
                }
            }
        }, false);
        principalPropertiesPathCache.addEventListener(new JetspeedCacheEventListener(){

            public void notifyElementAdded(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            public void notifyElementChanged(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            public void notifyElementEvicted(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            public void notifyElementExpired(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
                String principalKey;
                DatabasePageManagerPrincipalKeyCacheObject cacheObject = (DatabasePageManagerPrincipalKeyCacheObject)element;
                String string = principalKey = cacheObject != null ? cacheObject.getPrincipalKey() : (String)key;
                if (principalKey == null) return;
                Class<DatabasePageManagerCache> clazz = DatabasePageManagerCache.class;
                synchronized (DatabasePageManagerCache.class) {
                    principalPropertiesCache.removeQuiet((Object)principalKey);
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return;
                }
            }
        }, false);
    }

    private static int getFragmentIdFromFragmentKey(String fragmentKey) {
        int fragmentId = -1;
        int fragmentIdSeparatorIndex = fragmentKey.lastIndexOf(58);
        if (fragmentIdSeparatorIndex != -1) {
            try {
                fragmentId = Integer.parseInt(fragmentKey.substring(fragmentIdSeparatorIndex + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return fragmentId;
    }

    private static void clearPrincipalPropertiesCache(int fragmentId) {
        List principalKeys = principalPropertiesCache.getKeys();
        block0: for (String principalKey : principalKeys) {
            CacheElement propertiesElement = principalPropertiesCache.get((Object)principalKey);
            if (propertiesElement == null) continue;
            DatabasePageManagerCachedFragmentPropertyList cachedPrincipalFragmentPropertyList = (DatabasePageManagerCachedFragmentPropertyList)propertiesElement.getContent();
            for (FragmentProperty fragmentProperty : cachedPrincipalFragmentPropertyList) {
                if (((BaseFragmentElementImpl)((FragmentPropertyImpl)fragmentProperty).getFragment()).getIdentity() != fragmentId) continue;
                principalPropertiesCache.removeQuiet((Object)principalKey);
                principalPropertiesPathCache.removeQuiet((Object)principalKey);
                continue block0;
            }
        }
    }

    public static synchronized void setPageManagerProxy(PageManager proxy) {
        if (pageManager != proxy) {
            pageManager = proxy;
            DatabasePageManagerCache.cacheClear();
        }
    }

    public static synchronized NodeImpl cacheLookup(String path) {
        return DatabasePageManagerCache.cacheLookup(path, true);
    }

    private static synchronized NodeImpl cacheLookup(String path, boolean cacheRead) {
        Identity oid;
        if (path != null && (oid = pathToOidMap.get(path)) != null) {
            return DatabasePageManagerCache.cacheLookup(oid, cacheRead);
        }
        return null;
    }

    public static synchronized void addUpdatePath(String path) {
        updatePathsList.add(path);
    }

    private static synchronized void cacheAdd(Identity oid, NodeImpl node) {
        String path = node.getPath();
        oidCache.remove((Object)oid);
        boolean removed = pathCache.remove((Object)path);
        CacheElement pathElement = pathCache.createElement((Object)path, (Object)new DatabasePageManagerCacheObject(oid, path));
        pathCache.put(pathElement);
        if (!removed && updatePathsList.contains(path)) {
            pathCache.remove((Object)path);
            pathCache.put(pathElement);
        }
        CacheElement element = oidCache.createElement((Object)oid, (Object)node);
        oidCache.put(element);
    }

    public static synchronized void removeUpdatePath(String path) {
        updatePathsList.remove(path);
    }

    public static synchronized void cacheClear() {
        pathToOidMap.clear();
        for (Object remove : oidCache.getKeys()) {
            oidCache.remove((Object)((Identity)remove));
        }
        for (Object remove : propertiesCache.getKeys()) {
            propertiesCache.remove(remove);
        }
        for (Object remove : principalPropertiesCache.getKeys()) {
            principalPropertiesCache.remove(remove);
        }
        for (Object remove : pathCache.getKeys()) {
            pathCache.removeQuiet(remove);
        }
        for (Object remove : propertiesPathCache.getKeys()) {
            propertiesPathCache.removeQuiet(remove);
        }
        for (Object remove : principalPropertiesPathCache.getKeys()) {
            principalPropertiesPathCache.removeQuiet(remove);
        }
    }

    private static synchronized NodeImpl cacheLookup(Identity oid, boolean cacheRead) {
        CacheElement element;
        if (oid != null && (element = oidCache.get((Object)oid)) != null) {
            NodeImpl node = (NodeImpl)element.getContent();
            if (cacheRead) {
                Identity parentOid;
                CacheElement parentElement;
                String path = node.getPath();
                pathCache.get((Object)path);
                Integer parentIdentity = node.getParentIdentity();
                while (parentIdentity != null && (parentElement = oidCache.get((Object)(parentOid = new Identity(FolderImpl.class, FolderImpl.class, new Object[]{new Integer(parentIdentity)})))) != null) {
                    NodeImpl parentNode = (NodeImpl)parentElement.getContent();
                    String parentPath = parentNode.getPath();
                    pathCache.get((Object)parentPath);
                    parentIdentity = parentNode.getParentIdentity();
                }
            }
            return node;
        }
        return null;
    }

    public static synchronized void cacheRemove(Identity oid) {
        NodeImpl node;
        if (oid != null && (node = DatabasePageManagerCache.cacheLookup(oid, false)) != null) {
            String path = node.getPath();
            oidCache.remove((Object)oid);
            boolean removed = pathCache.remove((Object)path);
            if (!removed) {
                CacheElement pathElement = pathCache.createElement((Object)path, (Object)new DatabasePageManagerCacheObject(oid, path));
                pathCache.put(pathElement);
                pathCache.remove((Object)path);
            }
        }
    }

    public static synchronized void cacheRemove(String path) {
        if (path != null) {
            CacheElement pathElement;
            Identity oid = pathToOidMap.get(path);
            if (oid != null) {
                oidCache.remove((Object)oid);
            }
            if ((pathElement = pathCache.get((Object)path)) != null) {
                DatabasePageManagerCacheObject cacheObject = (DatabasePageManagerCacheObject)pathElement.getContent();
                pathCache.remove((Object)path);
            } else {
                pathElement = pathCache.createElement((Object)path, (Object)new DatabasePageManagerCacheObject(path));
                pathCache.put(pathElement);
                pathCache.remove((Object)path);
            }
        }
    }

    public static synchronized void resetCachedSecurityConstraints() {
        for (Object reset : oidCache.getKeys()) {
            NodeImpl node = DatabasePageManagerCache.cacheLookup((Identity)reset, false);
            if (node == null) continue;
            node.resetCachedSecurityConstraints();
        }
    }

    public static synchronized void fragmentPropertyListCacheAdd(String fragmentKey, DatabasePageManagerCachedFragmentPropertyList fragmentPropertyList, boolean update) {
        boolean removed;
        propertiesCache.remove((Object)fragmentKey);
        if (update && !(removed = propertiesPathCache.remove((Object)fragmentKey))) {
            propertiesPathCache.put(propertiesPathCache.createElement((Object)fragmentKey, (Object)new DatabasePageManagerFragmentKeyCacheObject(fragmentKey)));
            propertiesPathCache.remove((Object)fragmentKey);
        }
        if (propertiesPathCache.get((Object)fragmentKey) == null) {
            propertiesPathCache.put(propertiesPathCache.createElement((Object)fragmentKey, (Object)new DatabasePageManagerFragmentKeyCacheObject(fragmentKey)));
        }
        propertiesCache.put(propertiesCache.createElement((Object)fragmentKey, (Object)fragmentPropertyList));
    }

    public static synchronized DatabasePageManagerCachedFragmentPropertyList fragmentPropertyListCacheLookup(String fragmentKey) {
        CacheElement propertiesElement;
        if (fragmentKey != null && (propertiesElement = propertiesCache.get((Object)fragmentKey)) != null) {
            return (DatabasePageManagerCachedFragmentPropertyList)propertiesElement.getContent();
        }
        return null;
    }

    public static synchronized void fragmentPropertyListCacheRemove(String fragmentKey) {
        if (fragmentKey != null) {
            propertiesCache.remove((Object)fragmentKey);
            boolean removed = propertiesPathCache.remove((Object)fragmentKey);
            if (!removed) {
                propertiesPathCache.put(propertiesPathCache.createElement((Object)fragmentKey, (Object)new DatabasePageManagerFragmentKeyCacheObject(fragmentKey)));
                propertiesPathCache.remove((Object)fragmentKey);
            }
        }
    }

    public static synchronized void principalFragmentPropertyListCacheAdd(String principalKey, DatabasePageManagerCachedFragmentPropertyList fragmentPropertyList, boolean update) {
        boolean removed;
        principalPropertiesCache.remove((Object)principalKey);
        if (update && !(removed = principalPropertiesPathCache.remove((Object)principalKey))) {
            principalPropertiesPathCache.put(principalPropertiesPathCache.createElement((Object)principalKey, (Object)new DatabasePageManagerPrincipalKeyCacheObject(principalKey)));
            principalPropertiesPathCache.remove((Object)principalKey);
        }
        if (principalPropertiesPathCache.get((Object)principalKey) == null) {
            principalPropertiesPathCache.put(principalPropertiesPathCache.createElement((Object)principalKey, (Object)new DatabasePageManagerPrincipalKeyCacheObject(principalKey)));
        }
        principalPropertiesCache.put(principalPropertiesCache.createElement((Object)principalKey, (Object)fragmentPropertyList));
    }

    public static synchronized DatabasePageManagerCachedFragmentPropertyList principalFragmentPropertyListCacheLookup(String principalKey) {
        CacheElement propertiesElement;
        if (principalKey != null && (propertiesElement = principalPropertiesCache.get((Object)principalKey)) != null) {
            return (DatabasePageManagerCachedFragmentPropertyList)propertiesElement.getContent();
        }
        return null;
    }

    public static synchronized void principalFragmentPropertyListCacheRemove(String principalKey) {
        if (principalKey != null) {
            principalPropertiesCache.remove((Object)principalKey);
            boolean removed = principalPropertiesPathCache.remove((Object)principalKey);
            if (!removed) {
                principalPropertiesPathCache.put(principalPropertiesPathCache.createElement((Object)principalKey, (Object)new DatabasePageManagerPrincipalKeyCacheObject(principalKey)));
                principalPropertiesPathCache.remove((Object)principalKey);
            }
        }
    }

    public static List<TransactionedOperation> getTransactions() {
        List<TransactionedOperation> operations = transactionedOperations.get();
        if (operations == null) {
            operations = new LinkedList<TransactionedOperation>();
            transactionedOperations.set(operations);
        }
        return operations;
    }

    public static void addTransaction(TransactionedOperation operation) {
        List<TransactionedOperation> transactions = DatabasePageManagerCache.getTransactions();
        transactions.add(operation);
    }

    public static synchronized void rollbackTransactions() {
        for (TransactionedOperation operation : DatabasePageManagerCache.getTransactions()) {
            if (operation.getTransactionType() == 0 || operation.getTransactionType() == 1) {
                DatabasePageManagerCache.cacheRemove(operation.getPath());
                continue;
            }
            if (operation.getTransactionType() == 2 || operation.getTransactionType() == 3) {
                DatabasePageManagerCache.fragmentPropertyListCacheRemove(operation.getFragmentKey());
                continue;
            }
            if (operation.getTransactionType() != 4 && operation.getTransactionType() != 5) continue;
            DatabasePageManagerCache.principalFragmentPropertyListCacheRemove(operation.getPrincipalKey());
        }
    }

    public static void clearTransactions() {
        transactionedOperations.remove();
    }

    public static boolean isDistributed() {
        return pathCache.isDistributed() && propertiesPathCache.isDistributed() && principalPropertiesPathCache.isDistributed();
    }

    public DatabasePageManagerCache(PersistenceBroker broker, Properties props) {
    }

    public void cache(Identity oid, Object obj) {
        if (obj instanceof NodeImpl) {
            DatabasePageManagerCache.cacheAdd(oid, (NodeImpl)obj);
        }
    }

    public void clear() {
        DatabasePageManagerCache.cacheClear();
    }

    public Object lookup(Identity oid) {
        return DatabasePageManagerCache.cacheLookup(oid, true);
    }

    public void remove(Identity oid) {
        DatabasePageManagerCache.cacheRemove(oid);
    }

    public static synchronized void dump() {
        StringBuilder dump = new StringBuilder();
        dump.append("--------------------------" + EOL);
        for (Object dumpOid : oidCache.getKeys()) {
            Identity oid = (Identity)dumpOid;
            NodeImpl node = DatabasePageManagerCache.cacheLookup(oid, false);
            dump.append("node=" + node.getPath() + ", oid=" + oid + EOL);
        }
        dump.append("--------------------------");
        log.debug("DatabasePageManagerCache dump:" + EOL + dump.toString());
    }

    static {
        updatePathsList = new ArrayList<String>();
        transactionedOperations = new ThreadLocal();
    }
}

