/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.document.impl;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeSet;

public class NodeSetImpl
implements NodeSet {
    public static final NodeSetImpl EMPTY_NODE_SET = new NodeSetImpl();
    private static final Map<String, Pattern> patternCache = new LRUMap(128);
    private Map<String, Node> nodes;
    private Comparator<String> comparator;

    public NodeSetImpl(List<? extends Node> nodes, Comparator<String> comparator) {
        this.nodes = new TreeMap<String, Node>(comparator);
        Node[] nodeToCopy = nodes.toArray(new Node[nodes.size()]);
        for (int ix = 0; ix < nodeToCopy.length; ++ix) {
            Node node = nodeToCopy[ix];
            if (this.nodes.containsKey(node.getName())) continue;
            this.nodes.put(node.getName(), node);
        }
        this.comparator = comparator;
    }

    public NodeSetImpl(List<? extends Node> nodes) {
        this(nodes, null);
    }

    public NodeSetImpl(Comparator<String> comparator) {
        this.comparator = comparator;
    }

    public NodeSetImpl(NodeSet nodeSet) {
        this(nodeSet instanceof NodeSetImpl ? ((NodeSetImpl)nodeSet).comparator : null);
    }

    public NodeSetImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pattern getCachedPattern(String regex) {
        Map<String, Pattern> map = patternCache;
        synchronized (map) {
            if (patternCache.containsKey(regex)) {
                return patternCache.get(regex);
            }
            Pattern pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
            return pattern;
        }
    }

    public void add(Node node) {
        if (this.nodes == null) {
            this.nodes = new TreeMap<String, Node>(this.comparator);
        }
        if (!this.nodes.containsKey(node.getName())) {
            this.nodes.put(node.getName(), node);
        }
    }

    public Node get(String name) {
        if (this.nodes != null) {
            return this.nodes.get(name);
        }
        return null;
    }

    public Iterator<Node> iterator() {
        if (this.nodes == null) {
            this.nodes = new TreeMap<String, Node>(this.comparator);
        }
        return this.nodes.values().iterator();
    }

    public NodeSet subset(String type) {
        NodeSetImpl subset = new NodeSetImpl(this.comparator);
        Iterator<Node> i$ = this.iterator();
        while (i$.hasNext()) {
            Node node = i$.next();
            if (!node.getType().equals(type)) continue;
            subset.add(node);
        }
        return subset;
    }

    public NodeSet inclusiveSubset(String regex) {
        Pattern pattern = this.getCachedPattern(regex);
        NodeSetImpl subset = new NodeSetImpl(this.comparator);
        Iterator<Node> i$ = this.iterator();
        while (i$.hasNext()) {
            Node node = i$.next();
            if (!pattern.matcher(node.getName()).matches()) continue;
            subset.add(node);
        }
        return subset;
    }

    public NodeSet exclusiveSubset(String regex) {
        Pattern pattern = this.getCachedPattern(regex);
        NodeSetImpl subset = new NodeSetImpl(this.comparator);
        Iterator<Node> i$ = this.iterator();
        while (i$.hasNext()) {
            Node node = i$.next();
            if (pattern.matcher(node.getName()).matches()) continue;
            subset.add(node);
        }
        return subset;
    }

    public int size() {
        if (this.nodes != null) {
            return this.nodes.size();
        }
        return 0;
    }

    public boolean contains(Node node) {
        if (this.nodes != null) {
            return this.nodes.containsValue(node);
        }
        return false;
    }

    public boolean isEmpty() {
        if (this.nodes != null) {
            return this.nodes.isEmpty();
        }
        return true;
    }
}

