/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.MenuDefinitionElement;
import org.apache.jetspeed.om.folder.MenuExcludeDefinition;
import org.apache.jetspeed.om.folder.MenuIncludeDefinition;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.folder.MenuSeparatorDefinition;
import org.apache.jetspeed.om.page.BaseFragmentElement;
import org.apache.jetspeed.om.page.BaseFragmentsElement;
import org.apache.jetspeed.om.page.BasePageElement;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.om.page.FragmentProperty;
import org.apache.jetspeed.om.page.FragmentReference;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageFragment;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.preference.FragmentPreference;
import org.apache.jetspeed.page.FragmentPropertyManagement;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageManagerEventListener;
import org.apache.jetspeed.page.PageManagerUtils;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPageManager
implements PageManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractPageManager.class);
    private static final long DEFAULT_NODE_REAPING_INTERVAL = 300000L;
    private static final String FOLDER_NODE_TYPE = "folder";
    private static final String PAGE_NODE_TYPE = "page";
    private static final String FRAGMENT_NODE_TYPE = "fragment";
    private static final String LINK_NODE_TYPE = "link";
    protected Class fragmentClass;
    protected Class pageClass;
    protected Class folderClass;
    protected Class linkClass;
    protected Class pageSecurityClass;
    protected Class propertyClass;
    protected Class folderMenuDefinitionClass;
    protected Class folderMenuExcludeDefinitionClass;
    protected Class folderMenuIncludeDefinitionClass;
    protected Class folderMenuOptionsDefinitionClass;
    protected Class folderMenuSeparatorDefinitionClass;
    protected Class pageMenuDefinitionClass;
    protected Class pageMenuExcludeDefinitionClass;
    protected Class pageMenuIncludeDefinitionClass;
    protected Class pageMenuOptionsDefinitionClass;
    protected Class pageMenuSeparatorDefinitionClass;
    protected Class securityConstraintsClass;
    protected Class folderSecurityConstraintClass;
    protected Class pageSecurityConstraintClass;
    protected Class fragmentSecurityConstraintClass;
    protected Class linkSecurityConstraintClass;
    protected Class pageSecuritySecurityConstraintClass;
    protected Class securityConstraintsDefClass;
    protected Class fragmentPreferenceClass;
    protected Class fragmentReferenceClass;
    protected Class pageFragmentClass;
    protected Class pageTemplateClass;
    protected Class dynamicPageClass;
    protected Class fragmentDefinitionClass;
    protected Class fragmentPropertyClass;
    private IdGenerator generator;
    private boolean permissionsEnabled;
    private boolean constraintsEnabled;
    private List<PageManagerEventListener> listeners = new LinkedList<PageManagerEventListener>();
    private long nodeReapingInterval = 300000L;
    private volatile Thread nodeReapingThread;

    public AbstractPageManager(IdGenerator generator, boolean permissionsEnabled, boolean constraintsEnabled) {
        this.generator = generator;
        this.permissionsEnabled = permissionsEnabled;
        this.constraintsEnabled = constraintsEnabled;
    }

    public void init() {
        if (this.nodeReapingInterval > 0L && this.nodeReapingThread == null) {
            this.nodeReapingThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    Thread runningThread;
                    Thread thread = runningThread = Thread.currentThread();
                    synchronized (thread) {
                        while (AbstractPageManager.this.nodeReapingThread == runningThread) {
                            try {
                                runningThread.wait(AbstractPageManager.this.nodeReapingInterval);
                                if (AbstractPageManager.this.nodeReapingThread != runningThread) continue;
                                AbstractPageManager.this.notifyReapNodes();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        return;
                    }
                }
            }, "PageManagerNodeReapingThread");
            this.nodeReapingThread.setDaemon(true);
            this.nodeReapingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Thread destroyReapingThread = this.nodeReapingThread;
        if (destroyReapingThread != null) {
            this.nodeReapingThread = null;
            Thread thread = destroyReapingThread;
            synchronized (thread) {
                destroyReapingThread.notifyAll();
            }
            try {
                destroyReapingThread.join(this.nodeReapingInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public AbstractPageManager(IdGenerator generator, boolean permissionsEnabled, boolean constraintsEnabled, Map<String, Class<?>> modelClasses) {
        this(generator, permissionsEnabled, constraintsEnabled);
        this.fragmentClass = modelClasses.get("FragmentImpl");
        this.pageClass = modelClasses.get("PageImpl");
        this.folderClass = modelClasses.get("FolderImpl");
        this.linkClass = modelClasses.get("LinkImpl");
        this.pageSecurityClass = modelClasses.get("PageSecurityImpl");
        this.folderMenuDefinitionClass = modelClasses.get("FolderMenuDefinitionImpl");
        this.folderMenuExcludeDefinitionClass = modelClasses.get("FolderMenuExcludeDefinitionImpl");
        this.folderMenuIncludeDefinitionClass = modelClasses.get("FolderMenuIncludeDefinitionImpl");
        this.folderMenuOptionsDefinitionClass = modelClasses.get("FolderMenuOptionsDefinitionImpl");
        this.folderMenuSeparatorDefinitionClass = modelClasses.get("FolderMenuSeparatorDefinitionImpl");
        this.pageMenuDefinitionClass = modelClasses.get("PageMenuDefinitionImpl");
        this.pageMenuExcludeDefinitionClass = modelClasses.get("PageMenuExcludeDefinitionImpl");
        this.pageMenuIncludeDefinitionClass = modelClasses.get("PageMenuIncludeDefinitionImpl");
        this.pageMenuOptionsDefinitionClass = modelClasses.get("PageMenuOptionsDefinitionImpl");
        this.pageMenuSeparatorDefinitionClass = modelClasses.get("PageMenuSeparatorDefinitionImpl");
        this.securityConstraintsClass = modelClasses.get("SecurityConstraintsImpl");
        this.folderSecurityConstraintClass = modelClasses.get("FolderSecurityConstraintImpl");
        this.pageSecurityConstraintClass = modelClasses.get("PageSecurityConstraintImpl");
        this.fragmentSecurityConstraintClass = modelClasses.get("FragmentSecurityConstraintImpl");
        this.linkSecurityConstraintClass = modelClasses.get("LinkSecurityConstraintImpl");
        this.pageSecuritySecurityConstraintClass = modelClasses.get("PageSecuritySecurityConstraintImpl");
        this.securityConstraintsDefClass = modelClasses.get("SecurityConstraintsDefImpl");
        this.fragmentPreferenceClass = modelClasses.get("FragmentPreferenceImpl");
        this.fragmentReferenceClass = modelClasses.get("FragmentReferenceImpl");
        this.pageFragmentClass = modelClasses.get("PageFragmentImpl");
        this.pageTemplateClass = modelClasses.get("PageTemplateImpl");
        this.dynamicPageClass = modelClasses.get("DynamicPageImpl");
        this.fragmentDefinitionClass = modelClasses.get("FragmentDefinitionImpl");
        this.fragmentPropertyClass = modelClasses.get("FragmentPropertyImpl");
    }

    public boolean getPermissionsEnabled() {
        return this.permissionsEnabled;
    }

    public boolean getConstraintsEnabled() {
        return this.constraintsEnabled;
    }

    public long getNodeReapingInterval() {
        return this.nodeReapingInterval;
    }

    public Page newPage(String path) {
        Page page = null;
        try {
            page = (Page)this.createObject(this.pageClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith(".psml")) {
                path = path + ".psml";
            }
            page.setPath(path);
            page.setRootFragment((BaseFragmentElement)this.newFragment());
        }
        catch (ClassCastException e) {
            String message = "Failed to create page object for " + this.pageClass;
            log.error(message, (Throwable)e);
        }
        return page;
    }

    public PageTemplate newPageTemplate(String path) {
        PageTemplate pageTemplate = null;
        try {
            pageTemplate = (PageTemplate)this.createObject(this.pageTemplateClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith(".tpsml")) {
                path = path + ".psml";
            }
            pageTemplate.setPath(path);
            pageTemplate.setRootFragment((BaseFragmentElement)this.newFragment());
        }
        catch (ClassCastException e) {
            String message = "Failed to create page template object for " + this.pageTemplateClass;
            log.error(message, (Throwable)e);
        }
        return pageTemplate;
    }

    public DynamicPage newDynamicPage(String path) {
        DynamicPage dynamicPage = null;
        try {
            dynamicPage = (DynamicPage)this.createObject(this.dynamicPageClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith(".dpsml")) {
                path = path + ".dpsml";
            }
            dynamicPage.setPath(path);
            dynamicPage.setRootFragment((BaseFragmentElement)this.newFragment());
        }
        catch (ClassCastException e) {
            String message = "Failed to create dynamic page object for " + this.dynamicPageClass;
            log.error(message, (Throwable)e);
        }
        return dynamicPage;
    }

    public FragmentDefinition newFragmentDefinition(String path) {
        FragmentDefinition fragmentDefinition = null;
        try {
            fragmentDefinition = (FragmentDefinition)this.createObject(this.fragmentDefinitionClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith(".fpsml")) {
                path = path + ".fpsml";
            }
            fragmentDefinition.setPath(path);
            fragmentDefinition.setRootFragment((BaseFragmentElement)this.newPortletFragment());
        }
        catch (ClassCastException e) {
            String message = "Failed to create fragment definition object for " + this.dynamicPageClass;
            log.error(message, (Throwable)e);
        }
        return fragmentDefinition;
    }

    public Folder newFolder(String path) {
        Folder folder = null;
        try {
            folder = (Folder)this.createObject(this.folderClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            folder.setPath(path);
        }
        catch (ClassCastException e) {
            String message = "Failed to create link object for " + this.linkClass;
            log.error(message, (Throwable)e);
        }
        return folder;
    }

    public Link newLink(String path) {
        Link link = null;
        try {
            link = (Link)this.createObject(this.linkClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith(".link")) {
                path = path + ".link";
            }
            link.setPath(path);
        }
        catch (ClassCastException e) {
            String message = "Failed to create link object for " + this.linkClass;
            log.error(message, (Throwable)e);
        }
        return link;
    }

    public PageSecurity newPageSecurity() {
        PageSecurity pageSecurity = null;
        try {
            pageSecurity = (PageSecurity)this.createObject(this.pageSecurityClass);
            pageSecurity.setPath("/page.security");
        }
        catch (ClassCastException e) {
            String message = "Failed to create page security object for " + this.pageClass;
            log.error(message, (Throwable)e);
        }
        return pageSecurity;
    }

    public Fragment newFragment() {
        Fragment fragment = null;
        try {
            fragment = (Fragment)this.createObject(this.fragmentClass);
            fragment.setType("layout");
            fragment.setId(this.generator.getNextPeid());
        }
        catch (ClassCastException e) {
            String message = "Failed to create fragment object for " + this.fragmentClass;
            log.error(message, (Throwable)e);
        }
        return fragment;
    }

    public Fragment newPortletFragment() {
        Fragment fragment = null;
        try {
            fragment = (Fragment)this.createObject(this.fragmentClass);
            fragment.setType("portlet");
            fragment.setId(this.generator.getNextPeid());
        }
        catch (ClassCastException e) {
            String message = "Failed to create fragment object for " + this.fragmentClass;
            log.error(message, (Throwable)e);
        }
        return fragment;
    }

    public FragmentReference newFragmentReference() {
        FragmentReference fragment = null;
        try {
            fragment = (FragmentReference)this.createObject(this.fragmentReferenceClass);
            fragment.setId(this.generator.getNextPeid());
        }
        catch (ClassCastException e) {
            String message = "Failed to create page object for " + this.fragmentReferenceClass;
            log.error(message, (Throwable)e);
        }
        return fragment;
    }

    public PageFragment newPageFragment() {
        PageFragment fragment = null;
        try {
            fragment = (PageFragment)this.createObject(this.pageFragmentClass);
            fragment.setId(this.generator.getNextPeid());
        }
        catch (ClassCastException e) {
            String message = "Failed to create fragment object for " + this.pageFragmentClass;
            log.error(message, (Throwable)e);
        }
        return fragment;
    }

    public MenuDefinition newFolderMenuDefinition() {
        try {
            return (MenuDefinition)this.createObject(this.folderMenuDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu definition object for " + this.folderMenuDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuExcludeDefinition newFolderMenuExcludeDefinition() {
        try {
            return (MenuExcludeDefinition)this.createObject(this.folderMenuExcludeDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu exclude definition object for " + this.folderMenuExcludeDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuIncludeDefinition newFolderMenuIncludeDefinition() {
        try {
            return (MenuIncludeDefinition)this.createObject(this.folderMenuIncludeDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu include definition object for " + this.folderMenuIncludeDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuOptionsDefinition newFolderMenuOptionsDefinition() {
        try {
            return (MenuOptionsDefinition)this.createObject(this.folderMenuOptionsDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu options definition object for " + this.folderMenuOptionsDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuSeparatorDefinition newFolderMenuSeparatorDefinition() {
        try {
            return (MenuSeparatorDefinition)this.createObject(this.folderMenuSeparatorDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu separator definition object for " + this.folderMenuSeparatorDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuDefinition newPageMenuDefinition() {
        try {
            return (MenuDefinition)this.createObject(this.pageMenuDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu definition object for " + this.pageMenuDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuExcludeDefinition newPageMenuExcludeDefinition() {
        try {
            return (MenuExcludeDefinition)this.createObject(this.pageMenuExcludeDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu exclude definition object for " + this.pageMenuExcludeDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuIncludeDefinition newPageMenuIncludeDefinition() {
        try {
            return (MenuIncludeDefinition)this.createObject(this.pageMenuIncludeDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu include definition object for " + this.pageMenuIncludeDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuOptionsDefinition newPageMenuOptionsDefinition() {
        try {
            return (MenuOptionsDefinition)this.createObject(this.pageMenuOptionsDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu options definition object for " + this.pageMenuOptionsDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public MenuSeparatorDefinition newPageMenuSeparatorDefinition() {
        try {
            return (MenuSeparatorDefinition)this.createObject(this.pageMenuSeparatorDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu separator definition object for " + this.pageMenuSeparatorDefinitionClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraints newSecurityConstraints() {
        try {
            return (SecurityConstraints)this.createObject(this.securityConstraintsClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraints definition object for " + this.securityConstraintsClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newFolderSecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.folderSecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.folderSecurityConstraintClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newPageSecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.pageSecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.pageSecurityConstraintClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newFragmentSecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.fragmentSecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.fragmentSecurityConstraintClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newLinkSecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.linkSecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.linkSecurityConstraintClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newPageSecuritySecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.pageSecuritySecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.pageSecuritySecurityConstraintClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraintsDef newSecurityConstraintsDef() {
        try {
            return (SecurityConstraintsDef)this.createObject(this.securityConstraintsDefClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraints definition object for " + this.securityConstraintsDefClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public FragmentPreference newFragmentPreference() {
        try {
            return (FragmentPreference)this.createObject(this.fragmentPreferenceClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create fragment preference object for " + this.fragmentPropertyClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    public FragmentProperty newFragmentProperty() {
        try {
            return (FragmentProperty)this.createObject(this.fragmentPropertyClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create fragment property object for " + this.fragmentPropertyClass;
            log.error(message, (Throwable)e);
            return null;
        }
    }

    private Object createObject(Class classe) {
        Object object = null;
        try {
            object = classe.newInstance();
        }
        catch (Exception e) {
            log.error("Factory failed to create object: " + classe.getName(), (Throwable)e);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PageManagerEventListener listener) {
        List<PageManagerEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PageManagerEventListener listener) {
        List<PageManagerEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void reset() {
    }

    public void shutdown() {
    }

    public boolean isDistributed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNewNode(Node node) {
        ArrayList<PageManagerEventListener> listenersList = null;
        List<PageManagerEventListener> list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList<PageManagerEventListener>(this.listeners);
        }
        for (PageManagerEventListener listener : listenersList) {
            try {
                listener.newNode(node);
            }
            catch (Exception e) {
                log.error("Failed to notify page manager event listener", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUpdatedNode(Node node) {
        ArrayList<PageManagerEventListener> listenersList = null;
        List<PageManagerEventListener> list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList<PageManagerEventListener>(this.listeners);
        }
        for (PageManagerEventListener listener : listenersList) {
            try {
                listener.updatedNode(node);
            }
            catch (Exception e) {
                log.error("Failed to notify page manager event listener", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemovedNode(Node node) {
        ArrayList<PageManagerEventListener> listenersList = null;
        List<PageManagerEventListener> list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList<PageManagerEventListener>(this.listeners);
        }
        for (PageManagerEventListener listener : listenersList) {
            try {
                listener.removedNode(node);
            }
            catch (Exception e) {
                log.error("Failed to notify page manager event listener", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReapNodes() {
        ArrayList<PageManagerEventListener> listenersList = null;
        List<PageManagerEventListener> list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList<PageManagerEventListener>(this.listeners);
        }
        for (PageManagerEventListener listener : listenersList) {
            try {
                listener.reapNodes(this.nodeReapingInterval);
            }
            catch (Exception e) {
                log.error("Failed to notify page manager event listener", (Throwable)e);
            }
        }
    }

    public Folder copyFolder(Folder source, String path) throws NodeException {
        Folder folder = this.newFolder(path);
        folder.setDefaultPage(source.getDefaultPage());
        folder.setShortTitle(source.getShortTitle());
        folder.setTitle(source.getTitle());
        folder.setHidden(source.isHidden());
        folder.setDefaultDecorator(source.getDefaultDecorator("layout"), "layout");
        folder.setDefaultDecorator(source.getDefaultDecorator("portlet"), "portlet");
        folder.setSkin(source.getSkin());
        folder.getMetadata().copyFields(source.getMetadata().getFields());
        SecurityConstraints srcSecurity = source.getSecurityConstraints();
        if (srcSecurity != null && !srcSecurity.isEmpty()) {
            SecurityConstraints copiedSecurity = this.copySecurityConstraints(FOLDER_NODE_TYPE, srcSecurity);
            folder.setSecurityConstraints(copiedSecurity);
        }
        folder.setDocumentOrder(this.createList());
        for (String name : source.getDocumentOrder()) {
            folder.getDocumentOrder().add(name);
        }
        List menus = source.getMenuDefinitions();
        if (menus != null) {
            List<MenuDefinition> copiedMenus = this.copyMenuDefinitions(FOLDER_NODE_TYPE, menus);
            folder.setMenuDefinitions(copiedMenus);
        }
        return folder;
    }

    public Page copyPage(Page source, String path) throws NodeException {
        return this.copyPage(source, path, false);
    }

    public Page copyPage(Page source, String path, boolean copyIds) throws NodeException {
        Page page = this.newPage(path);
        this.copyPageAttributes((BasePageElement)source, copyIds, (BasePageElement)page);
        page.setHidden(source.isHidden());
        return page;
    }

    public PageTemplate copyPageTemplate(PageTemplate source, String path) throws NodeException {
        return this.copyPageTemplate(source, path, false);
    }

    public PageTemplate copyPageTemplate(PageTemplate source, String path, boolean copyIds) throws NodeException {
        PageTemplate pageTemplate = this.newPageTemplate(path);
        this.copyPageAttributes((BasePageElement)source, copyIds, (BasePageElement)pageTemplate);
        return pageTemplate;
    }

    public DynamicPage copyDynamicPage(DynamicPage source, String path) throws NodeException {
        return this.copyDynamicPage(source, path, false);
    }

    public DynamicPage copyDynamicPage(DynamicPage source, String path, boolean copyIds) throws NodeException {
        DynamicPage dynamicPage = this.newDynamicPage(path);
        this.copyPageAttributes((BasePageElement)source, copyIds, (BasePageElement)dynamicPage);
        dynamicPage.setHidden(source.isHidden());
        dynamicPage.setContentType(source.getContentType());
        dynamicPage.setInheritable(source.isInheritable());
        return dynamicPage;
    }

    public FragmentDefinition copyFragmentDefinition(FragmentDefinition source, String path) throws NodeException {
        return this.copyFragmentDefinition(source, path, false);
    }

    public FragmentDefinition copyFragmentDefinition(FragmentDefinition source, String path, boolean copyIds) throws NodeException {
        FragmentDefinition fragmentDefinition = this.newFragmentDefinition(path);
        this.copyFragmentsAttributes((BaseFragmentsElement)source, copyIds, (BaseFragmentsElement)fragmentDefinition);
        return fragmentDefinition;
    }

    protected void copyFragmentsAttributes(BaseFragmentsElement source, boolean copyIds, BaseFragmentsElement dest) throws NodeException {
        dest.setTitle(source.getTitle());
        dest.setShortTitle(source.getShortTitle());
        dest.setVersion(source.getVersion());
        dest.getMetadata().copyFields(source.getMetadata().getFields());
        SecurityConstraints srcSecurity = source.getSecurityConstraints();
        if (srcSecurity != null && !srcSecurity.isEmpty()) {
            SecurityConstraints copiedSecurity = this.copySecurityConstraints(PAGE_NODE_TYPE, srcSecurity);
            dest.setSecurityConstraints(copiedSecurity);
        }
        BaseFragmentElement root = this.copyFragment(source.getRootFragment(), null, copyIds);
        dest.setRootFragment(root);
    }

    protected void copyPageAttributes(BasePageElement source, boolean copyIds, BasePageElement dest) throws NodeException {
        this.copyFragmentsAttributes((BaseFragmentsElement)source, copyIds, (BaseFragmentsElement)dest);
        dest.setDefaultDecorator(source.getDefaultDecorator("layout"), "layout");
        dest.setDefaultDecorator(source.getDefaultDecorator("portlet"), "portlet");
        dest.setSkin(source.getSkin());
        List menus = source.getMenuDefinitions();
        if (menus != null) {
            List<MenuDefinition> copiedMenus = this.copyMenuDefinitions(PAGE_NODE_TYPE, menus);
            dest.setMenuDefinitions(copiedMenus);
        }
    }

    public BaseFragmentElement copyFragment(BaseFragmentElement source, String name) throws NodeException {
        return this.copyFragment(source, name, false);
    }

    public BaseFragmentElement copyFragment(BaseFragmentElement source, String name, boolean copyIds) throws NodeException {
        Fragment sourceFragment;
        Fragment copyFragment;
        Fragment copy;
        if (source instanceof Fragment) {
            copy = this.newFragment();
        } else if (source instanceof FragmentReference) {
            copy = this.newFragmentReference();
        } else if (source instanceof PageFragment) {
            copy = this.newPageFragment();
        } else {
            throw new IllegalArgumentException("Unsupported fragment type: " + (source != null ? source.getClass().getName() : "null"));
        }
        if (copyIds) {
            copy.setId(source.getId());
        }
        copy.setDecorator(source.getDecorator());
        copy.setLayoutColumn(source.getLayoutColumn());
        copy.setLayoutHeight(source.getLayoutHeight());
        copy.setLayoutRow(source.getLayoutRow());
        copy.setLayoutSizes(source.getLayoutSizes());
        copy.setLayoutX(source.getLayoutX());
        copy.setLayoutY(source.getLayoutY());
        copy.setLayoutZ(source.getLayoutZ());
        copy.setLayoutWidth(source.getLayoutWidth());
        copy.setMode(source.getMode());
        copy.setShortTitle(source.getShortTitle());
        copy.setSkin(source.getSkin());
        copy.setState(source.getState());
        copy.setTitle(source.getTitle());
        SecurityConstraints srcSecurity = source.getSecurityConstraints();
        if (srcSecurity != null && !srcSecurity.isEmpty()) {
            SecurityConstraints copiedSecurity = this.copySecurityConstraints(FRAGMENT_NODE_TYPE, srcSecurity);
            copy.setSecurityConstraints(copiedSecurity);
        }
        for (FragmentProperty prop : source.getProperties()) {
            String propName = prop.getName();
            String propScope = prop.getScope();
            String propScopeValue = prop.getScopeValue();
            if (propScope != null && (propScope.equals("group") || propScope.equals("role")) || copy.getProperty(propName, propScope, propScopeValue) != null) continue;
            copy.setProperty(propName, propScope, propScopeValue, prop.getValue());
        }
        for (FragmentPreference pref : source.getPreferences()) {
            FragmentPreference newPref = this.newFragmentPreference();
            newPref.setName(pref.getName());
            newPref.setReadOnly(pref.isReadOnly());
            newPref.setValueList(this.createList());
            for (String value : pref.getValueList()) {
                newPref.getValueList().add(value);
            }
            copy.getPreferences().add(newPref);
        }
        if (source instanceof Fragment) {
            copyFragment = copy;
            sourceFragment = (Fragment)source;
            if (name == null) {
                name = sourceFragment.getName();
            }
            copyFragment.setName(name);
            copyFragment.setType(sourceFragment.getType());
            for (BaseFragmentElement fragment : sourceFragment.getFragments()) {
                BaseFragmentElement copiedFragment = this.copyFragment(fragment, null, copyIds);
                copyFragment.getFragments().add(copiedFragment);
            }
        } else if (source instanceof FragmentReference) {
            copyFragment = (FragmentReference)copy;
            sourceFragment = (FragmentReference)source;
            copyFragment.setRefId(sourceFragment.getRefId());
        }
        return copy;
    }

    public Link copyLink(Link source, String path) throws NodeException {
        Link link = this.newLink(path);
        link.setTitle(source.getTitle());
        link.setShortTitle(source.getShortTitle());
        link.setSkin(source.getSkin());
        link.setVersion(source.getVersion());
        link.setTarget(source.getTarget());
        link.setUrl(source.getUrl());
        link.setHidden(source.isHidden());
        link.getMetadata().copyFields(source.getMetadata().getFields());
        SecurityConstraints srcSecurity = source.getSecurityConstraints();
        if (srcSecurity != null && !srcSecurity.isEmpty()) {
            SecurityConstraints copiedSecurity = this.copySecurityConstraints(LINK_NODE_TYPE, srcSecurity);
            link.setSecurityConstraints(copiedSecurity);
        }
        return link;
    }

    public PageSecurity copyPageSecurity(PageSecurity source) throws NodeException {
        PageSecurity copy = this.newPageSecurity();
        copy.setPath(source.getPath());
        copy.setVersion(source.getVersion());
        copy.setSecurityConstraintsDefs(this.createList());
        for (SecurityConstraintsDef def : source.getSecurityConstraintsDefs()) {
            SecurityConstraintsDef defCopy = this.newSecurityConstraintsDef();
            defCopy.setName(def.getName());
            List copiedConstraints = this.createList();
            for (SecurityConstraint srcConstraint : def.getSecurityConstraints()) {
                SecurityConstraint dstConstraint = this.newPageSecuritySecurityConstraint();
                this.copyConstraint(srcConstraint, dstConstraint);
                copiedConstraints.add(dstConstraint);
            }
            defCopy.setSecurityConstraints(copiedConstraints);
            copy.getSecurityConstraintsDefs().add(defCopy);
        }
        copy.setGlobalSecurityConstraintsRefs(this.createList());
        for (String global : source.getGlobalSecurityConstraintsRefs()) {
            copy.getGlobalSecurityConstraintsRefs().add(global);
        }
        return copy;
    }

    protected List<MenuDefinition> copyMenuDefinitions(String type, List<MenuDefinition> srcMenus) {
        List copiedMenus = this.createList();
        for (MenuDefinition srcMenu : srcMenus) {
            MenuDefinition copiedMenu = (MenuDefinition)this.copyMenuElement(type, (MenuDefinitionElement)srcMenu);
            if (copiedMenu == null) continue;
            copiedMenus.add(copiedMenu);
        }
        return copiedMenus;
    }

    protected MenuDefinitionElement copyMenuElement(String type, MenuDefinitionElement srcElement) {
        if (srcElement instanceof MenuDefinition) {
            MenuDefinition source = (MenuDefinition)srcElement;
            MenuDefinition menu = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menu = this.newPageMenuDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menu = this.newFolderMenuDefinition();
            }
            menu.setDepth(source.getDepth());
            menu.setName(source.getName());
            menu.setOptions(source.getOptions());
            menu.setOrder(source.getOrder());
            menu.setPaths(source.isPaths());
            menu.setProfile(source.getProfile());
            menu.setRegexp(source.isRegexp());
            menu.setShortTitle(source.getShortTitle());
            menu.setSkin(source.getSkin());
            menu.setTitle(source.getTitle());
            menu.getMetadata().copyFields(source.getMetadata().getFields());
            List elements = source.getMenuElements();
            if (elements != null) {
                List copiedElements = this.createList();
                for (MenuDefinitionElement element : elements) {
                    MenuDefinitionElement copiedElement = this.copyMenuElement(type, element);
                    if (copiedElement == null) continue;
                    copiedElements.add(copiedElement);
                }
                menu.setMenuElements(copiedElements);
            }
            return menu;
        }
        if (srcElement instanceof MenuExcludeDefinition) {
            MenuExcludeDefinition source = (MenuExcludeDefinition)srcElement;
            MenuExcludeDefinition menuExclude = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuExclude = this.newPageMenuExcludeDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuExclude = this.newFolderMenuExcludeDefinition();
            }
            menuExclude.setName(source.getName());
            return menuExclude;
        }
        if (srcElement instanceof MenuIncludeDefinition) {
            MenuIncludeDefinition source = (MenuIncludeDefinition)srcElement;
            MenuIncludeDefinition menuInclude = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuInclude = this.newPageMenuIncludeDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuInclude = this.newFolderMenuIncludeDefinition();
            }
            menuInclude.setName(source.getName());
            menuInclude.setNest(source.isNest());
            return menuInclude;
        }
        if (srcElement instanceof MenuOptionsDefinition) {
            MenuOptionsDefinition source = (MenuOptionsDefinition)srcElement;
            MenuOptionsDefinition menuOptions = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuOptions = this.newPageMenuOptionsDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuOptions = this.newFolderMenuOptionsDefinition();
            }
            menuOptions.setDepth(source.getDepth());
            menuOptions.setOptions(source.getOptions());
            menuOptions.setOrder(source.getOrder());
            menuOptions.setPaths(source.isPaths());
            menuOptions.setProfile(source.getProfile());
            menuOptions.setRegexp(source.isRegexp());
            menuOptions.setSkin(source.getSkin());
            return menuOptions;
        }
        if (srcElement instanceof MenuSeparatorDefinition) {
            MenuSeparatorDefinition source = (MenuSeparatorDefinition)srcElement;
            MenuSeparatorDefinition menuSeparator = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuSeparator = this.newPageMenuSeparatorDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuSeparator = this.newFolderMenuSeparatorDefinition();
            }
            menuSeparator.setSkin(source.getSkin());
            menuSeparator.setTitle(source.getTitle());
            menuSeparator.setText(source.getText());
            menuSeparator.getMetadata().copyFields(source.getMetadata().getFields());
            return menuSeparator;
        }
        return null;
    }

    protected void copyConstraint(SecurityConstraint srcConstraint, SecurityConstraint dstConstraint) {
        dstConstraint.setUsers(srcConstraint.getUsers());
        dstConstraint.setRoles(srcConstraint.getRoles());
        dstConstraint.setGroups(srcConstraint.getGroups());
        dstConstraint.setPermissions(srcConstraint.getPermissions());
    }

    protected SecurityConstraints copySecurityConstraints(String type, SecurityConstraints source) {
        SecurityConstraints security = this.newSecurityConstraints();
        if (source.getOwner() != null) {
            security.setOwner(source.getOwner());
        }
        if (source.getSecurityConstraints() != null) {
            List copiedConstraints = this.createList();
            for (SecurityConstraint srcConstraint : source.getSecurityConstraints()) {
                SecurityConstraint dstConstraint = null;
                if (type.equals(PAGE_NODE_TYPE)) {
                    dstConstraint = this.newPageSecurityConstraint();
                } else if (type.equals(FOLDER_NODE_TYPE)) {
                    dstConstraint = this.newFolderSecurityConstraint();
                } else if (type.equals(LINK_NODE_TYPE)) {
                    dstConstraint = this.newLinkSecurityConstraint();
                } else if (type.equals(FRAGMENT_NODE_TYPE)) {
                    dstConstraint = this.newFragmentSecurityConstraint();
                }
                this.copyConstraint(srcConstraint, dstConstraint);
                copiedConstraints.add(dstConstraint);
            }
            security.setSecurityConstraints(copiedConstraints);
        }
        if (source.getSecurityConstraintsRefs() != null) {
            List copiedRefs = this.createList();
            for (String constraintsRef : source.getSecurityConstraintsRefs()) {
                copiedRefs.add(constraintsRef);
            }
            security.setSecurityConstraintsRefs(copiedRefs);
        }
        return security;
    }

    public void deepCopyFolder(Folder srcFolder, String destinationPath, String owner) throws NodeException {
        this.deepCopyFolder(srcFolder, destinationPath, owner, false);
    }

    public void deepCopyFolder(Folder srcFolder, String destinationPath, String owner, boolean copyIds) throws NodeException {
        PageManagerUtils.deepCopyFolder(this, srcFolder, destinationPath, owner, copyIds);
    }

    public void deepMergeFolder(Folder srcFolder, String destinationPath, String owner) throws NodeException {
        this.deepMergeFolder(srcFolder, destinationPath, owner, false);
    }

    public void deepMergeFolder(Folder srcFolder, String destinationPath, String owner, boolean copyIds) throws NodeException {
        PageManagerUtils.deepMergeFolder((PageManager)this, srcFolder, destinationPath, owner, copyIds);
    }

    public Page getUserPage(String userName, String pageName) throws PageNotFoundException, NodeException {
        return this.getPage("/_user/" + userName + "/" + pageName);
    }

    public Folder getUserFolder(String userName) throws FolderNotFoundException, InvalidFolderException, NodeException {
        return this.getFolder("/_user/" + userName);
    }

    public boolean folderExists(String folderName) {
        try {
            this.getFolder(folderName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean pageExists(String pageName) {
        try {
            this.getPage(pageName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean pageTemplateExists(String pageName) {
        try {
            this.getPageTemplate(pageName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean dynamicPageExists(String pageName) {
        try {
            this.getDynamicPage(pageName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean fragmentDefinitionExists(String name) {
        try {
            this.getFragmentDefinition(name);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean linkExists(String linkName) {
        try {
            this.getLink(linkName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean userFolderExists(String userName) {
        try {
            this.getFolder("/_user/" + userName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean userPageExists(String userName, String pageName) {
        try {
            this.getPage("/_user/" + userName + "/" + pageName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void cleanupRequestCache() {
    }

    public void createUserHomePagesFromRoles(Subject subject) throws NodeException {
        PageManagerUtils.createUserHomePagesFromRoles(this, subject);
    }

    public FragmentPropertyManagement getFragmentPropertyManager() {
        return null;
    }
}

