/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.SecurityConstraintImpl;
import org.apache.jetspeed.om.page.SecurityConstraintsRefExpression;
import org.apache.jetspeed.om.page.SecurityConstraintsRefParser;
import org.apache.jetspeed.om.page.impl.BaseSecurityConstraintsRef;
import org.apache.jetspeed.om.page.impl.SecurityConstraintList;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsRefList;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConstraintsImpl
implements SecurityConstraints {
    private static final Logger log = LoggerFactory.getLogger(SecurityConstraintsImpl.class);
    private String owner;
    private List<SecurityConstraintImpl> constraints;
    private List<BaseSecurityConstraintsRef> constraintsRefs;
    private SecurityConstraintList securityConstraints;
    private SecurityConstraintsRefList securityConstraintsRefs;
    private List<Object> allConstraints;

    List<BaseSecurityConstraintsRef> accessConstraintsRefs() {
        if (this.constraintsRefs == null) {
            this.constraintsRefs = DatabasePageManagerUtils.createList();
        }
        return this.constraintsRefs;
    }

    List<SecurityConstraintImpl> accessConstraints() {
        if (this.constraints == null) {
            this.constraints = DatabasePageManagerUtils.createList();
        }
        return this.constraints;
    }

    public Class getSecurityConstraintClass() {
        return null;
    }

    public Class getSecurityConstraintsRefClass() {
        return null;
    }

    public void checkConstraints(List<String> actions, List<String> userPrincipals, List<String> rolePrincipals, List<String> groupPrincipals, PageSecurity pageSecurity) throws SecurityException {
        if (this.owner != null && userPrincipals != null && userPrincipals.contains(this.owner)) {
            return;
        }
        try {
            List<Object> checkConstraints = this.getAllSecurityConstraints(pageSecurity);
            if (checkConstraints != null && !checkConstraints.isEmpty()) {
                for (String action : actions) {
                    boolean actionPermitted = false;
                    boolean actionNotPermitted = false;
                    boolean anyActionsPermitted = this.getOwner() != null;
                    for (Object constraintOrExpression : checkConstraints) {
                        if (constraintOrExpression instanceof SecurityConstraintImpl) {
                            SecurityConstraintImpl constraint = (SecurityConstraintImpl)constraintOrExpression;
                            if (constraint.getPermissions() != null) {
                                anyActionsPermitted = true;
                                if (!constraint.actionMatch(action) || !constraint.principalsMatch(userPrincipals, rolePrincipals, groupPrincipals, true)) continue;
                                actionPermitted = true;
                                break;
                            }
                            if (!constraint.principalsMatch(userPrincipals, rolePrincipals, groupPrincipals, false)) continue;
                            actionNotPermitted = true;
                            break;
                        }
                        if (!(constraintOrExpression instanceof SecurityConstraintsRefExpression)) continue;
                        SecurityConstraintsRefExpression expression = (SecurityConstraintsRefExpression)constraintOrExpression;
                        anyActionsPermitted = true;
                        if (!expression.checkExpression(action, userPrincipals, rolePrincipals, groupPrincipals)) continue;
                        actionPermitted = true;
                        break;
                    }
                    if ((actionPermitted || !anyActionsPermitted) && !actionNotPermitted) continue;
                    throw new SecurityException("SecurityConstraintsImpl.checkConstraints(): Access for " + action + " not permitted.");
                }
            } else if (this.getOwner() != null && !actions.isEmpty()) {
                String action = actions.get(0);
                throw new SecurityException("SecurityConstraintsImpl.checkConstraints(): Access for " + action + " not permitted, (not owner).");
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("Security constraints check exception: " + e, (Throwable)e);
            } else {
                log.error("Security constraints check exception: " + e);
            }
            throw new SecurityException("SecurityConstraintsImpl.checkConstraints(): Exception detected: " + e);
        }
    }

    public void resetCachedSecurityConstraints() {
        this.clearAllSecurityConstraints();
    }

    private synchronized List<Object> getAllSecurityConstraints(PageSecurity pageSecurity) {
        List<Object> referencedConstraints;
        List globalConstraintsRefs;
        List<Object> referencedConstraints2;
        if (this.allConstraints != null) {
            return this.allConstraints;
        }
        ArrayList<Object> newAllConstraints = new ArrayList<Object>();
        if (this.getSecurityConstraints() != null && !this.getSecurityConstraints().isEmpty()) {
            newAllConstraints.addAll(this.securityConstraints);
        }
        if (this.getSecurityConstraintsRefs() != null && !this.getSecurityConstraintsRefs().isEmpty() && (referencedConstraints2 = this.dereferenceSecurityConstraintsRefs(this.getSecurityConstraintsRefs(), pageSecurity)) != null) {
            newAllConstraints.addAll(referencedConstraints2);
        }
        if (pageSecurity != null && (globalConstraintsRefs = pageSecurity.getGlobalSecurityConstraintsRefs()) != null && !globalConstraintsRefs.isEmpty() && (referencedConstraints = this.dereferenceSecurityConstraintsRefs(globalConstraintsRefs, pageSecurity)) != null) {
            newAllConstraints.addAll(referencedConstraints);
        }
        this.allConstraints = newAllConstraints;
        return this.allConstraints;
    }

    synchronized void clearAllSecurityConstraints() {
        this.allConstraints = null;
    }

    private List<Object> dereferenceSecurityConstraintsRefs(List<String> constraintsRefs, PageSecurity pageSecurity) {
        ArrayList<Object> constraints = null;
        if (pageSecurity != null) {
            for (String constraintsRef : constraintsRefs) {
                Object parsedConstraintsOrExpression = SecurityConstraintsRefParser.parse(constraintsRef, pageSecurity);
                if (parsedConstraintsOrExpression instanceof List) {
                    List parsedConstraints = (List)parsedConstraintsOrExpression;
                    if (constraints == null) {
                        constraints = new ArrayList<Object>();
                    }
                    constraints.addAll(parsedConstraints);
                    continue;
                }
                if (parsedConstraintsOrExpression instanceof SecurityConstraintsRefExpression) {
                    if (constraints == null) {
                        constraints = new ArrayList();
                    }
                    constraints.add(parsedConstraintsOrExpression);
                    continue;
                }
                if (parsedConstraintsOrExpression == null) continue;
                throw new RuntimeException("Unexpected security constraints ref parser result");
            }
        } else {
            throw new RuntimeException("Page security definitions not available");
        }
        return constraints;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
        this.clearAllSecurityConstraints();
    }

    public List<SecurityConstraint> getSecurityConstraints() {
        if (this.securityConstraints == null) {
            this.securityConstraints = new SecurityConstraintList(this);
        }
        return this.securityConstraints;
    }

    public void setSecurityConstraints(List<SecurityConstraint> constraints) {
        List<SecurityConstraint> securityConstraints = this.getSecurityConstraints();
        if (constraints != securityConstraints) {
            securityConstraints.clear();
            if (constraints != null) {
                securityConstraints.addAll(constraints);
            }
        }
        this.clearAllSecurityConstraints();
    }

    public List<String> getSecurityConstraintsRefs() {
        if (this.securityConstraintsRefs == null) {
            this.securityConstraintsRefs = new SecurityConstraintsRefList(this);
        }
        return this.securityConstraintsRefs;
    }

    public void setSecurityConstraintsRefs(List<String> constraintsRefs) {
        List<String> securityConstraintsRefs = this.getSecurityConstraintsRefs();
        if (constraintsRefs != securityConstraintsRefs) {
            securityConstraintsRefs.clear();
            if (constraintsRefs != null) {
                securityConstraintsRefs.addAll(constraintsRefs);
            }
        }
        this.clearAllSecurityConstraints();
    }

    public boolean isEmpty() {
        return !(this.owner != null || this.constraints != null && !this.constraints.isEmpty() || this.constraintsRefs != null && !this.constraintsRefs.isEmpty());
    }
}

