/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jetspeed.om.page.impl.PageSecurityGlobalSecurityConstraintsRef;
import org.apache.jetspeed.om.page.impl.PageSecurityImpl;

class PageSecurityConstraintsRefList
extends AbstractList<String> {
    private PageSecurityImpl pageSecurity;
    private List<PageSecurityGlobalSecurityConstraintsRef> removedConstraintsRefs;

    PageSecurityConstraintsRefList(PageSecurityImpl pageSecurity) {
        this.pageSecurity = pageSecurity;
    }

    private PageSecurityGlobalSecurityConstraintsRef wrapNameStringForAdd(String name) {
        int removedIndex;
        if (name == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        PageSecurityGlobalSecurityConstraintsRef constraintsRef = new PageSecurityGlobalSecurityConstraintsRef();
        constraintsRef.setName(name);
        if (this.pageSecurity.accessGlobalConstraintsRefs().contains(constraintsRef)) {
            throw new IllegalArgumentException("Unable to add duplicate entry to list: " + constraintsRef.getName());
        }
        if (this.removedConstraintsRefs != null && (removedIndex = this.removedConstraintsRefs.indexOf(constraintsRef)) >= 0) {
            constraintsRef = this.removedConstraintsRefs.remove(removedIndex);
        }
        return constraintsRef;
    }

    private List<PageSecurityGlobalSecurityConstraintsRef> getRemovedConstraintsRefs() {
        if (this.removedConstraintsRefs == null) {
            this.removedConstraintsRefs = Collections.synchronizedList(new ArrayList());
        }
        return this.removedConstraintsRefs;
    }

    @Override
    public void add(int index, String element) {
        PageSecurityGlobalSecurityConstraintsRef nextConstraintsRef;
        if (index < 0 || index > this.pageSecurity.accessGlobalConstraintsRefs().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        PageSecurityGlobalSecurityConstraintsRef constraintsRef = this.wrapNameStringForAdd(element);
        this.pageSecurity.accessGlobalConstraintsRefs().add(index, constraintsRef);
        if (index > 0) {
            constraintsRef.setApplyOrder(this.pageSecurity.accessGlobalConstraintsRefs().get(index - 1).getApplyOrder() + 1);
        } else {
            constraintsRef.setApplyOrder(0);
        }
        int limit = this.pageSecurity.accessGlobalConstraintsRefs().size() - 1;
        for (int i = index; i < limit && (nextConstraintsRef = this.pageSecurity.accessGlobalConstraintsRefs().get(i + 1)).getApplyOrder() <= constraintsRef.getApplyOrder(); ++i) {
            nextConstraintsRef.setApplyOrder(constraintsRef.getApplyOrder() + 1);
            constraintsRef = nextConstraintsRef;
        }
    }

    @Override
    public String get(int index) {
        return this.pageSecurity.accessGlobalConstraintsRefs().get(index).getName();
    }

    @Override
    public String remove(int index) {
        PageSecurityGlobalSecurityConstraintsRef removed = this.pageSecurity.accessGlobalConstraintsRefs().remove(index);
        if (removed != null) {
            this.getRemovedConstraintsRefs().add(removed);
            return removed.getName();
        }
        return null;
    }

    @Override
    public String set(int index, String element) {
        PageSecurityGlobalSecurityConstraintsRef newConstraintsRef = this.wrapNameStringForAdd(element);
        PageSecurityGlobalSecurityConstraintsRef constraintsRef = this.pageSecurity.accessGlobalConstraintsRefs().set(index, newConstraintsRef);
        newConstraintsRef.setApplyOrder(constraintsRef.getApplyOrder());
        this.getRemovedConstraintsRefs().add(constraintsRef);
        return constraintsRef.getName();
    }

    @Override
    public int size() {
        return this.pageSecurity.accessGlobalConstraintsRefs().size();
    }
}

