/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.AbstractList;
import org.apache.jetspeed.om.folder.MenuDefinitionElement;
import org.apache.jetspeed.om.page.impl.PageMenuDefinitionElement;
import org.apache.jetspeed.om.page.impl.PageMenuDefinitionImpl;

class PageMenuDefinitionElementList
extends AbstractList<MenuDefinitionElement> {
    private PageMenuDefinitionImpl menuDefinition;

    PageMenuDefinitionElementList(PageMenuDefinitionImpl menuDefinition) {
        this.menuDefinition = menuDefinition;
    }

    private PageMenuDefinitionElement validateMenuElementForAdd(MenuDefinitionElement menuElement) {
        if (menuElement == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        return (PageMenuDefinitionElement)menuElement;
    }

    @Override
    public void add(int index, MenuDefinitionElement element) {
        PageMenuDefinitionElement nextMenuElement;
        if (index < 0 || index > this.menuDefinition.accessElements().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        PageMenuDefinitionElement menuElement = this.validateMenuElementForAdd(element);
        this.menuDefinition.accessElements().add(index, menuElement);
        if (index > 0) {
            menuElement.setElementOrder(((PageMenuDefinitionElement)this.menuDefinition.accessElements().get(index - 1)).getElementOrder() + 1);
        } else {
            menuElement.setElementOrder(0);
        }
        int limit = this.menuDefinition.accessElements().size() - 1;
        for (int i = index; i < limit && (nextMenuElement = (PageMenuDefinitionElement)this.menuDefinition.accessElements().get(i + 1)).getElementOrder() <= menuElement.getElementOrder(); ++i) {
            nextMenuElement.setElementOrder(menuElement.getElementOrder() + 1);
            menuElement = nextMenuElement;
        }
    }

    @Override
    public MenuDefinitionElement get(int index) {
        return this.menuDefinition.accessElements().get(index);
    }

    @Override
    public MenuDefinitionElement remove(int index) {
        return this.menuDefinition.accessElements().remove(index);
    }

    @Override
    public MenuDefinitionElement set(int index, MenuDefinitionElement element) {
        PageMenuDefinitionElement newMenuElement = this.validateMenuElementForAdd(element);
        PageMenuDefinitionElement menuElement = (PageMenuDefinitionElement)this.menuDefinition.accessElements().set(index, newMenuElement);
        newMenuElement.setElementOrder(menuElement.getElementOrder());
        return menuElement;
    }

    @Override
    public int size() {
        return this.menuDefinition.accessElements().size();
    }
}

