/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.AbstractList;
import org.apache.jetspeed.om.page.impl.FragmentPreferenceImpl;
import org.apache.jetspeed.om.page.impl.FragmentPreferenceValue;

class FragmentPreferenceValueList
extends AbstractList<String> {
    private FragmentPreferenceImpl preference;

    FragmentPreferenceValueList(FragmentPreferenceImpl preference) {
        this.preference = preference;
    }

    private FragmentPreferenceValue wrapValueStringForAdd(String value) {
        if (value == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        FragmentPreferenceValue preferenceValue = new FragmentPreferenceValue();
        preferenceValue.setValue(value);
        return preferenceValue;
    }

    @Override
    public void add(int index, String element) {
        FragmentPreferenceValue nextPreferenceValue;
        if (index < 0 || index > this.preference.accessValues().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        FragmentPreferenceValue preferenceValue = this.wrapValueStringForAdd(element);
        this.preference.accessValues().add(index, preferenceValue);
        if (index > 0) {
            preferenceValue.setValueOrder(this.preference.accessValues().get(index - 1).getValueOrder() + 1);
        } else {
            preferenceValue.setValueOrder(0);
        }
        int limit = this.preference.accessValues().size() - 1;
        for (int i = index; i < limit && (nextPreferenceValue = this.preference.accessValues().get(i + 1)).getValueOrder() <= preferenceValue.getValueOrder(); ++i) {
            nextPreferenceValue.setValueOrder(preferenceValue.getValueOrder() + 1);
            preferenceValue = nextPreferenceValue;
        }
    }

    @Override
    public String get(int index) {
        return this.preference.accessValues().get(index).getValue();
    }

    @Override
    public String remove(int index) {
        return this.preference.accessValues().remove(index).getValue();
    }

    @Override
    public String set(int index, String element) {
        FragmentPreferenceValue newPreferenceValue = this.wrapValueStringForAdd(element);
        FragmentPreferenceValue preferenceValue = this.preference.accessValues().set(index, newPreferenceValue);
        newPreferenceValue.setValueOrder(preferenceValue.getValueOrder());
        return preferenceValue.getValue();
    }

    @Override
    public int size() {
        return this.preference.accessValues().size();
    }
}

