/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.page.BaseFragmentElement;
import org.apache.jetspeed.om.page.BaseFragmentValidationListener;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.impl.BaseFragmentElementImpl;
import org.apache.jetspeed.om.page.impl.BaseFragmentsElementImpl;
import org.apache.jetspeed.om.page.impl.FilteredFragmentList;
import org.apache.jetspeed.om.page.impl.FragmentList;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

public class FragmentImpl
extends BaseFragmentElementImpl
implements Fragment {
    private List<BaseFragmentElementImpl> fragments;
    private String type;
    private FragmentList fragmentsList;

    List<BaseFragmentElementImpl> accessFragments() {
        if (this.fragments == null) {
            this.fragments = DatabasePageManagerUtils.createList();
        }
        return this.fragments;
    }

    @Override
    void setBaseFragmentsElement(BaseFragmentsElementImpl baseFragmentsElement) {
        super.setBaseFragmentsElement(baseFragmentsElement);
        if (this.fragments != null) {
            for (BaseFragmentElementImpl fragmentElement : this.fragments) {
                fragmentElement.setBaseFragmentsElement(baseFragmentsElement);
            }
        }
    }

    @Override
    public BaseFragmentElement getFragmentById(String id) {
        if (this.getId().equals(id)) {
            return this;
        }
        if (this.fragments != null) {
            for (BaseFragmentElementImpl fragmentElement : this.fragments) {
                BaseFragmentElement matchedFragment = fragmentElement.getFragmentById(id);
                if (matchedFragment == null) continue;
                return matchedFragment;
            }
        }
        return null;
    }

    public BaseFragmentElement removeFragmentById(String id) {
        if (this.fragments != null) {
            Iterator<BaseFragmentElementImpl> fragmentsIter = this.fragments.iterator();
            while (fragmentsIter.hasNext()) {
                BaseFragmentElementImpl fragment = fragmentsIter.next();
                if (!fragment.getId().equals(id)) {
                    BaseFragmentElement removed;
                    if (!(fragment instanceof FragmentImpl) || (removed = ((FragmentImpl)fragment).removeFragmentById(id)) == null) continue;
                    return removed;
                }
                try {
                    fragment.checkAccess(JetspeedActions.EDIT);
                    fragmentsIter.remove();
                    return fragment;
                }
                catch (SecurityException se) {
                }
            }
        }
        return null;
    }

    @Override
    List<BaseFragmentElement> getFragmentsByName(String name) {
        List<BaseFragmentElement> matchedFragments = super.getFragmentsByName(name);
        if (this.fragments != null) {
            for (BaseFragmentElementImpl fragmentElement : this.fragments) {
                List<BaseFragmentElement> matchedChildFragments = fragmentElement.getFragmentsByName(name);
                if (matchedChildFragments == null) continue;
                if (matchedFragments == null) {
                    matchedFragments = matchedChildFragments;
                    continue;
                }
                matchedFragments.addAll(matchedChildFragments);
            }
        }
        return matchedFragments;
    }

    @Override
    List<BaseFragmentElement> getFragmentsByInterface(Class interfaceFilter) {
        List<BaseFragmentElement> matchedFragments = super.getFragmentsByInterface(interfaceFilter);
        if (this.fragments != null) {
            for (BaseFragmentElementImpl fragmentElement : this.fragments) {
                List<BaseFragmentElement> matchedChildFragments = fragmentElement.getFragmentsByInterface(interfaceFilter);
                if (matchedChildFragments == null) continue;
                if (matchedFragments == null) {
                    matchedFragments = matchedChildFragments;
                    continue;
                }
                matchedFragments.addAll(matchedChildFragments);
            }
        }
        return matchedFragments;
    }

    @Override
    public void resetCachedSecurityConstraints() {
        super.resetCachedSecurityConstraints();
        if (this.fragments != null) {
            for (BaseFragmentElementImpl fragmentElement : this.fragments) {
                fragmentElement.resetCachedSecurityConstraints();
            }
        }
    }

    @Override
    public String getLogicalPermissionPath() {
        if (this.getBaseFragmentsElement() != null && this.getName() != null) {
            return this.getBaseFragmentsElement().getLogicalPermissionPath() + "/" + this.getName();
        }
        return null;
    }

    @Override
    public String getPhysicalPermissionPath() {
        if (this.getBaseFragmentsElement() != null && this.getName() != null) {
            return this.getBaseFragmentsElement().getPhysicalPermissionPath() + "/" + this.getName();
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<BaseFragmentElement> getFragments() {
        if (this.fragmentsList == null) {
            this.fragmentsList = new FragmentList(this);
        }
        return this.filterFragmentsByAccess(this.fragmentsList, true);
    }

    @Override
    protected boolean validateFragments(BaseFragmentValidationListener validationListener) {
        if (!validationListener.validate(this)) {
            return false;
        }
        if (this.fragments != null) {
            for (BaseFragmentElementImpl fragmentElement : this.fragments) {
                if (fragmentElement.validateFragments(validationListener)) continue;
                return false;
            }
        }
        return true;
    }

    List<BaseFragmentElement> filterFragmentsByAccess(List<BaseFragmentElement> fragments, boolean mutable) {
        if (fragments != null && !fragments.isEmpty()) {
            ArrayList<BaseFragmentElement> filteredFragments = null;
            for (BaseFragmentElement fragment : fragments) {
                try {
                    fragment.checkAccess(JetspeedActions.VIEW);
                    if (filteredFragments == null) continue;
                    filteredFragments.add(fragment);
                }
                catch (SecurityException se) {
                    if (filteredFragments != null) continue;
                    filteredFragments = new ArrayList<BaseFragmentElement>(fragments.size());
                    for (BaseFragmentElement copyFragment : fragments) {
                        if (copyFragment == fragment) break;
                        filteredFragments.add(copyFragment);
                    }
                }
            }
            if (filteredFragments != null) {
                if (!filteredFragments.isEmpty()) {
                    if (mutable) {
                        return new FilteredFragmentList(this, (List<BaseFragmentElement>)filteredFragments);
                    }
                    return filteredFragments;
                }
                return new FilteredFragmentList(this, (List<BaseFragmentElement>)filteredFragments);
            }
        }
        return fragments;
    }
}

