/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page;

import java.util.List;
import java.util.Stack;
import org.apache.jetspeed.om.page.SecurityConstraintImpl;
import org.apache.jetspeed.om.page.SecurityConstraintsRefToken;

public class SecurityConstraintsRefExpression {
    private String constraintsRef;
    private List<SecurityConstraintsRefToken> constraintsRefTokens;

    SecurityConstraintsRefExpression(String constraintsRef, List<SecurityConstraintsRefToken> constraintsRefTokens) {
        this.constraintsRef = constraintsRef;
        this.constraintsRefTokens = constraintsRefTokens;
    }

    public boolean checkExpression(String action, List<String> userPrincipals, List<String> rolePrincipals, List<String> groupPrincipals) {
        Stack<Boolean> operandsStack = new Stack<Boolean>();
        for (SecurityConstraintsRefToken token : this.constraintsRefTokens) {
            boolean operand;
            String tokenOperation = token.getOperation();
            if (tokenOperation != null) {
                boolean operand2;
                boolean operand1;
                boolean operand0;
                if (tokenOperation.equals("not")) {
                    if (operandsStack.size() >= 1) {
                        operand = (Boolean)operandsStack.pop();
                        operand = !operand;
                        operandsStack.push(operand);
                        continue;
                    }
                    throw new RuntimeException("Missing NOT expression operand in \"" + this.constraintsRef + "\"");
                }
                if (tokenOperation.equals("and")) {
                    if (operandsStack.size() >= 2) {
                        operand0 = (Boolean)operandsStack.pop();
                        operand1 = (Boolean)operandsStack.pop();
                        operand2 = operand0 && operand1;
                        operandsStack.push(operand2);
                        continue;
                    }
                    throw new RuntimeException("Missing AND expression operand in \"" + this.constraintsRef + "\"");
                }
                if (tokenOperation.equals("or")) {
                    if (operandsStack.size() >= 2) {
                        operand0 = (Boolean)operandsStack.pop();
                        operand1 = (Boolean)operandsStack.pop();
                        operand2 = operand0 || operand1;
                        operandsStack.push(operand2);
                        continue;
                    }
                    throw new RuntimeException("Missing OR expression operand in \"" + this.constraintsRef + "\"");
                }
                throw new RuntimeException("Unexpected expression operator " + tokenOperation + " in \"" + this.constraintsRef + "\"");
            }
            if (token.getConstraint() != null) {
                operand = this.checkExpressionConstraint(action, userPrincipals, rolePrincipals, groupPrincipals, token.getConstraint());
                operandsStack.push(operand);
                continue;
            }
            throw new RuntimeException("Unexpected expression token in \"" + this.constraintsRef + "\"");
        }
        if (operandsStack.size() == 1) {
            return (Boolean)operandsStack.pop();
        }
        throw new RuntimeException("Unexpected expression operand in \"" + this.constraintsRef + "\"");
    }

    private boolean checkExpressionConstraint(String action, List<String> userPrincipals, List<String> rolePrincipals, List<String> groupPrincipals, SecurityConstraintImpl constraint) {
        if (constraint.getPermissions() != null) {
            return constraint.actionMatch(action) && constraint.principalsMatch(userPrincipals, rolePrincipals, groupPrincipals, true);
        }
        return !constraint.principalsMatch(userPrincipals, rolePrincipals, groupPrincipals, false);
    }
}

