/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.document.psml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.jetspeed.cache.file.FileCache;
import org.apache.jetspeed.cache.file.FileCacheEntry;
import org.apache.jetspeed.cache.file.FileCacheEventListener;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.om.folder.Reset;
import org.apache.jetspeed.om.folder.psml.FolderImpl;
import org.apache.jetspeed.om.folder.psml.FolderMetaDataImpl;
import org.apache.jetspeed.om.page.Document;
import org.apache.jetspeed.page.document.DocumentHandler;
import org.apache.jetspeed.page.document.DocumentHandlerFactory;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.FailedToDeleteFolderException;
import org.apache.jetspeed.page.document.FailedToUpdateFolderException;
import org.apache.jetspeed.page.document.FolderHandler;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.UnsupportedDocumentTypeException;
import org.apache.jetspeed.page.document.psml.AbstractNode;
import org.apache.jetspeed.page.document.psml.NodeSetImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemFolderHandler
implements FolderHandler,
FileCacheEventListener {
    private IdGenerator generator;
    private File documentRootDir;
    private DocumentHandler metadataDocHandler;
    private DocumentHandlerFactory handlerFactory;
    private static final Logger log = LoggerFactory.getLogger(FileSystemFolderHandler.class);
    protected static final FilenameFilter FOLDER_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File pathname, String fileName) {
            return new File(pathname, fileName).isDirectory();
        }
    };
    private FileCache fileCache;

    public FileSystemFolderHandler(IdGenerator generator, String documentRoot, DocumentHandlerFactory handlerFactory, FileCache fileCache) throws FileNotFoundException, UnsupportedDocumentTypeException {
        this.generator = generator;
        this.documentRootDir = new File(documentRoot);
        this.verifyPath(this.documentRootDir);
        this.handlerFactory = handlerFactory;
        this.metadataDocHandler = handlerFactory.getDocumentHandler("folder.metadata");
        this.fileCache = fileCache;
        this.fileCache.addListener((FileCacheEventListener)this);
    }

    public Folder getFolder(String path) throws FolderNotFoundException, InvalidFolderException, NodeException {
        return this.getFolder(path, true);
    }

    protected void verifyPath(File path) throws FileNotFoundException {
        if (path == null) {
            throw new IllegalArgumentException("Page root cannot be null");
        }
        if (!path.exists()) {
            throw new FileNotFoundException("Could not locate root pages path " + path.getAbsolutePath());
        }
    }

    public Folder getFolder(String path, boolean fromCache) throws NodeException, FolderNotFoundException, InvalidFolderException {
        Folder folder = null;
        File folderFile = new File(this.documentRootDir, path);
        if (!folderFile.exists()) {
            throw new FolderNotFoundException(folderFile.getAbsolutePath() + " does not exist.");
        }
        if (!folderFile.isDirectory()) {
            throw new InvalidFolderException(folderFile.getAbsolutePath() + " is not a valid directory.");
        }
        if (!path.equals("/") && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (fromCache) {
            folder = (Folder)this.fileCache.getDocument(path);
        }
        if (folder == null) {
            try {
                FolderMetaDataImpl metadata = (FolderMetaDataImpl)this.metadataDocHandler.getDocument(path + "/" + "folder.metadata");
                folder = new FolderImpl(path, metadata, this.handlerFactory, this);
            }
            catch (DocumentNotFoundException e) {
                folder = new FolderImpl(path, this.handlerFactory, this);
            }
            if (!path.equals("/")) {
                String parentPath = path;
                int parentSeparatorIndex = parentPath.lastIndexOf(47);
                parentPath = parentSeparatorIndex > 0 ? parentPath.substring(0, parentSeparatorIndex) : "/";
                folder.setParent((Node)this.getFolder(parentPath));
            }
            ((FolderImpl)folder).unmarshalled(this.generator);
            if (fromCache) {
                this.addToCache(path, folder);
            }
        }
        return folder;
    }

    public void updateFolder(Folder folder) throws FailedToUpdateFolderException {
        if (folder == null) {
            log.warn("Recieved null Folder to update");
            return;
        }
        String path = folder.getPath();
        if (path == null) {
            path = folder.getId();
            if (path == null) {
                log.warn("Recieved Folder with null path/id to update");
                return;
            }
            folder.setPath(path);
        }
        FolderImpl folderImpl = (FolderImpl)folder;
        folderImpl.setFolderHandler(this);
        folderImpl.setHandlerFactory(this.handlerFactory);
        folderImpl.setPermissionsEnabled(this.handlerFactory.getPermissionsEnabled());
        folderImpl.setConstraintsEnabled(this.handlerFactory.getConstraintsEnabled());
        folderImpl.marshalling();
        File folderFile = new File(this.documentRootDir, path);
        if (folderFile.exists() && !folderFile.isDirectory() || !folderFile.exists() && !folderFile.mkdir()) {
            throw new FailedToUpdateFolderException(folderFile.getAbsolutePath() + " does not exist and cannot be created.");
        }
        try {
            FolderMetaDataImpl metadata = folderImpl.getFolderMetaData();
            metadata.setPath(path + "/" + "folder.metadata");
            this.metadataDocHandler.updateDocument((Document)metadata);
        }
        catch (Exception e) {
            throw new FailedToUpdateFolderException(folderFile.getAbsolutePath() + " failed to update folder.metadata", (Throwable)e);
        }
        this.addToCache(path, folder);
    }

    public void removeFolder(Folder folder) throws FailedToDeleteFolderException {
        if (folder == null) {
            log.warn("Recieved null Folder to remove");
            return;
        }
        String path = folder.getPath();
        if (path == null) {
            path = folder.getId();
            if (path == null) {
                log.warn("Recieved Folder with null path/id to remove");
                return;
            }
            folder.setPath(path);
        }
        FolderImpl folderImpl = (FolderImpl)folder;
        try {
            ArrayList<Node> removeNodes = new ArrayList<Node>();
            for (Node node : folderImpl.getAllNodes()) {
                removeNodes.add(node);
            }
            for (Node node : removeNodes) {
                if (node instanceof Folder) {
                    this.removeFolder((Folder)node);
                } else if (node instanceof Document) {
                    try {
                        this.handlerFactory.getDocumentHandler(node.getType()).removeDocument((Document)node);
                    }
                    catch (Exception e) {
                        File documentFile = new File(this.documentRootDir, node.getPath());
                        throw new FailedToDeleteFolderException(documentFile.getAbsolutePath() + " document cannot be deleted.");
                    }
                }
                ((NodeSetImpl)folderImpl.getAllNodes()).remove(node);
            }
        }
        catch (FailedToDeleteFolderException fdfe) {
            throw fdfe;
        }
        catch (Exception e) {
            throw new FailedToDeleteFolderException(e.getMessage());
        }
        File folderFile = new File(this.documentRootDir, path);
        File metadataFile = null;
        if (folderImpl.getFolderMetaData() != null && folderImpl.getFolderMetaData().getPath() != null) {
            metadataFile = new File(this.documentRootDir, folderImpl.getFolderMetaData().getPath());
        }
        if (folderFile.exists() && folderFile.isDirectory()) {
            String[] contents = folderFile.list();
            for (int i = 0; i < contents.length; ++i) {
                File contentFile = new File(folderFile, contents[i]);
                if (metadataFile != null && contentFile.equals(metadataFile) || FileSystemFolderHandler.deleteFile(contentFile)) continue;
                throw new FailedToDeleteFolderException(folderFile.getAbsolutePath() + " unrecognized folder contents cannot be deleted.");
            }
            if (metadataFile != null && metadataFile.exists() && !metadataFile.delete()) {
                throw new FailedToDeleteFolderException(folderFile.getAbsolutePath() + " folder metadata cannot be deleted.");
            }
            if (!path.equals("/") && !folderFile.delete()) {
                throw new FailedToDeleteFolderException(folderFile.getAbsolutePath() + " folder cannot be deleted.");
            }
        } else {
            throw new FailedToDeleteFolderException(folderFile.getAbsolutePath() + " not found.");
        }
        this.fileCache.remove(path);
        if (folderImpl.getFolderMetaData() != null) {
            folderImpl.getFolderMetaData().setParent(null);
        }
        folderImpl.setParent(null);
        folderImpl.reset();
    }

    private static final boolean deleteFile(File file) {
        if (file.isDirectory()) {
            String[] children = file.list();
            for (int i = 0; i < children.length; ++i) {
                if (FileSystemFolderHandler.deleteFile(new File(file, children[i]))) continue;
                return false;
            }
        }
        return file.delete();
    }

    public NodeSet getFolders(String path) throws FolderNotFoundException, InvalidFolderException, NodeException {
        File parent = new File(this.documentRootDir, path);
        if (!parent.exists()) {
            throw new FolderNotFoundException("No folder exists at the path: " + parent.getAbsolutePath());
        }
        String[] children = this.getChildrenNames(path, FOLDER_FILTER);
        NodeSetImpl folders = new NodeSetImpl(path);
        for (int i = 0; i < children.length; ++i) {
            if (path.endsWith("/")) {
                folders.add((Node)this.getFolder(path + children[i]));
                continue;
            }
            folders.add((Node)this.getFolder(path + "/" + children[i]));
        }
        return folders;
    }

    public String[] list(String folderPath, String documentType) throws FolderNotFoundException {
        return this.getChildrenNames(folderPath, new DocumentTypeFilter(documentType));
    }

    public String[] listAll(String folderPath) throws FolderNotFoundException {
        return this.getChildrenNames(folderPath, null);
    }

    protected String[] getChildrenNames(String path, FilenameFilter filter) throws FolderNotFoundException {
        File parent = new File(this.documentRootDir, path);
        if (!parent.exists()) {
            throw new FolderNotFoundException("No folder exists at the path: " + parent.getAbsolutePath());
        }
        if (filter != null) {
            return parent.list(filter);
        }
        return parent.list();
    }

    public NodeSet getNodes(String path, boolean regexp, String documentType) throws FolderNotFoundException, InvalidFolderException, NodeException {
        if (path == null || !path.startsWith("/")) {
            throw new InvalidFolderException("Invalid path specified " + path);
        }
        Folder folder = this.getFolder("/");
        NodeSetImpl matched = new NodeSetImpl(null);
        this.getNodes(folder, path, regexp, matched);
        if (documentType != null) {
            return matched.subset(documentType);
        }
        return matched;
    }

    private void getNodes(Folder folder, String path, boolean regexp, NodeSet matched) throws FolderNotFoundException, InvalidFolderException, NodeException {
        int separatorIndex;
        if (path.equals("/")) {
            matched.add((Node)folder);
            return;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((separatorIndex = path.indexOf("/")) != -1) {
            String folderName = path.substring(0, separatorIndex);
            String folderPath = (folder.getPath().endsWith("/") ? folder.getPath() : folder.getPath() + "/") + folderName;
            NodeSet matchedFolders = null;
            if (regexp) {
                matchedFolders = ((FolderImpl)folder).getFolders(false).inclusiveSubset(folderPath);
            } else {
                Folder matchedFolder = this.getFolder(folderPath);
                if (matchedFolder != null) {
                    matchedFolders = new NodeSetImpl(folder.getPath());
                    matchedFolders.add((Node)matchedFolder);
                }
            }
            if (matchedFolders == null || matchedFolders.size() == 0) {
                throw new FolderNotFoundException("Cannot find folder" + folderName + " in " + folder.getPath());
            }
            path = path.substring(separatorIndex);
            for (Node matchedFolder : matchedFolders) {
                this.getNodes((Folder)matchedFolder, path, regexp, matched);
            }
            return;
        }
        String nodeName = path;
        String nodePath = (folder.getPath().endsWith("/") ? folder.getPath() : folder.getPath() + "/") + nodeName;
        if (regexp) {
            for (Node matchedNode : ((FolderImpl)folder).getAllNodes().inclusiveSubset(nodePath)) {
                matched.add(matchedNode);
            }
        } else {
            for (Node findNode : ((FolderImpl)folder).getAllNodes()) {
                if (!findNode.getPath().equals(nodePath)) continue;
                matched.add(findNode);
                break;
            }
        }
    }

    public void shutdown() {
        this.fileCache.removeListener((FileCacheEventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToCache(String id, Object objectToCache) {
        FileCache fileCache = this.fileCache;
        synchronized (fileCache) {
            try {
                this.fileCache.put(id, objectToCache, this.documentRootDir);
            }
            catch (IOException e) {
                String msg = "Error storing Document in the FileCache: " + e.toString();
                log.error(msg);
                IllegalStateException ise = new IllegalStateException(msg);
                ise.initCause(e);
            }
        }
    }

    public void refresh(FileCacheEntry entry) throws Exception {
        Node folderNode;
        Document doc;
        if (entry.getDocument() instanceof Folder) {
            Folder folder = (Folder)entry.getDocument();
            entry.setDocument((Object)this.getFolder(folder.getPath(), false));
            Node parentNode = ((AbstractNode)folder).getParent(false);
            if (parentNode != null) {
                FileCacheEntry parentEntry = this.fileCache.get(parentNode.getPath());
                this.refresh(parentEntry);
            }
        } else if (entry.getDocument() instanceof Document && (doc = (Document)entry.getDocument()).getType().equals("folder.metadata") && (folderNode = ((AbstractNode)doc).getParent(false)) != null) {
            FileCacheEntry folderEntry = this.fileCache.get(folderNode.getPath());
            this.refresh(folderEntry);
        }
        if (entry.getDocument() instanceof Reset) {
            ((Reset)entry.getDocument()).reset();
        }
    }

    public void evict(FileCacheEntry entry) throws Exception {
    }

    public boolean isFolder(String path) {
        return new File(this.documentRootDir, path).isDirectory();
    }

    public class DocumentTypeFilter
    implements FilenameFilter {
        private String documentType;

        public DocumentTypeFilter(String documentType) {
            this.documentType = documentType;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.documentType);
        }
    }
}

