/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.psml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.page.BaseFragmentElement;
import org.apache.jetspeed.om.page.BaseFragmentValidationListener;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.psml.AbstractBaseFragmentElement;
import org.apache.jetspeed.om.page.psml.AbstractBaseFragmentsElement;
import org.apache.jetspeed.om.page.psml.FilteredFragmentList;
import org.apache.jetspeed.om.page.psml.FragmentElementImpl;
import org.apache.jetspeed.om.page.psml.FragmentList;

public class FragmentImpl
extends AbstractBaseFragmentElement
implements Fragment,
Serializable {
    private String type = null;
    private List<AbstractBaseFragmentElement> fragments = new ArrayList<AbstractBaseFragmentElement>();
    private List<FragmentElementImpl> fragmentElementImpls = new ArrayList<FragmentElementImpl>();
    private String name;
    private FragmentList fragmentsList;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    List<AbstractBaseFragmentElement> accessFragments() {
        return this.fragments;
    }

    public List<BaseFragmentElement> getFragments() {
        if (this.fragmentsList == null) {
            this.fragmentsList = new FragmentList(this);
        }
        return this.filterFragmentsByAccess(this.fragmentsList);
    }

    public List<FragmentElementImpl> getFragmentElementImpls() {
        return this.fragmentElementImpls;
    }

    public void setFragmentElementImpls(List<FragmentElementImpl> elements) {
        this.fragmentElementImpls = elements;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    void setBaseFragmentsElement(AbstractBaseFragmentsElement baseFragmentsElement) {
        super.setBaseFragmentsElement(baseFragmentsElement);
        if (this.fragments != null) {
            for (AbstractBaseFragmentElement fragmentElement : this.fragments) {
                fragmentElement.setBaseFragmentsElement(baseFragmentsElement);
            }
        }
    }

    public BaseFragmentElement getFragmentById(String id) {
        Stack<BaseFragmentElement> stack = new Stack<BaseFragmentElement>();
        for (AbstractBaseFragmentElement fragmentElement : this.fragments) {
            stack.push(fragmentElement);
        }
        BaseFragmentElement f = (BaseFragmentElement)stack.pop();
        while (f != null && !f.getId().equals(id)) {
            if (f instanceof Fragment) {
                for (BaseFragmentElement child : ((Fragment)f).getFragments()) {
                    stack.push(child);
                }
            }
            if (stack.size() > 0) {
                f = (BaseFragmentElement)stack.pop();
                continue;
            }
            f = null;
        }
        return f;
    }

    public BaseFragmentElement removeFragmentById(String id) {
        BaseFragmentElement parent;
        HashMap<BaseFragmentElement, BaseFragmentElement> parents = new HashMap<BaseFragmentElement, BaseFragmentElement>();
        Stack<BaseFragmentElement> stack = new Stack<BaseFragmentElement>();
        for (BaseFragmentElement fragmentElement : this.getFragments()) {
            stack.push(fragmentElement);
        }
        BaseFragmentElement f = (BaseFragmentElement)stack.pop();
        while (f != null && !f.getId().equals(id)) {
            if (f instanceof Fragment) {
                for (BaseFragmentElement child : ((Fragment)f).getFragments()) {
                    stack.push(child);
                    parents.put(child, f);
                }
            }
            if (stack.size() > 0) {
                f = (BaseFragmentElement)stack.pop();
                continue;
            }
            f = null;
        }
        if (f != null && ((parent = (BaseFragmentElement)parents.get(f)) != null ? parent instanceof Fragment && ((Fragment)parent).getFragments().remove(f) : this.getFragments().remove(f))) {
            return f;
        }
        return null;
    }

    @Override
    public String getLogicalPermissionPath() {
        if (this.getBaseFragmentsElement() != null && this.getName() != null) {
            return this.getBaseFragmentsElement().getLogicalPermissionPath() + "/" + this.getName();
        }
        return null;
    }

    @Override
    public String getPhysicalPermissionPath() {
        if (this.getBaseFragmentsElement() != null && this.getName() != null) {
            return this.getBaseFragmentsElement().getPhysicalPermissionPath() + "/" + this.getName();
        }
        return null;
    }

    @Override
    protected boolean validateFragments(BaseFragmentValidationListener validationListener) {
        if (!validationListener.validate(this)) {
            return false;
        }
        if (this.fragments != null) {
            for (AbstractBaseFragmentElement fragmentElement : this.fragments) {
                if (fragmentElement.validateFragments(validationListener)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean unmarshalled(IdGenerator generator) {
        boolean dirty = super.unmarshalled(generator);
        this.fragments.clear();
        for (FragmentElementImpl fragmentElement : this.fragmentElementImpls) {
            AbstractBaseFragmentElement fragment = (AbstractBaseFragmentElement)fragmentElement.getElement();
            this.fragments.add(fragment);
            dirty = fragment.unmarshalled(generator) || dirty;
        }
        return dirty;
    }

    @Override
    public void marshalling() {
        this.fragmentElementImpls.clear();
        for (AbstractBaseFragmentElement fragment : this.fragments) {
            this.fragmentElementImpls.add(new FragmentElementImpl(fragment));
            fragment.marshalling();
        }
        super.marshalling();
    }

    List<BaseFragmentElement> filterFragmentsByAccess(List<BaseFragmentElement> fragments) {
        if (fragments != null && !fragments.isEmpty()) {
            ArrayList<BaseFragmentElement> filteredFragments = null;
            for (BaseFragmentElement fragment : fragments) {
                try {
                    fragment.checkAccess(JetspeedActions.VIEW);
                    if (filteredFragments == null) continue;
                    filteredFragments.add(fragment);
                }
                catch (SecurityException se) {
                    if (filteredFragments != null) continue;
                    filteredFragments = new ArrayList<BaseFragmentElement>(fragments.size());
                    for (BaseFragmentElement copyFragment : fragments) {
                        if (copyFragment == fragment) break;
                        filteredFragments.add(copyFragment);
                    }
                }
            }
            if (filteredFragments != null) {
                return new FilteredFragmentList(this, filteredFragments);
            }
        }
        return fragments;
    }
}

