/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jetspeed.om.page.impl.BaseSecurityConstraintsRef;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsImpl;

class SecurityConstraintsRefList
extends AbstractList<String> {
    private SecurityConstraintsImpl constraints;
    private List<BaseSecurityConstraintsRef> removedConstraintsRefs;

    SecurityConstraintsRefList(SecurityConstraintsImpl constraints) {
        this.constraints = constraints;
    }

    private BaseSecurityConstraintsRef wrapNameStringForAdd(String name) {
        int removedIndex;
        if (name == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        BaseSecurityConstraintsRef constraintsRef = null;
        if (this.constraints.getSecurityConstraintsRefClass() != null) {
            try {
                constraintsRef = (BaseSecurityConstraintsRef)this.constraints.getSecurityConstraintsRefClass().newInstance();
            }
            catch (InstantiationException ie) {
                throw new ClassCastException("Unable to create constratins reference list element instance: " + this.constraints.getSecurityConstraintsRefClass().getName() + ", (" + ie + ").");
            }
            catch (IllegalAccessException iae) {
                throw new ClassCastException("Unable to create constraints reference list element instance: " + this.constraints.getSecurityConstraintsRefClass().getName() + ", (" + iae + ").");
            }
        } else {
            constraintsRef = new BaseSecurityConstraintsRef();
        }
        constraintsRef.setName(name);
        if (this.constraints.accessConstraintsRefs().contains(constraintsRef)) {
            throw new IllegalArgumentException("Unable to add duplicate entry to list: " + constraintsRef.getName());
        }
        if (this.removedConstraintsRefs != null && (removedIndex = this.removedConstraintsRefs.indexOf(constraintsRef)) >= 0) {
            constraintsRef = this.removedConstraintsRefs.remove(removedIndex);
        }
        return constraintsRef;
    }

    private List<BaseSecurityConstraintsRef> getRemovedConstraintsRefs() {
        if (this.removedConstraintsRefs == null) {
            this.removedConstraintsRefs = Collections.synchronizedList(new ArrayList());
        }
        return this.removedConstraintsRefs;
    }

    @Override
    public void add(int index, String element) {
        BaseSecurityConstraintsRef nextConstraintsRef;
        if (index < 0 || index > this.constraints.accessConstraintsRefs().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        BaseSecurityConstraintsRef constraintsRef = this.wrapNameStringForAdd(element);
        this.constraints.accessConstraintsRefs().add(index, constraintsRef);
        if (index > 0) {
            constraintsRef.setApplyOrder(this.constraints.accessConstraintsRefs().get(index - 1).getApplyOrder() + 1);
        } else {
            constraintsRef.setApplyOrder(0);
        }
        int limit = this.constraints.accessConstraintsRefs().size() - 1;
        for (int i = index; i < limit && (nextConstraintsRef = this.constraints.accessConstraintsRefs().get(i + 1)).getApplyOrder() <= constraintsRef.getApplyOrder(); ++i) {
            nextConstraintsRef.setApplyOrder(constraintsRef.getApplyOrder() + 1);
            constraintsRef = nextConstraintsRef;
        }
        this.constraints.clearAllSecurityConstraints();
    }

    @Override
    public String get(int index) {
        return this.constraints.accessConstraintsRefs().get(index).getName();
    }

    @Override
    public String remove(int index) {
        BaseSecurityConstraintsRef removed = this.constraints.accessConstraintsRefs().remove(index);
        if (removed != null) {
            this.getRemovedConstraintsRefs().add(removed);
            this.constraints.clearAllSecurityConstraints();
        }
        return removed.getName();
    }

    @Override
    public String set(int index, String element) {
        BaseSecurityConstraintsRef newConstraintsRef = this.wrapNameStringForAdd(element);
        BaseSecurityConstraintsRef constraintsRef = this.constraints.accessConstraintsRefs().set(index, newConstraintsRef);
        newConstraintsRef.setApplyOrder(constraintsRef.getApplyOrder());
        this.getRemovedConstraintsRefs().add(constraintsRef);
        this.constraints.clearAllSecurityConstraints();
        return constraintsRef.getName();
    }

    @Override
    public int size() {
        return this.constraints.accessConstraintsRefs().size();
    }
}

