/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.AbstractList;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.page.SecurityConstraintImpl;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsImpl;

class SecurityConstraintList
extends AbstractList<SecurityConstraint> {
    private SecurityConstraintsImpl constraints;

    SecurityConstraintList(SecurityConstraintsImpl constraints) {
        this.constraints = constraints;
    }

    private SecurityConstraintImpl validateConstraintForAdd(SecurityConstraint constraint) {
        if (constraint == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        if (this.constraints.getSecurityConstraintClass() != null && !this.constraints.getSecurityConstraintClass().isInstance(constraint)) {
            throw new ClassCastException("Unable to add list element instance: expected " + this.constraints.getSecurityConstraintClass().getName() + ", got " + constraint.getClass().getName() + ".");
        }
        return (SecurityConstraintImpl)constraint;
    }

    @Override
    public void add(int index, SecurityConstraint element) {
        SecurityConstraintImpl nextConstraint;
        if (index < 0 || index > this.constraints.accessConstraints().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        SecurityConstraintImpl constraint = this.validateConstraintForAdd(element);
        this.constraints.accessConstraints().add(index, constraint);
        if (index > 0) {
            constraint.setApplyOrder(this.constraints.accessConstraints().get(index - 1).getApplyOrder() + 1);
        } else {
            constraint.setApplyOrder(0);
        }
        int limit = this.constraints.accessConstraints().size() - 1;
        for (int i = index; i < limit && (nextConstraint = this.constraints.accessConstraints().get(i + 1)).getApplyOrder() <= constraint.getApplyOrder(); ++i) {
            nextConstraint.setApplyOrder(constraint.getApplyOrder() + 1);
            constraint = nextConstraint;
        }
        this.constraints.clearAllSecurityConstraints();
    }

    @Override
    public SecurityConstraint get(int index) {
        return this.constraints.accessConstraints().get(index);
    }

    @Override
    public SecurityConstraint remove(int index) {
        SecurityConstraint removed = this.constraints.accessConstraints().remove(index);
        if (removed != null) {
            this.constraints.clearAllSecurityConstraints();
        }
        return removed;
    }

    @Override
    public SecurityConstraint set(int index, SecurityConstraint element) {
        SecurityConstraintImpl newConstraint = this.validateConstraintForAdd(element);
        SecurityConstraintImpl constraint = this.constraints.accessConstraints().set(index, newConstraint);
        newConstraint.setApplyOrder(constraint.getApplyOrder());
        this.constraints.clearAllSecurityConstraints();
        return constraint;
    }

    @Override
    public int size() {
        return this.constraints.accessConstraints().size();
    }
}

