/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.SecurityConstraintImpl;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.page.SecurityConstraintsRefExpression;
import org.apache.jetspeed.om.page.SecurityConstraintsRefToken;

public class SecurityConstraintsRefParser {
    public static final String OPEN_PAREN = "(";
    public static final String CLOSE_PAREN = ")";
    public static final String NOT_OPERATION = "not";
    public static final String AND_OPERATION = "and";
    public static final String OR_OPERATION = "or";
    private static final Map<String, Integer> OPERATOR_PRECEDENCE = new HashMap<String, Integer>();

    public static Object parse(String constraintsRef, PageSecurity pageSecurity) {
        String postfixToken;
        List<String> postfixTokens = SecurityConstraintsRefParser.parseConstraintsRef(constraintsRef);
        if (postfixTokens.isEmpty()) {
            return null;
        }
        if (!(postfixTokens.size() != 1 || (postfixToken = postfixTokens.get(0)).equals(AND_OPERATION) || postfixToken.equals(OR_OPERATION) || postfixToken.equals(NOT_OPERATION))) {
            SecurityConstraintsDef securityConstraintsDef = pageSecurity.getSecurityConstraintsDef(postfixToken);
            if (securityConstraintsDef != null && securityConstraintsDef.getSecurityConstraints() != null) {
                return new ArrayList(securityConstraintsDef.getSecurityConstraints());
            }
            return null;
        }
        ArrayList<SecurityConstraintsRefToken> constraintsRefTokens = new ArrayList<SecurityConstraintsRefToken>();
        for (String postfixToken2 : postfixTokens) {
            if (postfixToken2.equals(AND_OPERATION) || postfixToken2.equals(OR_OPERATION) || postfixToken2.equals(NOT_OPERATION)) {
                constraintsRefTokens.add(new SecurityConstraintsRefToken(postfixToken2));
                continue;
            }
            SecurityConstraintsDef securityConstraintsDef = pageSecurity.getSecurityConstraintsDef(postfixToken2);
            if (securityConstraintsDef != null && securityConstraintsDef.getSecurityConstraints() != null) {
                boolean multipleConstraintsOrExpression = false;
                for (SecurityConstraint securityConstraint : securityConstraintsDef.getSecurityConstraints()) {
                    constraintsRefTokens.add(new SecurityConstraintsRefToken(postfixToken2, (SecurityConstraintImpl)securityConstraint));
                    if (multipleConstraintsOrExpression) {
                        constraintsRefTokens.add(new SecurityConstraintsRefToken(OR_OPERATION));
                        continue;
                    }
                    multipleConstraintsOrExpression = true;
                }
                continue;
            }
            throw new RuntimeException("Unable to find security constraints reference " + postfixToken2 + " in \"" + constraintsRef + "\"");
        }
        return new SecurityConstraintsRefExpression(constraintsRef, constraintsRefTokens);
    }

    static List<String> parseConstraintsRef(String constraintsRef) {
        int parseIndex;
        ArrayList<String> postfixTokens = new ArrayList<String>();
        Stack<String> infixToPostfixStack = new Stack<String>();
        int tokenIndex = -1;
        boolean token = false;
        int parseLimit = constraintsRef.length();
        for (parseIndex = 0; parseIndex < parseLimit; ++parseIndex) {
            char parseChar = constraintsRef.charAt(parseIndex);
            if (token && !Character.isJavaIdentifierPart(parseChar) && parseChar != '-' && parseChar != '.') {
                SecurityConstraintsRefParser.infixToPostfix(constraintsRef, constraintsRef.substring(tokenIndex, parseIndex), parseIndex, infixToPostfixStack, postfixTokens);
                token = false;
            }
            if (token) continue;
            if (Character.isJavaIdentifierStart(parseChar)) {
                tokenIndex = parseIndex;
                token = true;
                continue;
            }
            if (parseChar == '(' || parseChar == ')' || parseChar == '!') {
                SecurityConstraintsRefParser.infixToPostfix(constraintsRef, constraintsRef.substring(parseIndex, parseIndex + 1), parseIndex, infixToPostfixStack, postfixTokens);
                continue;
            }
            if ((parseChar == '&' || parseChar == '|') && parseIndex + 1 < parseLimit && constraintsRef.charAt(parseIndex + 1) == parseChar) {
                SecurityConstraintsRefParser.infixToPostfix(constraintsRef, constraintsRef.substring(parseIndex, parseIndex + 2), parseIndex, infixToPostfixStack, postfixTokens);
                ++parseIndex;
                continue;
            }
            if (Character.isWhitespace(parseChar)) continue;
            throw new RuntimeException("Illegal character '" + parseChar + "' at position " + parseIndex + " in \"" + constraintsRef + "\"");
        }
        if (token) {
            SecurityConstraintsRefParser.infixToPostfix(constraintsRef, constraintsRef.substring(tokenIndex), parseIndex, infixToPostfixStack, postfixTokens);
        }
        SecurityConstraintsRefParser.infixToPostfix(constraintsRef, null, parseIndex, infixToPostfixStack, postfixTokens);
        return postfixTokens;
    }

    private static void infixToPostfix(String expression, String token, int parseIndex, Stack<String> stack, List<String> postfixTokens) {
        if (token == null) {
            if (!stack.empty()) {
                String peek = stack.peek();
                while (!peek.equals(OPEN_PAREN)) {
                    postfixTokens.add(stack.pop());
                    if (stack.empty()) break;
                    peek = stack.peek();
                }
                if (peek.equals(OPEN_PAREN)) {
                    throw new RuntimeException("Missing paren at position " + parseIndex + " in \"" + expression + "\"");
                }
            }
            return;
        }
        if (token.equals(OPEN_PAREN)) {
            stack.push(token);
            return;
        }
        if (token.equals(CLOSE_PAREN)) {
            boolean matchedParen = false;
            if (!stack.empty()) {
                String peek = stack.peek();
                while (!peek.equals(OPEN_PAREN)) {
                    postfixTokens.add(stack.pop());
                    if (stack.empty()) break;
                    peek = stack.peek();
                }
                if (peek.equals(OPEN_PAREN)) {
                    stack.pop();
                    matchedParen = true;
                }
            }
            if (!matchedParen) {
                throw new RuntimeException("Mismatched paren at position " + parseIndex + " in \"" + expression + "\"");
            }
            return;
        }
        if (token.equals("&&") || token.equalsIgnoreCase(AND_OPERATION) && !token.equals(AND_OPERATION)) {
            token = AND_OPERATION;
        } else if (token.equals("||") || token.equalsIgnoreCase(OR_OPERATION) && !token.equals(OR_OPERATION)) {
            token = OR_OPERATION;
        } else if (token.equals("!") || token.equalsIgnoreCase(NOT_OPERATION) && !token.equals(NOT_OPERATION)) {
            token = NOT_OPERATION;
        }
        Integer operatorPrecedence = OPERATOR_PRECEDENCE.get(token);
        if (operatorPrecedence == null) {
            postfixTokens.add(token);
            return;
        }
        if (!stack.empty()) {
            String peek = stack.peek();
            while (!peek.equals(OPEN_PAREN) && OPERATOR_PRECEDENCE.get(peek) >= operatorPrecedence) {
                postfixTokens.add(stack.pop());
                if (stack.empty()) break;
                peek = stack.peek();
            }
        }
        stack.push(token);
    }

    static {
        OPERATOR_PRECEDENCE.put(NOT_OPERATION, new Integer(2));
        OPERATOR_PRECEDENCE.put(AND_OPERATION, new Integer(1));
        OPERATOR_PRECEDENCE.put(OR_OPERATION, new Integer(0));
    }
}

