/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

public class SecurityConstraintImpl
implements SecurityConstraint {
    private int id;
    private int applyOrder;
    private List<String> usersList;
    private List<String> rolesList;
    private List<String> groupsList;
    private List<String> permissionsList;
    private String users;
    private String roles;
    private String groups;
    private String permissions;

    public int getApplyOrder() {
        return this.applyOrder;
    }

    public void setApplyOrder(int order) {
        this.applyOrder = order;
    }

    public String getUsersAsString() {
        if (this.users == null && this.usersList != null && !this.usersList.isEmpty()) {
            this.users = SecurityConstraintImpl.formatCSVList(this.usersList);
        }
        return this.users;
    }

    public void setUsersAsString(String users) {
        this.users = users;
        this.usersList = SecurityConstraintImpl.parseCSVList(users);
    }

    public String getRolesAsString() {
        if (this.roles == null && this.rolesList != null && !this.rolesList.isEmpty()) {
            this.roles = SecurityConstraintImpl.formatCSVList(this.rolesList);
        }
        return this.roles;
    }

    public void setRolesAsString(String roles) {
        this.roles = roles;
        this.rolesList = SecurityConstraintImpl.parseCSVList(roles);
    }

    public String getGroupsAsString() {
        if (this.groups == null && this.groupsList != null && !this.groupsList.isEmpty()) {
            this.groups = SecurityConstraintImpl.formatCSVList(this.groupsList);
        }
        return this.groups;
    }

    public void setGroupsAsString(String groups) {
        this.groups = groups;
        this.groupsList = SecurityConstraintImpl.parseCSVList(groups);
    }

    public String getPermissionsAsString() {
        if (this.permissions == null && this.permissionsList != null && !this.permissionsList.isEmpty()) {
            this.permissions = SecurityConstraintImpl.formatCSVList(this.permissionsList);
        }
        return this.permissions;
    }

    public void setPermissionsAsString(String permissions) {
        this.permissions = permissions;
        this.permissionsList = SecurityConstraintImpl.parseCSVList(permissions);
    }

    public List<String> getUsers() {
        return this.usersList;
    }

    public void setUsers(List<String> users) {
        this.usersList = users;
        this.users = null;
    }

    public List<String> getRoles() {
        return this.rolesList;
    }

    public void setRoles(List<String> roles) {
        this.rolesList = roles;
        this.roles = null;
    }

    public List<String> getGroups() {
        return this.groupsList;
    }

    public void setGroups(List<String> groups) {
        this.groupsList = groups;
        this.groups = null;
    }

    public List<String> getPermissions() {
        return this.permissionsList;
    }

    public void setPermissions(List<String> permissions) {
        this.permissionsList = permissions;
        this.permissions = null;
    }

    public boolean principalsMatch(List<String> userPrincipals, List<String> rolePrincipals, List<String> groupPrincipals, boolean allowDefault) {
        return allowDefault && this.usersList == null && this.rolesList == null && this.groupsList == null || this.usersList != null && userPrincipals != null && (SecurityConstraintImpl.containsAny(this.usersList, userPrincipals) || this.usersList.contains("*")) || this.rolesList != null && rolePrincipals != null && (SecurityConstraintImpl.containsAny(this.rolesList, rolePrincipals) || this.rolesList.contains("*")) || this.groupsList != null && groupPrincipals != null && (SecurityConstraintImpl.containsAny(this.groupsList, groupPrincipals) || this.groupsList.contains("*"));
    }

    public boolean actionMatch(String action) {
        return this.permissionsList != null && (this.permissionsList.contains(action) || this.permissionsList.contains("*"));
    }

    public static List<String> parseCSVList(String csv) {
        if (csv != null) {
            List<String> csvList = DatabasePageManagerUtils.createList();
            if (csv.indexOf(44) != -1) {
                StringTokenizer csvTokens = new StringTokenizer(csv, ",");
                while (csvTokens.hasMoreTokens()) {
                    csvList.add(csvTokens.nextToken().trim());
                }
            } else {
                csvList.add(csv);
            }
            return csvList;
        }
        return null;
    }

    public static String formatCSVList(List<String> list) {
        if (list != null && !list.isEmpty()) {
            StringBuffer csv = new StringBuffer();
            for (String item : list) {
                if (csv.length() > 0) {
                    csv.append(",");
                }
                csv.append(item);
            }
            return csv.toString();
        }
        return null;
    }

    public static boolean containsAny(Collection<String> collection0, Collection<String> collection1) {
        if (collection0 != null && collection1 != null) {
            for (String item1 : collection1) {
                if (!collection0.contains(item1)) continue;
                return true;
            }
        }
        return false;
    }
}

