/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.folder.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.impl.FolderImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuDefinitionImpl;

class FolderMenuDefinitionList
extends AbstractList<MenuDefinition> {
    private FolderImpl folder;
    private List<MenuDefinition> removedMenuDefinitions;

    FolderMenuDefinitionList(FolderImpl folder) {
        this.folder = folder;
    }

    private FolderMenuDefinitionImpl validateDefinitionForAdd(MenuDefinition definition) {
        int removedIndex;
        if (definition == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        if (this.folder.accessMenus().contains(definition)) {
            throw new IllegalArgumentException("Unable to add duplicate entry to list: " + definition.getName());
        }
        if (this.removedMenuDefinitions != null && (removedIndex = this.removedMenuDefinitions.indexOf(definition)) >= 0) {
            MenuDefinition addDefinition = definition;
            definition = this.removedMenuDefinitions.remove(removedIndex);
            definition.setOptions(addDefinition.getOptions());
            definition.setDepth(addDefinition.getDepth());
            definition.setPaths(addDefinition.isPaths());
            definition.setRegexp(addDefinition.isRegexp());
            definition.setProfile(addDefinition.getProfile());
            definition.setOrder(addDefinition.getOrder());
            definition.setSkin(addDefinition.getSkin());
            definition.setTitle(addDefinition.getTitle());
            definition.setShortTitle(addDefinition.getShortTitle());
            definition.setMenuElements(addDefinition.getMenuElements());
            definition.getMetadata().copyFields(addDefinition.getMetadata().getFields());
        }
        return (FolderMenuDefinitionImpl)definition;
    }

    private List<MenuDefinition> getRemovedMenuDefinitions() {
        if (this.removedMenuDefinitions == null) {
            this.removedMenuDefinitions = Collections.synchronizedList(new ArrayList());
        }
        return this.removedMenuDefinitions;
    }

    @Override
    public void add(int index, MenuDefinition element) {
        if (index < 0 || index > this.folder.accessMenus().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        FolderMenuDefinitionImpl definition = this.validateDefinitionForAdd(element);
        this.folder.accessMenus().add(index, definition);
    }

    @Override
    public MenuDefinition get(int index) {
        return this.folder.accessMenus().get(index);
    }

    @Override
    public MenuDefinition remove(int index) {
        FolderMenuDefinitionImpl removed = this.folder.accessMenus().remove(index);
        if (removed != null) {
            this.getRemovedMenuDefinitions().add(removed);
        }
        return removed;
    }

    @Override
    public MenuDefinition set(int index, MenuDefinition element) {
        FolderMenuDefinitionImpl newDefinition = this.validateDefinitionForAdd(element);
        FolderMenuDefinitionImpl definition = this.folder.accessMenus().set(index, newDefinition);
        this.getRemovedMenuDefinitions().add(definition);
        return definition;
    }

    @Override
    public int size() {
        return this.folder.accessMenus().size();
    }
}

