/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer;

import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.jetspeed.components.util.ConfigurationProperties;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.serializer.AbstractJetspeedComponentSerializer;
import org.apache.jetspeed.serializer.SerializerException;
import org.apache.jetspeed.serializer.objects.JSSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetspeedUserTemplateSerializer
extends AbstractJetspeedComponentSerializer {
    private static final Logger log = LoggerFactory.getLogger(JetspeedUserTemplateSerializer.class);
    private PageManager pageManager;
    private UserManager userManager;
    private String adminUserName = null;

    public JetspeedUserTemplateSerializer(PageManager pageManager, UserManager userManager, ConfigurationProperties config) {
        this.pageManager = pageManager;
        this.userManager = userManager;
        this.adminUserName = config.getString("default.admin.user");
    }

    protected void processExport(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        if (JetspeedUserTemplateSerializer.isSettingSet((Map)settings, (String)"process_user_templates")) {
            log.info("collecting user template info");
        }
    }

    protected void processImport(JSSnapshot snapshot, Map settings, Logger log) throws SerializerException {
        if (JetspeedUserTemplateSerializer.isSettingSet((Map)settings, (String)"process_user_templates")) {
            log.info("creating user templates");
            User adminUser = null;
            try {
                adminUser = this.userManager.getUser(this.adminUserName);
            }
            catch (Exception e) {
                System.out.println("admin user failed to retrieve " + this.adminUserName);
                e.printStackTrace();
                adminUser = null;
            }
            if (adminUser == null) {
                throw new SerializerException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)"admin"));
            }
        }
    }

    protected void deleteData(Map settings, Logger log) throws SerializerException {
        if (JetspeedUserTemplateSerializer.isSettingSet((Map)settings, (String)"process_user_templates")) {
            log.info("deleting user templates");
        }
    }

    private void createUserTemplate(String folderTemplate, String userTemplate, String subsite, final PageManager pageManager, String userName, User adminUser) {
        Subject adminSubject;
        final String innerFolderTemplate = folderTemplate;
        final String templateFolder = userTemplate;
        final String innerSubsite = subsite;
        final PageManager innerPageManager = pageManager;
        final String innerUserName = userName;
        try {
            adminSubject = this.userManager.getSubject(adminUser);
        }
        catch (SecurityException se) {
            return;
        }
        JetspeedException pe = (JetspeedException)JSSubject.doAsPrivileged((Subject)adminSubject, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    if (innerSubsite != null) {
                        User innerUser = JetspeedUserTemplateSerializer.this.userManager.getUser(innerUserName);
                        innerUser.getSecurityAttributes().getAttribute("org.apache.jetspeed.user.subsite", true).setStringValue(innerSubsite);
                        JetspeedUserTemplateSerializer.this.userManager.updateUser(innerUser);
                    }
                    Folder source = innerPageManager.getFolder(innerFolderTemplate);
                    innerPageManager.deepMergeFolder(source, templateFolder, innerUserName);
                    Folder newFolder = pageManager.getFolder(templateFolder);
                    newFolder.setTitle("Home Folder");
                    newFolder.setShortTitle("Home");
                    return null;
                }
                catch (FolderNotFoundException e1) {
                    return e1;
                }
                catch (InvalidFolderException e1) {
                    return e1;
                }
                catch (NodeException e1) {
                    e1.printStackTrace();
                    return e1;
                }
                catch (SecurityException se) {
                    se.printStackTrace();
                    return se;
                }
            }
        }, null);
        if (pe != null) {
            // empty if block
        }
    }
}

