/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageManagerUtils {
    protected static Logger log = LoggerFactory.getLogger(PageManagerUtils.class);

    public static void createUserHomePagesFromRoles(PageManager pageManager, Subject subject) throws NodeException {
        Principal principal = SubjectHelper.getBestPrincipal((Subject)subject, User.class);
        if (principal == null) {
            String errorMessage = "Could not create user home for null principal";
            log.error(errorMessage);
            throw new NodeException(errorMessage);
        }
        try {
            Folder newUserFolder;
            String userName = principal.getName();
            if (pageManager.userFolderExists(userName)) {
                newUserFolder = pageManager.getUserFolder(userName);
            } else {
                newUserFolder = pageManager.newFolder("/_user/" + userName);
                SecurityConstraints constraints = pageManager.newSecurityConstraints();
                newUserFolder.setSecurityConstraints(constraints);
                newUserFolder.getSecurityConstraints().setOwner(userName);
                pageManager.updateFolder(newUserFolder);
            }
            for (Role role : SubjectHelper.getPrincipals((Subject)subject, Role.class)) {
                if (!pageManager.folderExists("/_role/" + role.getName())) continue;
                Folder roleFolder = pageManager.getFolder("/_role/" + role.getName());
                PageManagerUtils.deepMergeFolder(pageManager, roleFolder, "/_user/" + newUserFolder.getName(), userName, role.getName());
            }
        }
        catch (Exception e) {
            String errorMessage = "createUserHomePagesFromRoles failed: " + e.getMessage();
            log.error(errorMessage, (Throwable)e);
            throw new NodeException(errorMessage, (Throwable)e);
        }
    }

    public static void deepMergeFolder(PageManager pageManager, Folder srcFolder, String destinationPath, String owner, String uniqueName) throws NodeException {
        for (Page srcPage : srcFolder.getPages()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcPage.getName());
            if (pageManager.pageExists(path)) continue;
            Page dstPage = pageManager.copyPage(srcPage, path);
            pageManager.updatePage(dstPage);
        }
        for (PageTemplate srcPageTemplate : srcFolder.getPageTemplates()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcPageTemplate.getName());
            if (pageManager.pageTemplateExists(path)) continue;
            PageTemplate dstPageTemplate = pageManager.copyPageTemplate(srcPageTemplate, path);
            pageManager.updatePageTemplate(dstPageTemplate);
        }
        for (DynamicPage srcDynamicPage : srcFolder.getDynamicPages()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcDynamicPage.getName());
            if (pageManager.dynamicPageExists(path)) continue;
            DynamicPage dstDynamicPage = pageManager.copyDynamicPage(srcDynamicPage, path);
            pageManager.updateDynamicPage(dstDynamicPage);
        }
        for (FragmentDefinition srcFragmentDefinition : srcFolder.getFragmentDefinitions()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcFragmentDefinition.getName());
            if (pageManager.fragmentDefinitionExists(path)) continue;
            FragmentDefinition dstFragmentDefinition = pageManager.copyFragmentDefinition(srcFragmentDefinition, path);
            pageManager.updateFragmentDefinition(dstFragmentDefinition);
        }
        for (Link srcLink : srcFolder.getLinks()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcLink.getName());
            if (pageManager.linkExists(path)) continue;
            Link dstLink = pageManager.copyLink(srcLink, path);
            pageManager.updateLink(dstLink);
        }
        for (Folder folder : srcFolder.getFolders()) {
            String newPath = PageManagerUtils.concatenatePaths(destinationPath, folder.getName());
            if (!pageManager.folderExists(newPath)) {
                Folder dstFolder = pageManager.copyFolder(folder, newPath);
                pageManager.updateFolder(dstFolder);
            }
            PageManagerUtils.deepMergeFolder(pageManager, folder, newPath, null, uniqueName);
        }
    }

    public static String concatenatePaths(String base, String path) {
        String result = "";
        if (base == null) {
            if (path == null) {
                return result;
            }
            return path;
        }
        if (path == null) {
            return base;
        }
        if (base.endsWith("/")) {
            if (path.startsWith("/")) {
                result = base.concat(path.substring(1));
                return result;
            }
        } else if (!path.startsWith("/")) {
            result = base.concat("/").concat(path);
            return result;
        }
        return base.concat(path);
    }

    public static void deepCopyFolder(PageManager pageManager, Folder srcFolder, String destinationPath, String owner, boolean copyIds) throws NodeException {
        boolean found = true;
        try {
            pageManager.getFolder(destinationPath);
        }
        catch (FolderNotFoundException e) {
            found = false;
        }
        if (found) {
            throw new NodeException("Destination already exists");
        }
        Folder dstFolder = pageManager.copyFolder(srcFolder, destinationPath);
        if (owner != null) {
            SecurityConstraints constraints = dstFolder.getSecurityConstraints();
            if (constraints == null) {
                constraints = pageManager.newSecurityConstraints();
                dstFolder.setSecurityConstraints(constraints);
            }
            dstFolder.getSecurityConstraints().setOwner(owner);
        }
        pageManager.updateFolder(dstFolder);
        for (Page srcPage : srcFolder.getPages()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcPage.getName());
            Page dstPage = pageManager.copyPage(srcPage, path, copyIds);
            pageManager.updatePage(dstPage);
        }
        for (PageTemplate srcPageTemplate : srcFolder.getPageTemplates()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcPageTemplate.getName());
            PageTemplate dstPageTemplate = pageManager.copyPageTemplate(srcPageTemplate, path, copyIds);
            pageManager.updatePageTemplate(dstPageTemplate);
        }
        for (DynamicPage srcDynamicPage : srcFolder.getDynamicPages()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcDynamicPage.getName());
            DynamicPage dstDynamicPage = pageManager.copyDynamicPage(srcDynamicPage, path, copyIds);
            pageManager.updateDynamicPage(dstDynamicPage);
        }
        for (FragmentDefinition srcFragmentDefinition : srcFolder.getFragmentDefinitions()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcFragmentDefinition.getName());
            FragmentDefinition dstFragmentDefinition = pageManager.copyFragmentDefinition(srcFragmentDefinition, path, copyIds);
            pageManager.updateFragmentDefinition(dstFragmentDefinition);
        }
        for (Link srcLink : srcFolder.getLinks()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcLink.getName());
            Link dstLink = pageManager.copyLink(srcLink, path);
            pageManager.updateLink(dstLink);
        }
        for (Folder folder : srcFolder.getFolders()) {
            String newPath = PageManagerUtils.concatenatePaths(destinationPath, folder.getName());
            PageManagerUtils.deepCopyFolder(pageManager, folder, newPath, null, copyIds);
        }
    }

    public static void deepMergeFolder(PageManager pageManager, Folder srcFolder, String destinationPath, String owner, boolean copyIds) throws NodeException {
        boolean found = true;
        Folder dstFolder = null;
        try {
            dstFolder = pageManager.getFolder(destinationPath);
        }
        catch (FolderNotFoundException e) {
            found = false;
        }
        if (!found) {
            dstFolder = pageManager.copyFolder(srcFolder, destinationPath);
            if (owner != null) {
                SecurityConstraints constraints = dstFolder.getSecurityConstraints();
                if (constraints == null) {
                    constraints = pageManager.newSecurityConstraints();
                    dstFolder.setSecurityConstraints(constraints);
                }
                dstFolder.getSecurityConstraints().setOwner(owner);
            }
            pageManager.updateFolder(dstFolder);
        }
        for (Page srcPage : srcFolder.getPages()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcPage.getName());
            if (pageManager.pageExists(path)) continue;
            Page dstPage = pageManager.copyPage(srcPage, path, copyIds);
            pageManager.updatePage(dstPage);
        }
        for (PageTemplate srcPageTemplate : srcFolder.getPageTemplates()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcPageTemplate.getName());
            if (pageManager.pageTemplateExists(path)) continue;
            PageTemplate dstPageTemplate = pageManager.copyPageTemplate(srcPageTemplate, path, copyIds);
            pageManager.updatePageTemplate(dstPageTemplate);
        }
        for (DynamicPage srcDynamicPage : srcFolder.getDynamicPages()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcDynamicPage.getName());
            if (pageManager.dynamicPageExists(path)) continue;
            DynamicPage dstDynamicPage = pageManager.copyDynamicPage(srcDynamicPage, path, copyIds);
            pageManager.updateDynamicPage(dstDynamicPage);
        }
        for (FragmentDefinition srcFragmentDefinition : srcFolder.getFragmentDefinitions()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcFragmentDefinition.getName());
            if (pageManager.fragmentDefinitionExists(path)) continue;
            FragmentDefinition dstFragmentDefinition = pageManager.copyFragmentDefinition(srcFragmentDefinition, path, copyIds);
            pageManager.updateFragmentDefinition(dstFragmentDefinition);
        }
        for (Link srcLink : srcFolder.getLinks()) {
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcLink.getName());
            if (pageManager.linkExists(path)) continue;
            Link dstLink = pageManager.copyLink(srcLink, path);
            pageManager.updateLink(dstLink);
        }
        for (Folder folder : srcFolder.getFolders()) {
            String newPath = PageManagerUtils.concatenatePaths(destinationPath, folder.getName());
            PageManagerUtils.deepMergeFolder(pageManager, folder, newPath, null, copyIds);
        }
    }
}

