/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.om.page.BaseFragmentElement;
import org.apache.jetspeed.om.page.BaseFragmentValidationListener;
import org.apache.jetspeed.om.page.FragmentProperty;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.impl.BaseElementImpl;
import org.apache.jetspeed.om.page.impl.BaseFragmentsElementImpl;
import org.apache.jetspeed.om.page.impl.FragmentPreferenceList;
import org.apache.jetspeed.om.page.impl.FragmentPropertyImpl;
import org.apache.jetspeed.om.page.impl.FragmentPropertyListImpl;
import org.apache.jetspeed.om.page.impl.FragmentSecurityConstraintsImpl;
import org.apache.jetspeed.page.FragmentPropertyList;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;

public abstract class BaseFragmentElementImpl
extends BaseElementImpl
implements BaseFragmentElement,
PersistenceBrokerAware {
    private String ojbConcreteClass = this.getClass().getName();
    private String fragmentId;
    private String skinProperty;
    private String decoratorProperty;
    private String stateProperty;
    private String modeProperty;
    private int layoutRowProperty = -1;
    private int layoutColumnProperty = -1;
    private String layoutSizesProperty;
    private float layoutXProperty = -1.0f;
    private float layoutYProperty = -1.0f;
    private float layoutZProperty = -1.0f;
    private float layoutWidthProperty = -1.0f;
    private float layoutHeightProperty = -1.0f;
    private List preferences;
    private FragmentPropertyList fragmentProperties;
    private FragmentPreferenceList fragmentPreferences;
    private BaseFragmentsElementImpl baseFragmentsElement;

    public BaseFragmentElementImpl() {
        super(new FragmentSecurityConstraintsImpl());
    }

    List accessPreferences() {
        if (this.preferences == null) {
            this.preferences = DatabasePageManagerUtils.createList();
        }
        return this.preferences;
    }

    public BaseFragmentsElementImpl getBaseFragmentsElement() {
        return this.baseFragmentsElement;
    }

    void setBaseFragmentsElement(BaseFragmentsElementImpl baseFragmentsElement) {
        this.baseFragmentsElement = baseFragmentsElement;
    }

    public BaseFragmentElement getFragmentById(String id) {
        if (this.getId().equals(id)) {
            return this;
        }
        return null;
    }

    List getFragmentsByName(String name) {
        ArrayList<BaseFragmentElementImpl> matchedFragments = null;
        if (this.getName() != null && this.getName().equals(name)) {
            if (matchedFragments == null) {
                matchedFragments = new ArrayList<BaseFragmentElementImpl>();
            }
            matchedFragments.add(this);
        }
        return matchedFragments;
    }

    List getFragmentsByInterface(Class interfaceFilter) {
        ArrayList<BaseFragmentElementImpl> matchedFragments = null;
        if (interfaceFilter == null || interfaceFilter.isInstance(this)) {
            if (matchedFragments == null) {
                matchedFragments = new ArrayList<BaseFragmentElementImpl>();
            }
            matchedFragments.add(this);
        }
        return matchedFragments;
    }

    public PageManager getPageManager() {
        return this.baseFragmentsElement != null ? this.baseFragmentsElement.getPageManager() : null;
    }

    public PageSecurity getEffectivePageSecurity() {
        if (this.baseFragmentsElement != null) {
            return this.baseFragmentsElement.getEffectivePageSecurity();
        }
        return null;
    }

    public void checkPermissions(String path, int mask, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        AccessController.checkPermission((Permission)pf.newPermission("fragment", path, mask));
    }

    public boolean getConstraintsEnabled() {
        if (this.baseFragmentsElement != null) {
            return this.baseFragmentsElement.getConstraintsEnabled();
        }
        return false;
    }

    public boolean getPermissionsEnabled() {
        if (this.baseFragmentsElement != null) {
            return this.baseFragmentsElement.getPermissionsEnabled();
        }
        return false;
    }

    public String getId() {
        if (this.fragmentId != null) {
            return this.fragmentId;
        }
        return super.getId();
    }

    public void setId(String fragmentId) {
        this.fragmentId = fragmentId;
    }

    public String getSkin() {
        return this.getProperty("skin");
    }

    public void setSkin(String skinName) {
        this.skinProperty = skinName;
    }

    public void setSkin(String propScope, String propScopeValue, String skinName) {
        this.setProperty("skin", propScope, propScopeValue, skinName);
    }

    public String getDecorator() {
        return this.getProperty("decorator");
    }

    public void setDecorator(String decoratorName) {
        this.decoratorProperty = decoratorName;
    }

    public void setDecorator(String propScope, String propScopeValue, String decoratorName) {
        this.setProperty("decorator", propScope, propScopeValue, decoratorName);
    }

    public String getState() {
        return this.getProperty("state");
    }

    public void setState(String state) {
        this.stateProperty = state;
    }

    public void setState(String propScope, String propScopeValue, String state) {
        this.setProperty("state", propScope, propScopeValue, state);
    }

    public String getMode() {
        return this.getProperty("mode");
    }

    public void setMode(String mode) {
        this.modeProperty = mode;
    }

    public void setMode(String propScope, String propScopeValue, String mode) {
        this.setProperty("mode", propScope, propScopeValue, mode);
    }

    public String getProperty(String propName) {
        String[] userValue = new String[1];
        String[] groupValue = new String[1];
        String[] roleValue = new String[1];
        String[] globalValue = new String[1];
        FragmentPropertyImpl.getFragmentProperty(propName, this.getProperties(), userValue, groupValue, roleValue, globalValue);
        if (userValue[0] == null && groupValue[0] == null && roleValue[0] == null) {
            if ("skin".equals(propName)) {
                globalValue[0] = this.skinProperty;
            } else if ("decorator".equals(propName)) {
                globalValue[0] = this.decoratorProperty;
            } else if ("state".equals(propName)) {
                globalValue[0] = this.stateProperty;
            } else if ("mode".equals(propName)) {
                globalValue[0] = this.modeProperty;
            } else if ("row".equals(propName)) {
                globalValue[0] = this.layoutRowProperty >= 0 ? Integer.toString(this.layoutRowProperty) : null;
            } else if ("column".equals(propName)) {
                globalValue[0] = this.layoutColumnProperty >= 0 ? Integer.toString(this.layoutColumnProperty) : null;
            } else if ("sizes".equals(propName)) {
                globalValue[0] = this.layoutSizesProperty;
            } else if ("x".equals(propName)) {
                globalValue[0] = this.layoutXProperty >= 0.0f ? Float.toString(this.layoutXProperty) : null;
            } else if ("y".equals(propName)) {
                globalValue[0] = this.layoutYProperty >= 0.0f ? Float.toString(this.layoutYProperty) : null;
            } else if ("z".equals(propName)) {
                globalValue[0] = this.layoutZProperty >= 0.0f ? Float.toString(this.layoutZProperty) : null;
            } else if ("width".equals(propName)) {
                globalValue[0] = this.layoutWidthProperty >= 0.0f ? Float.toString(this.layoutWidthProperty) : null;
            } else if ("height".equals(propName)) {
                String string = globalValue[0] = this.layoutHeightProperty >= 0.0f ? Float.toString(this.layoutHeightProperty) : null;
            }
        }
        return userValue[0] != null ? userValue[0] : (groupValue[0] != null ? groupValue[0] : (roleValue[0] != null ? roleValue[0] : globalValue[0]));
    }

    public String getProperty(String propName, String propScope, String propScopeValue) {
        FragmentProperty fragmentProperty;
        if (propScope == null) {
            if ("skin".equals(propName)) {
                return this.skinProperty;
            }
            if ("decorator".equals(propName)) {
                return this.decoratorProperty;
            }
            if ("state".equals(propName)) {
                return this.stateProperty;
            }
            if ("mode".equals(propName)) {
                return this.modeProperty;
            }
            if ("row".equals(propName)) {
                return this.layoutRowProperty >= 0 ? Integer.toString(this.layoutRowProperty) : null;
            }
            if ("column".equals(propName)) {
                return this.layoutColumnProperty >= 0 ? Integer.toString(this.layoutColumnProperty) : null;
            }
            if ("sizes".equals(propName)) {
                return this.layoutSizesProperty;
            }
            if ("x".equals(propName)) {
                return this.layoutXProperty >= 0.0f ? Float.toString(this.layoutXProperty) : null;
            }
            if ("y".equals(propName)) {
                return this.layoutYProperty >= 0.0f ? Float.toString(this.layoutYProperty) : null;
            }
            if ("z".equals(propName)) {
                return this.layoutZProperty >= 0.0f ? Float.toString(this.layoutZProperty) : null;
            }
            if ("width".equals(propName)) {
                return this.layoutWidthProperty >= 0.0f ? Float.toString(this.layoutWidthProperty) : null;
            }
            if ("height".equals(propName)) {
                return this.layoutHeightProperty >= 0.0f ? Float.toString(this.layoutHeightProperty) : null;
            }
        }
        if (propScope != null && propScope.equals("user") && propScopeValue == null) {
            propScopeValue = FragmentPropertyImpl.getCurrentUserScopeValue();
        }
        if ((fragmentProperty = FragmentPropertyImpl.findFragmentProperty(propName, propScope, propScopeValue, this.getProperties())) != null) {
            return fragmentProperty.getValue();
        }
        return null;
    }

    public int getIntProperty(String propName) {
        String propValue = this.getProperty(propName);
        if (propValue != null) {
            return Integer.parseInt(propValue);
        }
        return -1;
    }

    public int getIntProperty(String propName, String propScope, String propScopeValue) {
        FragmentProperty fragmentProperty;
        if (propScope == null) {
            if ("row".equals(propName)) {
                return this.layoutRowProperty;
            }
            if ("column".equals(propName)) {
                return this.layoutColumnProperty;
            }
        }
        if (propScope != null && propScope.equals("user") && propScopeValue == null) {
            propScopeValue = FragmentPropertyImpl.getCurrentUserScopeValue();
        }
        if ((fragmentProperty = FragmentPropertyImpl.findFragmentProperty(propName, propScope, propScopeValue, this.getProperties())) != null) {
            return Integer.parseInt(fragmentProperty.getValue());
        }
        return -1;
    }

    public float getFloatProperty(String propName) {
        String propValue = this.getProperty(propName);
        if (propValue != null) {
            return Float.parseFloat(propValue);
        }
        return -1.0f;
    }

    public float getFloatProperty(String propName, String propScope, String propScopeValue) {
        FragmentProperty fragmentProperty;
        if (propScope == null) {
            if ("x".equals(propName)) {
                return this.layoutXProperty;
            }
            if ("y".equals(propName)) {
                return this.layoutYProperty;
            }
            if ("z".equals(propName)) {
                return this.layoutZProperty;
            }
            if ("width".equals(propName)) {
                return this.layoutWidthProperty;
            }
            if ("height".equals(propName)) {
                return this.layoutHeightProperty;
            }
        }
        if (propScope != null && propScope.equals("user") && propScopeValue == null) {
            propScopeValue = FragmentPropertyImpl.getCurrentUserScopeValue();
        }
        if ((fragmentProperty = FragmentPropertyImpl.findFragmentProperty(propName, propScope, propScopeValue, this.getProperties())) != null) {
            return Float.parseFloat(fragmentProperty.getValue());
        }
        return -1.0f;
    }

    public void setProperty(String propName, String propScope, String propScopeValue, String propValue) {
        if (propScope == null) {
            if ("skin".equals(propName)) {
                this.skinProperty = propValue;
                return;
            }
            if ("decorator".equals(propName)) {
                this.decoratorProperty = propValue;
                return;
            }
            if ("state".equals(propName)) {
                this.stateProperty = propValue;
                return;
            }
            if ("mode".equals(propName)) {
                this.modeProperty = propValue;
                return;
            }
            if ("row".equals(propName)) {
                this.layoutRowProperty = propValue != null ? Integer.parseInt(propValue) : -1;
                return;
            }
            if ("column".equals(propName)) {
                this.layoutColumnProperty = propValue != null ? Integer.parseInt(propValue) : -1;
                return;
            }
            if ("sizes".equals(propName)) {
                this.layoutSizesProperty = propValue;
                return;
            }
            if ("x".equals(propName)) {
                this.layoutXProperty = propValue != null ? (float)Integer.parseInt(propValue) : -1.0f;
                return;
            }
            if ("y".equals(propName)) {
                this.layoutYProperty = propValue != null ? (float)Integer.parseInt(propValue) : -1.0f;
                return;
            }
            if ("z".equals(propName)) {
                this.layoutZProperty = propValue != null ? (float)Integer.parseInt(propValue) : -1.0f;
                return;
            }
            if ("width".equals(propName)) {
                this.layoutWidthProperty = propValue != null ? (float)Integer.parseInt(propValue) : -1.0f;
                return;
            }
            if ("height".equals(propName)) {
                this.layoutHeightProperty = propValue != null ? (float)Integer.parseInt(propValue) : -1.0f;
                return;
            }
        }
        if (propScope != null && propScope.equals("user") && propScopeValue == null) {
            propScopeValue = FragmentPropertyImpl.getCurrentUserScopeValue();
        }
        FragmentProperty fragmentProperty = FragmentPropertyImpl.findFragmentProperty(propName, propScope, propScopeValue, this.getProperties());
        if (propValue != null) {
            if (fragmentProperty == null) {
                fragmentProperty = new FragmentPropertyImpl();
                fragmentProperty.setName(propName);
                fragmentProperty.setScope(propScope);
                fragmentProperty.setScopeValue(propScopeValue);
                fragmentProperty.setValue(propValue);
                this.getProperties().add(fragmentProperty);
            } else {
                fragmentProperty.setValue(propValue);
            }
        } else if (fragmentProperty != null) {
            this.getProperties().remove(fragmentProperty);
        }
    }

    public void setProperty(String propName, String propScope, String propScopeValue, int propValue) {
        if (propScope == null) {
            if ("row".equals(propName)) {
                this.layoutRowProperty = propValue;
                return;
            }
            if ("column".equals(propName)) {
                this.layoutColumnProperty = propValue;
                return;
            }
        }
        this.setProperty(propName, propScope, propScopeValue, Integer.toString(propValue));
    }

    public void setProperty(String propName, String propScope, String propScopeValue, float propValue) {
        if (propScope == null) {
            if ("x".equals(propName)) {
                this.layoutXProperty = propValue;
                return;
            }
            if ("y".equals(propName)) {
                this.layoutYProperty = propValue;
                return;
            }
            if ("z".equals(propName)) {
                this.layoutZProperty = propValue;
                return;
            }
            if ("width".equals(propName)) {
                this.layoutWidthProperty = propValue;
                return;
            }
            if ("height".equals(propName)) {
                this.layoutHeightProperty = propValue;
                return;
            }
        }
        this.setProperty(propName, propScope, propScopeValue, Float.toString(propValue));
    }

    public List getProperties() {
        PageManager pageManager;
        if (this.getIdentity() != 0 && (pageManager = this.getPageManager()) != null) {
            FragmentPropertyList properties = pageManager.getFragmentPropertyManager().getFragmentPropertyList((BaseFragmentElement)this, this.fragmentProperties);
            this.fragmentProperties = null;
            return properties;
        }
        if (this.fragmentProperties == null) {
            this.fragmentProperties = new FragmentPropertyListImpl(this);
        }
        return this.fragmentProperties;
    }

    public void setProperties(List properties) {
        List fragmentProperties = this.getProperties();
        if (properties != fragmentProperties) {
            fragmentProperties.clear();
            if (properties != null) {
                fragmentProperties.addAll(properties);
            }
        }
    }

    public int getLayoutRow() {
        return this.getIntProperty("row");
    }

    public void setLayoutRow(int row) {
        this.layoutRowProperty = row;
    }

    public void setLayoutRow(String scope, String scopeValue, int row) {
        this.setProperty("row", scope, scopeValue, row);
    }

    public int getLayoutColumn() {
        return this.getIntProperty("column");
    }

    public void setLayoutColumn(int column) {
        this.layoutColumnProperty = column;
    }

    public void setLayoutColumn(String scope, String scopeValue, int column) {
        this.setProperty("column", scope, scopeValue, column);
    }

    public String getLayoutSizes() {
        return this.getProperty("sizes");
    }

    public void setLayoutSizes(String sizes) {
        this.layoutSizesProperty = sizes;
    }

    public void setLayoutSizes(String scope, String scopeValue, String sizes) {
        this.setProperty("sizes", scope, scopeValue, sizes);
    }

    public float getLayoutX() {
        return this.getFloatProperty("x");
    }

    public void setLayoutX(float x) {
        this.layoutXProperty = x;
    }

    public void setLayoutX(String scope, String scopeValue, float x) {
        this.setProperty("x", scope, scopeValue, x);
    }

    public float getLayoutY() {
        return this.getFloatProperty("y");
    }

    public void setLayoutY(float y) {
        this.layoutYProperty = y;
    }

    public void setLayoutY(String scope, String scopeValue, float y) {
        this.setProperty("y", scope, scopeValue, y);
    }

    public float getLayoutZ() {
        return this.getFloatProperty("z");
    }

    public void setLayoutZ(float z) {
        this.layoutZProperty = z;
    }

    public void setLayoutZ(String scope, String scopeValue, float z) {
        this.setProperty("z", scope, scopeValue, z);
    }

    public float getLayoutWidth() {
        return this.getFloatProperty("width");
    }

    public void setLayoutWidth(float width) {
        this.layoutWidthProperty = width;
    }

    public void setLayoutWidth(String scope, String scopeValue, float width) {
        this.setProperty("width", scope, scopeValue, width);
    }

    public float getLayoutHeight() {
        return this.getFloatProperty("height");
    }

    public void setLayoutHeight(float height) {
        this.layoutHeightProperty = height;
    }

    public void setLayoutHeight(String scope, String scopeValue, float height) {
        this.setProperty("height", scope, scopeValue, height);
    }

    public List getPreferences() {
        if (this.fragmentPreferences == null) {
            this.fragmentPreferences = new FragmentPreferenceList(this);
        }
        return this.fragmentPreferences;
    }

    public void setPreferences(List preferences) {
        List fragmentPreferences = this.getPreferences();
        if (preferences != fragmentPreferences) {
            fragmentPreferences.clear();
            if (preferences != null) {
                fragmentPreferences.addAll(preferences);
            }
        }
    }

    public void afterDelete(PersistenceBroker broker) {
    }

    public void afterInsert(PersistenceBroker broker) {
        PageManager pageManager = this.getPageManager();
        if (pageManager != null) {
            pageManager.getFragmentPropertyManager().updateFragmentPropertyList((BaseFragmentElement)this, "all", this.fragmentProperties);
            this.fragmentProperties = null;
        }
    }

    public void afterLookup(PersistenceBroker broker) {
    }

    public void afterUpdate(PersistenceBroker broker) {
        PageManager pageManager = this.getPageManager();
        if (pageManager != null) {
            pageManager.getFragmentPropertyManager().updateFragmentPropertyList((BaseFragmentElement)this, "all", this.fragmentProperties);
            this.fragmentProperties = null;
        }
    }

    public void beforeDelete(PersistenceBroker broker) {
        PageManager pageManager = this.getPageManager();
        if (pageManager != null) {
            pageManager.getFragmentPropertyManager().removeFragmentPropertyList((BaseFragmentElement)this, this.fragmentProperties);
            this.fragmentProperties = null;
        }
    }

    public void beforeInsert(PersistenceBroker broker) {
    }

    public void beforeUpdate(PersistenceBroker broker) {
    }

    protected boolean validateFragments(BaseFragmentValidationListener validationListener) {
        return validationListener.validate(this);
    }
}

