/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.interceptors;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.jetspeed.util.interceptors.TransactionalMethodReplayDecisionMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodReplayInterceptor
implements MethodInterceptor {
    private Logger log = LoggerFactory.getLogger(MethodReplayInterceptor.class);
    private static final long serialVersionUID = -1316279974504594833L;
    private int retryCount;
    private int retryInterval;
    private TransactionalMethodReplayDecisionMaker replayDecisionMaker;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return invocation.proceed();
        }
        catch (Exception exp) {
            int retryCounter;
            if (!this.isReplayable(invocation, exp)) {
                throw exp;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Invocation for method [" + invocation.getMethod().toString() + "] failed. Will attempt to replay method invocation [" + this.retryCount + "] times with an interval of [" + this.retryInterval + "] milliseconds");
            }
            Exception lastExp = null;
            for (retryCounter = 1; retryCounter < this.retryCount; ++retryCounter) {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Sleeping for [" + this.retryInterval + "] milliseconds before replaying invocation for method [" + invocation.getMethod().toString() + "].");
                    }
                    Thread.sleep(this.retryInterval);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Attempt invocation [" + retryCounter + "] for method [" + invocation.getMethod().toString() + "].");
                    }
                    return invocation.proceed();
                }
                catch (Exception exp2) {
                    if (!this.isReplayable(invocation, exp)) {
                        throw exp;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Attempt [" + retryCounter + "] to replay invocation for method [" + invocation.getMethod().toString() + "] failed. [" + (this.retryCount - retryCounter) + "] attempts left.");
                    }
                    lastExp = exp2;
                    continue;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("[" + retryCounter + "] attempts to replay invocation for method [" + invocation.getMethod().toString() + "] failed. Throwing exception [" + lastExp.getClass().getName() + "]");
            }
            throw lastExp;
        }
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    private boolean isReplayable(MethodInvocation invocation, Exception exp) {
        return this.replayDecisionMaker.shouldReplay(invocation, exp);
    }

    public void setReplayDecisionMaker(TransactionalMethodReplayDecisionMaker replayDecisionMaker) {
        this.replayDecisionMaker = replayDecisionMaker;
    }
}

