/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.interceptors;

import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.jetspeed.page.impl.DatabasePageManagerCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageManagerInterceptor
implements MethodInterceptor {
    private static final long serialVersionUID = -1316279974504594833L;
    private final String[] cacheTransactionMethodsPrefix;
    private final String[] cacheTransactionMethods;

    public PageManagerInterceptor(List<String> cacheTransactionMethods) {
        ArrayList<String> cacheTransactionMethodsPrefixList = new ArrayList<String>();
        ArrayList cacheTransactionMethodsList = new ArrayList();
        for (String cacheTransactionMethod : cacheTransactionMethods) {
            if (cacheTransactionMethod.endsWith("*")) {
                cacheTransactionMethodsPrefixList.add(cacheTransactionMethod.substring(0, cacheTransactionMethod.length() - 1));
                continue;
            }
            cacheTransactionMethodsPrefixList.add(cacheTransactionMethod);
        }
        this.cacheTransactionMethodsPrefix = cacheTransactionMethodsPrefixList.toArray(new String[cacheTransactionMethodsPrefixList.size()]);
        this.cacheTransactionMethods = cacheTransactionMethodsList.toArray(new String[cacheTransactionMethodsList.size()]);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        boolean performCacheTransactionProcessing = false;
        for (String cacheTransactionMethodPrefix : this.cacheTransactionMethodsPrefix) {
            if (!methodName.startsWith(cacheTransactionMethodPrefix)) continue;
            performCacheTransactionProcessing = true;
            break;
        }
        if (!performCacheTransactionProcessing) {
            for (String cacheTransactionMethod : this.cacheTransactionMethods) {
                if (!methodName.equals(cacheTransactionMethod)) continue;
                performCacheTransactionProcessing = true;
                break;
            }
        }
        try {
            Object object = invocation.proceed();
            return object;
        }
        catch (Exception exception) {
            if (performCacheTransactionProcessing) {
                DatabasePageManagerCache.rollbackTransactions();
            }
            throw exception;
        }
        finally {
            if (performCacheTransactionProcessing) {
                DatabasePageManagerCache.clearTransactions();
            }
        }
    }
}

