/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.jetspeed.aggregator.PortletContent;
import org.apache.jetspeed.decoration.Decoration;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentFragmentImpl
implements ContentFragment {
    private final Fragment fragment;
    private StringBuffer overridenContent;
    private PortletContent portletContent;
    private List contentFragments;
    private static final Logger log = LoggerFactory.getLogger(ContentFragmentImpl.class);
    private final Map cachedFragments;
    private Decoration decoration;
    private boolean instantlyRendered;

    public ContentFragmentImpl(Fragment fragment, Map cachedFragments) {
        this(fragment, cachedFragments, false);
    }

    public ContentFragmentImpl(Fragment fragment, Map cachedFragments, boolean instantlyRendered) {
        this.fragment = fragment;
        this.cachedFragments = cachedFragments;
        this.instantlyRendered = instantlyRendered;
    }

    public List getContentFragments() {
        if (this.contentFragments == null) {
            this.contentFragments = new ContentFragmentList();
        }
        return this.contentFragments;
    }

    public List getFragments() {
        return this.getContentFragments();
    }

    public String getOverriddenContent() {
        return this.overridenContent != null ? this.overridenContent.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRenderedContent() throws IllegalStateException {
        if (this.overridenContent != null) {
            return this.overridenContent.toString();
        }
        if (this.portletContent != null) {
            PortletContent portletContent = this.portletContent;
            synchronized (portletContent) {
                String string;
                if (this.portletContent.isComplete()) {
                    return this.portletContent.getContent();
                }
                try {
                    log.debug("Waiting on content for Fragment " + this.getId());
                    this.portletContent.wait();
                    string = this.portletContent.getContent();
                }
                catch (InterruptedException e) {
                    String string2;
                    try {
                        string2 = e.getMessage();
                    }
                    catch (Throwable throwable) {
                        log.debug("Been notified that Faragment " + this.getId() + " is complete");
                        throw throwable;
                    }
                    log.debug("Been notified that Faragment " + this.getId() + " is complete");
                    return string2;
                }
                log.debug("Been notified that Faragment " + this.getId() + " is complete");
                return string;
            }
        }
        throw new IllegalStateException("You cannot invoke getRenderedContent() until the content has been set.");
    }

    public void overrideRenderedContent(String contnent) {
        if (contnent != null) {
            if (this.overridenContent == null) {
                this.overridenContent = new StringBuffer();
            }
            if (!contnent.equals(this.overridenContent.toString())) {
                this.overridenContent.append(contnent);
            }
        }
    }

    public void setPortletContent(PortletContent portletContent) {
        this.portletContent = portletContent;
    }

    public String getDecorator() {
        return this.fragment.getDecorator();
    }

    public String getName() {
        return this.fragment.getName();
    }

    public Map getProperties() {
        return this.fragment.getProperties();
    }

    public String getProperty(String propName) {
        return this.fragment.getProperty(propName);
    }

    public int getIntProperty(String propName) {
        return this.fragment.getIntProperty(propName);
    }

    public float getFloatProperty(String propName) {
        return this.fragment.getFloatProperty(propName);
    }

    public String getSkin() {
        return this.fragment.getSkin();
    }

    public String getState() {
        return this.fragment.getState();
    }

    public String getMode() {
        return this.fragment.getMode();
    }

    public String getType() {
        return this.fragment.getType();
    }

    public boolean isReference() {
        return this.fragment.isReference();
    }

    public void setDecorator(String decoratorName) {
        this.fragment.setDecorator(decoratorName);
    }

    public void setName(String name) {
        this.fragment.setName(name);
    }

    public int getLayoutRow() {
        return this.fragment.getLayoutRow();
    }

    public int getLayoutColumn() {
        return this.fragment.getLayoutColumn();
    }

    public String getLayoutSizes() {
        return this.fragment.getLayoutSizes();
    }

    public float getLayoutX() {
        return this.fragment.getLayoutX();
    }

    public float getLayoutY() {
        return this.fragment.getLayoutY();
    }

    public float getLayoutZ() {
        return this.fragment.getLayoutZ();
    }

    public float getLayoutWidth() {
        return this.fragment.getLayoutWidth();
    }

    public float getLayoutHeight() {
        return this.fragment.getLayoutHeight();
    }

    public void setLayoutRow(int row) {
        this.fragment.setLayoutRow(row);
    }

    public void setLayoutColumn(int column) {
        this.fragment.setLayoutColumn(column);
    }

    public void setLayoutSizes(String sizes) {
        this.fragment.setLayoutSizes(sizes);
    }

    public void setLayoutX(float x) {
        this.fragment.setLayoutX(x);
    }

    public void setLayoutY(float y) {
        this.fragment.setLayoutY(y);
    }

    public void setLayoutZ(float z) {
        this.fragment.setLayoutZ(z);
    }

    public void setLayoutWidth(float width) {
        this.fragment.setLayoutWidth(width);
    }

    public void setLayoutHeight(float height) {
        this.fragment.setLayoutHeight(height);
    }

    public void setSkin(String skinName) {
        this.fragment.setSkin(skinName);
    }

    public void setState(String state) {
        this.fragment.setState(state);
    }

    public void setMode(String mode) {
        this.fragment.setMode(mode);
    }

    public void setType(String type) {
        this.fragment.setType(type);
    }

    public String getId() {
        return this.fragment.getId();
    }

    public String getShortTitle() {
        return this.fragment.getShortTitle();
    }

    public String getTitle() {
        return this.fragment.getTitle();
    }

    public void setShortTitle(String title) {
        this.fragment.setShortTitle(title);
    }

    public void setTitle(String title) {
        this.fragment.setTitle(title);
    }

    public void checkAccess(String actions) throws SecurityException {
        this.fragment.checkAccess(actions);
    }

    public void checkConstraints(String actions) throws SecurityException {
        this.fragment.checkConstraints(actions);
    }

    public void checkPermissions(int mask) throws SecurityException {
        this.fragment.checkPermissions(mask);
    }

    public boolean getConstraintsEnabled() {
        return this.fragment.getConstraintsEnabled();
    }

    public boolean getPermissionsEnabled() {
        return this.fragment.getPermissionsEnabled();
    }

    public SecurityConstraints getSecurityConstraints() {
        return this.fragment.getSecurityConstraints();
    }

    public SecurityConstraints newSecurityConstraints() {
        return this.fragment.newSecurityConstraints();
    }

    public SecurityConstraint newSecurityConstraint() {
        return this.fragment.newSecurityConstraint();
    }

    public void setSecurityConstraints(SecurityConstraints constraints) {
        this.fragment.setSecurityConstraints(constraints);
    }

    protected ContentFragment getContentFragment(Fragment f) {
        ContentFragment cf;
        if (this.cachedFragments.containsKey(f.getId())) {
            cf = (ContentFragment)this.cachedFragments.get(f.getId());
        } else {
            cf = new ContentFragmentImpl(f, this.cachedFragments);
            this.cachedFragments.put(f.getId(), cf);
        }
        return cf;
    }

    public List getPreferences() {
        return this.fragment.getPreferences();
    }

    public Decoration getDecoration() {
        return this.decoration;
    }

    public void setPreferences(List preferences) {
        this.fragment.setPreferences(preferences);
    }

    public void setDecoration(Decoration decoration) {
        this.decoration = decoration;
    }

    public boolean isInstantlyRendered() {
        return this.instantlyRendered;
    }

    public PortletContent getPortletContent() {
        return this.portletContent;
    }

    protected final class ContentFragmentList
    implements List,
    Serializable {
        private List baseList;

        protected ContentFragmentList() {
            this.baseList = ContentFragmentImpl.this.fragment.getFragments();
        }

        public void add(int index, Object element) {
            if (element instanceof ContentFragmentImpl) {
                element = ((ContentFragmentImpl)element).fragment;
            }
            this.baseList.add(index, element);
        }

        public boolean add(Object o) {
            if (o instanceof ContentFragmentImpl) {
                o = ((ContentFragmentImpl)o).fragment;
            }
            return this.baseList.add(o);
        }

        public boolean addAll(int index, Collection c) {
            return this.baseList.addAll(index, c);
        }

        public boolean addAll(Collection c) {
            return this.baseList.addAll(c);
        }

        public void clear() {
            this.baseList.clear();
        }

        public boolean contains(Object o) {
            return this.baseList.contains(o);
        }

        public boolean containsAll(Collection c) {
            return this.baseList.containsAll(c);
        }

        public boolean equals(Object o) {
            return ((Object)this.baseList).equals(o);
        }

        public Object get(int index) {
            Fragment f = (Fragment)this.baseList.get(index);
            return ContentFragmentImpl.this.getContentFragment(f);
        }

        public int hashCode() {
            return ((Object)this.baseList).hashCode();
        }

        public int indexOf(Object o) {
            return this.baseList.indexOf(o);
        }

        public boolean isEmpty() {
            return this.baseList.isEmpty();
        }

        public Iterator iterator() {
            return this.duplicateList().iterator();
        }

        public int lastIndexOf(Object o) {
            return this.baseList.lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return this.duplicateList().listIterator();
        }

        public ListIterator listIterator(int index) {
            return this.duplicateList().listIterator(index);
        }

        public Object remove(int index) {
            return this.baseList.remove(index);
        }

        public boolean remove(Object o) {
            return this.baseList.remove(o);
        }

        public boolean removeAll(Collection c) {
            return this.baseList.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            return this.baseList.retainAll(c);
        }

        public Object set(int index, Object element) {
            return this.baseList.set(index, element);
        }

        public int size() {
            return this.baseList.size();
        }

        public List subList(int fromIndex, int toIndex) {
            return this.duplicateList().subList(fromIndex, toIndex);
        }

        public Object[] toArray() {
            return this.duplicateList().toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.duplicateList().toArray(a);
        }

        private List duplicateList() {
            List rFragList = DatabasePageManagerUtils.createList();
            for (int i = 0; i < this.baseList.size(); ++i) {
                Fragment f = (Fragment)this.baseList.get(i);
                ContentFragment cf = ContentFragmentImpl.this.getContentFragment(f);
                rFragList.add(cf);
            }
            return rFragList;
        }
    }
}

