/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.folder.psml;

import java.security.AccessController;
import java.security.Permission;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.MenuExcludeDefinition;
import org.apache.jetspeed.om.folder.MenuIncludeDefinition;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.folder.MenuSeparatorDefinition;
import org.apache.jetspeed.om.folder.Reset;
import org.apache.jetspeed.om.folder.psml.FolderMetaDataImpl;
import org.apache.jetspeed.om.folder.psml.MenuDefinitionImpl;
import org.apache.jetspeed.om.folder.psml.MenuExcludeDefinitionImpl;
import org.apache.jetspeed.om.folder.psml.MenuIncludeDefinitionImpl;
import org.apache.jetspeed.om.folder.psml.MenuOptionsDefinitionImpl;
import org.apache.jetspeed.om.folder.psml.MenuSeparatorDefinitionImpl;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.page.PageManagerUtils;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.DocumentException;
import org.apache.jetspeed.page.document.DocumentHandlerFactory;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.FolderHandler;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.UnsupportedDocumentTypeException;
import org.apache.jetspeed.page.document.psml.AbstractNode;
import org.apache.jetspeed.page.document.psml.NodeOrderComparator;
import org.apache.jetspeed.page.document.psml.NodeSetImpl;
import org.apache.jetspeed.security.PermissionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderImpl
extends AbstractNode
implements Folder,
Reset {
    private NodeSet allNodes;
    private FolderMetaDataImpl metadata;
    private FolderHandler folderHandler;
    private int reservedType = 0;
    private static final Logger log = LoggerFactory.getLogger(FolderImpl.class);
    private static PermissionFactory pf;

    public static void setPermissionsFactory(PermissionFactory pf) {
        FolderImpl.pf = pf;
    }

    public FolderImpl(String path, FolderMetaDataImpl metadata, DocumentHandlerFactory handlerFactory, FolderHandler folderHandler) {
        this.metadata = metadata;
        this.metadata.setParent(this);
        this.folderHandler = folderHandler;
        this.setPath(path);
        this.setReservedType();
        this.setHandlerFactory(handlerFactory);
        this.setPermissionsEnabled(handlerFactory.getPermissionsEnabled());
        this.setConstraintsEnabled(handlerFactory.getConstraintsEnabled());
    }

    public FolderImpl(String path, DocumentHandlerFactory handlerFactory, FolderHandler folderHandler) {
        this.metadata = new FolderMetaDataImpl();
        this.metadata.setParent(this);
        this.folderHandler = folderHandler;
        this.setPath(path);
        this.setReservedType();
        this.setHandlerFactory(handlerFactory);
        this.setPermissionsEnabled(handlerFactory.getPermissionsEnabled());
        this.setConstraintsEnabled(handlerFactory.getConstraintsEnabled());
    }

    public FolderImpl() {
        this.metadata = new FolderMetaDataImpl();
        this.metadata.setParent(this);
        this.setReservedType();
    }

    public String getSkin() {
        return this.metadata.getSkin();
    }

    public void setSkin(String skinName) {
        this.metadata.setSkin(skinName);
    }

    public String getEffectiveDefaultDecorator(String fragmentType) {
        Folder parentFolder;
        String decorator = this.getDefaultDecorator(fragmentType);
        if (decorator == null && (parentFolder = (Folder)this.getParent()) != null) {
            return parentFolder.getEffectiveDefaultDecorator(fragmentType);
        }
        return decorator;
    }

    public String getDefaultDecorator(String fragmentType) {
        return this.metadata.getDefaultDecorator(fragmentType);
    }

    public void setDefaultDecorator(String decoratorName, String fragmentType) {
        this.metadata.setDefaultDecorator(decoratorName, fragmentType);
    }

    public List getDocumentOrder() {
        return this.metadata.getDocumentOrder();
    }

    public void setDocumentOrder(List docIndexes) {
        this.metadata.setDocumentOrder(docIndexes);
    }

    public String getDefaultPage() {
        return this.metadata.getDefaultPage();
    }

    public void setDefaultPage(String defaultPage) {
        this.metadata.setDefaultPage(defaultPage);
    }

    public NodeSet getFolders(boolean checkAccess) throws DocumentException {
        NodeSet folders = this.getAllNodes().subset("folder");
        if (checkAccess) {
            folders = FolderImpl.checkAccess(folders, JetspeedActions.VIEW);
        }
        return folders;
    }

    public NodeSet getFolders() throws DocumentException {
        return this.getFolders(true);
    }

    public Folder getFolder(String name, boolean checkAccess) throws FolderNotFoundException, DocumentException {
        Folder folder = (Folder)this.getAllNodes().subset("folder").get(name);
        if (folder == null) {
            throw new FolderNotFoundException("Jetspeed PSML folder not found: " + name);
        }
        if (checkAccess) {
            folder.checkAccess(JetspeedActions.VIEW);
        }
        return folder;
    }

    public Folder getFolder(String name) throws FolderNotFoundException, DocumentException {
        return this.getFolder(name, true);
    }

    public NodeSet getPages(boolean checkAccess) throws NodeException {
        NodeSet pages = this.getAllNodes().subset(".psml");
        if (checkAccess) {
            pages = FolderImpl.checkAccess(pages, JetspeedActions.VIEW);
        }
        return pages;
    }

    public NodeSet getPages() throws NodeException {
        return this.getPages(true);
    }

    public Page getPage(String name, boolean checkAccess) throws PageNotFoundException, NodeException {
        Page page = (Page)this.getAllNodes().subset(".psml").get(name);
        if (page == null) {
            throw new PageNotFoundException("Jetspeed PSML page not found: " + name);
        }
        if (checkAccess) {
            page.checkAccess(JetspeedActions.VIEW);
        }
        return page;
    }

    public Page getPage(String name) throws PageNotFoundException, NodeException {
        return this.getPage(name, true);
    }

    public NodeSet getLinks(boolean checkAccess) throws NodeException {
        NodeSet links = this.getAllNodes().subset(".link");
        if (checkAccess) {
            links = FolderImpl.checkAccess(links, JetspeedActions.VIEW);
        }
        return links;
    }

    public NodeSet getLinks() throws NodeException {
        return this.getLinks(true);
    }

    public Link getLink(String name, boolean checkAccess) throws DocumentNotFoundException, NodeException {
        Link link = (Link)this.getAllNodes().subset(".link").get(name);
        if (link == null) {
            throw new DocumentNotFoundException("Jetspeed PSML link not found: " + name);
        }
        if (checkAccess) {
            link.checkAccess(JetspeedActions.VIEW);
        }
        return link;
    }

    public Link getLink(String name) throws DocumentNotFoundException, NodeException {
        return this.getLink(name, true);
    }

    public PageSecurity getPageSecurity(boolean checkAccess) throws DocumentNotFoundException, NodeException {
        PageSecurity pageSecurity;
        if (checkAccess) {
            this.checkAccess(JetspeedActions.VIEW);
        }
        if ((pageSecurity = (PageSecurity)this.getAllNodes(false).subset("page.security").get("page.security")) == null) {
            throw new DocumentNotFoundException("Jetspeed PSML page security not found: page.security");
        }
        return pageSecurity;
    }

    public PageSecurity getPageSecurity() throws DocumentNotFoundException, NodeException {
        return this.getPageSecurity(false);
    }

    public NodeSet getAll() throws DocumentException {
        NodeSet nodes = this.getAllNodes();
        NodeSetImpl filteredNodes = null;
        for (Node node : nodes) {
            try {
                ((AbstractNode)node).checkAccess(JetspeedActions.VIEW);
                if (filteredNodes == null) continue;
                filteredNodes.add(node);
            }
            catch (SecurityException se) {
                Node copyNode;
                if (filteredNodes != null) continue;
                filteredNodes = new NodeSetImpl(this.getPath(), ((NodeSetImpl)nodes).getComparator());
                Iterator copyIter = nodes.iterator();
                while (copyIter.hasNext() && (copyNode = (Node)copyIter.next()) != node) {
                    filteredNodes.add(copyNode);
                }
            }
        }
        if (filteredNodes != null) {
            return filteredNodes;
        }
        return nodes;
    }

    public NodeSet getAllNodes() throws DocumentException {
        return this.getAllNodes(true);
    }

    protected synchronized NodeSet getAllNodes(boolean folderExistenceRequired) throws DocumentException {
        block7: {
            if (this.allNodes == null && this.folderHandler != null) {
                this.allNodes = this.metadata.getDocumentOrder() != null ? (this.getPath().endsWith("/") ? new NodeSetImpl(this.getPath(), new NodeOrderComparator(this.metadata.getDocumentOrder(), this.getPath())) : new NodeSetImpl(this.getPath(), new NodeOrderComparator(this.metadata.getDocumentOrder(), this.getPath() + "/"))) : new NodeSetImpl(this.getPath());
                try {
                    String[] nodeNames = this.folderHandler.listAll(this.getPath());
                    for (int i = 0; i < nodeNames.length; ++i) {
                        if (nodeNames[i].equals("folder.metadata")) continue;
                        Object node = null;
                        try {
                            String full;
                            node = this.getPath().endsWith("/") ? (!this.folderHandler.isFolder(full = PageManagerUtils.concatenatePaths(this.getPath(), nodeNames[i])) ? this.getHandlerFactory().getDocumentHandlerForPath(nodeNames[i]).getDocument(this.getPath() + nodeNames[i]) : this.folderHandler.getFolder(this.getPath() + nodeNames[i])) : (!this.folderHandler.isFolder(full = PageManagerUtils.concatenatePaths(this.getPath(), nodeNames[i])) ? this.getHandlerFactory().getDocumentHandlerForPath(nodeNames[i]).getDocument(this.getPath() + "/" + nodeNames[i]) : this.folderHandler.getFolder(this.getPath() + "/" + nodeNames[i]));
                            node.setParent((Node)this);
                            this.allNodes.add((Node)node);
                            continue;
                        }
                        catch (UnsupportedDocumentTypeException e) {
                            log.info("getAllNodes() Skipping unsupported document: " + nodeNames[i]);
                            continue;
                        }
                        catch (Exception e) {
                            log.warn("getAllNodes() failed to create Node: " + nodeNames[i] + ":" + e.toString(), (Throwable)e);
                        }
                    }
                }
                catch (FolderNotFoundException fnfe) {
                    if (!folderExistenceRequired) break block7;
                    log.error("getAllNodes() unexpected missing folder: " + this.getPath(), (Throwable)fnfe);
                }
            }
        }
        return this.allNodes;
    }

    public FolderMetaDataImpl getFolderMetaData() {
        return this.metadata;
    }

    public void setFolderHandler(FolderHandler handler) {
        this.folderHandler = handler;
    }

    public GenericMetadata getMetadata() {
        return this.metadata.getMetadata();
    }

    public SecurityConstraints getSecurityConstraints() {
        return this.metadata.getSecurityConstraints();
    }

    public void setSecurityConstraints(SecurityConstraints constraints) {
        this.metadata.setSecurityConstraints(constraints);
    }

    public PageSecurity getEffectivePageSecurity() {
        PageSecurity pageSecurity = null;
        try {
            pageSecurity = this.getPageSecurity(false);
            if (pageSecurity != null) {
                return pageSecurity;
            }
        }
        catch (NodeException ne) {
        }
        catch (NodeNotFoundException nnfe) {
            // empty catch block
        }
        FolderImpl parentFolderImpl = (FolderImpl)this.getParent();
        if (parentFolderImpl != null) {
            return parentFolderImpl.getEffectivePageSecurity();
        }
        return null;
    }

    public void checkPermissions(String path, int mask, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        if (!checkParentsOnly) {
            AccessController.checkPermission((Permission)pf.newPermission("folder", path, mask));
        }
        if (!checkNodeOnly && this.getParent() != null) {
            ((AbstractNode)this.getParent()).checkPermissions(mask, false, false);
        }
    }

    public String getTitle(Locale locale) {
        return this.metadata.getTitle(locale);
    }

    public String getTitle() {
        return this.metadata.getTitle();
    }

    public void setTitle(String title) {
        this.metadata.setTitle(title);
    }

    public String getShortTitle(Locale locale) {
        return this.metadata.getShortTitle(locale);
    }

    public String getShortTitle() {
        return this.metadata.getShortTitle();
    }

    public void setShortTitle(String title) {
        this.metadata.setShortTitle(title);
    }

    public String getType() {
        return "folder";
    }

    public boolean isHidden() {
        return this.metadata.isHidden();
    }

    public void setHidden(boolean hidden) {
        this.metadata.setHidden(hidden);
    }

    public void reset() {
        this.allNodes = null;
    }

    public List getMenuDefinitions() {
        return this.metadata.getMenuDefinitions();
    }

    public MenuDefinition newMenuDefinition() {
        return new MenuDefinitionImpl();
    }

    public MenuExcludeDefinition newMenuExcludeDefinition() {
        return new MenuExcludeDefinitionImpl();
    }

    public MenuIncludeDefinition newMenuIncludeDefinition() {
        return new MenuIncludeDefinitionImpl();
    }

    public MenuOptionsDefinition newMenuOptionsDefinition() {
        return new MenuOptionsDefinitionImpl();
    }

    public MenuSeparatorDefinition newMenuSeparatorDefinition() {
        return new MenuSeparatorDefinitionImpl();
    }

    public void setMenuDefinitions(List definitions) {
        this.metadata.setMenuDefinitions(definitions);
    }

    public void unmarshalled() {
        super.unmarshalled();
        if (this.getTitle() == null) {
            this.setTitle(this.getTitleName());
        }
    }

    public boolean isReserved() {
        return this.reservedType > 0;
    }

    public int getReservedType() {
        return this.reservedType;
    }

    private void setReservedType() {
        String name = this.getName();
        if (name != null) {
            if (name.startsWith("__")) {
                this.reservedType = 1;
            } else if (name.startsWith("_")) {
                this.reservedType = name.equals("_user") ? 2 : (name.equals("_role") ? 3 : (name.equals("_group") ? 4 : (name.equals("_mediatype") ? 5 : (name.equals("_language") ? 6 : (name.equals("_country") ? 7 : 9999)))));
            }
        }
    }
}

