/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.interceptors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.jetspeed.page.impl.DatabasePageManagerCache;

public class PageManagerInterceptor
implements MethodInterceptor {
    private static final long serialVersionUID = -1316279974504594833L;
    private final String[] cacheTransactionMethodsPrefix;
    private final String[] cacheTransactionMethods;

    public PageManagerInterceptor(List cacheTransactionMethods) {
        ArrayList<String> cacheTransactionMethodsPrefixList = new ArrayList<String>();
        ArrayList cacheTransactionMethodsList = new ArrayList();
        Iterator iter = cacheTransactionMethods.iterator();
        while (iter.hasNext()) {
            String cacheTransactionMethod = (String)iter.next();
            if (cacheTransactionMethod.endsWith("*")) {
                cacheTransactionMethodsPrefixList.add(cacheTransactionMethod.substring(0, cacheTransactionMethod.length() - 1));
                continue;
            }
            cacheTransactionMethodsPrefixList.add(cacheTransactionMethod);
        }
        this.cacheTransactionMethodsPrefix = cacheTransactionMethodsPrefixList.toArray(new String[cacheTransactionMethodsPrefixList.size()]);
        this.cacheTransactionMethods = cacheTransactionMethodsList.toArray(new String[cacheTransactionMethodsList.size()]);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        int i;
        String methodName = invocation.getMethod().getName();
        boolean performCacheTransactionProcessing = false;
        for (i = 0; i < this.cacheTransactionMethodsPrefix.length; ++i) {
            if (!methodName.startsWith(this.cacheTransactionMethodsPrefix[i])) continue;
            performCacheTransactionProcessing = true;
            break;
        }
        if (!performCacheTransactionProcessing) {
            for (i = 0; i < this.cacheTransactionMethods.length; ++i) {
                if (!methodName.equals(this.cacheTransactionMethods[i])) continue;
                performCacheTransactionProcessing = true;
                break;
            }
        }
        try {
            Object i2 = invocation.proceed();
            return i2;
        }
        catch (Exception exp) {
            if (performCacheTransactionProcessing) {
                DatabasePageManagerCache.rollbackTransactions();
            }
            throw exp;
        }
        finally {
            if (performCacheTransactionProcessing) {
                DatabasePageManagerCache.clearTransactions();
            }
        }
    }
}

