/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.cache.JetspeedCacheEventListener;
import org.apache.jetspeed.om.folder.impl.FolderImpl;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.impl.NodeImpl;
import org.apache.jetspeed.page.impl.DatabasePageManager;
import org.apache.jetspeed.page.impl.DatabasePageManagerCacheObject;
import org.apache.jetspeed.page.impl.TransactionedOperation;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;

public class DatabasePageManagerCache
implements ObjectCache {
    private static JetspeedCache oidCache;
    private static JetspeedCache pathCache;
    private static boolean constraintsEnabled;
    private static boolean permissionsEnabled;
    private static PageManager pageManager;
    private static List updatePathsList;
    private static ThreadLocal transactionedOperations;
    static /* synthetic */ Class class$org$apache$jetspeed$page$impl$DatabasePageManagerCache;

    public static synchronized void cacheInit(final JetspeedCache oidCache, final JetspeedCache pathCache, final DatabasePageManager pageManager) {
        DatabasePageManagerCache.oidCache = oidCache;
        DatabasePageManagerCache.pathCache = pathCache;
        constraintsEnabled = pageManager.getConstraintsEnabled();
        permissionsEnabled = pageManager.getPermissionsEnabled();
        oidCache.addEventListener(new JetspeedCacheEventListener(){

            public void notifyElementAdded(JetspeedCache cache, boolean local, Object key, Object element) {
                NodeImpl node = (NodeImpl)element;
                node.setConstraintsEnabled(constraintsEnabled);
                node.setPermissionsEnabled(permissionsEnabled);
                if (node instanceof FolderImpl) {
                    ((FolderImpl)node).setPageManager(pageManager);
                }
            }

            public void notifyElementChanged(JetspeedCache cache, boolean local, Object key, Object element) {
                NodeImpl node = (NodeImpl)element;
                node.setConstraintsEnabled(constraintsEnabled);
                node.setPermissionsEnabled(permissionsEnabled);
                if (node instanceof FolderImpl) {
                    ((FolderImpl)node).setPageManager(pageManager);
                }
            }

            public void notifyElementEvicted(JetspeedCache cache, boolean local, Object key, Object element) {
                NodeImpl node = (NodeImpl)element;
                if (node instanceof FolderImpl) {
                    ((FolderImpl)node).resetAll(false);
                }
            }

            public void notifyElementExpired(JetspeedCache cache, boolean local, Object key, Object element) {
                NodeImpl node = (NodeImpl)element;
                if (node instanceof FolderImpl) {
                    ((FolderImpl)node).resetAll(false);
                }
            }

            public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
                NodeImpl node = (NodeImpl)element;
                if (node instanceof FolderImpl) {
                    ((FolderImpl)node).resetAll(false);
                }
            }
        }, true);
        pathCache.addEventListener(new JetspeedCacheEventListener(){

            public void notifyElementAdded(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            public void notifyElementChanged(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            public void notifyElementEvicted(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            public void notifyElementExpired(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
                DatabasePageManagerCacheObject cacheObject = (DatabasePageManagerCacheObject)element;
                if (cacheObject != null) {
                    Identity oid = cacheObject.getId();
                    String path = cacheObject.getPath();
                    if (oid != null || path != null) {
                        Class clazz = class$org$apache$jetspeed$page$impl$DatabasePageManagerCache == null ? (class$org$apache$jetspeed$page$impl$DatabasePageManagerCache = DatabasePageManagerCache.class$("org.apache.jetspeed.page.impl.DatabasePageManagerCache")) : class$org$apache$jetspeed$page$impl$DatabasePageManagerCache;
                        synchronized (clazz) {
                            if (oid != null) {
                                NodeImpl node = (NodeImpl)DatabasePageManagerCache.cacheLookup(oid);
                                if (node instanceof FolderImpl) {
                                    ((FolderImpl)node).resetAll(false);
                                }
                                pageManager.notifyUpdatedNode(node);
                                oidCache.removeQuiet((Object)oid);
                            }
                            if (path != null) {
                                int pathLastSeparatorIndex = path.lastIndexOf("/");
                                String parentPath = pathLastSeparatorIndex > 0 ? path.substring(0, pathLastSeparatorIndex) : "/";
                                NodeImpl parentNode = DatabasePageManagerCache.cacheLookup(parentPath);
                                if (parentNode instanceof FolderImpl) {
                                    ((FolderImpl)parentNode).resetAll(false);
                                }
                                pathCache.removeQuiet((Object)path);
                            }
                        }
                    }
                }
            }
        }, false);
    }

    public static synchronized void setPageManagerProxy(PageManager proxy) {
        if (pageManager != proxy) {
            pageManager = proxy;
            DatabasePageManagerCache.cacheClear();
        }
    }

    public static synchronized NodeImpl cacheLookup(String path) {
        CacheElement pathElement;
        if (path != null && (pathElement = pathCache.get((Object)path)) != null) {
            DatabasePageManagerCacheObject cacheObject = (DatabasePageManagerCacheObject)pathElement.getContent();
            return (NodeImpl)DatabasePageManagerCache.cacheLookup(cacheObject.getId());
        }
        return null;
    }

    public static synchronized void addUpdatePath(String path) {
        updatePathsList.add(path);
    }

    public static synchronized void cacheAdd(Identity oid, Object obj) {
        if (obj instanceof NodeImpl) {
            NodeImpl node = (NodeImpl)obj;
            String nodePath = node.getPath();
            oidCache.remove((Object)oid);
            CacheElement element = oidCache.createElement((Object)oid, (Object)node);
            oidCache.put(element);
            boolean removed = pathCache.remove((Object)nodePath);
            CacheElement pathElement = pathCache.createElement((Object)nodePath, (Object)new DatabasePageManagerCacheObject(oid, nodePath));
            pathCache.put(pathElement);
            if (!removed && updatePathsList.contains(nodePath)) {
                pathCache.remove((Object)nodePath);
                pathCache.put(pathElement);
            }
        }
    }

    public static synchronized void removeUpdatePath(String path) {
        updatePathsList.remove(path);
    }

    public static synchronized void cacheClear() {
        Iterator removeOidIter = oidCache.getKeys().iterator();
        while (removeOidIter.hasNext()) {
            oidCache.remove((Object)((Identity)removeOidIter.next()));
        }
        Iterator removePathIter = pathCache.getKeys().iterator();
        while (removePathIter.hasNext()) {
            pathCache.removeQuiet(removePathIter.next());
        }
    }

    public static synchronized Object cacheLookup(Identity oid) {
        CacheElement element;
        if (oid != null && (element = oidCache.get((Object)oid)) != null) {
            return element.getContent();
        }
        return null;
    }

    public static synchronized void cacheRemove(Identity oid) {
        NodeImpl node;
        if (oid != null && (node = (NodeImpl)DatabasePageManagerCache.cacheLookup(oid)) != null) {
            String nodePath = node.getPath();
            oidCache.remove((Object)oid);
            boolean removed = pathCache.remove((Object)nodePath);
            if (!removed) {
                CacheElement pathElement = pathCache.createElement((Object)nodePath, (Object)new DatabasePageManagerCacheObject(oid, nodePath));
                pathCache.put(pathElement);
                pathCache.remove((Object)nodePath);
            }
        }
    }

    public static synchronized void cacheRemove(String path) {
        if (path != null) {
            CacheElement pathElement = pathCache.get((Object)path);
            if (pathElement != null) {
                DatabasePageManagerCacheObject cacheObject = (DatabasePageManagerCacheObject)pathElement.getContent();
                oidCache.remove((Object)cacheObject.getId());
                pathCache.remove((Object)path);
            } else {
                pathElement = pathCache.createElement((Object)path, (Object)new DatabasePageManagerCacheObject(path));
                pathCache.put(pathElement);
                pathCache.remove((Object)path);
            }
        }
    }

    public static synchronized void resetCachedSecurityConstraints() {
        Iterator resetIter = oidCache.getKeys().iterator();
        while (resetIter.hasNext()) {
            NodeImpl node = (NodeImpl)DatabasePageManagerCache.cacheLookup((Identity)resetIter.next());
            if (node == null) continue;
            node.resetCachedSecurityConstraints();
        }
    }

    public static List getTransactions() {
        LinkedList operations = (LinkedList)transactionedOperations.get();
        if (operations == null) {
            operations = new LinkedList();
            transactionedOperations.set(operations);
        }
        return operations;
    }

    public static void addTransaction(TransactionedOperation operation) {
        List transactions = DatabasePageManagerCache.getTransactions();
        transactions.add(operation);
    }

    public static synchronized void rollbackTransactions() {
        Iterator transactions = DatabasePageManagerCache.getTransactions().iterator();
        while (transactions.hasNext()) {
            TransactionedOperation operation = (TransactionedOperation)transactions.next();
            DatabasePageManagerCache.cacheRemove(operation.getPath());
        }
    }

    public static void clearTransactions() {
        transactionedOperations.set(null);
    }

    public static boolean isDistributed() {
        return pathCache.isDistributed();
    }

    public DatabasePageManagerCache(PersistenceBroker broker, Properties props) {
    }

    public void cache(Identity oid, Object obj) {
        DatabasePageManagerCache.cacheAdd(oid, obj);
    }

    public void clear() {
        DatabasePageManagerCache.cacheClear();
    }

    public Object lookup(Identity oid) {
        return DatabasePageManagerCache.cacheLookup(oid);
    }

    public void remove(Identity oid) {
        DatabasePageManagerCache.cacheRemove(oid);
    }

    public static synchronized void dump() {
        System.out.println("--------------------------");
        Iterator dumpIter = oidCache.getKeys().iterator();
        while (dumpIter.hasNext()) {
            Identity oid = (Identity)dumpIter.next();
            NodeImpl node = (NodeImpl)DatabasePageManagerCache.cacheLookup(oid);
            System.out.println("node=" + node.getPath() + ", oid=" + oid);
        }
        System.out.println("--------------------------");
    }

    static {
        updatePathsList = new ArrayList();
        transactionedOperations = new ThreadLocal();
    }
}

