/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.MenuExcludeDefinition;
import org.apache.jetspeed.om.folder.MenuIncludeDefinition;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.folder.MenuSeparatorDefinition;
import org.apache.jetspeed.om.folder.impl.FolderImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuExcludeDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuIncludeDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuOptionsDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuSeparatorDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderSecurityConstraintImpl;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.ContentPageImpl;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.page.impl.FragmentImpl;
import org.apache.jetspeed.om.page.impl.FragmentPreferenceImpl;
import org.apache.jetspeed.om.page.impl.FragmentSecurityConstraintImpl;
import org.apache.jetspeed.om.page.impl.LinkImpl;
import org.apache.jetspeed.om.page.impl.LinkSecurityConstraintImpl;
import org.apache.jetspeed.om.page.impl.PageImpl;
import org.apache.jetspeed.om.page.impl.PageMenuDefinitionImpl;
import org.apache.jetspeed.om.page.impl.PageMenuExcludeDefinitionImpl;
import org.apache.jetspeed.om.page.impl.PageMenuIncludeDefinitionImpl;
import org.apache.jetspeed.om.page.impl.PageMenuOptionsDefinitionImpl;
import org.apache.jetspeed.om.page.impl.PageMenuSeparatorDefinitionImpl;
import org.apache.jetspeed.om.page.impl.PageSecurityConstraintImpl;
import org.apache.jetspeed.om.page.impl.PageSecurityImpl;
import org.apache.jetspeed.om.page.impl.PageSecuritySecurityConstraintImpl;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsDefImpl;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsImpl;
import org.apache.jetspeed.om.preference.FragmentPreference;
import org.apache.jetspeed.page.DelegatingPageManager;
import org.apache.jetspeed.page.FolderNotRemovedException;
import org.apache.jetspeed.page.FolderNotUpdatedException;
import org.apache.jetspeed.page.LinkNotRemovedException;
import org.apache.jetspeed.page.LinkNotUpdatedException;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageManagerEventListener;
import org.apache.jetspeed.page.PageManagerSecurityUtils;
import org.apache.jetspeed.page.PageManagerUtils;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.PageNotRemovedException;
import org.apache.jetspeed.page.PageNotUpdatedException;
import org.apache.jetspeed.page.document.DocumentException;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.FailedToDeleteDocumentException;
import org.apache.jetspeed.page.document.FailedToUpdateDocumentException;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.impl.NodeImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerCache;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;
import org.apache.jetspeed.page.impl.TransactionedOperation;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;

public class DatabasePageManager
extends InitablePersistenceBrokerDaoSupport
implements PageManager {
    private static Map modelClasses = new HashMap();
    private DelegatingPageManager delegator;
    private PageManager pageManagerProxy;

    public DatabasePageManager(String repositoryPath, IdGenerator generator, boolean isPermissionsSecurity, boolean isConstraintsSecurity, JetspeedCache oidCache, JetspeedCache pathCache) {
        super(repositoryPath);
        this.delegator = new DelegatingPageManager(generator, isPermissionsSecurity, isConstraintsSecurity, modelClasses);
        DatabasePageManagerCache.cacheInit(oidCache, pathCache, this);
    }

    public PageManager getPageManagerProxy() {
        return this.pageManagerProxy;
    }

    public void setPageManagerProxy(PageManager proxy) {
        if (this.pageManagerProxy != proxy) {
            this.pageManagerProxy = proxy;
            DatabasePageManagerCache.setPageManagerProxy(proxy);
        }
    }

    public boolean getConstraintsEnabled() {
        return this.delegator.getConstraintsEnabled();
    }

    public boolean getPermissionsEnabled() {
        return this.delegator.getPermissionsEnabled();
    }

    public long getNodeReapingInterval() {
        return this.delegator.getNodeReapingInterval();
    }

    public Page newPage(String path) {
        return this.delegator.newPage(path);
    }

    public Folder newFolder(String path) {
        return this.delegator.newFolder(path);
    }

    public Link newLink(String path) {
        return this.delegator.newLink(path);
    }

    public PageSecurity newPageSecurity() {
        return this.delegator.newPageSecurity();
    }

    public Fragment newFragment() {
        return this.delegator.newFragment();
    }

    public Fragment newPortletFragment() {
        return this.delegator.newPortletFragment();
    }

    public MenuDefinition newFolderMenuDefinition() {
        return this.delegator.newFolderMenuDefinition();
    }

    public MenuExcludeDefinition newFolderMenuExcludeDefinition() {
        return this.delegator.newFolderMenuExcludeDefinition();
    }

    public MenuIncludeDefinition newFolderMenuIncludeDefinition() {
        return this.delegator.newFolderMenuIncludeDefinition();
    }

    public MenuOptionsDefinition newFolderMenuOptionsDefinition() {
        return this.delegator.newFolderMenuOptionsDefinition();
    }

    public MenuSeparatorDefinition newFolderMenuSeparatorDefinition() {
        return this.delegator.newFolderMenuSeparatorDefinition();
    }

    public MenuDefinition newPageMenuDefinition() {
        return this.delegator.newPageMenuDefinition();
    }

    public MenuExcludeDefinition newPageMenuExcludeDefinition() {
        return this.delegator.newPageMenuExcludeDefinition();
    }

    public MenuIncludeDefinition newPageMenuIncludeDefinition() {
        return this.delegator.newPageMenuIncludeDefinition();
    }

    public MenuOptionsDefinition newPageMenuOptionsDefinition() {
        return this.delegator.newPageMenuOptionsDefinition();
    }

    public MenuSeparatorDefinition newPageMenuSeparatorDefinition() {
        return this.delegator.newPageMenuSeparatorDefinition();
    }

    public SecurityConstraints newSecurityConstraints() {
        return this.delegator.newSecurityConstraints();
    }

    public SecurityConstraint newFolderSecurityConstraint() {
        return this.delegator.newFolderSecurityConstraint();
    }

    public SecurityConstraint newPageSecurityConstraint() {
        return this.delegator.newPageSecurityConstraint();
    }

    public SecurityConstraint newFragmentSecurityConstraint() {
        return this.delegator.newFragmentSecurityConstraint();
    }

    public SecurityConstraint newLinkSecurityConstraint() {
        return this.delegator.newLinkSecurityConstraint();
    }

    public SecurityConstraint newPageSecuritySecurityConstraint() {
        return this.delegator.newPageSecuritySecurityConstraint();
    }

    public SecurityConstraintsDef newSecurityConstraintsDef() {
        return this.delegator.newSecurityConstraintsDef();
    }

    public FragmentPreference newFragmentPreference() {
        return this.delegator.newFragmentPreference();
    }

    public void addListener(PageManagerEventListener listener) {
        this.delegator.addListener(listener);
    }

    public void removeListener(PageManagerEventListener listener) {
        this.delegator.removeListener(listener);
    }

    public void reset() {
        this.delegator.reset();
        DatabasePageManagerCache.cacheClear();
    }

    public void shutdown() {
        this.delegator.shutdown();
    }

    public Page getPage(String path) throws PageNotFoundException, NodeException {
        NodeImpl cachedNode = DatabasePageManagerCache.cacheLookup(path = NodeImpl.getCanonicalNodePath(path));
        if (cachedNode instanceof Page) {
            cachedNode.checkAccess(JetspeedActions.VIEW);
            return (Page)cachedNode;
        }
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("path", (Object)path);
            QueryByCriteria query = QueryFactory.newQuery((Class)PageImpl.class, (Criteria)filter);
            Page page = (Page)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (page == null) {
                throw new PageNotFoundException("Page " + path + " not found.");
            }
            page.checkAccess(JetspeedActions.VIEW);
            return page;
        }
        catch (PageNotFoundException pnfe) {
            throw pnfe;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new PageNotFoundException("Page " + path + " not found.", (Throwable)e);
        }
    }

    public ContentPage getContentPage(String path) throws PageNotFoundException, NodeException {
        return new ContentPageImpl(this.getPage(path));
    }

    public Link getLink(String path) throws DocumentNotFoundException, NodeException {
        NodeImpl cachedNode = DatabasePageManagerCache.cacheLookup(path = NodeImpl.getCanonicalNodePath(path));
        if (cachedNode instanceof Link) {
            cachedNode.checkAccess(JetspeedActions.VIEW);
            return (Link)cachedNode;
        }
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("path", (Object)path);
            QueryByCriteria query = QueryFactory.newQuery((Class)LinkImpl.class, (Criteria)filter);
            Link link = (Link)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (link == null) {
                throw new DocumentNotFoundException("Link " + path + " not found.");
            }
            link.checkAccess(JetspeedActions.VIEW);
            return link;
        }
        catch (DocumentNotFoundException dnfe) {
            throw dnfe;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new DocumentNotFoundException("Link " + path + " not found.", (Throwable)e);
        }
    }

    public boolean checkConstraint(String securityConstraintName, String actions) {
        try {
            PageSecurity security = this.getPageSecurity();
            SecurityConstraintsDef def = security.getSecurityConstraintsDef(securityConstraintName);
            if (def != null) {
                return PageManagerSecurityUtils.checkConstraint(def, actions);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public PageSecurity getPageSecurity() throws DocumentNotFoundException, NodeException {
        String path = "/page.security";
        NodeImpl cachedNode = DatabasePageManagerCache.cacheLookup(path);
        if (cachedNode instanceof PageSecurity) {
            cachedNode.checkAccess(JetspeedActions.VIEW);
            return (PageSecurity)cachedNode;
        }
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("path", (Object)path);
            QueryByCriteria query = QueryFactory.newQuery((Class)PageSecurityImpl.class, (Criteria)filter);
            PageSecurity document = (PageSecurity)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (document == null) {
                throw new DocumentNotFoundException("Document " + path + " not found.");
            }
            document.checkAccess(JetspeedActions.VIEW);
            return document;
        }
        catch (DocumentNotFoundException dnfe) {
            throw dnfe;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new DocumentNotFoundException("Document " + path + " not found.", (Throwable)e);
        }
    }

    public Folder getFolder(String folderPath) throws FolderNotFoundException, InvalidFolderException, NodeException {
        NodeImpl cachedNode = DatabasePageManagerCache.cacheLookup(folderPath = NodeImpl.getCanonicalNodePath(folderPath));
        if (cachedNode instanceof Folder) {
            cachedNode.checkAccess(JetspeedActions.VIEW);
            return (Folder)cachedNode;
        }
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("path", (Object)folderPath);
            QueryByCriteria query = QueryFactory.newQuery((Class)FolderImpl.class, (Criteria)filter);
            Folder folder = (Folder)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (folder == null) {
                throw new FolderNotFoundException("Folder " + folderPath + " not found.");
            }
            folder.checkAccess(JetspeedActions.VIEW);
            return folder;
        }
        catch (FolderNotFoundException fnfe) {
            throw fnfe;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FolderNotFoundException("Folder " + folderPath + " not found.", (Throwable)e);
        }
    }

    public NodeSet getFolders(Folder folder) throws DocumentException {
        FolderImpl folderImpl = (FolderImpl)folder;
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery((Class)FolderImpl.class, (Criteria)filter);
            Collection folders = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            folderImpl.accessFolders().clear();
            if (folders != null) {
                folderImpl.accessFolders().addAll(folders);
            }
            folderImpl.resetFolders(true);
        }
        catch (Exception e) {
            folderImpl.resetFolders(false);
            throw new DocumentException("Unable to access folders for folder " + folder.getPath() + ".");
        }
        return folder.getFolders();
    }

    public Folder getFolder(Folder folder, String name) throws FolderNotFoundException, DocumentException {
        String folderPath = folder.getPath() + "/" + name;
        try {
            return this.getFolder(folderPath);
        }
        catch (FolderNotFoundException fnfe) {
            throw fnfe;
        }
        catch (Exception e) {
            throw new FolderNotFoundException("Folder " + folderPath + " not found.", (Throwable)e);
        }
    }

    public NodeSet getPages(Folder folder) throws NodeException {
        FolderImpl folderImpl = (FolderImpl)folder;
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery((Class)PageImpl.class, (Criteria)filter);
            Collection pages = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            folderImpl.accessPages().clear();
            if (pages != null) {
                folderImpl.accessPages().addAll(pages);
            }
            folderImpl.resetPages(true);
        }
        catch (Exception e) {
            folderImpl.resetPages(false);
            throw new NodeException("Unable to access pages for folder " + folder.getPath() + ".");
        }
        return folder.getPages();
    }

    public Page getPage(Folder folder, String name) throws PageNotFoundException, NodeException {
        String pagePath = folder.getPath() + "/" + name;
        try {
            return this.getPage(pagePath);
        }
        catch (PageNotFoundException pnfe) {
            throw pnfe;
        }
        catch (Exception e) {
            throw new PageNotFoundException("Page " + pagePath + " not found.", (Throwable)e);
        }
    }

    public NodeSet getLinks(Folder folder) throws NodeException {
        FolderImpl folderImpl = (FolderImpl)folder;
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery((Class)LinkImpl.class, (Criteria)filter);
            Collection links = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            folderImpl.accessLinks().clear();
            if (links != null) {
                folderImpl.accessLinks().addAll(links);
            }
            folderImpl.resetLinks(true);
        }
        catch (Exception e) {
            folderImpl.resetLinks(false);
            throw new NodeException("Unable to access links for folder " + folder.getPath() + ".");
        }
        return folder.getLinks();
    }

    public Link getLink(Folder folder, String name) throws DocumentNotFoundException, NodeException {
        String linkPath = folder.getPath() + "/" + name;
        try {
            return this.getLink(linkPath);
        }
        catch (DocumentNotFoundException dnfe) {
            throw dnfe;
        }
        catch (Exception e) {
            throw new DocumentNotFoundException("Link " + linkPath + " not found.", (Throwable)e);
        }
    }

    public PageSecurity getPageSecurity(Folder folder) throws DocumentNotFoundException, NodeException {
        FolderImpl folderImpl = (FolderImpl)folder;
        if (folder.getPath().equals("/")) {
            try {
                Criteria filter = new Criteria();
                filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
                QueryByCriteria query = QueryFactory.newQuery((Class)PageSecurityImpl.class, (Criteria)filter);
                PageSecurity document = (PageSecurity)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
                folderImpl.resetPageSecurity((PageSecurityImpl)document, true);
            }
            catch (Exception e) {
                folderImpl.resetPageSecurity(null, true);
                throw new NodeException("Unable to access page security for folder " + folder.getPath() + ".");
            }
        } else {
            folderImpl.resetPageSecurity(null, true);
        }
        return folder.getPageSecurity();
    }

    public NodeSet getAll(Folder folder) throws DocumentException {
        FolderImpl folderImpl = (FolderImpl)folder;
        try {
            List all = DatabasePageManagerUtils.createList();
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery((Class)FolderImpl.class, (Criteria)filter);
            Collection folders = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (folders != null) {
                all.addAll(folders);
            }
            query = QueryFactory.newQuery((Class)PageImpl.class, (Criteria)filter);
            Collection pages = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (pages != null) {
                all.addAll(pages);
            }
            query = QueryFactory.newQuery((Class)LinkImpl.class, (Criteria)filter);
            Collection links = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (links != null) {
                all.addAll(links);
            }
            query = QueryFactory.newQuery((Class)PageSecurityImpl.class, (Criteria)filter);
            PageSecurity document = (PageSecurity)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (document != null) {
                all.add(document);
            }
            folderImpl.accessAll().clear();
            folderImpl.accessAll().addAll(all);
            folderImpl.resetAll(true);
        }
        catch (Exception e) {
            folderImpl.resetAll(false);
            throw new DocumentException("Unable to access all nodes for folder " + folder.getPath() + ".");
        }
        return folder.getAll();
    }

    public void updatePage(Page page) throws NodeException, PageNotUpdatedException {
        block11: {
            try {
                FolderImpl parent;
                if (page instanceof ContentPageImpl) {
                    page = ((ContentPageImpl)page).getPage();
                }
                if ((parent = (FolderImpl)(page = (Page)ProxyHelper.getRealObject((Object)page)).getParent()) == null) {
                    String pagePath = page.getPath();
                    String parentPath = pagePath.substring(0, pagePath.lastIndexOf("/"));
                    if (parentPath.length() == 0) {
                        parentPath = "/";
                    }
                    try {
                        parent = (FolderImpl)this.getFolder(parentPath);
                    }
                    catch (FolderNotFoundException fnfe) {
                        throw new PageNotUpdatedException("Missing parent folder: " + parentPath);
                    }
                    parent.checkAccess(JetspeedActions.EDIT);
                    page.setParent((Node)parent);
                    this.storeEntity(page, pagePath, true);
                    if (parent != null) {
                        parent.resetPages(false);
                    }
                    this.delegator.notifyNewNode((Node)page);
                    break block11;
                }
                page.checkAccess(JetspeedActions.EDIT);
                this.storeEntity(page, page.getPath(), false);
                if (parent != null) {
                    parent.resetPages(false);
                }
                this.delegator.notifyUpdatedNode((Node)page);
            }
            catch (PageNotUpdatedException pnue) {
                throw pnue;
            }
            catch (SecurityException se) {
                throw se;
            }
            catch (Exception e) {
                throw new PageNotUpdatedException("Page " + page.getPath() + " not updated.", (Throwable)e);
            }
        }
    }

    public void removePage(Page page) throws NodeException, PageNotRemovedException {
        try {
            if (page instanceof ContentPageImpl) {
                page = ((ContentPageImpl)page).getPage();
            }
            page = (Page)ProxyHelper.getRealObject((Object)page);
            page.checkAccess(JetspeedActions.EDIT);
            if (page.getParent() != null) {
                FolderImpl parent = (FolderImpl)ProxyHelper.getRealObject((Object)page.getParent());
                this.getPersistenceBrokerTemplate().delete((Object)page);
                if (parent != null) {
                    parent.resetPages(false);
                }
            } else {
                this.getPersistenceBrokerTemplate().delete((Object)page);
            }
            this.delegator.notifyRemovedNode((Node)page);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new PageNotRemovedException("Page " + page.getPath() + " not removed.", (Throwable)e);
        }
    }

    public void updateFolder(Folder folder) throws NodeException, FolderNotUpdatedException {
        this.updateFolder(folder, false);
    }

    public void updateFolder(Folder folder, boolean deep) throws NodeException, FolderNotUpdatedException {
        try {
            folder = (Folder)ProxyHelper.getRealObject((Object)folder);
            FolderImpl folderImpl = (FolderImpl)folder;
            FolderImpl parent = (FolderImpl)folder.getParent();
            if (parent == null && !folder.getPath().equals("/")) {
                String folderPath = folder.getPath();
                String parentPath = folderPath.substring(0, folderPath.lastIndexOf("/"));
                if (parentPath.length() == 0) {
                    parentPath = "/";
                }
                try {
                    parent = (FolderImpl)this.getFolder(parentPath);
                }
                catch (FolderNotFoundException fnfe) {
                    throw new FolderNotUpdatedException("Missing parent folder: " + parentPath);
                }
                parent.checkAccess(JetspeedActions.EDIT);
                folder.setParent((Node)parent);
                this.storeEntity(folder, folderPath, true);
                if (parent != null) {
                    parent.resetFolders(false);
                }
                this.delegator.notifyNewNode((Node)folder);
            } else {
                boolean newFolder = folderImpl.getIdentity() == 0;
                String folderPath = folder.getPath();
                if (!newFolder || !folderPath.equals("/")) {
                    folder.checkAccess(JetspeedActions.EDIT);
                }
                this.storeEntity(folder, folderPath);
                if (newFolder && folderImpl.getIdentity() != 0) {
                    DatabasePageManagerCache.addTransaction(new TransactionedOperation(folderPath, 0));
                } else {
                    DatabasePageManagerCache.addTransaction(new TransactionedOperation(folderPath, 1));
                }
                if (parent != null) {
                    parent.resetFolders(false);
                }
                if (newFolder && folderImpl.getIdentity() != 0) {
                    this.delegator.notifyNewNode((Node)folder);
                } else {
                    this.delegator.notifyUpdatedNode((Node)folder);
                }
            }
            if (deep) {
                this.updateFolderNodes(folderImpl);
            }
        }
        catch (FolderNotUpdatedException fnue) {
            throw fnue;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FolderNotUpdatedException("Folder " + folder.getPath() + " not updated.", (Throwable)e);
        }
    }

    private void updateFolderNodes(FolderImpl folderImpl) throws FolderNotUpdatedException {
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery((Class)PageImpl.class, (Criteria)filter);
            Collection pages = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (pages != null) {
                Iterator pagesIter = pages.iterator();
                while (pagesIter.hasNext()) {
                    this.updatePage((Page)pagesIter.next());
                }
            }
            query = QueryFactory.newQuery((Class)LinkImpl.class, (Criteria)filter);
            Collection links = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (links != null) {
                Iterator linksIter = links.iterator();
                while (linksIter.hasNext()) {
                    this.updateLink((Link)linksIter.next());
                }
            }
            query = QueryFactory.newQuery((Class)PageSecurityImpl.class, (Criteria)filter);
            PageSecurity document = (PageSecurity)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (document != null) {
                this.updatePageSecurity(document);
            }
            query = QueryFactory.newQuery((Class)FolderImpl.class, (Criteria)filter);
            Collection folders = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (folders != null) {
                Iterator foldersIter = folders.iterator();
                while (foldersIter.hasNext()) {
                    this.updateFolder((Folder)foldersIter.next(), true);
                }
            }
        }
        catch (FolderNotUpdatedException fnue) {
            throw fnue;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FolderNotUpdatedException("Folder " + folderImpl.getPath() + " not updated.", (Throwable)e);
        }
    }

    public void removeFolder(Folder folder) throws NodeException, FolderNotRemovedException {
        try {
            folder = (Folder)ProxyHelper.getRealObject((Object)folder);
            folder.checkAccess(JetspeedActions.EDIT);
            ((FolderImpl)folder).resetAll(false);
            this.removeFolderNodes((FolderImpl)folder);
            if (folder.getParent() != null) {
                FolderImpl parent = (FolderImpl)ProxyHelper.getRealObject((Object)folder.getParent());
                this.getPersistenceBrokerTemplate().delete((Object)folder);
                if (parent != null) {
                    parent.resetFolders(false);
                }
            } else {
                this.getPersistenceBrokerTemplate().delete((Object)folder);
            }
            this.delegator.notifyRemovedNode((FolderImpl)folder);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FolderNotRemovedException("Folder " + folder.getPath() + " not removed.", (Throwable)e);
        }
    }

    private void removeFolderNodes(FolderImpl folderImpl) throws FolderNotRemovedException {
        try {
            Criteria filter = new Criteria();
            filter.addEqualTo("parent", (Object)new Integer(folderImpl.getIdentity()));
            QueryByCriteria query = QueryFactory.newQuery((Class)FolderImpl.class, (Criteria)filter);
            Collection folders = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (folders != null) {
                Iterator foldersIter = folders.iterator();
                while (foldersIter.hasNext()) {
                    this.removeFolder((Folder)foldersIter.next());
                }
            }
            query = QueryFactory.newQuery((Class)PageImpl.class, (Criteria)filter);
            Collection pages = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (pages != null) {
                Iterator pagesIter = pages.iterator();
                while (pagesIter.hasNext()) {
                    this.removePage((Page)pagesIter.next());
                }
            }
            query = QueryFactory.newQuery((Class)LinkImpl.class, (Criteria)filter);
            Collection links = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            if (links != null) {
                Iterator linksIter = links.iterator();
                while (linksIter.hasNext()) {
                    this.removeLink((Link)linksIter.next());
                }
            }
            query = QueryFactory.newQuery((Class)PageSecurityImpl.class, (Criteria)filter);
            PageSecurity document = (PageSecurity)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
            if (document != null) {
                this.removePageSecurity(document);
            }
        }
        catch (FolderNotRemovedException fnre) {
            throw fnre;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FolderNotRemovedException("Folder " + folderImpl.getPath() + " not removed.", (Throwable)e);
        }
    }

    public void updateLink(Link link) throws NodeException, LinkNotUpdatedException {
        block10: {
            try {
                link = (Link)ProxyHelper.getRealObject((Object)link);
                FolderImpl parent = (FolderImpl)link.getParent();
                if (parent == null) {
                    String linkPath = link.getPath();
                    String parentPath = linkPath.substring(0, linkPath.lastIndexOf("/"));
                    if (parentPath.length() == 0) {
                        parentPath = "/";
                    }
                    try {
                        parent = (FolderImpl)this.getFolder(parentPath);
                    }
                    catch (FolderNotFoundException fnfe) {
                        throw new FailedToUpdateDocumentException("Missing parent folder: " + parentPath);
                    }
                    parent.checkAccess(JetspeedActions.EDIT);
                    link.setParent((Node)parent);
                    this.storeEntity(link, linkPath, true);
                    if (parent != null) {
                        parent.resetLinks(false);
                    }
                    this.delegator.notifyNewNode((Node)link);
                    break block10;
                }
                link.checkAccess(JetspeedActions.EDIT);
                this.storeEntity(link, link.getPath(), false);
                if (parent != null) {
                    parent.resetLinks(false);
                }
                this.delegator.notifyUpdatedNode((Node)link);
            }
            catch (FailedToUpdateDocumentException fude) {
                throw fude;
            }
            catch (SecurityException se) {
                throw se;
            }
            catch (Exception e) {
                throw new FailedToUpdateDocumentException("Link " + link.getPath() + " not updated.", (Throwable)e);
            }
        }
    }

    public void removeLink(Link link) throws NodeException, LinkNotRemovedException {
        try {
            link = (Link)ProxyHelper.getRealObject((Object)link);
            link.checkAccess(JetspeedActions.EDIT);
            if (link.getParent() != null) {
                FolderImpl parent = (FolderImpl)ProxyHelper.getRealObject((Object)link.getParent());
                this.getPersistenceBrokerTemplate().delete((Object)link);
                if (parent != null) {
                    parent.resetLinks(false);
                }
            } else {
                this.getPersistenceBrokerTemplate().delete((Object)link);
            }
            this.delegator.notifyRemovedNode((Node)link);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FailedToDeleteDocumentException("Link " + link.getPath() + " not removed.", (Throwable)e);
        }
    }

    public void updatePageSecurity(PageSecurity pageSecurity) throws NodeException, FailedToUpdateDocumentException {
        try {
            pageSecurity = (PageSecurity)ProxyHelper.getRealObject((Object)pageSecurity);
            FolderImpl parent = (FolderImpl)pageSecurity.getParent();
            if (parent == null) {
                String pageSecurityPath = pageSecurity.getPath();
                String parentPath = pageSecurityPath.substring(0, pageSecurityPath.lastIndexOf("/"));
                if (parentPath.length() == 0) {
                    parentPath = "/";
                }
                try {
                    parent = (FolderImpl)this.getFolder(parentPath);
                }
                catch (FolderNotFoundException fnfe) {
                    throw new FailedToUpdateDocumentException("Missing parent folder: " + parentPath);
                }
                try {
                    parent.getPageSecurity();
                    throw new FailedToUpdateDocumentException("Parent folder page security exists: " + parentPath);
                }
                catch (DocumentNotFoundException dnfe) {
                    parent.checkAccess(JetspeedActions.EDIT);
                    pageSecurity.setParent((Node)parent);
                    this.storeEntity(pageSecurity, pageSecurityPath, true);
                    if (parent != null) {
                        parent.resetPageSecurity((PageSecurityImpl)pageSecurity, true);
                    }
                }
                catch (Exception e) {
                    throw new FailedToUpdateDocumentException("Parent folder page security exists: " + parentPath);
                }
                this.delegator.notifyNewNode((Node)pageSecurity);
            } else {
                pageSecurity.checkAccess(JetspeedActions.EDIT);
                this.storeEntity(pageSecurity, pageSecurity.getPath(), false);
                if (parent != null) {
                    parent.resetPageSecurity((PageSecurityImpl)pageSecurity, true);
                }
                this.delegator.notifyUpdatedNode((Node)pageSecurity);
            }
            DatabasePageManagerCache.resetCachedSecurityConstraints();
        }
        catch (FailedToUpdateDocumentException fude) {
            throw fude;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FailedToUpdateDocumentException("Document " + pageSecurity.getPath() + " not updated.", (Throwable)e);
        }
    }

    public void removePageSecurity(PageSecurity pageSecurity) throws NodeException, FailedToDeleteDocumentException {
        try {
            pageSecurity = (PageSecurity)ProxyHelper.getRealObject((Object)pageSecurity);
            pageSecurity.checkAccess(JetspeedActions.EDIT);
            if (pageSecurity.getParent() != null) {
                FolderImpl parent = (FolderImpl)ProxyHelper.getRealObject((Object)pageSecurity.getParent());
                this.getPersistenceBrokerTemplate().delete((Object)pageSecurity);
                if (parent != null) {
                    parent.resetPageSecurity(null, true);
                }
            } else {
                this.getPersistenceBrokerTemplate().delete((Object)pageSecurity);
            }
            DatabasePageManagerCache.resetCachedSecurityConstraints();
            this.delegator.notifyRemovedNode((Node)pageSecurity);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FailedToDeleteDocumentException("Document " + pageSecurity.getPath() + " not removed.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeEntity(Object node, String path) {
        DatabasePageManagerCache.addUpdatePath(path);
        try {
            this.getPersistenceBrokerTemplate().store(node);
        }
        finally {
            DatabasePageManagerCache.removeUpdatePath(path);
        }
    }

    private void storeEntity(Object node, String path, boolean add) {
        this.storeEntity(node, path);
        DatabasePageManagerCache.addTransaction(new TransactionedOperation(path, add ? 0 : 1));
    }

    public Page copyPage(Page source, String path) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyPage(source, path);
    }

    public Page copyPage(Page source, String path, boolean copyIds) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyPage(source, path, copyIds);
    }

    public Link copyLink(Link source, String path) throws NodeException, LinkNotUpdatedException {
        return this.delegator.copyLink(source, path);
    }

    public Folder copyFolder(Folder source, String path) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyFolder(source, path);
    }

    public Fragment copyFragment(Fragment source, String name) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyFragment(source, name);
    }

    public Fragment copyFragment(Fragment source, String name, boolean copyIds) throws NodeException, PageNotUpdatedException {
        return this.delegator.copyFragment(source, name, copyIds);
    }

    public PageSecurity copyPageSecurity(PageSecurity source) throws NodeException {
        return this.delegator.copyPageSecurity(source);
    }

    public Page getUserPage(String userName, String pageName) throws PageNotFoundException, NodeException {
        return this.getPage("/_user/" + userName + "/" + pageName);
    }

    public Folder getUserFolder(String userName) throws FolderNotFoundException, InvalidFolderException, NodeException {
        return this.getFolder("/_user/" + userName);
    }

    public boolean folderExists(String folderName) {
        try {
            this.getFolder(folderName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean pageExists(String pageName) {
        try {
            this.getPage(pageName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean linkExists(String linkName) {
        try {
            this.getLink(linkName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean userFolderExists(String userName) {
        try {
            this.getFolder("/_user/" + userName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean userPageExists(String userName, String pageName) {
        try {
            this.getPage("/_user/" + userName + "/" + pageName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void createUserHomePagesFromRoles(Subject subject) throws NodeException {
        PageManagerUtils.createUserHomePagesFromRoles(this, subject);
    }

    public void deepCopyFolder(Folder srcFolder, String destinationPath, String owner) throws NodeException, PageNotUpdatedException {
        this.deepCopyFolder(srcFolder, destinationPath, owner, false);
    }

    public void deepCopyFolder(Folder srcFolder, String destinationPath, String owner, boolean copyIds) throws NodeException, PageNotUpdatedException {
        PageManagerUtils.deepCopyFolder(this, srcFolder, destinationPath, owner, copyIds);
    }

    public void deepMergeFolder(Folder srcFolder, String destinationPath, String owner) throws NodeException, PageNotUpdatedException {
        this.deepMergeFolder(srcFolder, destinationPath, owner, false);
    }

    public void deepMergeFolder(Folder srcFolder, String destinationPath, String owner, boolean copyIds) throws NodeException, PageNotUpdatedException {
        PageManagerUtils.deepMergeFolder((PageManager)this, srcFolder, destinationPath, owner, copyIds);
    }

    public int addPages(Page[] pages) throws NodeException {
        if (pages.length > 0 && pages[0].getPath().equals("/tx__test1.psml")) {
            System.out.println("Adding first page");
            this.updatePage(pages[0]);
            System.out.println("Adding second page");
            this.updatePage(pages[1]);
            System.out.println("About to throw ex");
            throw new NodeException("Its gonna blow captain!");
        }
        for (int ix = 0; ix < pages.length; ++ix) {
            this.updatePage(pages[ix]);
        }
        return pages.length;
    }

    public boolean isDistributed() {
        return DatabasePageManagerCache.isDistributed();
    }

    public void notifyUpdatedNode(Node node) {
        this.delegator.notifyUpdatedNode(node);
    }

    static {
        modelClasses.put("FragmentImpl", FragmentImpl.class);
        modelClasses.put("PageImpl", PageImpl.class);
        modelClasses.put("FolderImpl", FolderImpl.class);
        modelClasses.put("LinkImpl", LinkImpl.class);
        modelClasses.put("PageSecurityImpl", PageSecurityImpl.class);
        modelClasses.put("FolderMenuDefinitionImpl", FolderMenuDefinitionImpl.class);
        modelClasses.put("FolderMenuExcludeDefinitionImpl", FolderMenuExcludeDefinitionImpl.class);
        modelClasses.put("FolderMenuIncludeDefinitionImpl", FolderMenuIncludeDefinitionImpl.class);
        modelClasses.put("FolderMenuOptionsDefinitionImpl", FolderMenuOptionsDefinitionImpl.class);
        modelClasses.put("FolderMenuSeparatorDefinitionImpl", FolderMenuSeparatorDefinitionImpl.class);
        modelClasses.put("PageMenuDefinitionImpl", PageMenuDefinitionImpl.class);
        modelClasses.put("PageMenuExcludeDefinitionImpl", PageMenuExcludeDefinitionImpl.class);
        modelClasses.put("PageMenuIncludeDefinitionImpl", PageMenuIncludeDefinitionImpl.class);
        modelClasses.put("PageMenuOptionsDefinitionImpl", PageMenuOptionsDefinitionImpl.class);
        modelClasses.put("PageMenuSeparatorDefinitionImpl", PageMenuSeparatorDefinitionImpl.class);
        modelClasses.put("SecurityConstraintsImpl", SecurityConstraintsImpl.class);
        modelClasses.put("FolderSecurityConstraintImpl", FolderSecurityConstraintImpl.class);
        modelClasses.put("PageSecurityConstraintImpl", PageSecurityConstraintImpl.class);
        modelClasses.put("FragmentSecurityConstraintImpl", FragmentSecurityConstraintImpl.class);
        modelClasses.put("LinkSecurityConstraintImpl", LinkSecurityConstraintImpl.class);
        modelClasses.put("PageSecuritySecurityConstraintImpl", PageSecuritySecurityConstraintImpl.class);
        modelClasses.put("SecurityConstraintsDefImpl", SecurityConstraintsDefImpl.class);
        modelClasses.put("FragmentPreferenceImpl", FragmentPreferenceImpl.class);
    }
}

