/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.document.psml;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeSet;

public class NodeSetImpl
implements NodeSet {
    private Map nodes;
    private Map subsets;
    private String resolveToPath;
    private Comparator comparator;
    protected static final Map patternCache = new HashMap();

    public NodeSetImpl(String resolveToPath) {
        this.resolveToPath = resolveToPath;
        this.nodes = new TreeMap();
        this.subsets = new HashMap();
    }

    public NodeSetImpl(String resolveToPath, Comparator comparator) {
        this.resolveToPath = resolveToPath;
        this.nodes = new TreeMap(comparator);
        this.comparator = comparator;
        this.subsets = new HashMap();
    }

    public Node get(String name) {
        if (this.nodes.containsKey(name)) {
            return (Node)this.nodes.get(name);
        }
        if (this.resolveToPath != null) {
            if (this.resolveToPath.endsWith("/")) {
                return (Node)this.nodes.get(this.resolveToPath + name);
            }
            return (Node)this.nodes.get(this.resolveToPath + "/" + name);
        }
        return null;
    }

    public void add(Node node) {
        String path = node.getPath();
        this.nodes.put(path, node);
        if (this.subsets.containsKey(node.getType())) {
            ((NodeSet)this.subsets.get(node.getType())).add(node);
        }
    }

    public int size() {
        return this.nodes.size();
    }

    public Iterator iterator() {
        return this.nodes.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeSet subset(String type) {
        NodeSet subset = (NodeSet)this.subsets.get(type);
        if (subset == null) {
            subset = new NodeSetImpl(this.resolveToPath, this.comparator);
            Iterator nodeItr = this.nodes.values().iterator();
            while (nodeItr.hasNext()) {
                Node node = (Node)nodeItr.next();
                if (!node.getType().equals(type)) continue;
                subset.add(node);
            }
            Map map = this.subsets;
            synchronized (map) {
                this.subsets.put(type, subset);
            }
        }
        return subset;
    }

    public NodeSet exclusiveSubset(String regex) {
        Iterator allNodes = this.nodes.entrySet().iterator();
        NodeSetImpl subset = new NodeSetImpl(this.resolveToPath, this.comparator);
        Pattern pattern = this.getPattern(regex);
        while (allNodes.hasNext()) {
            Map.Entry entry = allNodes.next();
            Node node = (Node)entry.getValue();
            String key = (String)entry.getKey();
            if (this.matches(pattern, key) || this.matches(pattern, node.getName())) continue;
            subset.add(node);
        }
        return subset;
    }

    public NodeSet inclusiveSubset(String regex) {
        Iterator allNodes = this.nodes.entrySet().iterator();
        NodeSetImpl subset = new NodeSetImpl(this.resolveToPath, this.comparator);
        Pattern pattern = this.getPattern(regex);
        while (allNodes.hasNext()) {
            Map.Entry entry = allNodes.next();
            String key = (String)entry.getKey();
            Node node = (Node)entry.getValue();
            if (!this.matches(pattern, key) && !this.matches(pattern, node.getName())) continue;
            subset.add(node);
        }
        return subset;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    protected final boolean matches(Pattern pattern, String value) {
        return pattern.matcher(value).matches();
    }

    protected final Pattern getPattern(String regex) {
        if (patternCache.containsKey(regex)) {
            return (Pattern)patternCache.get(regex);
        }
        Pattern pattern = Pattern.compile(regex);
        patternCache.put(regex, pattern);
        return pattern;
    }

    public boolean contains(Node node) {
        return this.nodes.values().contains(node);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public Node remove(Node node) {
        String path = node.getPath();
        if (this.nodes.get(path) == node) {
            this.nodes.remove(path);
            if (this.subsets.containsKey(node.getType())) {
                ((NodeSetImpl)this.subsets.get(node.getType())).remove(node);
            }
        }
        return null;
    }
}

