/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.document.psml;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.common.GenericMetadata;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.page.PageMetadataImpl;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.psml.AbstractBaseElement;
import org.apache.jetspeed.om.page.psml.SecurityConstraintsImpl;
import org.apache.jetspeed.page.document.Node;

public abstract class AbstractNode
extends AbstractBaseElement
implements Node {
    private PageMetadataImpl metadata;
    private Node parent;
    private String path;
    private String url;
    private boolean hidden = false;
    private String profiledPath;
    private boolean dirty = false;

    public GenericMetadata getMetadata() {
        return this.getPageMetadata();
    }

    public void setMetadata(GenericMetadata metadata) {
        this.getPageMetadata().setFields(metadata.getFields());
    }

    public Collection getMetadataFields() {
        return this.getPageMetadata().getFields();
    }

    public void setMetadataFields(Collection metadataFields) {
        this.getPageMetadata().setFields(metadataFields);
    }

    private PageMetadataImpl getPageMetadata() {
        if (this.metadata == null) {
            this.metadata = new PageMetadataImpl();
        }
        return this.metadata;
    }

    public String getTitle(Locale locale) {
        String title = this.getPageMetadata().getText("title", locale);
        if (title == null) {
            title = this.getTitle();
        }
        return title;
    }

    public String getShortTitle(Locale locale) {
        String shortTitle = this.getPageMetadata().getText("short-title", locale);
        if (shortTitle == null && (shortTitle = this.getPageMetadata().getText("title", locale)) == null && (shortTitle = this.getShortTitle()) == null) {
            shortTitle = this.getTitle();
        }
        return shortTitle;
    }

    public Node getParent(boolean checkAccess) {
        AbstractNode parent = (AbstractNode)this.parent;
        if (parent != null && checkAccess) {
            parent.checkAccess(JetspeedActions.VIEW);
        }
        return parent;
    }

    public Node getParent() {
        return this.getParent(false);
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public String getName() {
        String name = this.getPath();
        if (name != null && !name.equals("/")) {
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        return name;
    }

    public String getTitleName() {
        String titleName = this.getName();
        if (titleName != null) {
            if (titleName.endsWith(this.getType()) && titleName.length() > this.getType().length()) {
                titleName = titleName.substring(0, titleName.length() - this.getType().length());
            } else if (titleName.equals("/")) {
                titleName = "top";
            }
            titleName = titleName.replace('_', ' ');
            titleName = titleName.replace('-', ' ');
            titleName = titleName.trim();
            int wordIndex = -1;
            do {
                if (Character.isTitleCase(titleName.charAt(wordIndex + 1))) continue;
                StringBuffer makeTitle = new StringBuffer();
                makeTitle.append(titleName.substring(0, wordIndex + 1));
                makeTitle.append(Character.toTitleCase(titleName.charAt(wordIndex + 1)));
                makeTitle.append(titleName.substring(wordIndex + 2));
                titleName = makeTitle.toString();
            } while ((wordIndex = titleName.indexOf(32, wordIndex + 1)) != -1);
        }
        return titleName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        this.setId(path);
    }

    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        return this.getPath();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getProfiledPath() {
        return this.profiledPath;
    }

    public void setProfiledPath(String profiledPath) {
        this.profiledPath = profiledPath;
    }

    public PageSecurity getEffectivePageSecurity() {
        if (this.parent != null) {
            return ((AbstractNode)this.parent).getEffectivePageSecurity();
        }
        return null;
    }

    public void checkConstraints(List actions, List userPrincipals, List rolePrincipals, List groupPrincipals, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        if (checkNodeOnly) {
            SecurityConstraints constraints = this.getSecurityConstraints();
            if (constraints != null && !constraints.isEmpty()) {
                ((SecurityConstraintsImpl)constraints).checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, this.getEffectivePageSecurity());
            } else if (this.parent != null) {
                ((AbstractNode)this.parent).checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, checkNodeOnly, false);
            }
        } else {
            SecurityConstraints constraints;
            if (!checkParentsOnly && (constraints = this.getSecurityConstraints()) != null && !constraints.isEmpty()) {
                ((SecurityConstraintsImpl)constraints).checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, this.getEffectivePageSecurity());
            }
            if (this.parent != null) {
                ((AbstractNode)this.parent).checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, false, false);
            }
        }
    }

    public void checkPermissions(String path, int mask, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        if (!checkParentsOnly) {
            super.checkPermissions(path, mask, true, false);
        }
        if (!checkNodeOnly && this.parent != null) {
            ((AbstractNode)this.parent).checkPermissions(mask, false, false);
        }
    }

    public String getLogicalPermissionPath() {
        return this.profiledPath;
    }

    public String getPhysicalPermissionPath() {
        return this.path;
    }

    public boolean unmarshalled(IdGenerator generator) {
        boolean dirty = super.unmarshalled(generator);
        Collection metadataFields = this.getMetadataFields();
        if (metadataFields != null) {
            this.setMetadataFields(metadataFields);
        }
        return dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

