/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.document.impl;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.jetspeed.om.common.GenericMetadata;
import org.apache.jetspeed.om.page.PageMetadataImpl;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.impl.BaseElementImpl;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsImpl;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;
import org.apache.ojb.broker.core.proxy.ProxyHelper;

public abstract class NodeImpl
extends BaseElementImpl
implements Node {
    private Node parent;
    private boolean hidden;
    private Collection metadataFields;
    private String path = "/";
    private String subsite;
    private String user;
    private String role;
    private String group;
    private String mediatype;
    private String locale;
    private String extendedAttributeName;
    private String extendedAttributeValue;
    private PageMetadataImpl pageMetadata;
    private String logicalPath;

    public NodeImpl(SecurityConstraintsImpl constraints) {
        super(constraints);
    }

    public static String getCanonicalNodePath(String path) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/") && !path.equals("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public PageMetadataImpl newPageMetadata(Collection fields) {
        return null;
    }

    public PageMetadataImpl getPageMetadata() {
        if (this.pageMetadata == null) {
            if (this.metadataFields == null) {
                this.metadataFields = DatabasePageManagerUtils.createCollection();
            }
            this.pageMetadata = this.newPageMetadata(this.metadataFields);
        }
        return this.pageMetadata;
    }

    protected String defaultTitleFromName() {
        String title = this.getName();
        if (title != null) {
            if (this.getType() != null && title.endsWith(this.getType())) {
                title = title.substring(0, title.length() - this.getType().length());
            } else if (title.equals("/")) {
                title = "top";
            }
            title = title.replace('_', ' ');
            title = title.replace('-', ' ');
            title = title.trim();
            int wordIndex = -1;
            do {
                if (Character.isTitleCase(title.charAt(wordIndex + 1))) continue;
                StringBuffer makeTitle = new StringBuffer();
                makeTitle.append(title.substring(0, wordIndex + 1));
                makeTitle.append(Character.toTitleCase(title.charAt(wordIndex + 1)));
                makeTitle.append(title.substring(wordIndex + 2));
                title = makeTitle.toString();
            } while ((wordIndex = title.indexOf(32, wordIndex + 1)) != -1);
        }
        return title;
    }

    public String getName() {
        String name = super.getName();
        if (name == null && this.path != null) {
            name = !this.path.equals("/") ? this.path.substring(this.path.lastIndexOf("/") + 1) : "/";
            super.setName(name);
        }
        return name;
    }

    public void setName(String name) {
        if (name != null) {
            if (this.path != null) {
                this.path = !name.equals("/") ? this.path.substring(0, this.path.lastIndexOf("/") + 1) + name : "/";
                this.logicalPath = null;
            }
            super.setName(name);
        }
    }

    public PageSecurity getEffectivePageSecurity() {
        NodeImpl parentNodeImpl = (NodeImpl)ProxyHelper.getRealObject((Object)this.parent);
        if (parentNodeImpl != null) {
            return parentNodeImpl.getEffectivePageSecurity();
        }
        return null;
    }

    public void checkConstraints(List actions, List userPrincipals, List rolePrincipals, List groupPrincipals, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        if (checkNodeOnly) {
            SecurityConstraintsImpl constraintsImpl = (SecurityConstraintsImpl)this.getSecurityConstraints();
            if (constraintsImpl != null && !constraintsImpl.isEmpty()) {
                constraintsImpl.checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, this.getEffectivePageSecurity());
            } else {
                NodeImpl parentNodeImpl = (NodeImpl)ProxyHelper.getRealObject((Object)this.parent);
                if (parentNodeImpl != null) {
                    parentNodeImpl.checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, checkNodeOnly, false);
                }
            }
        } else {
            NodeImpl parentNodeImpl;
            SecurityConstraintsImpl constraintsImpl;
            if (!checkParentsOnly && (constraintsImpl = (SecurityConstraintsImpl)this.getSecurityConstraints()) != null && !constraintsImpl.isEmpty()) {
                constraintsImpl.checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, this.getEffectivePageSecurity());
            }
            if ((parentNodeImpl = (NodeImpl)ProxyHelper.getRealObject((Object)this.parent)) != null) {
                parentNodeImpl.checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, false, false);
            }
        }
    }

    public void checkPermissions(String path, int mask, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        NodeImpl parentNodeImpl;
        if (!checkParentsOnly) {
            super.checkPermissions(path, mask, true, false);
        }
        if (!checkNodeOnly && (parentNodeImpl = (NodeImpl)ProxyHelper.getRealObject((Object)this.parent)) != null) {
            parentNodeImpl.checkPermissions(mask, false, false);
        }
    }

    public String getLogicalPermissionPath() {
        if (this.logicalPath == null) {
            if (this.subsite != null || this.user != null || this.role != null || this.group != null || this.mediatype != null || this.locale != null || this.extendedAttributeName != null || this.extendedAttributeValue != null) {
                boolean skipAttribute = false;
                StringBuffer logicalPathBuffer = new StringBuffer();
                StringTokenizer pathElements = new StringTokenizer(this.path, "/");
                while (pathElements.hasMoreTokens()) {
                    String pathElement = pathElements.nextToken();
                    if (!skipAttribute) {
                        if (pathElement.startsWith("__")) continue;
                        if (!pathElement.startsWith("_")) {
                            logicalPathBuffer.append("/");
                            logicalPathBuffer.append(pathElement);
                            continue;
                        }
                        skipAttribute = true;
                        continue;
                    }
                    skipAttribute = false;
                }
                this.logicalPath = logicalPathBuffer.length() > 0 ? logicalPathBuffer.toString() : "/";
            } else {
                this.logicalPath = this.path;
            }
        }
        return this.logicalPath;
    }

    public String getPhysicalPermissionPath() {
        return this.path;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        String parentPath;
        this.parent = parent;
        if (parent != null && ((parentPath = parent.getPath()).equals("/") && this.path.lastIndexOf("/") > 0 || !parentPath.equals("/") && !parentPath.equals(this.path.substring(0, this.path.lastIndexOf("/"))))) {
            this.path = parentPath + "/" + this.getName();
            this.logicalPath = null;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        String parentPath;
        this.path = NodeImpl.getCanonicalNodePath(path);
        this.logicalPath = null;
        String attributeName = null;
        StringTokenizer pathElements = new StringTokenizer(this.path, "/");
        while (pathElements.hasMoreTokens()) {
            String pathElement = pathElements.nextToken();
            if (attributeName != null) {
                if (attributeName.startsWith("_user")) {
                    this.user = pathElement.toLowerCase();
                } else if (attributeName.startsWith("_role")) {
                    this.role = pathElement.toLowerCase();
                } else if (attributeName.startsWith("_group")) {
                    this.group = pathElement.toLowerCase();
                } else if (attributeName.startsWith("_mediatype")) {
                    this.mediatype = pathElement.toLowerCase();
                } else if (attributeName.startsWith("_language")) {
                    this.locale = this.locale != null ? pathElement.toLowerCase() + "_" + this.locale : pathElement.toLowerCase();
                } else if (attributeName.startsWith("_country")) {
                    this.locale = this.locale != null ? this.locale + "_" + pathElement.toLowerCase() : pathElement.toLowerCase();
                } else if (attributeName.startsWith("_")) {
                    this.extendedAttributeName = attributeName.substring("_".length());
                    this.extendedAttributeValue = pathElement.toLowerCase();
                }
                attributeName = null;
                continue;
            }
            if (pathElement.startsWith("__")) {
                this.subsite = pathElement.substring("__".length()).toLowerCase();
                continue;
            }
            if (!pathElement.startsWith("_")) continue;
            attributeName = pathElement.toLowerCase();
        }
        if (!this.path.equals("/")) {
            super.setName(this.path.substring(this.path.lastIndexOf("/") + 1));
        } else {
            super.setName("/");
        }
        if (this.parent != null && ((parentPath = this.parent.getPath()).equals("/") && this.path.lastIndexOf("/") > 0 || !parentPath.equals("/") && !parentPath.equals(this.path.substring(0, this.path.lastIndexOf("/"))))) {
            this.parent = null;
        }
    }

    public GenericMetadata getMetadata() {
        return this.getPageMetadata();
    }

    public String getTitle(Locale locale) {
        String title = this.getPageMetadata().getText("title", locale);
        if (title == null) {
            title = this.getTitle();
        }
        return title;
    }

    public String getShortTitle(Locale locale) {
        String shortTitle = this.getPageMetadata().getText("short-title", locale);
        if (shortTitle == null && (shortTitle = this.getPageMetadata().getText("title", locale)) == null && (shortTitle = this.getShortTitle()) == null) {
            shortTitle = this.getTitle();
        }
        return shortTitle;
    }

    public abstract String getType();

    public String getUrl() {
        return this.path;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

