/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page;

import java.security.Principal;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.security.RolePrincipal;
import org.apache.jetspeed.security.SecurityHelper;
import org.apache.jetspeed.security.UserPrincipal;

public class PageManagerUtils {
    protected static Log log = LogFactory.getLog((Class)PageManagerUtils.class);

    public static void createUserHomePagesFromRoles(PageManager pageManager, Subject subject) throws NodeException {
        Principal principal = SecurityHelper.getBestPrincipal((Subject)subject, (Class)UserPrincipal.class);
        if (principal == null) {
            String errorMessage = "Could not create user home for null principal";
            log.error((Object)errorMessage);
            throw new NodeException(errorMessage);
        }
        try {
            Folder newUserFolder;
            String userName = principal.getName();
            if (pageManager.userFolderExists(userName)) {
                newUserFolder = pageManager.getUserFolder(userName);
            } else {
                newUserFolder = pageManager.newFolder("/_user/" + userName);
                SecurityConstraints constraints = pageManager.newSecurityConstraints();
                newUserFolder.setSecurityConstraints(constraints);
                newUserFolder.getSecurityConstraints().setOwner(userName);
                pageManager.updateFolder(newUserFolder);
            }
            Iterator roles = SecurityHelper.getPrincipals((Subject)subject, (Class)RolePrincipal.class).iterator();
            while (roles.hasNext()) {
                RolePrincipal role = (RolePrincipal)roles.next();
                if (!pageManager.folderExists("/_role/" + role.getName())) continue;
                Folder roleFolder = pageManager.getFolder("/_role/" + role.getName());
                PageManagerUtils.deepMergeFolder(pageManager, roleFolder, "/_user/" + newUserFolder.getName(), userName, role.getName());
            }
        }
        catch (Exception e) {
            String errorMessage = "createUserHomePagesFromRoles failed: " + e.getMessage();
            log.error((Object)errorMessage, (Throwable)e);
            throw new NodeException(errorMessage, (Throwable)e);
        }
    }

    public static void deepMergeFolder(PageManager pageManager, Folder srcFolder, String destinationPath, String owner, String uniqueName) throws NodeException {
        Iterator pages = srcFolder.getPages().iterator();
        while (pages.hasNext()) {
            Page srcPage = (Page)pages.next();
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcPage.getName());
            if (pageManager.pageExists(path)) continue;
            Page dstPage = pageManager.copyPage(srcPage, path);
            pageManager.updatePage(dstPage);
        }
        Iterator links = srcFolder.getLinks().iterator();
        while (links.hasNext()) {
            Link srcLink = (Link)links.next();
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcLink.getName());
            if (pageManager.linkExists(path)) continue;
            Link dstLink = pageManager.copyLink(srcLink, path);
            pageManager.updateLink(dstLink);
        }
        Iterator folders = srcFolder.getFolders().iterator();
        while (folders.hasNext()) {
            Folder folder = (Folder)folders.next();
            String newPath = PageManagerUtils.concatenatePaths(destinationPath, folder.getName());
            if (!pageManager.folderExists(newPath)) {
                Folder dstFolder = pageManager.copyFolder(folder, newPath);
                pageManager.updateFolder(dstFolder);
            }
            PageManagerUtils.deepMergeFolder(pageManager, folder, newPath, null, uniqueName);
        }
    }

    public static String concatenatePaths(String base, String path) {
        String result = "";
        if (base == null) {
            if (path == null) {
                return result;
            }
            return path;
        }
        if (path == null) {
            return base;
        }
        if (base.endsWith("/")) {
            if (path.startsWith("/")) {
                result = base.concat(path.substring(1));
                return result;
            }
        } else if (!path.startsWith("/")) {
            result = base.concat("/").concat(path);
            return result;
        }
        return base.concat(path);
    }

    public static void deepCopyFolder(PageManager pageManager, Folder srcFolder, String destinationPath, String owner, boolean copyIds) throws NodeException {
        boolean found = true;
        try {
            pageManager.getFolder(destinationPath);
        }
        catch (FolderNotFoundException e) {
            found = false;
        }
        if (found) {
            throw new NodeException("Destination already exists");
        }
        Folder dstFolder = pageManager.copyFolder(srcFolder, destinationPath);
        if (owner != null) {
            SecurityConstraints constraints = dstFolder.getSecurityConstraints();
            if (constraints == null) {
                constraints = pageManager.newSecurityConstraints();
                dstFolder.setSecurityConstraints(constraints);
            }
            dstFolder.getSecurityConstraints().setOwner(owner);
        }
        pageManager.updateFolder(dstFolder);
        Iterator pages = srcFolder.getPages().iterator();
        while (pages.hasNext()) {
            Page srcPage = (Page)pages.next();
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcPage.getName());
            Page dstPage = pageManager.copyPage(srcPage, path, copyIds);
            pageManager.updatePage(dstPage);
        }
        Iterator links = srcFolder.getLinks().iterator();
        while (links.hasNext()) {
            Link srcLink = (Link)links.next();
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcLink.getName());
            Link dstLink = pageManager.copyLink(srcLink, path);
            pageManager.updateLink(dstLink);
        }
        Iterator folders = srcFolder.getFolders().iterator();
        while (folders.hasNext()) {
            Folder folder = (Folder)folders.next();
            String newPath = PageManagerUtils.concatenatePaths(destinationPath, folder.getName());
            PageManagerUtils.deepCopyFolder(pageManager, folder, newPath, null, copyIds);
        }
    }

    public static void deepMergeFolder(PageManager pageManager, Folder srcFolder, String destinationPath, String owner, boolean copyIds) throws NodeException {
        boolean found = true;
        Folder dstFolder = null;
        try {
            dstFolder = pageManager.getFolder(destinationPath);
        }
        catch (FolderNotFoundException e) {
            found = false;
        }
        if (!found) {
            dstFolder = pageManager.copyFolder(srcFolder, destinationPath);
            if (owner != null) {
                SecurityConstraints constraints = dstFolder.getSecurityConstraints();
                if (constraints == null) {
                    constraints = pageManager.newSecurityConstraints();
                    dstFolder.setSecurityConstraints(constraints);
                }
                dstFolder.getSecurityConstraints().setOwner(owner);
            }
            pageManager.updateFolder(dstFolder);
        }
        Iterator pages = srcFolder.getPages().iterator();
        while (pages.hasNext()) {
            Page srcPage = (Page)pages.next();
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcPage.getName());
            if (pageManager.pageExists(path)) continue;
            Page dstPage = pageManager.copyPage(srcPage, path, copyIds);
            pageManager.updatePage(dstPage);
        }
        Iterator links = srcFolder.getLinks().iterator();
        while (links.hasNext()) {
            Link srcLink = (Link)links.next();
            String path = PageManagerUtils.concatenatePaths(destinationPath, srcLink.getName());
            if (pageManager.linkExists(path)) continue;
            Link dstLink = pageManager.copyLink(srcLink, path);
            pageManager.updateLink(dstLink);
        }
        Iterator folders = srcFolder.getFolders().iterator();
        while (folders.hasNext()) {
            Folder folder = (Folder)folders.next();
            String newPath = PageManagerUtils.concatenatePaths(destinationPath, folder.getName());
            PageManagerUtils.deepMergeFolder(pageManager, folder, newPath, null, copyIds);
        }
    }
}

