/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page;

import java.util.Iterator;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class PageImporter {
    private PageManager sourceManager;
    private PageManager destManager;
    private String rootFolder;
    private boolean overwriteFolders = false;
    private boolean overwritePages = true;
    private int folderCount = 0;
    private int pageCount = 0;
    private int linkCount = 0;

    public static void main(String[] args) {
        String fileName = System.getProperty("org.apache.jetspeed.page.import.configuration", "import.properties");
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        try {
            ClassPathXmlApplicationContext ctx;
            configuration.load(fileName);
            String[] bootAssemblies = configuration.getStringArray("boot.assemblies");
            String[] assemblies = configuration.getStringArray("assemblies");
            if (bootAssemblies != null) {
                ClassPathXmlApplicationContext bootContext = new ClassPathXmlApplicationContext(bootAssemblies, true);
                ctx = new ClassPathXmlApplicationContext(assemblies, true, (ApplicationContext)bootContext);
            } else {
                ctx = new ClassPathXmlApplicationContext(assemblies, true);
            }
            String rootFolder = configuration.getString("root.folder", "/");
            boolean overwriteFolders = configuration.getBoolean("overwrite.folders", true);
            boolean overwritePages = configuration.getBoolean("overwrite.pages", true);
            boolean fullImport = configuration.getBoolean("full.import", true);
            String sourcePageManager = configuration.getString("source.page.manager", "castorPageManager");
            String destPageManager = configuration.getString("dest.page.manager", "dbPageManager");
            PageManager srcManager = (PageManager)ctx.getBean(sourcePageManager);
            PageManager dstManager = (PageManager)ctx.getBean(destPageManager);
            PageImporter importer = new PageImporter(srcManager, dstManager, rootFolder, overwriteFolders, overwritePages);
            if (fullImport) {
                importer.fullImport();
            } else {
                importer.folderTreeImport();
            }
        }
        catch (Exception e) {
            System.err.println("Failed to import: " + e);
            e.printStackTrace();
        }
    }

    public PageImporter(PageManager sourceManager, PageManager destManager, String rootFolder, boolean overwriteFolders, boolean overwritePages) {
        this.sourceManager = sourceManager;
        this.destManager = destManager;
        this.rootFolder = rootFolder;
        this.overwriteFolders = overwriteFolders;
        this.overwritePages = overwritePages;
    }

    public void fullImport() throws JetspeedException {
        Folder fsRoot = null;
        try {
            fsRoot = this.sourceManager.getFolder(this.rootFolder);
        }
        catch (FolderNotFoundException fnfe) {
            // empty catch block
        }
        if (fsRoot != null) {
            this.importFolder(fsRoot);
            PageSecurity sourcePageSecurity = null;
            try {
                sourcePageSecurity = this.sourceManager.getPageSecurity();
            }
            catch (DocumentNotFoundException e) {
                // empty catch block
            }
            if (sourcePageSecurity != null) {
                PageSecurity rootSecurity = this.destManager.copyPageSecurity(sourcePageSecurity);
                this.destManager.updatePageSecurity(rootSecurity);
            }
        }
    }

    public void folderTreeImport() throws JetspeedException {
        Folder fsRoot = this.sourceManager.getFolder(this.rootFolder);
        this.importFolder(fsRoot);
    }

    private Folder importFolder(Folder srcFolder) throws JetspeedException {
        Folder dstFolder = this.lookupFolder(srcFolder.getPath());
        if (null != dstFolder) {
            if (this.isOverwriteFolders()) {
                System.out.println("overwriting folder " + srcFolder.getPath());
                this.destManager.removeFolder(dstFolder);
                dstFolder = this.destManager.copyFolder(srcFolder, srcFolder.getPath());
                this.destManager.updateFolder(dstFolder);
                ++this.folderCount;
            } else {
                System.out.println("skipping folder " + srcFolder.getPath());
            }
        } else {
            System.out.println("importing new folder " + srcFolder.getPath());
            dstFolder = this.destManager.copyFolder(srcFolder, srcFolder.getPath());
            this.destManager.updateFolder(dstFolder);
            ++this.folderCount;
        }
        Iterator pages = srcFolder.getPages().iterator();
        while (pages.hasNext()) {
            Page srcPage = (Page)pages.next();
            Page dstPage = this.lookupPage(srcPage.getPath());
            if (null != dstPage) {
                if (this.isOverwritePages()) {
                    System.out.println("overwriting page " + srcPage.getPath());
                    this.destManager.removePage(dstPage);
                    dstPage = this.destManager.copyPage(srcPage, srcPage.getPath(), true);
                    this.destManager.updatePage(dstPage);
                    ++this.pageCount;
                    continue;
                }
                System.out.println("skipping page " + srcPage.getPath());
                continue;
            }
            System.out.println("importing new page " + srcPage.getPath());
            dstPage = this.destManager.copyPage(srcPage, srcPage.getPath(), true);
            this.destManager.updatePage(dstPage);
            ++this.pageCount;
        }
        Iterator links = srcFolder.getLinks().iterator();
        while (links.hasNext()) {
            Link srcLink = (Link)links.next();
            Link dstLink = this.lookupLink(srcLink.getPath());
            if (null != dstLink) {
                if (this.isOverwritePages()) {
                    System.out.println("overwriting link " + srcLink.getPath());
                    this.destManager.removeLink(dstLink);
                    dstLink = this.destManager.copyLink(srcLink, srcLink.getPath());
                    this.destManager.updateLink(dstLink);
                    ++this.linkCount;
                    continue;
                }
                System.out.println("skipping link " + srcLink.getPath());
                continue;
            }
            System.out.println("importing new link " + srcLink.getPath());
            dstLink = this.destManager.copyLink(srcLink, srcLink.getPath());
            this.destManager.updateLink(dstLink);
            ++this.linkCount;
        }
        Iterator folders = srcFolder.getFolders().iterator();
        while (folders.hasNext()) {
            Folder folder = (Folder)folders.next();
            this.importFolder(folder);
        }
        return dstFolder;
    }

    private Page lookupPage(String path) {
        try {
            return this.destManager.getPage(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Link lookupLink(String path) {
        try {
            return this.destManager.getLink(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Folder lookupFolder(String path) {
        try {
            return this.destManager.getFolder(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isOverwriteFolders() {
        return this.overwriteFolders;
    }

    public void setOverwriteFolders(boolean overwrite) {
        this.overwriteFolders = overwrite;
    }

    public PageManager getDestManager() {
        return this.destManager;
    }

    public void setDestManager(PageManager destManager) {
        this.destManager = destManager;
    }

    public int getFolderCount() {
        return this.folderCount;
    }

    public void setFolderCount(int folderCount) {
        this.folderCount = folderCount;
    }

    public boolean isOverwritePages() {
        return this.overwritePages;
    }

    public void setOverwritePages(boolean overwritePages) {
        this.overwritePages = overwritePages;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public int getLinkCount() {
        return this.linkCount;
    }

    public void setLinkCount(int linkCount) {
        this.linkCount = linkCount;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    public PageManager getSourceManager() {
        return this.sourceManager;
    }

    public void setSourceManager(PageManager sourceManager) {
        this.sourceManager = sourceManager;
    }
}

