/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.MenuExcludeDefinition;
import org.apache.jetspeed.om.folder.MenuIncludeDefinition;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.folder.MenuSeparatorDefinition;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.preference.FragmentPreference;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageManagerEventListener;
import org.apache.jetspeed.page.PageManagerUtils;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

public abstract class AbstractPageManager
implements PageManager {
    private static final Log log = LogFactory.getLog((Class)AbstractPageManager.class);
    private static final long DEFAULT_NODE_REAPING_INTERVAL = 300000L;
    private static final String FOLDER_NODE_TYPE = "folder";
    private static final String PAGE_NODE_TYPE = "page";
    private static final String FRAGMENT_NODE_TYPE = "fragment";
    private static final String LINK_NODE_TYPE = "link";
    protected Class fragmentClass;
    protected Class pageClass;
    protected Class folderClass;
    protected Class linkClass;
    protected Class pageSecurityClass;
    protected Class propertyClass;
    protected Class folderMenuDefinitionClass;
    protected Class folderMenuExcludeDefinitionClass;
    protected Class folderMenuIncludeDefinitionClass;
    protected Class folderMenuOptionsDefinitionClass;
    protected Class folderMenuSeparatorDefinitionClass;
    protected Class pageMenuDefinitionClass;
    protected Class pageMenuExcludeDefinitionClass;
    protected Class pageMenuIncludeDefinitionClass;
    protected Class pageMenuOptionsDefinitionClass;
    protected Class pageMenuSeparatorDefinitionClass;
    protected Class securityConstraintsClass;
    protected Class folderSecurityConstraintClass;
    protected Class pageSecurityConstraintClass;
    protected Class fragmentSecurityConstraintClass;
    protected Class linkSecurityConstraintClass;
    protected Class pageSecuritySecurityConstraintClass;
    protected Class securityConstraintsDefClass;
    protected Class fragmentPreferenceClass;
    private IdGenerator generator;
    private boolean permissionsEnabled;
    private boolean constraintsEnabled;
    private List listeners = new LinkedList();
    private long nodeReapingInterval = 300000L;

    public AbstractPageManager(IdGenerator generator, boolean permissionsEnabled, boolean constraintsEnabled) {
        this.generator = generator;
        this.permissionsEnabled = permissionsEnabled;
        this.constraintsEnabled = constraintsEnabled;
        if (this.nodeReapingInterval > 0L) {
            Thread nodeReapingThread = new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(AbstractPageManager.this.nodeReapingInterval);
                                AbstractPageManager.this.notifyReapNodes();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            }, "PageManagerNodeReapingThread");
            nodeReapingThread.setDaemon(true);
            nodeReapingThread.start();
        }
    }

    public AbstractPageManager(IdGenerator generator, boolean permissionsEnabled, boolean constraintsEnabled, Map modelClasses) {
        this(generator, permissionsEnabled, constraintsEnabled);
        this.fragmentClass = (Class)modelClasses.get("FragmentImpl");
        this.pageClass = (Class)modelClasses.get("PageImpl");
        this.folderClass = (Class)modelClasses.get("FolderImpl");
        this.linkClass = (Class)modelClasses.get("LinkImpl");
        this.pageSecurityClass = (Class)modelClasses.get("PageSecurityImpl");
        this.folderMenuDefinitionClass = (Class)modelClasses.get("FolderMenuDefinitionImpl");
        this.folderMenuExcludeDefinitionClass = (Class)modelClasses.get("FolderMenuExcludeDefinitionImpl");
        this.folderMenuIncludeDefinitionClass = (Class)modelClasses.get("FolderMenuIncludeDefinitionImpl");
        this.folderMenuOptionsDefinitionClass = (Class)modelClasses.get("FolderMenuOptionsDefinitionImpl");
        this.folderMenuSeparatorDefinitionClass = (Class)modelClasses.get("FolderMenuSeparatorDefinitionImpl");
        this.pageMenuDefinitionClass = (Class)modelClasses.get("PageMenuDefinitionImpl");
        this.pageMenuExcludeDefinitionClass = (Class)modelClasses.get("PageMenuExcludeDefinitionImpl");
        this.pageMenuIncludeDefinitionClass = (Class)modelClasses.get("PageMenuIncludeDefinitionImpl");
        this.pageMenuOptionsDefinitionClass = (Class)modelClasses.get("PageMenuOptionsDefinitionImpl");
        this.pageMenuSeparatorDefinitionClass = (Class)modelClasses.get("PageMenuSeparatorDefinitionImpl");
        this.securityConstraintsClass = (Class)modelClasses.get("SecurityConstraintsImpl");
        this.folderSecurityConstraintClass = (Class)modelClasses.get("FolderSecurityConstraintImpl");
        this.pageSecurityConstraintClass = (Class)modelClasses.get("PageSecurityConstraintImpl");
        this.fragmentSecurityConstraintClass = (Class)modelClasses.get("FragmentSecurityConstraintImpl");
        this.linkSecurityConstraintClass = (Class)modelClasses.get("LinkSecurityConstraintImpl");
        this.pageSecuritySecurityConstraintClass = (Class)modelClasses.get("PageSecuritySecurityConstraintImpl");
        this.securityConstraintsDefClass = (Class)modelClasses.get("SecurityConstraintsDefImpl");
        this.fragmentPreferenceClass = (Class)modelClasses.get("FragmentPreferenceImpl");
    }

    public boolean getPermissionsEnabled() {
        return this.permissionsEnabled;
    }

    public boolean getConstraintsEnabled() {
        return this.constraintsEnabled;
    }

    public long getNodeReapingInterval() {
        return this.nodeReapingInterval;
    }

    public Page newPage(String path) {
        Page page = null;
        try {
            page = (Page)this.createObject(this.pageClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith(".psml")) {
                path = path + ".psml";
            }
            page.setPath(path);
            page.setRootFragment(this.newFragment());
        }
        catch (ClassCastException e) {
            String message = "Failed to create page object for " + this.pageClass;
            log.error((Object)message, (Throwable)e);
        }
        return page;
    }

    public Folder newFolder(String path) {
        Folder folder = null;
        try {
            folder = (Folder)this.createObject(this.folderClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            folder.setPath(path);
        }
        catch (ClassCastException e) {
            String message = "Failed to create link object for " + this.linkClass;
            log.error((Object)message, (Throwable)e);
        }
        return folder;
    }

    public Link newLink(String path) {
        Link link = null;
        try {
            link = (Link)this.createObject(this.linkClass);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith(".link")) {
                path = path + ".link";
            }
            link.setPath(path);
        }
        catch (ClassCastException e) {
            String message = "Failed to create link object for " + this.linkClass;
            log.error((Object)message, (Throwable)e);
        }
        return link;
    }

    public PageSecurity newPageSecurity() {
        PageSecurity pageSecurity = null;
        try {
            pageSecurity = (PageSecurity)this.createObject(this.pageSecurityClass);
            pageSecurity.setPath("/page.security");
        }
        catch (ClassCastException e) {
            String message = "Failed to create page security object for " + this.pageClass;
            log.error((Object)message, (Throwable)e);
        }
        return pageSecurity;
    }

    public Fragment newFragment() {
        Fragment fragment = null;
        try {
            fragment = (Fragment)this.createObject(this.fragmentClass);
            fragment.setType("layout");
            fragment.setId(this.generator.getNextPeid());
        }
        catch (ClassCastException e) {
            String message = "Failed to create page object for " + this.pageClass;
            log.error((Object)message, (Throwable)e);
        }
        return fragment;
    }

    public Fragment newPortletFragment() {
        Fragment fragment = null;
        try {
            fragment = (Fragment)this.createObject(this.fragmentClass);
            fragment.setType("portlet");
            fragment.setId(this.generator.getNextPeid());
        }
        catch (ClassCastException e) {
            String message = "Failed to create page object for " + this.pageClass;
            log.error((Object)message, (Throwable)e);
        }
        return fragment;
    }

    public MenuDefinition newFolderMenuDefinition() {
        try {
            return (MenuDefinition)this.createObject(this.folderMenuDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu definition object for " + this.folderMenuDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public MenuExcludeDefinition newFolderMenuExcludeDefinition() {
        try {
            return (MenuExcludeDefinition)this.createObject(this.folderMenuExcludeDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu exclude definition object for " + this.folderMenuExcludeDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public MenuIncludeDefinition newFolderMenuIncludeDefinition() {
        try {
            return (MenuIncludeDefinition)this.createObject(this.folderMenuIncludeDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu include definition object for " + this.folderMenuIncludeDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public MenuOptionsDefinition newFolderMenuOptionsDefinition() {
        try {
            return (MenuOptionsDefinition)this.createObject(this.folderMenuOptionsDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu options definition object for " + this.folderMenuOptionsDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public MenuSeparatorDefinition newFolderMenuSeparatorDefinition() {
        try {
            return (MenuSeparatorDefinition)this.createObject(this.folderMenuSeparatorDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu separator definition object for " + this.folderMenuSeparatorDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public MenuDefinition newPageMenuDefinition() {
        try {
            return (MenuDefinition)this.createObject(this.pageMenuDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu definition object for " + this.pageMenuDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public MenuExcludeDefinition newPageMenuExcludeDefinition() {
        try {
            return (MenuExcludeDefinition)this.createObject(this.pageMenuExcludeDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu exclude definition object for " + this.pageMenuExcludeDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public MenuIncludeDefinition newPageMenuIncludeDefinition() {
        try {
            return (MenuIncludeDefinition)this.createObject(this.pageMenuIncludeDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu include definition object for " + this.pageMenuIncludeDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public MenuOptionsDefinition newPageMenuOptionsDefinition() {
        try {
            return (MenuOptionsDefinition)this.createObject(this.pageMenuOptionsDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu options definition object for " + this.pageMenuOptionsDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public MenuSeparatorDefinition newPageMenuSeparatorDefinition() {
        try {
            return (MenuSeparatorDefinition)this.createObject(this.pageMenuSeparatorDefinitionClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create menu separator definition object for " + this.pageMenuSeparatorDefinitionClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraints newSecurityConstraints() {
        try {
            return (SecurityConstraints)this.createObject(this.securityConstraintsClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraints definition object for " + this.securityConstraintsClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newFolderSecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.folderSecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.folderSecurityConstraintClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newPageSecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.pageSecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.pageSecurityConstraintClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newFragmentSecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.fragmentSecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.fragmentSecurityConstraintClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newLinkSecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.linkSecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.linkSecurityConstraintClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraint newPageSecuritySecurityConstraint() {
        try {
            return (SecurityConstraint)this.createObject(this.pageSecuritySecurityConstraintClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraint definition object for " + this.pageSecuritySecurityConstraintClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public SecurityConstraintsDef newSecurityConstraintsDef() {
        try {
            return (SecurityConstraintsDef)this.createObject(this.securityConstraintsDefClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraints definition object for " + this.securityConstraintsDefClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    public FragmentPreference newFragmentPreference() {
        try {
            return (FragmentPreference)this.createObject(this.fragmentPreferenceClass);
        }
        catch (ClassCastException e) {
            String message = "Failed to create security constraints definition object for " + this.fragmentPreferenceClass;
            log.error((Object)message, (Throwable)e);
            return null;
        }
    }

    private Object createObject(Class classe) {
        Object object = null;
        try {
            object = classe.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Factory failed to create object: " + classe.getName()), (Throwable)e);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PageManagerEventListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PageManagerEventListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void reset() {
    }

    public void shutdown() {
    }

    public boolean isDistributed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNewNode(Node node) {
        ArrayList listenersList = null;
        List list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList(this.listeners);
        }
        Iterator listenersIter = listenersList.iterator();
        while (listenersIter.hasNext()) {
            PageManagerEventListener listener = (PageManagerEventListener)listenersIter.next();
            try {
                listener.newNode(node);
            }
            catch (Exception e) {
                log.error((Object)"Failed to notify page manager event listener", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUpdatedNode(Node node) {
        ArrayList listenersList = null;
        List list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList(this.listeners);
        }
        Iterator listenersIter = listenersList.iterator();
        while (listenersIter.hasNext()) {
            PageManagerEventListener listener = (PageManagerEventListener)listenersIter.next();
            try {
                listener.updatedNode(node);
            }
            catch (Exception e) {
                log.error((Object)"Failed to notify page manager event listener", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemovedNode(Node node) {
        ArrayList listenersList = null;
        List list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList(this.listeners);
        }
        Iterator listenersIter = listenersList.iterator();
        while (listenersIter.hasNext()) {
            PageManagerEventListener listener = (PageManagerEventListener)listenersIter.next();
            try {
                listener.removedNode(node);
            }
            catch (Exception e) {
                log.error((Object)"Failed to notify page manager event listener", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReapNodes() {
        ArrayList listenersList = null;
        List list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList(this.listeners);
        }
        Iterator listenersIter = listenersList.iterator();
        while (listenersIter.hasNext()) {
            PageManagerEventListener listener = (PageManagerEventListener)listenersIter.next();
            try {
                listener.reapNodes(this.nodeReapingInterval);
            }
            catch (Exception e) {
                log.error((Object)"Failed to notify page manager event listener", (Throwable)e);
            }
        }
    }

    public Folder copyFolder(Folder source, String path) throws NodeException {
        Folder folder = this.newFolder(path);
        folder.setDefaultPage(source.getDefaultPage());
        folder.setShortTitle(source.getShortTitle());
        folder.setTitle(source.getTitle());
        folder.setHidden(source.isHidden());
        folder.setDefaultDecorator(source.getDefaultDecorator("layout"), "layout");
        folder.setDefaultDecorator(source.getDefaultDecorator("portlet"), "portlet");
        folder.setSkin(source.getSkin());
        folder.getMetadata().copyFields(source.getMetadata().getFields());
        SecurityConstraints srcSecurity = source.getSecurityConstraints();
        if (srcSecurity != null && !srcSecurity.isEmpty()) {
            SecurityConstraints copiedSecurity = this.copySecurityConstraints(FOLDER_NODE_TYPE, srcSecurity);
            folder.setSecurityConstraints(copiedSecurity);
        }
        folder.setDocumentOrder(DatabasePageManagerUtils.createList());
        Iterator documentOrders = source.getDocumentOrder().iterator();
        while (documentOrders.hasNext()) {
            String name = (String)documentOrders.next();
            folder.getDocumentOrder().add(name);
        }
        List menus = source.getMenuDefinitions();
        if (menus != null) {
            List copiedMenus = this.copyMenuDefinitions(FOLDER_NODE_TYPE, menus);
            folder.setMenuDefinitions(copiedMenus);
        }
        return folder;
    }

    public Page copyPage(Page source, String path) throws NodeException {
        return this.copyPage(source, path, false);
    }

    public Page copyPage(Page source, String path, boolean copyIds) throws NodeException {
        List menus;
        Page page = this.newPage(path);
        page.setTitle(source.getTitle());
        page.setShortTitle(source.getShortTitle());
        page.setVersion(source.getVersion());
        page.setDefaultDecorator(source.getDefaultDecorator("layout"), "layout");
        page.setDefaultDecorator(source.getDefaultDecorator("portlet"), "portlet");
        page.setSkin(source.getSkin());
        page.setHidden(source.isHidden());
        page.getMetadata().copyFields(source.getMetadata().getFields());
        SecurityConstraints srcSecurity = source.getSecurityConstraints();
        if (srcSecurity != null && !srcSecurity.isEmpty()) {
            SecurityConstraints copiedSecurity = this.copySecurityConstraints(PAGE_NODE_TYPE, srcSecurity);
            page.setSecurityConstraints(copiedSecurity);
        }
        if ((menus = source.getMenuDefinitions()) != null) {
            List copiedMenus = this.copyMenuDefinitions(PAGE_NODE_TYPE, menus);
            page.setMenuDefinitions(copiedMenus);
        }
        Fragment root = this.copyFragment(source.getRootFragment(), source.getRootFragment().getName(), copyIds);
        page.setRootFragment(root);
        return page;
    }

    public Fragment copyFragment(Fragment source, String name) throws NodeException {
        return this.copyFragment(source, name, false);
    }

    public Fragment copyFragment(Fragment source, String name, boolean copyIds) throws NodeException {
        Fragment copy = this.newFragment();
        if (copyIds) {
            copy.setId(source.getId());
        }
        copy.setDecorator(source.getDecorator());
        copy.setName(name);
        copy.setShortTitle(source.getShortTitle());
        copy.setSkin(source.getSkin());
        copy.setTitle(source.getTitle());
        copy.setType(source.getType());
        copy.setState(source.getState());
        SecurityConstraints srcSecurity = source.getSecurityConstraints();
        if (srcSecurity != null && !srcSecurity.isEmpty()) {
            SecurityConstraints copiedSecurity = this.copySecurityConstraints(FRAGMENT_NODE_TYPE, srcSecurity);
            copy.setSecurityConstraints(copiedSecurity);
        }
        Iterator props = source.getProperties().entrySet().iterator();
        while (props.hasNext()) {
            Map.Entry prop = props.next();
            copy.getProperties().put(prop.getKey(), prop.getValue());
        }
        copy.setPreferences(DatabasePageManagerUtils.createList());
        Iterator prefs = source.getPreferences().iterator();
        while (prefs.hasNext()) {
            FragmentPreference pref = (FragmentPreference)prefs.next();
            FragmentPreference newPref = this.newFragmentPreference();
            newPref.setName(pref.getName());
            newPref.setReadOnly(pref.isReadOnly());
            newPref.setValueList(DatabasePageManagerUtils.createList());
            Iterator values = pref.getValueList().iterator();
            while (values.hasNext()) {
                String value = (String)values.next();
                newPref.getValueList().add(value);
            }
            copy.getPreferences().add(newPref);
        }
        Iterator fragments = source.getFragments().iterator();
        while (fragments.hasNext()) {
            Fragment fragment = (Fragment)fragments.next();
            Fragment copiedFragment = this.copyFragment(fragment, fragment.getName(), copyIds);
            copy.getFragments().add(copiedFragment);
        }
        return copy;
    }

    public Link copyLink(Link source, String path) throws NodeException {
        Link link = this.newLink(path);
        link.setTitle(source.getTitle());
        link.setShortTitle(source.getShortTitle());
        link.setSkin(source.getSkin());
        link.setVersion(source.getVersion());
        link.setTarget(source.getTarget());
        link.setUrl(source.getUrl());
        link.setHidden(source.isHidden());
        link.getMetadata().copyFields(source.getMetadata().getFields());
        SecurityConstraints srcSecurity = source.getSecurityConstraints();
        if (srcSecurity != null && !srcSecurity.isEmpty()) {
            SecurityConstraints copiedSecurity = this.copySecurityConstraints(LINK_NODE_TYPE, srcSecurity);
            link.setSecurityConstraints(copiedSecurity);
        }
        return link;
    }

    public PageSecurity copyPageSecurity(PageSecurity source) throws NodeException {
        PageSecurity copy = this.newPageSecurity();
        copy.setPath(source.getPath());
        copy.setVersion(source.getVersion());
        copy.setSecurityConstraintsDefs(DatabasePageManagerUtils.createList());
        Iterator defs = source.getSecurityConstraintsDefs().iterator();
        while (defs.hasNext()) {
            SecurityConstraintsDef def = (SecurityConstraintsDef)defs.next();
            SecurityConstraintsDef defCopy = this.newSecurityConstraintsDef();
            defCopy.setName(def.getName());
            List copiedConstraints = DatabasePageManagerUtils.createList();
            Iterator constraints = def.getSecurityConstraints().iterator();
            while (constraints.hasNext()) {
                SecurityConstraint srcConstraint = (SecurityConstraint)constraints.next();
                SecurityConstraint dstConstraint = this.newPageSecuritySecurityConstraint();
                this.copyConstraint(srcConstraint, dstConstraint);
                copiedConstraints.add(dstConstraint);
            }
            defCopy.setSecurityConstraints(copiedConstraints);
            copy.getSecurityConstraintsDefs().add(defCopy);
        }
        copy.setGlobalSecurityConstraintsRefs(DatabasePageManagerUtils.createList());
        Iterator globals = source.getGlobalSecurityConstraintsRefs().iterator();
        while (globals.hasNext()) {
            String global = (String)globals.next();
            copy.getGlobalSecurityConstraintsRefs().add(global);
        }
        return copy;
    }

    protected List copyMenuDefinitions(String type, List srcMenus) {
        List copiedMenus = DatabasePageManagerUtils.createList();
        Iterator menus = srcMenus.iterator();
        while (menus.hasNext()) {
            MenuDefinition srcMenu = (MenuDefinition)menus.next();
            MenuDefinition copiedMenu = (MenuDefinition)this.copyMenuElement(type, srcMenu);
            if (copiedMenu == null) continue;
            copiedMenus.add(copiedMenu);
        }
        return copiedMenus;
    }

    protected Object copyMenuElement(String type, Object srcElement) {
        if (srcElement instanceof MenuDefinition) {
            MenuDefinition source = (MenuDefinition)srcElement;
            MenuDefinition menu = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menu = this.newPageMenuDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menu = this.newFolderMenuDefinition();
            }
            menu.setDepth(source.getDepth());
            menu.setName(source.getName());
            menu.setOptions(source.getOptions());
            menu.setOrder(source.getOrder());
            menu.setPaths(source.isPaths());
            menu.setProfile(source.getProfile());
            menu.setRegexp(source.isRegexp());
            menu.setShortTitle(source.getShortTitle());
            menu.setSkin(source.getSkin());
            menu.setTitle(source.getTitle());
            menu.getMetadata().copyFields(source.getMetadata().getFields());
            List elements = source.getMenuElements();
            if (elements != null) {
                List copiedElements = DatabasePageManagerUtils.createList();
                Iterator elementsIter = elements.iterator();
                while (elementsIter.hasNext()) {
                    Object element = elementsIter.next();
                    Object copiedElement = this.copyMenuElement(type, element);
                    if (copiedElement == null) continue;
                    copiedElements.add(copiedElement);
                }
                menu.setMenuElements(copiedElements);
            }
            return menu;
        }
        if (srcElement instanceof MenuExcludeDefinition) {
            MenuExcludeDefinition source = (MenuExcludeDefinition)srcElement;
            MenuExcludeDefinition menuExclude = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuExclude = this.newPageMenuExcludeDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuExclude = this.newFolderMenuExcludeDefinition();
            }
            menuExclude.setName(source.getName());
            return menuExclude;
        }
        if (srcElement instanceof MenuIncludeDefinition) {
            MenuIncludeDefinition source = (MenuIncludeDefinition)srcElement;
            MenuIncludeDefinition menuInclude = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuInclude = this.newPageMenuIncludeDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuInclude = this.newFolderMenuIncludeDefinition();
            }
            menuInclude.setName(source.getName());
            menuInclude.setNest(source.isNest());
            return menuInclude;
        }
        if (srcElement instanceof MenuOptionsDefinition) {
            MenuOptionsDefinition source = (MenuOptionsDefinition)srcElement;
            MenuOptionsDefinition menuOptions = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuOptions = this.newPageMenuOptionsDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuOptions = this.newFolderMenuOptionsDefinition();
            }
            menuOptions.setDepth(source.getDepth());
            menuOptions.setOptions(source.getOptions());
            menuOptions.setOrder(source.getOrder());
            menuOptions.setPaths(source.isPaths());
            menuOptions.setProfile(source.getProfile());
            menuOptions.setRegexp(source.isRegexp());
            menuOptions.setSkin(source.getSkin());
            return menuOptions;
        }
        if (srcElement instanceof MenuSeparatorDefinition) {
            MenuSeparatorDefinition source = (MenuSeparatorDefinition)srcElement;
            MenuSeparatorDefinition menuSeparator = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuSeparator = this.newPageMenuSeparatorDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuSeparator = this.newFolderMenuSeparatorDefinition();
            }
            menuSeparator.setSkin(source.getSkin());
            menuSeparator.setTitle(source.getTitle());
            menuSeparator.setText(source.getText());
            menuSeparator.getMetadata().copyFields(source.getMetadata().getFields());
            return menuSeparator;
        }
        return null;
    }

    protected void copyConstraint(SecurityConstraint srcConstraint, SecurityConstraint dstConstraint) {
        dstConstraint.setUsers(srcConstraint.getUsers());
        dstConstraint.setRoles(srcConstraint.getRoles());
        dstConstraint.setGroups(srcConstraint.getGroups());
        dstConstraint.setPermissions(srcConstraint.getPermissions());
    }

    protected SecurityConstraints copySecurityConstraints(String type, SecurityConstraints source) {
        SecurityConstraints security = this.newSecurityConstraints();
        if (source.getOwner() != null) {
            security.setOwner(source.getOwner());
        }
        if (source.getSecurityConstraints() != null) {
            List copiedConstraints = DatabasePageManagerUtils.createList();
            Iterator constraints = source.getSecurityConstraints().iterator();
            while (constraints.hasNext()) {
                SecurityConstraint srcConstraint = (SecurityConstraint)constraints.next();
                SecurityConstraint dstConstraint = null;
                if (type.equals(PAGE_NODE_TYPE)) {
                    dstConstraint = this.newPageSecurityConstraint();
                } else if (type.equals(FOLDER_NODE_TYPE)) {
                    dstConstraint = this.newFolderSecurityConstraint();
                } else if (type.equals(LINK_NODE_TYPE)) {
                    dstConstraint = this.newLinkSecurityConstraint();
                } else if (type.equals(FRAGMENT_NODE_TYPE)) {
                    dstConstraint = this.newFragmentSecurityConstraint();
                }
                this.copyConstraint(srcConstraint, dstConstraint);
                copiedConstraints.add(dstConstraint);
            }
            security.setSecurityConstraints(copiedConstraints);
        }
        if (source.getSecurityConstraintsRefs() != null) {
            List copiedRefs = DatabasePageManagerUtils.createList();
            Iterator refs = source.getSecurityConstraintsRefs().iterator();
            while (refs.hasNext()) {
                String constraintsRef = (String)refs.next();
                copiedRefs.add(constraintsRef);
            }
            security.setSecurityConstraintsRefs(copiedRefs);
        }
        return security;
    }

    public void deepCopyFolder(Folder srcFolder, String destinationPath, String owner) throws NodeException {
        this.deepCopyFolder(srcFolder, destinationPath, owner, false);
    }

    public void deepCopyFolder(Folder srcFolder, String destinationPath, String owner, boolean copyIds) throws NodeException {
        PageManagerUtils.deepCopyFolder(this, srcFolder, destinationPath, owner, copyIds);
    }

    public void deepMergeFolder(Folder srcFolder, String destinationPath, String owner) throws NodeException {
        this.deepMergeFolder(srcFolder, destinationPath, owner, false);
    }

    public void deepMergeFolder(Folder srcFolder, String destinationPath, String owner, boolean copyIds) throws NodeException {
        PageManagerUtils.deepMergeFolder((PageManager)this, srcFolder, destinationPath, owner, copyIds);
    }

    public Page getUserPage(String userName, String pageName) throws PageNotFoundException, NodeException {
        return this.getPage("/_user/" + userName + "/" + pageName);
    }

    public Folder getUserFolder(String userName) throws FolderNotFoundException, InvalidFolderException, NodeException {
        return this.getFolder("/_user/" + userName);
    }

    public boolean folderExists(String folderName) {
        try {
            this.getFolder(folderName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean pageExists(String pageName) {
        try {
            this.getPage(pageName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean linkExists(String linkName) {
        try {
            this.getLink(linkName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean userFolderExists(String userName) {
        try {
            this.getFolder("/_user/" + userName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean userPageExists(String userName, String pageName) {
        try {
            this.getPage("/_user/" + userName + "/" + pageName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void createUserHomePagesFromRoles(Subject subject) throws NodeException {
        PageManagerUtils.createUserHomePagesFromRoles(this, subject);
    }
}

