/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.psml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.SecurityConstraintImpl;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;

public class SecurityConstraintsImpl
implements SecurityConstraints {
    private static final Log log = LogFactory.getLog((Class)SecurityConstraintsImpl.class);
    private String owner;
    private List constraints;
    private List constraintsRefs;
    private List allConstraints;

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List getSecurityConstraints() {
        if (this.constraints == null) {
            this.constraints = Collections.synchronizedList(new ArrayList());
        }
        return this.constraints;
    }

    public void setSecurityConstraints(List constraints) {
        this.constraints = constraints;
    }

    public List getSecurityConstraintsRefs() {
        if (this.constraintsRefs == null) {
            this.constraintsRefs = Collections.synchronizedList(new ArrayList());
        }
        return this.constraintsRefs;
    }

    public void setSecurityConstraintsRefs(List constraintsRefs) {
        this.constraintsRefs = constraintsRefs;
    }

    public boolean isEmpty() {
        return this.owner == null && this.constraints == null && this.constraintsRefs == null;
    }

    public void checkConstraints(List actions, List userPrincipals, List rolePrincipals, List groupPrincipals, PageSecurity pageSecurity) throws SecurityException {
        if (this.owner != null && userPrincipals != null && userPrincipals.contains(this.owner)) {
            return;
        }
        List checkConstraints = this.getAllSecurityConstraints(pageSecurity);
        if (checkConstraints != null && !checkConstraints.isEmpty()) {
            Iterator actionsIter = actions.iterator();
            while (actionsIter.hasNext()) {
                String action = (String)actionsIter.next();
                boolean actionPermitted = false;
                boolean actionNotPermitted = false;
                boolean anyActionsPermitted = false;
                Iterator checkConstraintsIter = checkConstraints.iterator();
                while (checkConstraintsIter.hasNext()) {
                    SecurityConstraintImpl constraint = (SecurityConstraintImpl)checkConstraintsIter.next();
                    if (constraint.getPermissions() != null) {
                        anyActionsPermitted = true;
                        if (!constraint.actionMatch(action) || !constraint.principalsMatch(userPrincipals, rolePrincipals, groupPrincipals, true)) continue;
                        actionPermitted = true;
                        break;
                    }
                    if (!constraint.principalsMatch(userPrincipals, rolePrincipals, groupPrincipals, false)) continue;
                    actionNotPermitted = true;
                    break;
                }
                if ((actionPermitted || !anyActionsPermitted) && !actionNotPermitted) continue;
                throw new SecurityException("SecurityConstraintsImpl.checkConstraints(): Access for " + action + " not permitted.");
            }
        }
    }

    private synchronized List getAllSecurityConstraints(PageSecurity pageSecurity) {
        List referencedConstraints;
        List globalConstraintsRefs;
        List referencedConstraints2;
        if (this.allConstraints != null) {
            return this.allConstraints;
        }
        this.allConstraints = Collections.synchronizedList(new ArrayList(8));
        if (this.constraints != null) {
            this.allConstraints.addAll(this.constraints);
        }
        if (this.constraintsRefs != null && !this.constraintsRefs.isEmpty() && (referencedConstraints2 = this.dereferenceSecurityConstraintsRefs(this.constraintsRefs, pageSecurity)) != null) {
            this.allConstraints.addAll(referencedConstraints2);
        }
        if (pageSecurity != null && (globalConstraintsRefs = pageSecurity.getGlobalSecurityConstraintsRefs()) != null && !globalConstraintsRefs.isEmpty() && (referencedConstraints = this.dereferenceSecurityConstraintsRefs(globalConstraintsRefs, pageSecurity)) != null) {
            this.allConstraints.addAll(referencedConstraints);
        }
        return this.allConstraints;
    }

    private List dereferenceSecurityConstraintsRefs(List constraintsRefs, PageSecurity pageSecurity) {
        List constraints = null;
        if (pageSecurity != null) {
            Iterator constraintsRefsIter = constraintsRefs.iterator();
            while (constraintsRefsIter.hasNext()) {
                String constraintsRef = (String)constraintsRefsIter.next();
                SecurityConstraintsDef securityConstraintsDef = pageSecurity.getSecurityConstraintsDef(constraintsRef);
                if (securityConstraintsDef != null && securityConstraintsDef.getSecurityConstraints() != null) {
                    if (constraints == null) {
                        constraints = Collections.synchronizedList(new ArrayList(constraintsRefs.size()));
                    }
                    constraints.addAll(securityConstraintsDef.getSecurityConstraints());
                    continue;
                }
                log.error((Object)("dereferenceSecurityConstraintsRefs(): Unable to dereference \"" + constraintsRef + "\" security constraints definition."));
            }
        } else {
            log.error((Object)"dereferenceSecurityConstraintsRefs(): Missing page security, unable to dereference security constraints definitions.");
        }
        return constraints;
    }
}

