/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.psml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.MenuExcludeDefinition;
import org.apache.jetspeed.om.folder.MenuIncludeDefinition;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.folder.MenuSeparatorDefinition;
import org.apache.jetspeed.om.folder.psml.MenuDefinitionImpl;
import org.apache.jetspeed.om.folder.psml.MenuExcludeDefinitionImpl;
import org.apache.jetspeed.om.folder.psml.MenuIncludeDefinitionImpl;
import org.apache.jetspeed.om.folder.psml.MenuOptionsDefinitionImpl;
import org.apache.jetspeed.om.folder.psml.MenuSeparatorDefinitionImpl;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.psml.DefaultsImpl;
import org.apache.jetspeed.om.page.psml.DocumentImpl;
import org.apache.jetspeed.om.page.psml.FragmentImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

public class PageImpl
extends DocumentImpl
implements Page {
    private DefaultsImpl defaults = new DefaultsImpl();
    private Fragment root = null;
    private int hashCode;
    private List menuDefinitions;

    public void setId(String id) {
        this.hashCode = (Page.class.getName() + ":" + id).hashCode();
        super.setId(id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Page) {
            Page page = (Page)obj;
            return page != null && page.getId() != null && this.getId() != null && this.getId().equals(page.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getSkin() {
        return this.defaults.getSkin();
    }

    public void setSkin(String skinName) {
        this.defaults.setSkin(skinName);
    }

    public String getEffectiveDefaultDecorator(String fragmentType) {
        Folder parentFolder;
        String decorator = this.getDefaultDecorator(fragmentType);
        if (decorator == null && (parentFolder = (Folder)this.getParent()) != null) {
            return parentFolder.getEffectiveDefaultDecorator(fragmentType);
        }
        return decorator;
    }

    public String getDefaultDecorator(String fragmentType) {
        return this.defaults.getDecorator(fragmentType);
    }

    public void setDefaultDecorator(String decoratorName, String fragmentType) {
        this.defaults.setDecorator(fragmentType, decoratorName);
    }

    public Fragment getRootFragment() {
        return this.root;
    }

    public void setRootFragment(Fragment root) {
        this.root = root;
        if (root instanceof FragmentImpl) {
            ((FragmentImpl)root).setPage(this);
        }
    }

    public Fragment getFragmentById(String id) {
        Stack<Object> stack = new Stack<Object>();
        if (this.getRootFragment() != null) {
            stack.push(this.getRootFragment());
        }
        Fragment f = (Fragment)stack.pop();
        while (f != null && !f.getId().equals(id)) {
            Iterator i = f.getFragments().iterator();
            while (i.hasNext()) {
                stack.push(i.next());
            }
            if (stack.size() > 0) {
                f = (Fragment)stack.pop();
                continue;
            }
            f = null;
        }
        return f;
    }

    public Fragment removeFragmentById(String id) {
        HashMap<Fragment, Fragment> parents = new HashMap<Fragment, Fragment>();
        Stack<Fragment> stack = new Stack<Fragment>();
        if (this.getRootFragment() != null) {
            stack.push(this.getRootFragment());
        }
        Fragment f = (Fragment)stack.pop();
        while (f != null && !f.getId().equals(id)) {
            Iterator i = f.getFragments().iterator();
            while (i.hasNext()) {
                Fragment child = (Fragment)i.next();
                stack.push(child);
                parents.put(child, f);
            }
            if (stack.size() > 0) {
                f = (Fragment)stack.pop();
                continue;
            }
            f = null;
        }
        if (f != null) {
            Fragment parent = (Fragment)parents.get(f);
            if (parent != null) {
                if (parent.getFragments().remove(f)) {
                    return f;
                }
            } else if (f == this.root) {
                this.root = null;
                return f;
            }
        }
        return null;
    }

    public List getFragmentsByName(String name) {
        List fragments = DatabasePageManagerUtils.createList();
        Stack<Object> stack = new Stack<Object>();
        if (this.getRootFragment() != null) {
            stack.push(this.getRootFragment());
        }
        Fragment f = (Fragment)stack.pop();
        while (f != null) {
            if (f.getName() != null && f.getName().equals(name)) {
                fragments.add(f);
            }
            Iterator i = f.getFragments().iterator();
            while (i.hasNext()) {
                stack.push(i.next());
            }
            if (stack.size() > 0) {
                f = (Fragment)stack.pop();
                continue;
            }
            f = null;
        }
        return fragments;
    }

    public DefaultsImpl getDefaults() {
        return this.defaults;
    }

    public void setDefaults(DefaultsImpl defaults) {
        this.defaults = defaults;
    }

    public String getType() {
        return ".psml";
    }

    public List getMenuDefinitions() {
        return this.menuDefinitions;
    }

    public MenuDefinition newMenuDefinition() {
        return new MenuDefinitionImpl();
    }

    public MenuExcludeDefinition newMenuExcludeDefinition() {
        return new MenuExcludeDefinitionImpl();
    }

    public MenuIncludeDefinition newMenuIncludeDefinition() {
        return new MenuIncludeDefinitionImpl();
    }

    public MenuOptionsDefinition newMenuOptionsDefinition() {
        return new MenuOptionsDefinitionImpl();
    }

    public MenuSeparatorDefinition newMenuSeparatorDefinition() {
        return new MenuSeparatorDefinitionImpl();
    }

    public void setMenuDefinitions(List definitions) {
        this.menuDefinitions = definitions;
    }

    public boolean unmarshalled(IdGenerator generator) {
        boolean dirty = super.unmarshalled(generator);
        if (this.menuDefinitions != null) {
            Iterator menuIter = this.menuDefinitions.iterator();
            while (menuIter.hasNext()) {
                ((MenuDefinitionImpl)menuIter.next()).unmarshalled();
            }
        }
        if (this.root != null) {
            boolean bl = dirty = ((FragmentImpl)this.root).unmarshalled(generator) || dirty;
        }
        if (this.getTitle() == null) {
            this.setTitle(this.getTitleName());
        }
        return dirty;
    }

    public void marshalling() {
        if (this.root != null) {
            ((FragmentImpl)this.root).marshalling();
        }
        if (this.menuDefinitions != null) {
            Iterator menuIter = this.menuDefinitions.iterator();
            while (menuIter.hasNext()) {
                ((MenuDefinitionImpl)menuIter.next()).marshalling();
            }
        }
        super.marshalling();
    }
}

