/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.psml;

import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.common.SecuredResource;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.page.BaseElement;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.SecurityConstraintImpl;
import org.apache.jetspeed.om.page.psml.SecurityConstraintsImpl;
import org.apache.jetspeed.page.document.DocumentHandlerFactory;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.psml.NodeSetImpl;
import org.apache.jetspeed.security.FolderPermission;
import org.apache.jetspeed.security.GroupPrincipal;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.security.PagePermission;
import org.apache.jetspeed.security.PortalResourcePermission;
import org.apache.jetspeed.security.RolePrincipal;
import org.apache.jetspeed.security.UserPrincipal;

public abstract class AbstractBaseElement
implements Serializable,
SecuredResource {
    private static final Log log = LogFactory.getLog((Class)AbstractBaseElement.class);
    private String id = null;
    private String title = null;
    private String shortTitle = null;
    private boolean constraintsEnabled;
    private SecurityConstraints constraints = null;
    private boolean permissionsEnabled;
    private DocumentHandlerFactory handlerFactory = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getShortTitle() {
        String title = this.shortTitle;
        if (title == null) {
            title = this.title;
        }
        return title;
    }

    public void setShortTitle(String title) {
        this.shortTitle = title;
    }

    public boolean getConstraintsEnabled() {
        return this.constraintsEnabled;
    }

    public void setConstraintsEnabled(boolean enabled) {
        this.constraintsEnabled = enabled;
    }

    public SecurityConstraints getSecurityConstraints() {
        return this.constraints;
    }

    public SecurityConstraints newSecurityConstraints() {
        return new SecurityConstraintsImpl();
    }

    public SecurityConstraint newSecurityConstraint() {
        return new SecurityConstraintImpl();
    }

    public void setSecurityConstraints(SecurityConstraints constraints) {
        this.constraints = constraints;
    }

    public void checkConstraints(String actions) throws SecurityException {
        Subject subject;
        if (!this.getConstraintsEnabled()) {
            return;
        }
        if (actions == null) {
            throw new SecurityException("AbstractBaseElement.checkConstraints(): No actions specified.");
        }
        ArrayList<String> viewActionList = SecurityConstraintImpl.parseCSVList(actions);
        ArrayList<String> otherActionsList = null;
        if (viewActionList.size() == 1) {
            if (!viewActionList.contains(JetspeedActions.VIEW)) {
                otherActionsList = viewActionList;
                viewActionList = null;
            }
        } else {
            otherActionsList = viewActionList;
            viewActionList = null;
            if (otherActionsList.remove(JetspeedActions.VIEW)) {
                viewActionList = new ArrayList<String>(1);
                viewActionList.add(JetspeedActions.VIEW);
            }
        }
        if ((subject = JSSubject.getSubject((AccessControlContext)AccessController.getContext())) == null) {
            throw new SecurityException("AbstractBaseElement.checkConstraints(): Missing JSSubject");
        }
        LinkedList<String> userPrincipals = null;
        LinkedList<String> rolePrincipals = null;
        LinkedList<String> groupPrincipals = null;
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal principal = principals.next();
            if (principal instanceof UserPrincipal) {
                if (userPrincipals == null) {
                    userPrincipals = new LinkedList<String>();
                }
                userPrincipals.add(principal.getName());
                continue;
            }
            if (principal instanceof RolePrincipal) {
                if (rolePrincipals == null) {
                    rolePrincipals = new LinkedList<String>();
                }
                rolePrincipals.add(principal.getName());
                continue;
            }
            if (!(principal instanceof GroupPrincipal)) continue;
            if (groupPrincipals == null) {
                groupPrincipals = new LinkedList<String>();
            }
            groupPrincipals.add(principal.getName());
        }
        if (viewActionList != null) {
            this.checkConstraints(viewActionList, userPrincipals, rolePrincipals, groupPrincipals, false, this.grantViewActionAccess());
        }
        if (otherActionsList != null) {
            this.checkConstraints(otherActionsList, userPrincipals, rolePrincipals, groupPrincipals, true, false);
        }
    }

    public void checkConstraints(List actions, List userPrincipals, List rolePrincipals, List groupPrincipals, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        if (this.constraints != null && !this.constraints.isEmpty()) {
            ((SecurityConstraintsImpl)this.constraints).checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, this.getEffectivePageSecurity());
        }
    }

    public boolean getPermissionsEnabled() {
        return this.permissionsEnabled;
    }

    public void setPermissionsEnabled(boolean enabled) {
        this.permissionsEnabled = enabled;
    }

    public void checkPermissions(int mask) throws SecurityException {
        if (!this.getPermissionsEnabled()) {
            return;
        }
        boolean viewAction = (mask & 8) == 8;
        int otherMask = mask & 0xFFFFFFF7;
        if (viewAction) {
            this.checkPermissions(8, false, this.grantViewActionAccess());
        }
        if (otherMask != 0) {
            this.checkPermissions(otherMask, true, false);
        }
    }

    public void checkPermissions(int mask, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        String physicalPermissionPath = this.getPhysicalPermissionPath();
        if (physicalPermissionPath != null) {
            try {
                this.checkPermissions(physicalPermissionPath, mask, checkNodeOnly, checkParentsOnly);
            }
            catch (SecurityException physicalSE) {
                String logicalPermissionPath = this.getLogicalPermissionPath();
                if (logicalPermissionPath != null && !logicalPermissionPath.equals(physicalPermissionPath)) {
                    this.checkPermissions(logicalPermissionPath, mask, checkNodeOnly, checkParentsOnly);
                }
                throw physicalSE;
            }
        }
    }

    public void checkPermissions(String path, int mask, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        try {
            PagePermission permission = new PagePermission(path, mask);
            AccessController.checkPermission((Permission)permission);
        }
        catch (SecurityException se) {
            FolderPermission permission = new FolderPermission(path, mask);
            AccessController.checkPermission((Permission)permission);
        }
    }

    public String getLogicalPermissionPath() {
        return this.getPhysicalPermissionPath();
    }

    public String getPhysicalPermissionPath() {
        log.warn((Object)("getPhysicalPermissionPath(): no permission path available for " + this + " element."));
        return null;
    }

    public void checkAccess(String actions) throws SecurityException {
        if (this.getPermissionsEnabled()) {
            int mask = PortalResourcePermission.parseActions((String)actions);
            this.checkPermissions(mask);
        }
        if (this.getConstraintsEnabled()) {
            this.checkConstraints(actions);
        }
    }

    public boolean grantViewActionAccess() {
        return false;
    }

    public PageSecurity getEffectivePageSecurity() {
        return null;
    }

    public DocumentHandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    public void setHandlerFactory(DocumentHandlerFactory factory) {
        this.handlerFactory = factory;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseElement) {
            AbstractBaseElement element = (AbstractBaseElement)obj;
            return this.id != null && element.getId() != null && this.id.equals(element.getId());
        }
        return false;
    }

    public int hashCode() {
        return null != this.id ? this.id.hashCode() : -1;
    }

    public String toString() {
        return this.getId();
    }

    public static NodeSet checkAccess(NodeSet nodes, String actions) {
        if (nodes != null && !nodes.isEmpty()) {
            NodeSetImpl filteredNodes = null;
            Iterator checkAccessIter = nodes.iterator();
            while (checkAccessIter.hasNext()) {
                AbstractBaseElement node = (AbstractBaseElement)checkAccessIter.next();
                try {
                    node.checkAccess(actions);
                    if (filteredNodes == null) continue;
                    filteredNodes.add((Node)node);
                }
                catch (SecurityException se) {
                    Node copyNode;
                    if (filteredNodes != null) continue;
                    filteredNodes = new NodeSetImpl(null, ((NodeSetImpl)nodes).getComparator());
                    Iterator copyIter = nodes.iterator();
                    while (copyIter.hasNext() && (copyNode = (Node)copyIter.next()) != node) {
                        filteredNodes.add(copyNode);
                    }
                }
            }
            if (filteredNodes != null) {
                return filteredNodes;
            }
        }
        return nodes;
    }

    public boolean unmarshalled(IdGenerator generator) {
        return false;
    }

    public void marshalling() {
    }
}

