/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.SecurityConstraintImpl;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.page.impl.SecurityConstraintList;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsRefList;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

public class SecurityConstraintsImpl
implements SecurityConstraints {
    private String owner;
    private List constraints;
    private List constraintsRefs;
    private SecurityConstraintList securityConstraints;
    private SecurityConstraintsRefList securityConstraintsRefs;
    private List allConstraints;

    List accessConstraintsRefs() {
        if (this.constraintsRefs == null) {
            this.constraintsRefs = DatabasePageManagerUtils.createList();
        }
        return this.constraintsRefs;
    }

    List accessConstraints() {
        if (this.constraints == null) {
            this.constraints = DatabasePageManagerUtils.createList();
        }
        return this.constraints;
    }

    public Class getSecurityConstraintClass() {
        return null;
    }

    public Class getSecurityConstraintsRefClass() {
        return null;
    }

    public void checkConstraints(List actions, List userPrincipals, List rolePrincipals, List groupPrincipals, PageSecurity pageSecurity) throws SecurityException {
        if (this.owner != null && userPrincipals != null && userPrincipals.contains(this.owner)) {
            return;
        }
        List checkConstraints = this.getAllSecurityConstraints(pageSecurity);
        if (checkConstraints != null && !checkConstraints.isEmpty()) {
            Iterator actionsIter = actions.iterator();
            while (actionsIter.hasNext()) {
                String action = (String)actionsIter.next();
                boolean actionPermitted = false;
                boolean actionNotPermitted = false;
                boolean anyActionsPermitted = this.getOwner() != null;
                Iterator checkConstraintsIter = checkConstraints.iterator();
                while (checkConstraintsIter.hasNext()) {
                    SecurityConstraintImpl constraint = (SecurityConstraintImpl)checkConstraintsIter.next();
                    if (constraint.getPermissions() != null) {
                        anyActionsPermitted = true;
                        if (!constraint.actionMatch(action) || !constraint.principalsMatch(userPrincipals, rolePrincipals, groupPrincipals, true)) continue;
                        actionPermitted = true;
                        break;
                    }
                    if (!constraint.principalsMatch(userPrincipals, rolePrincipals, groupPrincipals, false)) continue;
                    actionNotPermitted = true;
                    break;
                }
                if ((actionPermitted || !anyActionsPermitted) && !actionNotPermitted) continue;
                throw new SecurityException("SecurityConstraintsImpl.checkConstraints(): Access for " + action + " not permitted.");
            }
        } else if (this.getOwner() != null && !actions.isEmpty()) {
            String action = (String)actions.get(0);
            throw new SecurityException("SecurityConstraintsImpl.checkConstraints(): Access for " + action + " not permitted, (not owner).");
        }
    }

    public void resetCachedSecurityConstraints() {
        this.clearAllSecurityConstraints();
    }

    private synchronized List getAllSecurityConstraints(PageSecurity pageSecurity) {
        List referencedConstraints;
        List globalConstraintsRefs;
        List referencedConstraints2;
        if (this.allConstraints != null) {
            return this.allConstraints;
        }
        this.allConstraints = DatabasePageManagerUtils.createList();
        if (this.getSecurityConstraints() != null && !this.getSecurityConstraints().isEmpty()) {
            this.allConstraints.addAll(this.securityConstraints);
        }
        if (this.getSecurityConstraintsRefs() != null && !this.getSecurityConstraintsRefs().isEmpty() && (referencedConstraints2 = this.dereferenceSecurityConstraintsRefs(this.getSecurityConstraintsRefs(), pageSecurity)) != null) {
            this.allConstraints.addAll(referencedConstraints2);
        }
        if (pageSecurity != null && (globalConstraintsRefs = pageSecurity.getGlobalSecurityConstraintsRefs()) != null && !globalConstraintsRefs.isEmpty() && (referencedConstraints = this.dereferenceSecurityConstraintsRefs(globalConstraintsRefs, pageSecurity)) != null) {
            this.allConstraints.addAll(referencedConstraints);
        }
        return this.allConstraints;
    }

    synchronized void clearAllSecurityConstraints() {
        this.allConstraints = null;
    }

    private List dereferenceSecurityConstraintsRefs(List constraintsRefs, PageSecurity pageSecurity) {
        List constraints = null;
        if (pageSecurity != null) {
            Iterator constraintsRefsIter = constraintsRefs.iterator();
            while (constraintsRefsIter.hasNext()) {
                String constraintsRef = (String)constraintsRefsIter.next();
                SecurityConstraintsDef securityConstraintsDef = pageSecurity.getSecurityConstraintsDef(constraintsRef);
                if (securityConstraintsDef == null || securityConstraintsDef.getSecurityConstraints() == null) continue;
                if (constraints == null) {
                    constraints = DatabasePageManagerUtils.createList();
                }
                constraints.addAll(securityConstraintsDef.getSecurityConstraints());
            }
        }
        return constraints;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
        this.clearAllSecurityConstraints();
    }

    public List getSecurityConstraints() {
        if (this.securityConstraints == null) {
            this.securityConstraints = new SecurityConstraintList(this);
        }
        return this.securityConstraints;
    }

    public void setSecurityConstraints(List constraints) {
        List securityConstraints = this.getSecurityConstraints();
        if (constraints != securityConstraints) {
            securityConstraints.clear();
            if (constraints != null) {
                securityConstraints.addAll(constraints);
            }
        }
        this.clearAllSecurityConstraints();
    }

    public List getSecurityConstraintsRefs() {
        if (this.securityConstraintsRefs == null) {
            this.securityConstraintsRefs = new SecurityConstraintsRefList(this);
        }
        return this.securityConstraintsRefs;
    }

    public void setSecurityConstraintsRefs(List constraintsRefs) {
        List securityConstraintsRefs = this.getSecurityConstraintsRefs();
        if (constraintsRefs != securityConstraintsRefs) {
            securityConstraintsRefs.clear();
            if (constraintsRefs != null) {
                securityConstraintsRefs.addAll(constraintsRefs);
            }
        }
        this.clearAllSecurityConstraints();
    }

    public boolean isEmpty() {
        return !(this.owner != null || this.constraints != null && !this.constraints.isEmpty() || this.constraintsRefs != null && !this.constraintsRefs.isEmpty());
    }
}

