/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.page.impl.PageSecurityConstraintsDefList;
import org.apache.jetspeed.om.page.impl.PageSecurityConstraintsRefList;
import org.apache.jetspeed.om.page.impl.PageSecuritySecurityConstraintImpl;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsDefImpl;
import org.apache.jetspeed.page.document.impl.DocumentImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

public class PageSecurityImpl
extends DocumentImpl
implements PageSecurity {
    private List constraintsDefs;
    private List globalConstraintsRefs;
    private PageSecurityConstraintsDefList securityConstraintsDefs;
    private Map securityConstraintsDefsMap;
    private PageSecurityConstraintsRefList globalSecurityConstraintsRefs;

    public PageSecurityImpl() {
        super(null);
    }

    List accessConstraintsDefs() {
        if (this.constraintsDefs == null) {
            this.constraintsDefs = DatabasePageManagerUtils.createList();
        }
        return this.constraintsDefs;
    }

    List accessGlobalConstraintsRefs() {
        if (this.globalConstraintsRefs == null) {
            this.globalConstraintsRefs = DatabasePageManagerUtils.createList();
        }
        return this.globalConstraintsRefs;
    }

    synchronized void clearSecurityConstraintsDefsMap() {
        this.securityConstraintsDefsMap = null;
    }

    public SecurityConstraint newSecurityConstraint() {
        return new PageSecuritySecurityConstraintImpl();
    }

    public List getSecurityConstraintsDefs() {
        if (this.securityConstraintsDefs == null) {
            this.securityConstraintsDefs = new PageSecurityConstraintsDefList(this);
        }
        return this.securityConstraintsDefs;
    }

    public SecurityConstraintsDef newSecurityConstraintsDef() {
        return new SecurityConstraintsDefImpl();
    }

    public void setSecurityConstraintsDefs(List definitions) {
        List securityConstraintsDefs = this.getSecurityConstraintsDefs();
        if (definitions != securityConstraintsDefs) {
            securityConstraintsDefs.clear();
            if (definitions != null) {
                securityConstraintsDefs.addAll(definitions);
            }
        }
        this.clearSecurityConstraintsDefsMap();
    }

    public synchronized SecurityConstraintsDef getSecurityConstraintsDef(String name) {
        if (this.getSecurityConstraintsDefs() != null && this.securityConstraintsDefsMap == null) {
            this.securityConstraintsDefsMap = new HashMap(this.getSecurityConstraintsDefs().size() * 2 + 1);
            Iterator definitionsIter = this.getSecurityConstraintsDefs().iterator();
            while (definitionsIter.hasNext()) {
                SecurityConstraintsDef definition = (SecurityConstraintsDef)definitionsIter.next();
                String definitionName = definition.getName();
                if (this.securityConstraintsDefsMap.containsKey(definitionName)) continue;
                this.securityConstraintsDefsMap.put(definitionName, definition);
            }
        }
        if (this.securityConstraintsDefsMap != null) {
            return (SecurityConstraintsDef)this.securityConstraintsDefsMap.get(name);
        }
        return null;
    }

    public List getGlobalSecurityConstraintsRefs() {
        if (this.globalSecurityConstraintsRefs == null) {
            this.globalSecurityConstraintsRefs = new PageSecurityConstraintsRefList(this);
        }
        return this.globalSecurityConstraintsRefs;
    }

    public void setGlobalSecurityConstraintsRefs(List constraintsRefs) {
        List globalSecurityConstraintsRefs = this.getGlobalSecurityConstraintsRefs();
        if (constraintsRefs != globalSecurityConstraintsRefs) {
            globalSecurityConstraintsRefs.clear();
            if (constraintsRefs != null) {
                globalSecurityConstraintsRefs.addAll(constraintsRefs);
            }
        }
    }

    public String getType() {
        return "page.security";
    }
}

