/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.AbstractList;
import java.util.List;
import org.apache.jetspeed.om.page.impl.PageSecurityImpl;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsDefImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

class PageSecurityConstraintsDefList
extends AbstractList {
    private PageSecurityImpl pageSecurity;
    private List removedConstraintsDefs;

    PageSecurityConstraintsDefList(PageSecurityImpl pageSecurity) {
        this.pageSecurity = pageSecurity;
    }

    private SecurityConstraintsDefImpl validateConstraintsDefForAdd(SecurityConstraintsDefImpl constraintsDef) {
        int removedIndex;
        if (constraintsDef == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        if (this.pageSecurity.accessConstraintsDefs().contains(constraintsDef)) {
            throw new IllegalArgumentException("Unable to add duplicate entry to list: " + constraintsDef.getName());
        }
        if (this.removedConstraintsDefs != null && (removedIndex = this.removedConstraintsDefs.indexOf(constraintsDef)) >= 0) {
            SecurityConstraintsDefImpl addConstraintsDef = constraintsDef;
            constraintsDef = (SecurityConstraintsDefImpl)this.removedConstraintsDefs.remove(removedIndex);
            constraintsDef.setSecurityConstraints(addConstraintsDef.getSecurityConstraints());
        }
        return constraintsDef;
    }

    private List getRemovedConstraintsDefs() {
        if (this.removedConstraintsDefs == null) {
            this.removedConstraintsDefs = DatabasePageManagerUtils.createList();
        }
        return this.removedConstraintsDefs;
    }

    public void add(int index, Object element) {
        if (index < 0 || index > this.pageSecurity.accessConstraintsDefs().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        SecurityConstraintsDefImpl constraintsDef = this.validateConstraintsDefForAdd((SecurityConstraintsDefImpl)element);
        this.pageSecurity.accessConstraintsDefs().add(index, constraintsDef);
        this.pageSecurity.clearSecurityConstraintsDefsMap();
    }

    public Object get(int index) {
        return this.pageSecurity.accessConstraintsDefs().get(index);
    }

    public Object remove(int index) {
        SecurityConstraintsDefImpl removed = (SecurityConstraintsDefImpl)this.pageSecurity.accessConstraintsDefs().remove(index);
        if (removed != null) {
            this.getRemovedConstraintsDefs().add(removed);
            this.pageSecurity.clearSecurityConstraintsDefsMap();
        }
        return removed;
    }

    public Object set(int index, Object element) {
        SecurityConstraintsDefImpl newConstraintsDef = this.validateConstraintsDefForAdd((SecurityConstraintsDefImpl)element);
        SecurityConstraintsDefImpl constraintsDef = this.pageSecurity.accessConstraintsDefs().set(index, newConstraintsDef);
        this.getRemovedConstraintsDefs().add(constraintsDef);
        this.pageSecurity.clearSecurityConstraintsDefsMap();
        return constraintsDef;
    }

    public int size() {
        return this.pageSecurity.accessConstraintsDefs().size();
    }
}

