/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.AbstractList;
import java.util.List;
import org.apache.jetspeed.om.page.impl.PageImpl;
import org.apache.jetspeed.om.page.impl.PageMenuDefinitionImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

class PageMenuDefinitionList
extends AbstractList {
    private PageImpl page;
    private List removedMenuDefinitions;

    PageMenuDefinitionList(PageImpl page) {
        this.page = page;
    }

    private PageMenuDefinitionImpl validateDefinitionForAdd(PageMenuDefinitionImpl definition) {
        int removedIndex;
        if (definition == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        if (this.page.accessMenus().contains(definition)) {
            throw new IllegalArgumentException("Unable to add duplicate entry to list: " + definition.getName());
        }
        if (this.removedMenuDefinitions != null && (removedIndex = this.removedMenuDefinitions.indexOf(definition)) >= 0) {
            PageMenuDefinitionImpl addDefinition = definition;
            definition = (PageMenuDefinitionImpl)this.removedMenuDefinitions.remove(removedIndex);
            definition.setOptions(addDefinition.getOptions());
            definition.setDepth(addDefinition.getDepth());
            definition.setPaths(addDefinition.isPaths());
            definition.setRegexp(addDefinition.isRegexp());
            definition.setProfile(addDefinition.getProfile());
            definition.setOrder(addDefinition.getOrder());
            definition.setSkin(addDefinition.getSkin());
            definition.setTitle(addDefinition.getTitle());
            definition.setShortTitle(addDefinition.getShortTitle());
            definition.setMenuElements(addDefinition.getMenuElements());
            definition.getMetadata().copyFields(addDefinition.getMetadata().getFields());
        }
        return definition;
    }

    private List getRemovedMenuDefinitions() {
        if (this.removedMenuDefinitions == null) {
            this.removedMenuDefinitions = DatabasePageManagerUtils.createList();
        }
        return this.removedMenuDefinitions;
    }

    public void add(int index, Object element) {
        if (index < 0 || index > this.page.accessMenus().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        PageMenuDefinitionImpl definition = this.validateDefinitionForAdd((PageMenuDefinitionImpl)element);
        this.page.accessMenus().add(index, definition);
    }

    public Object get(int index) {
        return this.page.accessMenus().get(index);
    }

    public Object remove(int index) {
        PageMenuDefinitionImpl removed = (PageMenuDefinitionImpl)this.page.accessMenus().remove(index);
        if (removed != null) {
            this.getRemovedMenuDefinitions().add(removed);
        }
        return removed;
    }

    public Object set(int index, Object element) {
        PageMenuDefinitionImpl newDefinition = this.validateDefinitionForAdd((PageMenuDefinitionImpl)element);
        PageMenuDefinitionImpl definition = this.page.accessMenus().set(index, newDefinition);
        this.getRemovedMenuDefinitions().add(definition);
        return definition;
    }

    public int size() {
        return this.page.accessMenus().size();
    }
}

