/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.page.BaseElement;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.SecurityConstraintImpl;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;
import org.apache.jetspeed.security.FolderPermission;
import org.apache.jetspeed.security.GroupPrincipal;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.security.PagePermission;
import org.apache.jetspeed.security.PortalResourcePermission;
import org.apache.jetspeed.security.RolePrincipal;
import org.apache.jetspeed.security.UserPrincipal;

public abstract class BaseElementImpl
implements BaseElement {
    private int id;
    private String name;
    private String title;
    private String shortTitle;
    private SecurityConstraintsImpl constraints;
    private boolean constraintsEnabled;
    private boolean permissionsEnabled;

    protected BaseElementImpl(SecurityConstraintsImpl constraints) {
        this.constraints = constraints;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConstraintsEnabled(boolean enabled) {
        this.constraintsEnabled = enabled;
    }

    public void setPermissionsEnabled(boolean enabled) {
        this.permissionsEnabled = enabled;
    }

    public boolean grantViewActionAccess() {
        return false;
    }

    public PageSecurity getEffectivePageSecurity() {
        return null;
    }

    public void checkConstraints(List actions, List userPrincipals, List rolePrincipals, List groupPrincipals, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        if (this.constraints != null && !this.constraints.isEmpty()) {
            this.constraints.checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, this.getEffectivePageSecurity());
        }
    }

    public String getLogicalPermissionPath() {
        return this.getPhysicalPermissionPath();
    }

    public String getPhysicalPermissionPath() {
        return null;
    }

    public void checkPermissions(int mask, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        String physicalPermissionPath = this.getPhysicalPermissionPath();
        if (physicalPermissionPath != null) {
            try {
                this.checkPermissions(physicalPermissionPath, mask, checkNodeOnly, checkParentsOnly);
            }
            catch (SecurityException physicalSE) {
                String logicalPermissionPath = this.getLogicalPermissionPath();
                if (logicalPermissionPath != null && !logicalPermissionPath.equals(physicalPermissionPath)) {
                    this.checkPermissions(logicalPermissionPath, mask, checkNodeOnly, checkParentsOnly);
                }
                throw physicalSE;
            }
        }
    }

    public void checkPermissions(String path, int mask, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        try {
            PagePermission permission = new PagePermission(path, mask);
            AccessController.checkPermission((Permission)permission);
        }
        catch (SecurityException se) {
            FolderPermission permission = new FolderPermission(path, mask);
            AccessController.checkPermission((Permission)permission);
        }
    }

    public boolean getConstraintsEnabled() {
        return this.constraintsEnabled;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass()) && this.id != 0 && this.id == ((BaseElementImpl)o).id;
    }

    public int hashCode() {
        return this.id;
    }

    public SecurityConstraints getSecurityConstraints() {
        return this.constraints;
    }

    public SecurityConstraints newSecurityConstraints() {
        return new SecurityConstraintsImpl();
    }

    public SecurityConstraint newSecurityConstraint() {
        if (this.constraints != null && this.constraints.getSecurityConstraintClass() != null) {
            try {
                return (SecurityConstraintImpl)this.constraints.getSecurityConstraintClass().newInstance();
            }
            catch (InstantiationException ie) {
                throw new ClassCastException("Unable to create security constraint instance: " + this.constraints.getSecurityConstraintClass().getName() + ", (" + ie + ").");
            }
            catch (IllegalAccessException iae) {
                throw new ClassCastException("Unable to create security constraint instance: " + this.constraints.getSecurityConstraintClass().getName() + ", (" + iae + ").");
            }
        }
        return new SecurityConstraintImpl();
    }

    public void setSecurityConstraints(SecurityConstraints constraints) {
        if (this.constraints != null) {
            this.constraints.setOwner(constraints.getOwner());
            this.constraints.setSecurityConstraints(constraints.getSecurityConstraints());
            this.constraints.setSecurityConstraintsRefs(constraints.getSecurityConstraintsRefs());
        }
    }

    public void checkConstraints(String actions) throws SecurityException {
        Subject subject;
        if (!this.getConstraintsEnabled()) {
            return;
        }
        if (actions == null) {
            throw new SecurityException("BaseElementImpl.checkConstraints(): No actions specified.");
        }
        List viewActionList = SecurityConstraintImpl.parseCSVList(actions);
        List otherActionsList = null;
        if (viewActionList.size() == 1) {
            if (!viewActionList.contains(JetspeedActions.VIEW)) {
                otherActionsList = viewActionList;
                viewActionList = null;
            }
        } else {
            otherActionsList = viewActionList;
            viewActionList = null;
            if (otherActionsList.remove(JetspeedActions.VIEW)) {
                viewActionList = DatabasePageManagerUtils.createList();
                viewActionList.add(JetspeedActions.VIEW);
            }
        }
        if ((subject = JSSubject.getSubject((AccessControlContext)AccessController.getContext())) == null) {
            throw new SecurityException("BaseElementImpl.checkConstraints(): Missing JSSubject.");
        }
        LinkedList<String> userPrincipals = null;
        LinkedList<String> rolePrincipals = null;
        LinkedList<String> groupPrincipals = null;
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal principal = principals.next();
            if (principal instanceof UserPrincipal) {
                if (userPrincipals == null) {
                    userPrincipals = new LinkedList<String>();
                }
                userPrincipals.add(principal.getName());
                continue;
            }
            if (principal instanceof RolePrincipal) {
                if (rolePrincipals == null) {
                    rolePrincipals = new LinkedList<String>();
                }
                rolePrincipals.add(principal.getName());
                continue;
            }
            if (!(principal instanceof GroupPrincipal)) continue;
            if (groupPrincipals == null) {
                groupPrincipals = new LinkedList<String>();
            }
            groupPrincipals.add(principal.getName());
        }
        if (viewActionList != null) {
            this.checkConstraints(viewActionList, userPrincipals, rolePrincipals, groupPrincipals, false, this.grantViewActionAccess());
        }
        if (otherActionsList != null) {
            this.checkConstraints(otherActionsList, userPrincipals, rolePrincipals, groupPrincipals, true, false);
        }
    }

    public void resetCachedSecurityConstraints() {
        if (this.constraints != null) {
            this.constraints.resetCachedSecurityConstraints();
        }
    }

    public boolean getPermissionsEnabled() {
        return this.permissionsEnabled;
    }

    public void checkPermissions(int mask) throws SecurityException {
        if (!this.getPermissionsEnabled()) {
            return;
        }
        boolean viewAction = (mask & 8) == 8;
        int otherMask = mask & 0xFFFFFFF7;
        if (viewAction) {
            this.checkPermissions(8, false, this.grantViewActionAccess());
        }
        if (otherMask != 0) {
            this.checkPermissions(otherMask, true, false);
        }
    }

    public void checkAccess(String actions) throws SecurityException {
        if (this.getPermissionsEnabled()) {
            int mask = PortalResourcePermission.parseActions((String)actions);
            this.checkPermissions(mask);
        }
        if (this.getConstraintsEnabled()) {
            this.checkConstraints(actions);
        }
    }

    public String getId() {
        return Integer.toString(this.getIdentity());
    }

    public int getIdentity() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }
}

