/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.jetspeed.om.common.LocalizedField;
import org.apache.jetspeed.om.impl.GenericMetadataImpl;
import org.apache.jetspeed.om.page.PageLocalizedFieldImpl;
import org.apache.jetspeed.util.ArgUtil;

public class PageMetadataImpl
extends GenericMetadataImpl {
    private Class fieldImplClass = PageLocalizedFieldImpl.class;
    private Map localizedText;

    public PageMetadataImpl() {
    }

    public PageMetadataImpl(Class fieldImplClass) {
        this();
        this.fieldImplClass = fieldImplClass;
    }

    public LocalizedField createLocalizedField() {
        try {
            return (LocalizedField)this.fieldImplClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create LocalizedField object: " + this.fieldImplClass.getName(), e);
        }
    }

    public String getText(String name, Locale locale) {
        Collection fields;
        ArgUtil.assertNotNull((Class)String.class, (Object)name, (Object)((Object)this), (String)"getText(String, Locale)");
        ArgUtil.assertNotNull((Class)Locale.class, (Object)locale, (Object)((Object)this), (String)"getText(String, Locale)");
        HashMap<Locale, LocalizedField> namedLocalizedText = this.localizedText != null ? this.localizedText.get(name) : null;
        if (namedLocalizedText == null && this.getFields() != null && (fields = this.getFields(name)) != null) {
            if (this.localizedText == null) {
                this.localizedText = Collections.synchronizedMap(new HashMap(this.getFields().size()));
            }
            namedLocalizedText = new HashMap<Locale, LocalizedField>(this.getFields().size());
            this.localizedText.put(name, namedLocalizedText);
            Iterator fieldsItr = fields.iterator();
            while (fieldsItr.hasNext()) {
                LocalizedField field = (LocalizedField)fieldsItr.next();
                namedLocalizedText.put(field.getLocale(), field);
            }
        }
        if (namedLocalizedText != null) {
            if (namedLocalizedText.containsKey(locale)) {
                return ((LocalizedField)namedLocalizedText.get(locale)).getValue().trim();
            }
            Locale languageOnly = new Locale(locale.getLanguage());
            if (namedLocalizedText.containsKey(languageOnly)) {
                return ((LocalizedField)namedLocalizedText.get(languageOnly)).getValue().trim();
            }
        }
        return null;
    }
}

