/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.folder.impl;

import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.MenuExcludeDefinition;
import org.apache.jetspeed.om.folder.MenuIncludeDefinition;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.folder.MenuSeparatorDefinition;
import org.apache.jetspeed.om.folder.impl.FolderMenuDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuDefinitionList;
import org.apache.jetspeed.om.folder.impl.FolderMenuExcludeDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuIncludeDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuOptionsDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMenuSeparatorDefinitionImpl;
import org.apache.jetspeed.om.folder.impl.FolderMetadataLocalizedFieldImpl;
import org.apache.jetspeed.om.folder.impl.FolderOrderList;
import org.apache.jetspeed.om.folder.impl.FolderSecurityConstraintsImpl;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageMetadataImpl;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.impl.LinkImpl;
import org.apache.jetspeed.om.page.impl.PageImpl;
import org.apache.jetspeed.om.page.impl.PageSecurityImpl;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.DocumentException;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.impl.NodeImpl;
import org.apache.jetspeed.page.document.impl.NodeSetImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;
import org.apache.jetspeed.security.FolderPermission;
import org.apache.ojb.broker.core.proxy.ProxyHelper;

public class FolderImpl
extends NodeImpl
implements Folder {
    private String defaultPage;
    private String skin;
    private String defaultLayoutDecorator;
    private String defaultPortletDecorator;
    private List orders;
    private List menus;
    private PageManager pageManager;
    private List folders;
    private boolean foldersCached;
    private List pages;
    private boolean pagesCached;
    private List links;
    private boolean linksCached;
    private PageSecurityImpl pageSecurity;
    private boolean pageSecurityCached;
    private List all;
    private boolean allCached;
    private FolderOrderList documentOrder;
    private boolean documentOrderComparatorValid;
    private Comparator documentOrderComparator;
    private NodeSet foldersNodeSet;
    private NodeSet pagesNodeSet;
    private NodeSet linksNodeSet;
    private NodeSet allNodeSet;
    private FolderMenuDefinitionList menuDefinitions;

    public FolderImpl() {
        super(new FolderSecurityConstraintsImpl());
    }

    List accessFolderOrders() {
        if (this.orders == null) {
            this.orders = DatabasePageManagerUtils.createList();
        }
        return this.orders;
    }

    List accessMenus() {
        if (this.menus == null) {
            this.menus = DatabasePageManagerUtils.createList();
        }
        return this.menus;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public List accessFolders() {
        if (this.folders == null) {
            this.folders = DatabasePageManagerUtils.createList();
        }
        return this.folders;
    }

    public void resetFolders(boolean cached) {
        this.foldersCached = cached;
        this.allCached = false;
        if (!cached) {
            this.accessFolders().clear();
        }
        this.accessAll().clear();
        this.foldersNodeSet = null;
        this.allNodeSet = null;
    }

    public List accessPages() {
        if (this.pages == null) {
            this.pages = DatabasePageManagerUtils.createList();
        }
        return this.pages;
    }

    public void resetPages(boolean cached) {
        this.pagesCached = cached;
        this.allCached = false;
        if (!cached) {
            this.accessPages().clear();
        }
        this.accessAll().clear();
        this.pagesNodeSet = null;
        this.allNodeSet = null;
    }

    public List accessLinks() {
        if (this.links == null) {
            this.links = DatabasePageManagerUtils.createList();
        }
        return this.links;
    }

    public void resetLinks(boolean cached) {
        this.linksCached = cached;
        this.allCached = false;
        if (!cached) {
            this.accessLinks().clear();
        }
        this.accessAll().clear();
        this.linksNodeSet = null;
        this.allNodeSet = null;
    }

    public PageSecurityImpl accessPageSecurity() {
        return this.pageSecurity;
    }

    public void resetPageSecurity(PageSecurityImpl newPageSecurity, boolean cached) {
        this.pageSecurity = newPageSecurity;
        this.pageSecurityCached = cached;
        this.allCached = false;
        this.accessAll().clear();
        this.allNodeSet = null;
    }

    public List accessAll() {
        if (this.all == null) {
            this.all = DatabasePageManagerUtils.createList();
        }
        return this.all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAll(boolean cached) {
        this.allCached = cached;
        this.foldersCached = cached;
        this.pagesCached = cached;
        this.linksCached = cached;
        this.pageSecurityCached = cached;
        this.accessFolders().clear();
        this.accessPages().clear();
        this.accessLinks().clear();
        this.pageSecurity = null;
        if (cached) {
            List list = this.all;
            synchronized (list) {
                Iterator nodeIter = this.accessAll().iterator();
                while (nodeIter.hasNext()) {
                    Node node = (Node)nodeIter.next();
                    if (node instanceof PageImpl) {
                        this.pages.add(node);
                        continue;
                    }
                    if (node instanceof FolderImpl) {
                        this.folders.add(node);
                        continue;
                    }
                    if (node instanceof LinkImpl) {
                        this.links.add(node);
                        continue;
                    }
                    if (!(node instanceof PageSecurityImpl)) continue;
                    this.pageSecurity = (PageSecurityImpl)node;
                }
            }
        } else {
            this.accessAll().clear();
        }
        this.allNodeSet = null;
        this.foldersNodeSet = null;
        this.pagesNodeSet = null;
        this.linksNodeSet = null;
    }

    private Comparator createDocumentOrderComparator() {
        if (!this.documentOrderComparatorValid) {
            this.documentOrderComparatorValid = true;
            final List documentOrder = this.getDocumentOrder();
            if (documentOrder == null || documentOrder.isEmpty()) {
                return null;
            }
            this.documentOrderComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    String name2;
                    int index2;
                    String name1 = (String)o1;
                    int index1 = documentOrder.indexOf(name1);
                    if (index1 >= 0) {
                        name1 = String.valueOf(index1);
                    }
                    if ((index2 = documentOrder.indexOf(name2 = (String)o2)) >= 0) {
                        name2 = String.valueOf(index2);
                        if (index1 >= 0) {
                            while (name1.length() != name2.length()) {
                                if (name1.length() < name2.length()) {
                                    name1 = "0" + name1;
                                    continue;
                                }
                                name2 = "0" + name2;
                            }
                        }
                    }
                    return name1.compareTo(name2);
                }
            };
        }
        return this.documentOrderComparator;
    }

    void clearDocumentOrderComparator() {
        this.documentOrderComparatorValid = false;
        this.documentOrderComparator = null;
        this.allNodeSet = null;
        this.foldersNodeSet = null;
        this.pagesNodeSet = null;
    }

    public PageMetadataImpl newPageMetadata(Collection fields) {
        PageMetadataImpl pageMetadata = new PageMetadataImpl(FolderMetadataLocalizedFieldImpl.class);
        pageMetadata.setFields(fields);
        return pageMetadata;
    }

    public PageSecurity getEffectivePageSecurity() {
        block6: {
            if (!this.pageSecurityCached) {
                try {
                    return this.getPageManager().getPageSecurity((Folder)this);
                }
                catch (NodeException ne) {
                    break block6;
                }
                catch (NodeNotFoundException nnfe) {
                    break block6;
                }
            }
            if (this.pageSecurity != null) {
                return this.pageSecurity;
            }
        }
        FolderImpl parentFolderImpl = (FolderImpl)ProxyHelper.getRealObject((Object)this.getParent());
        if (parentFolderImpl != null) {
            return parentFolderImpl.getEffectivePageSecurity();
        }
        return null;
    }

    public void checkPermissions(String path, int mask, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        FolderImpl parentFolderImpl;
        if (!checkParentsOnly) {
            FolderPermission permission = new FolderPermission(path, mask);
            AccessController.checkPermission((Permission)permission);
        }
        if (!checkNodeOnly && (parentFolderImpl = (FolderImpl)ProxyHelper.getRealObject((Object)this.getParent())) != null) {
            parentFolderImpl.checkPermissions(mask, false, false);
        }
    }

    public String getTitle() {
        String title = super.getTitle();
        if (title == null) {
            title = this.defaultTitleFromName();
            this.setTitle(title);
        }
        return title;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String skinName) {
        this.skin = skinName;
    }

    public String getEffectiveDefaultDecorator(String fragmentType) {
        Folder parentFolder;
        String decorator = this.getDefaultDecorator(fragmentType);
        if (decorator == null && (parentFolder = (Folder)ProxyHelper.getRealObject((Object)this.getParent())) != null) {
            return parentFolder.getEffectiveDefaultDecorator(fragmentType);
        }
        return decorator;
    }

    public String getDefaultDecorator(String fragmentType) {
        if (fragmentType != null) {
            if (fragmentType.equals("layout")) {
                return this.defaultLayoutDecorator;
            }
            if (fragmentType.equals("portlet")) {
                return this.defaultPortletDecorator;
            }
        }
        return null;
    }

    public void setDefaultDecorator(String decoratorName, String fragmentType) {
        if (fragmentType != null) {
            if (fragmentType.equals("layout")) {
                this.defaultLayoutDecorator = decoratorName;
            }
            if (fragmentType.equals("portlet")) {
                this.defaultPortletDecorator = decoratorName;
            }
        }
    }

    public List getDocumentOrder() {
        if (this.documentOrder == null) {
            this.documentOrder = new FolderOrderList(this);
        }
        return this.documentOrder;
    }

    public void setDocumentOrder(List docNames) {
        List documentOrder = this.getDocumentOrder();
        if (docNames != documentOrder) {
            documentOrder.clear();
            if (docNames != null) {
                documentOrder.addAll(docNames);
            }
        }
    }

    public String getDefaultPage() {
        return this.defaultPage;
    }

    public void setDefaultPage(String defaultPage) {
        this.defaultPage = defaultPage;
    }

    public NodeSet getFolders() throws DocumentException {
        if (!this.foldersCached) {
            return this.getPageManager().getFolders((Folder)this);
        }
        return FolderImpl.filterNodeSetByAccess(this.getFoldersNodeSet());
    }

    public Folder getFolder(String name) throws FolderNotFoundException, DocumentException {
        if (!this.foldersCached) {
            return this.getPageManager().getFolder((Folder)this, name);
        }
        Folder folder = (Folder)this.getFoldersNodeSet().get(name);
        if (folder == null) {
            throw new FolderNotFoundException("Folder not found: " + name);
        }
        folder.checkAccess(JetspeedActions.VIEW);
        return folder;
    }

    public NodeSet getPages() throws NodeException {
        if (!this.pagesCached) {
            return this.getPageManager().getPages((Folder)this);
        }
        return FolderImpl.filterNodeSetByAccess(this.getPagesNodeSet());
    }

    public Page getPage(String name) throws PageNotFoundException, NodeException {
        if (!this.pagesCached) {
            return this.getPageManager().getPage((Folder)this, name);
        }
        Page page = (Page)this.getPagesNodeSet().get(name);
        if (page == null) {
            throw new PageNotFoundException("Page not found: " + name);
        }
        page.checkAccess(JetspeedActions.VIEW);
        return page;
    }

    public NodeSet getLinks() throws NodeException {
        if (!this.linksCached) {
            return this.getPageManager().getLinks((Folder)this);
        }
        return FolderImpl.filterNodeSetByAccess(this.getLinksNodeSet());
    }

    public Link getLink(String name) throws DocumentNotFoundException, NodeException {
        if (!this.linksCached) {
            return this.getPageManager().getLink((Folder)this, name);
        }
        Link link = (Link)this.getLinksNodeSet().get(name);
        if (link == null) {
            throw new DocumentNotFoundException("Link not found: " + name);
        }
        link.checkAccess(JetspeedActions.VIEW);
        return link;
    }

    public PageSecurity getPageSecurity() throws DocumentNotFoundException, NodeException {
        if (!this.pageSecurityCached) {
            return this.getPageManager().getPageSecurity((Folder)this);
        }
        if (this.pageSecurity == null) {
            throw new DocumentNotFoundException("Page security document not found");
        }
        this.pageSecurity.checkAccess(JetspeedActions.VIEW);
        return this.pageSecurity;
    }

    public NodeSet getAll() throws DocumentException {
        if (!this.allCached) {
            return this.getPageManager().getAll((Folder)this);
        }
        return FolderImpl.filterNodeSetByAccess(this.getAllNodeSet());
    }

    public List getMenuDefinitions() {
        if (this.menuDefinitions == null) {
            this.menuDefinitions = new FolderMenuDefinitionList(this);
        }
        return this.menuDefinitions;
    }

    public MenuDefinition newMenuDefinition() {
        return new FolderMenuDefinitionImpl();
    }

    public MenuExcludeDefinition newMenuExcludeDefinition() {
        return new FolderMenuExcludeDefinitionImpl();
    }

    public MenuIncludeDefinition newMenuIncludeDefinition() {
        return new FolderMenuIncludeDefinitionImpl();
    }

    public MenuOptionsDefinition newMenuOptionsDefinition() {
        return new FolderMenuOptionsDefinitionImpl();
    }

    public MenuSeparatorDefinition newMenuSeparatorDefinition() {
        return new FolderMenuSeparatorDefinitionImpl();
    }

    public void setMenuDefinitions(List definitions) {
        List menuDefinitions = this.getMenuDefinitions();
        if (definitions != menuDefinitions) {
            menuDefinitions.clear();
            if (definitions != null) {
                menuDefinitions.addAll(definitions);
            }
        }
    }

    public boolean isReserved() {
        return false;
    }

    public int getReservedType() {
        return 0;
    }

    public String getType() {
        return "folder";
    }

    private NodeSet getFoldersNodeSet() {
        if (this.foldersNodeSet == null) {
            this.foldersNodeSet = this.folders != null && !this.folders.isEmpty() ? new NodeSetImpl(this.folders, this.createDocumentOrderComparator()) : NodeSetImpl.EMPTY_NODE_SET;
        }
        return this.foldersNodeSet;
    }

    private NodeSet getPagesNodeSet() throws NodeException {
        if (this.pagesNodeSet == null) {
            this.pagesNodeSet = this.pages != null && !this.pages.isEmpty() ? new NodeSetImpl(this.pages, this.createDocumentOrderComparator()) : NodeSetImpl.EMPTY_NODE_SET;
        }
        return this.pagesNodeSet;
    }

    private NodeSet getLinksNodeSet() throws NodeException {
        if (this.linksNodeSet == null) {
            this.linksNodeSet = this.links != null && !this.links.isEmpty() ? new NodeSetImpl(this.links, this.createDocumentOrderComparator()) : NodeSetImpl.EMPTY_NODE_SET;
        }
        return this.linksNodeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeSet getAllNodeSet() {
        if (this.allNodeSet == null) {
            if (this.all != null && !this.all.isEmpty()) {
                ArrayList allCopy = new ArrayList();
                List list = this.all;
                synchronized (list) {
                    allCopy.addAll(this.all);
                }
                this.allNodeSet = new NodeSetImpl(allCopy, this.createDocumentOrderComparator());
            } else {
                this.allNodeSet = NodeSetImpl.EMPTY_NODE_SET;
            }
        }
        return this.allNodeSet;
    }

    static NodeSet filterNodeSetByAccess(NodeSet nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            NodeSetImpl filteredNodes = null;
            Iterator checkAccessIter = nodes.iterator();
            while (checkAccessIter.hasNext()) {
                Node node = (Node)checkAccessIter.next();
                try {
                    node.checkAccess(JetspeedActions.VIEW);
                    if (filteredNodes == null) continue;
                    filteredNodes.add(node);
                }
                catch (SecurityException se) {
                    Node copyNode;
                    if (filteredNodes != null) continue;
                    filteredNodes = new NodeSetImpl(nodes);
                    Iterator copyIter = nodes.iterator();
                    while (copyIter.hasNext() && (copyNode = (Node)copyIter.next()) != node) {
                        filteredNodes.add(copyNode);
                    }
                }
            }
            if (filteredNodes != null) {
                return filteredNodes;
            }
        }
        return nodes;
    }

    public PageManager getPageManager() {
        if (this.pageManager == null) {
            this.pageManager = (PageManager)Jetspeed.getComponentManager().getComponent((Object)"org.apache.jetspeed.page.PageManager");
        }
        return this.pageManager;
    }
}

