/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.layout.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.layout.PageLayoutComponent;
import org.apache.jetspeed.layout.impl.PageLayoutComponentException;
import org.apache.jetspeed.layout.impl.PageLayoutComponentUtils;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.BaseConcretePageElement;
import org.apache.jetspeed.om.page.BaseFragmentElement;
import org.apache.jetspeed.om.page.BaseFragmentsElement;
import org.apache.jetspeed.om.page.BasePageElement;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.om.page.FragmentProperty;
import org.apache.jetspeed.om.page.FragmentReference;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageFragment;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.om.page.impl.ContentFragmentImpl;
import org.apache.jetspeed.om.page.impl.ContentFragmentPreferenceImpl;
import org.apache.jetspeed.om.page.impl.ContentFragmentPropertyImpl;
import org.apache.jetspeed.om.page.impl.ContentLocalizedFieldImpl;
import org.apache.jetspeed.om.page.impl.ContentPageImpl;
import org.apache.jetspeed.om.page.impl.ContentSecurityConstraint;
import org.apache.jetspeed.om.page.impl.ContentSecurityConstraints;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.om.preference.FragmentPreference;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.PageNotRemovedException;
import org.apache.jetspeed.page.PageNotUpdatedException;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.pluto.container.PortletPreference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageLayoutComponentImpl
implements PageLayoutComponent,
PageLayoutComponentUtils {
    private static final Logger log = LoggerFactory.getLogger(PageLayoutComponentImpl.class);
    private PageManager pageManager;
    private String defaultLayoutPortletName;

    public PageLayoutComponentImpl(PageManager pageManager, String defaultLayoutPortletName) {
        this.pageManager = pageManager;
        this.defaultLayoutPortletName = defaultLayoutPortletName;
    }

    public ContentFragment addFragmentAtRowColumn(ContentPage contentPage, ContentFragment contentFragment, int row, int column) {
        log.debug("PageLayoutComponentImpl.addFragmentAtRowColumn() invoked");
        try {
            if (PageLayoutComponentUtils.Utils.isNull(contentFragment.getType()) || PageLayoutComponentUtils.Utils.isNull(contentFragment.getName())) {
                throw new IllegalArgumentException("Portlet type and name not specified");
            }
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            ContentFragmentImpl pageRootContentFragmentImpl = contentPageImpl.getPageRootContentFragment();
            if (pageRootContentFragmentImpl != null && pageRootContentFragmentImpl.isLocked()) {
                pageRootContentFragmentImpl = (ContentFragmentImpl)pageRootContentFragmentImpl.getNonTemplateLayoutFragment();
            }
            if (pageRootContentFragmentImpl == null || pageRootContentFragmentImpl.isLocked()) {
                throw new IllegalArgumentException("Page root content fragment not found or is locked");
            }
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            BaseFragmentElement rootFragment = pageOrTemplate.getRootFragment();
            if (!(rootFragment instanceof Fragment)) {
                throw new IllegalArgumentException("New fragment cannot be added to page root fragment");
            }
            Fragment fragment = (Fragment)rootFragment;
            if (!"layout".equals(fragment.getType())) {
                throw new IllegalArgumentException("New fragment cannot be added to non-layout page root fragment");
            }
            fragment.checkAccess(JetspeedActions.EDIT);
            Fragment newFragment = this.pageManager.newFragment();
            newFragment.setType(contentFragment.getType());
            newFragment.setName(contentFragment.getName());
            if (!PageLayoutComponentUtils.Utils.isNull(row)) {
                newFragment.setLayoutRow(row);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(column)) {
                newFragment.setLayoutColumn(column);
            }
            fragment.getFragments().add(newFragment);
            this.updatePage(pageOrTemplate);
            ContentFragmentImpl contentFragmentImpl = (ContentFragmentImpl)contentFragment;
            contentFragmentImpl.initialize(this, pageOrTemplate, pageOrTemplate, (BaseFragmentElement)newFragment, null, null, false, false);
            if (!PageLayoutComponentUtils.Utils.isNull(row)) {
                contentFragmentImpl.setLayoutRow(null, null, row);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(column)) {
                contentFragmentImpl.setLayoutColumn(null, null, column);
            }
            pageRootContentFragmentImpl.getFragments().add(contentFragmentImpl);
            String newContentFragmentId = pageRootContentFragmentImpl.getId() + "__" + contentFragmentImpl.getFragment().getId();
            contentFragmentImpl.setId(newContentFragmentId);
            return contentFragmentImpl;
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public ContentFragment addFragmentReference(ContentFragment contentFragment, String id, int row, int column) {
        log.debug("PageLayoutComponentImpl.addFragmentReference() invoked");
        try {
            if (PageLayoutComponentUtils.Utils.isNull(id)) {
                throw new IllegalArgumentException("Fragment definition id not specified");
            }
            ContentFragmentImpl contentFragmentImpl = (ContentFragmentImpl)contentFragment;
            if (contentFragmentImpl.getDefinition() == null) {
                throw new IllegalArgumentException("Transient content fragments are not mutable");
            }
            if (contentFragmentImpl.isLocked()) {
                throw new IllegalArgumentException("Locked content fragment is not mutable");
            }
            if (!contentFragmentImpl.getDefinition().getPath().equals(contentFragmentImpl.getPageOrTemplate().getPath())) {
                throw new IllegalArgumentException("Only page fragments can be modified");
            }
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentFragmentImpl.getPageOrTemplate().getPath());
            BaseFragmentElement parentFragment = pageOrTemplate.getFragmentById(contentFragmentImpl.getFragment().getId());
            if (!(parentFragment instanceof Fragment)) {
                throw new IllegalArgumentException("New fragment cannot be added to parent fragment");
            }
            Fragment fragment = (Fragment)parentFragment;
            if (!"layout".equals(fragment.getType())) {
                throw new IllegalArgumentException("New fragment cannot be added to non-layout parent fragment");
            }
            fragment.checkAccess(JetspeedActions.EDIT);
            FragmentReference newFragmentReference = this.pageManager.newFragmentReference();
            newFragmentReference.setRefId(id);
            if (!PageLayoutComponentUtils.Utils.isNull(row)) {
                newFragmentReference.setLayoutRow(row);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(column)) {
                newFragmentReference.setLayoutColumn(column);
            }
            fragment.getFragments().add(newFragmentReference);
            this.updatePage(pageOrTemplate);
            ContentFragmentImpl newContentFragmentImpl = this.newContentFragment(contentFragmentImpl.getId(), pageOrTemplate, pageOrTemplate, newFragmentReference);
            contentFragmentImpl.getFragments().add(newContentFragmentImpl);
            return newContentFragmentImpl;
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public ContentFragment addFragmentReference(ContentFragment contentFragment, String id) {
        return this.addFragmentReference(contentFragment, id, -1, -1);
    }

    public ContentFragment addFragmentReference(ContentPage contentPage, String id) {
        log.debug("PageLayoutComponentImpl.addFragmentReference() invoked");
        try {
            if (PageLayoutComponentUtils.Utils.isNull(id)) {
                throw new IllegalArgumentException("Fragment definition id not specified");
            }
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            ContentFragmentImpl pageRootContentFragmentImpl = contentPageImpl.getPageRootContentFragment();
            if (pageRootContentFragmentImpl != null && pageRootContentFragmentImpl.isLocked()) {
                pageRootContentFragmentImpl = (ContentFragmentImpl)pageRootContentFragmentImpl.getNonTemplateLayoutFragment();
            }
            if (pageRootContentFragmentImpl == null || pageRootContentFragmentImpl.isLocked()) {
                throw new IllegalArgumentException("Page root content fragment not found or is locked");
            }
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPage.getPageOrTemplate().getPath());
            BaseFragmentElement rootFragment = pageOrTemplate.getRootFragment();
            if (!(rootFragment instanceof Fragment)) {
                throw new IllegalArgumentException("New Fragment cannot be added to page root fragment");
            }
            Fragment fragment = (Fragment)rootFragment;
            if (!"layout".equals(fragment.getType())) {
                throw new IllegalArgumentException("New Fragment cannot be added to non-layout page root fragment");
            }
            fragment.checkAccess(JetspeedActions.EDIT);
            FragmentReference newFragmentReference = this.pageManager.newFragmentReference();
            newFragmentReference.setRefId(id);
            fragment.getFragments().add(newFragmentReference);
            this.updatePage(pageOrTemplate);
            ContentFragmentImpl newContentFragmentImpl = this.newContentFragment(pageRootContentFragmentImpl.getId(), pageOrTemplate, pageOrTemplate, newFragmentReference);
            pageRootContentFragmentImpl.getFragments().add(newContentFragmentImpl);
            return newContentFragmentImpl;
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public ContentFragment addPortlet(ContentFragment contentFragment, String type, String name, int row, int column) {
        log.debug("PageLayoutComponentImpl.addPortlet() invoked");
        try {
            if (PageLayoutComponentUtils.Utils.isNull(type) || PageLayoutComponentUtils.Utils.isNull(name)) {
                throw new IllegalArgumentException("Portlet type and name not specified");
            }
            ContentFragmentImpl contentFragmentImpl = (ContentFragmentImpl)contentFragment;
            if (contentFragmentImpl.getDefinition() == null) {
                throw new IllegalArgumentException("Transient content fragments are not mutable");
            }
            if (contentFragmentImpl.isLocked()) {
                throw new IllegalArgumentException("Locked content fragment is not mutable");
            }
            if (!contentFragmentImpl.getDefinition().getPath().equals(contentFragmentImpl.getPageOrTemplate().getPath())) {
                throw new IllegalArgumentException("Only page fragments can be modified");
            }
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentFragmentImpl.getPageOrTemplate().getPath());
            BaseFragmentElement parentFragment = pageOrTemplate.getFragmentById(contentFragmentImpl.getFragment().getId());
            if (!(parentFragment instanceof Fragment)) {
                throw new IllegalArgumentException("New fragment cannot be added to parent fragment");
            }
            Fragment fragment = (Fragment)parentFragment;
            if (!"layout".equals(fragment.getType())) {
                throw new IllegalArgumentException("New fragment cannot be added to non-layout parent fragment");
            }
            fragment.checkAccess(JetspeedActions.EDIT);
            Fragment newFragment = this.pageManager.newFragment();
            newFragment.setType(type);
            newFragment.setName(name);
            if (!PageLayoutComponentUtils.Utils.isNull(row)) {
                newFragment.setLayoutRow(row);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(column)) {
                newFragment.setLayoutColumn(column);
            }
            fragment.getFragments().add(newFragment);
            this.updatePage(pageOrTemplate);
            ContentFragmentImpl newContentFragmentImpl = this.newContentFragment(contentFragmentImpl.getId(), pageOrTemplate, null, pageOrTemplate, (BaseFragmentElement)newFragment, false);
            contentFragmentImpl.getFragments().add(newContentFragmentImpl);
            return newContentFragmentImpl;
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public ContentFragment addPortlet(ContentFragment contentFragment, String type, String name) {
        return this.addPortlet(contentFragment, type, name, -1, -1);
    }

    public ContentFragment addPortlet(ContentPage contentPage, String type, String name) {
        log.debug("PageLayoutComponentImpl.addPortlet() invoked");
        try {
            if (PageLayoutComponentUtils.Utils.isNull(type) || PageLayoutComponentUtils.Utils.isNull(name)) {
                throw new IllegalArgumentException("Portlet type and name not specified");
            }
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            ContentFragmentImpl pageRootContentFragmentImpl = contentPageImpl.getPageRootContentFragment();
            if (pageRootContentFragmentImpl != null && pageRootContentFragmentImpl.isLocked()) {
                pageRootContentFragmentImpl = (ContentFragmentImpl)pageRootContentFragmentImpl.getNonTemplateLayoutFragment();
            }
            if (pageRootContentFragmentImpl == null || pageRootContentFragmentImpl.isLocked()) {
                throw new IllegalArgumentException("Page root content fragment not found or is locked");
            }
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPage.getPageOrTemplate().getPath());
            BaseFragmentElement rootFragment = pageOrTemplate.getRootFragment();
            if (!(rootFragment instanceof Fragment)) {
                throw new IllegalArgumentException("New Fragment cannot be added to page root fragment");
            }
            Fragment fragment = (Fragment)rootFragment;
            if (!"layout".equals(fragment.getType())) {
                throw new IllegalArgumentException("New Fragment cannot be added to non-layout page root fragment");
            }
            fragment.checkAccess(JetspeedActions.EDIT);
            Fragment newFragment = this.pageManager.newFragment();
            newFragment.setType(type);
            newFragment.setName(name);
            fragment.getFragments().add(newFragment);
            this.updatePage(pageOrTemplate);
            ContentFragmentImpl newContentFragmentImpl = this.newContentFragment(pageRootContentFragmentImpl.getId(), pageOrTemplate, null, pageOrTemplate, (BaseFragmentElement)newFragment, false);
            pageRootContentFragmentImpl.getFragments().add(newContentFragmentImpl);
            return newContentFragmentImpl;
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void decrementFolderInDocumentOrder(ContentPage contentPage) {
        log.debug("PageLayoutComponentImpl.decrementFolderInDocumentOrder() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplates = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            Folder pageFolder = (Folder)pageOrTemplates.getParent();
            Folder documentOrderingFolder = (Folder)pageFolder.getParent();
            if (documentOrderingFolder != null) {
                documentOrderingFolder.checkAccess(JetspeedActions.EDIT);
                boolean update = this.shiftDocumentOrder(documentOrderingFolder, pageFolder.getName(), null, true);
                if (update) {
                    this.pageManager.updateFolder(documentOrderingFolder);
                }
            }
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void decrementInDocumentOrder(ContentPage contentPage) {
        log.debug("PageLayoutComponentImpl.decrementInDocumentOrder() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            Folder documentOrderingFolder = (Folder)pageOrTemplate.getParent();
            documentOrderingFolder.checkAccess(JetspeedActions.EDIT);
            boolean update = this.shiftDocumentOrder(documentOrderingFolder, pageOrTemplate.getName(), pageOrTemplate.getType(), true);
            if (update) {
                this.pageManager.updateFolder(documentOrderingFolder);
            }
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void incrementFolderInDocumentOrder(ContentPage contentPage) {
        log.debug("PageLayoutComponentImpl.incrementFolderInDocumentOrder() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            Folder pageFolder = (Folder)pageOrTemplate.getParent();
            Folder documentOrderingFolder = (Folder)pageFolder.getParent();
            if (documentOrderingFolder != null) {
                documentOrderingFolder.checkAccess(JetspeedActions.EDIT);
                boolean update = this.shiftDocumentOrder(documentOrderingFolder, pageFolder.getName(), null, false);
                if (update) {
                    this.pageManager.updateFolder(documentOrderingFolder);
                }
            }
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void incrementInDocumentOrder(ContentPage contentPage) {
        log.debug("PageLayoutComponentImpl.incrementInDocumentOrder() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            Folder documentOrderingFolder = (Folder)pageOrTemplate.getParent();
            documentOrderingFolder.checkAccess(JetspeedActions.EDIT);
            boolean update = this.shiftDocumentOrder(documentOrderingFolder, pageOrTemplate.getName(), pageOrTemplate.getType(), false);
            if (update) {
                this.pageManager.updateFolder(documentOrderingFolder);
            }
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void moveFragment(ContentPage contentPage, String fragmentId, String toFragmentId) {
        this.moveFragment(contentPage, fragmentId, null, toFragmentId);
    }

    public void moveFragment(ContentPage contentPage, String fragmentId, String fromFragmentId, String toFragmentId) {
        log.debug("PageLayoutComponentImpl.moveFragment() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            ContentFragmentImpl fromContentFragmentImpl = (ContentFragmentImpl)(fromFragmentId != null ? contentPageImpl.getFragmentById(fromFragmentId) : contentPageImpl.getRootFragment());
            ContentFragmentImpl contentFragmentImpl = fromContentFragmentImpl.getFragmentById(fragmentId);
            ContentFragmentImpl toContentFragmentImpl = (ContentFragmentImpl)contentPageImpl.getFragmentById(toFragmentId);
            if (contentFragmentImpl == null || fromContentFragmentImpl == null || fromContentFragmentImpl.isLocked() || toContentFragmentImpl == null || toContentFragmentImpl.isLocked()) {
                throw new IllegalArgumentException("Fragment ids involved in move and page not consistent or locked");
            }
            if (fromContentFragmentImpl.getDefinition() == null || contentFragmentImpl.getDefinition() == null || toContentFragmentImpl.getDefinition() == null) {
                throw new IllegalArgumentException("Transient content fragments are not mutable");
            }
            if (!(fromContentFragmentImpl.getDefinition().getPath().equals(contentPageImpl.getPath()) && contentFragmentImpl.getDefinition().getPath().equals(contentPageImpl.getPath()) && toContentFragmentImpl.getDefinition().getPath().equals(contentPageImpl.getPath()))) {
                throw new IllegalArgumentException("Cannot use move fragment operation between pages");
            }
            boolean contentFragmentIsReference = contentFragmentImpl.getReference() != null;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            BaseFragmentElement fromFragmentElement = pageOrTemplate.getFragmentById(fromContentFragmentImpl.getFragment().getId());
            if (!(fromFragmentElement instanceof Fragment)) {
                throw new IllegalArgumentException("Move from fragmentId and page not consistent");
            }
            Fragment fromFragment = (Fragment)fromFragmentElement;
            String pageFragmentId = contentFragmentIsReference ? contentFragmentImpl.getReference().getId() : contentFragmentImpl.getFragment().getId();
            BaseFragmentElement fragment = fromFragment.getFragmentById(pageFragmentId);
            if (fragment == null) {
                throw new IllegalArgumentException("Move fragmentId and page not consistent");
            }
            BaseFragmentElement toFragmentElement = pageOrTemplate.getFragmentById(toContentFragmentImpl.getFragment().getId());
            if (!(toFragmentElement instanceof Fragment)) {
                throw new IllegalArgumentException("Move to fragmentId and page not consistent");
            }
            Fragment toFragment = (Fragment)toFragmentElement;
            pageOrTemplate.checkAccess(JetspeedActions.EDIT);
            fragment = fromFragment.removeFragmentById(fragment.getId());
            toFragment.getFragments().add(fragment);
            this.updatePage(pageOrTemplate);
            fromContentFragmentImpl.removeFragmentById(fragmentId);
            toContentFragmentImpl.getFragments().add(contentFragmentImpl);
            String newContentFragmentId = toContentFragmentImpl.getId() + "__" + contentFragmentImpl.getFragment().getId();
            contentFragmentImpl.setId(newContentFragmentId);
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public ContentPage newContentPage(BaseFragmentsElement pageOrTemplate, PageTemplate pageTemplate, Map fragmentDefinitions) {
        String effectivePortletDefaultDecorator;
        BaseConcretePageElement concretePage = pageOrTemplate instanceof BaseConcretePageElement ? (BaseConcretePageElement)pageOrTemplate : null;
        DynamicPage dynamicPage = pageOrTemplate instanceof DynamicPage ? (DynamicPage)pageOrTemplate : null;
        FragmentDefinition fragmentDefinition = concretePage == null && pageOrTemplate instanceof FragmentDefinition ? (FragmentDefinition)pageOrTemplate : null;
        String contentPageId = pageOrTemplate.getId();
        ContentPageImpl contentPageImpl = new ContentPageImpl(this, contentPageId, pageOrTemplate, pageTemplate, fragmentDefinitions);
        this.mergeContentPageAttributes(contentPageImpl, pageOrTemplate);
        contentPageImpl.setName(pageOrTemplate.getName());
        contentPageImpl.setPath(pageOrTemplate.getPath());
        contentPageImpl.setUrl(pageOrTemplate.getUrl());
        contentPageImpl.setHidden(pageOrTemplate.isHidden());
        this.mergeContentPageAttributes(contentPageImpl, (BaseFragmentsElement)pageTemplate);
        HashMap<String, String> effectiveDefaultDecorators = null;
        String effectiveLayoutDefaultDecorator = contentPageImpl.getDefaultDecorator("layout");
        if (effectiveLayoutDefaultDecorator == null) {
            if (concretePage != null) {
                effectiveLayoutDefaultDecorator = concretePage.getEffectiveDefaultDecorator("layout");
            } else if (pageOrTemplate.getParent() != null) {
                effectiveLayoutDefaultDecorator = ((Folder)pageOrTemplate.getParent()).getEffectiveDefaultDecorator("layout");
            }
        }
        if (effectiveLayoutDefaultDecorator != null) {
            if (effectiveDefaultDecorators == null) {
                effectiveDefaultDecorators = new HashMap<String, String>();
            }
            effectiveDefaultDecorators.put("layout", effectiveLayoutDefaultDecorator);
        }
        if ((effectivePortletDefaultDecorator = contentPageImpl.getDefaultDecorator("portlet")) == null) {
            if (concretePage != null) {
                effectivePortletDefaultDecorator = concretePage.getEffectiveDefaultDecorator("portlet");
            } else if (pageOrTemplate.getParent() != null) {
                effectiveLayoutDefaultDecorator = ((Folder)pageOrTemplate.getParent()).getEffectiveDefaultDecorator("portlet");
            }
        }
        if (effectivePortletDefaultDecorator != null) {
            if (effectiveDefaultDecorators == null) {
                effectiveDefaultDecorators = new HashMap();
            }
            effectiveDefaultDecorators.put("portlet", effectivePortletDefaultDecorator);
        }
        contentPageImpl.setEffectiveDefaultDecorators(effectiveDefaultDecorators);
        if (dynamicPage != null) {
            contentPageImpl.setContentType(dynamicPage.getContentType());
            contentPageImpl.setInheritable(dynamicPage.isInheritable());
        }
        if (fragmentDefinition != null) {
            contentPageImpl.setDefId(fragmentDefinition.getDefId());
        }
        log.debug("PageLayoutComponentImpl.newContentPage(): construct ContentPage: id=" + contentPageImpl.getId() + ", path=" + contentPageImpl.getPath());
        PageTemplate definition = null;
        BaseFragmentElement rootFragment = null;
        boolean rootTemplate = false;
        if (pageTemplate != null) {
            definition = pageTemplate;
            rootFragment = definition.getRootFragment();
            rootTemplate = true;
        }
        if (rootFragment == null) {
            definition = pageOrTemplate;
            rootFragment = definition.getRootFragment();
        }
        if (rootFragment != null) {
            ContentFragmentImpl rootContentFragmentImpl = this.newContentFragment(null, pageOrTemplate, fragmentDefinitions, (BaseFragmentsElement)definition, rootFragment, rootTemplate);
            if (!rootContentFragmentImpl.getType().equals("layout")) {
                ContentFragmentImpl layoutContentFragmentImpl = this.newContentFragment("", pageOrTemplate, null, null, null, null, rootTemplate, true);
                layoutContentFragmentImpl.setType("layout");
                layoutContentFragmentImpl.setName(this.defaultLayoutPortletName);
                layoutContentFragmentImpl.getFragments().add(rootContentFragmentImpl);
                rootContentFragmentImpl = layoutContentFragmentImpl;
            }
            contentPageImpl.setRootFragment(rootContentFragmentImpl);
        }
        log.debug("PageLayoutComponentImpl.newContentPage(): constructed ContentPage: id=" + contentPageImpl.getId());
        return contentPageImpl;
    }

    public void newSiblingFolder(ContentPage contentPage, String folderName, String folderTitle, String folderShortTitle, String defaultPageLayoutName) {
        log.debug("PageLayoutComponentImpl.newSiblingFolder() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            BasePageElement page = pageOrTemplate instanceof BasePageElement ? (BasePageElement)pageOrTemplate : null;
            Folder folder = (Folder)pageOrTemplate.getParent();
            folder.checkAccess(JetspeedActions.EDIT);
            String newFolderPath = folder.getPath() + (folder.getPath().endsWith("/") ? "" : "/") + folderName;
            if (this.pageManager.folderExists(newFolderPath)) {
                throw new IllegalArgumentException("Folder " + newFolderPath + " exists");
            }
            Folder newFolder = this.pageManager.newFolder(newFolderPath);
            if (!PageLayoutComponentUtils.Utils.isNull(folderTitle)) {
                newFolder.setTitle(folderTitle);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(folderShortTitle)) {
                newFolder.setShortTitle(folderShortTitle);
            }
            String defaultLayoutDecorator = null;
            String defaultPortletDecorator = null;
            if (page != null) {
                defaultLayoutDecorator = page.getDefaultDecorator("layout");
                if (defaultLayoutDecorator != null) {
                    newFolder.setDefaultDecorator(defaultLayoutDecorator, "layout");
                }
                if ((defaultPortletDecorator = page.getDefaultDecorator("portlet")) != null) {
                    newFolder.setDefaultDecorator(defaultPortletDecorator, "portlet");
                }
            }
            this.pageManager.updateFolder(newFolder);
            List<String> documentOrder = folder.getDocumentOrder();
            if (documentOrder == null) {
                documentOrder = new ArrayList<String>(4);
                folder.setDocumentOrder(documentOrder);
            }
            if (documentOrder.indexOf(newFolder.getName()) == -1) {
                documentOrder.add(newFolder.getName());
            }
            this.pageManager.updateFolder(folder);
            String newPagePath = newFolder.getPath() + (newFolder.getPath().endsWith("/") ? "" : "/") + "default-page" + ".psml";
            Page newPage = this.pageManager.newPage(newPagePath);
            if (!PageLayoutComponentUtils.Utils.isNull(defaultPageLayoutName) && newPage.getRootFragment() instanceof Fragment) {
                ((Fragment)newPage.getRootFragment()).setName(defaultPageLayoutName);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(folderTitle)) {
                newPage.setTitle(folderTitle);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(folderShortTitle)) {
                newPage.setShortTitle(folderShortTitle);
            }
            if (defaultLayoutDecorator != null) {
                newPage.setDefaultDecorator(defaultLayoutDecorator, "layout");
            }
            if (defaultPortletDecorator != null) {
                newPage.setDefaultDecorator(defaultPortletDecorator, "portlet");
            }
            this.pageManager.updatePage(newPage);
            documentOrder = newFolder.getDocumentOrder();
            if (documentOrder == null) {
                documentOrder = new ArrayList(4);
                newFolder.setDocumentOrder(documentOrder);
            }
            if (documentOrder.indexOf(newPage.getName()) == -1) {
                documentOrder.add(newPage.getName());
            }
            this.pageManager.updateFolder(newFolder);
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void newSiblingPage(ContentPage contentPage, String pageName, String layoutName, String pageTitle, String pageShortTitle) {
        log.debug("PageLayoutComponentImpl.newSiblingPage() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            BasePageElement page = pageOrTemplate instanceof BasePageElement ? (BasePageElement)pageOrTemplate : null;
            Folder folder = (Folder)pageOrTemplate.getParent();
            folder.checkAccess(JetspeedActions.EDIT);
            String newPagePath = folder.getPath() + (folder.getPath().endsWith("/") ? "" : "/") + pageName + ".psml";
            if (this.pageManager.pageExists(newPagePath)) {
                throw new IllegalArgumentException("Page " + newPagePath + " exists");
            }
            Page newPage = this.pageManager.newPage(newPagePath);
            if (!PageLayoutComponentUtils.Utils.isNull(layoutName) && newPage.getRootFragment() instanceof Fragment) {
                ((Fragment)newPage.getRootFragment()).setName(layoutName);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(pageTitle)) {
                newPage.setTitle(pageTitle);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(pageShortTitle)) {
                newPage.setShortTitle(pageShortTitle);
            }
            String defaultLayoutDecorator = null;
            String defaultPortletDecorator = null;
            if (page != null) {
                defaultLayoutDecorator = page.getDefaultDecorator("layout");
                if (defaultLayoutDecorator != null) {
                    newPage.setDefaultDecorator(defaultLayoutDecorator, "layout");
                }
                if ((defaultPortletDecorator = page.getDefaultDecorator("portlet")) != null) {
                    newPage.setDefaultDecorator(defaultPortletDecorator, "portlet");
                }
            }
            this.pageManager.updatePage(newPage);
            ArrayList<String> documentOrder = folder.getDocumentOrder();
            if (documentOrder == null) {
                documentOrder = new ArrayList<String>(4);
                folder.setDocumentOrder(documentOrder);
            }
            if (documentOrder.indexOf(newPage.getName()) == -1) {
                documentOrder.add(newPage.getName());
            }
            this.pageManager.updateFolder(folder);
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void newSiblingDynamicPage(ContentPage contentPage, String pageName, String contentType, String layoutName, String pageTitle, String pageShortTitle) {
        log.debug("PageLayoutComponentImpl.newSiblingDynamicPage() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            BasePageElement page = pageOrTemplate instanceof BasePageElement ? (BasePageElement)pageOrTemplate : null;
            Folder folder = (Folder)pageOrTemplate.getParent();
            folder.checkAccess(JetspeedActions.EDIT);
            String newDynamicPagePath = folder.getPath() + (folder.getPath().endsWith("/") ? "" : "/") + pageName + ".dpsml";
            if (this.pageManager.dynamicPageExists(newDynamicPagePath)) {
                throw new IllegalArgumentException("Dynamic page " + newDynamicPagePath + " exists");
            }
            DynamicPage newDynamicPage = this.pageManager.newDynamicPage(newDynamicPagePath);
            newDynamicPage.setContentType(!PageLayoutComponentUtils.Utils.isNull(contentType) ? contentType : "*");
            if (!PageLayoutComponentUtils.Utils.isNull(layoutName) && newDynamicPage.getRootFragment() instanceof Fragment) {
                ((Fragment)newDynamicPage.getRootFragment()).setName(layoutName);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(pageTitle)) {
                newDynamicPage.setTitle(pageTitle);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(pageShortTitle)) {
                newDynamicPage.setShortTitle(pageShortTitle);
            }
            String defaultLayoutDecorator = null;
            String defaultPortletDecorator = null;
            if (page != null) {
                defaultLayoutDecorator = page.getDefaultDecorator("layout");
                if (defaultLayoutDecorator != null) {
                    newDynamicPage.setDefaultDecorator(defaultLayoutDecorator, "layout");
                }
                if ((defaultPortletDecorator = page.getDefaultDecorator("portlet")) != null) {
                    newDynamicPage.setDefaultDecorator(defaultPortletDecorator, "portlet");
                }
            }
            this.pageManager.updateDynamicPage(newDynamicPage);
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void newSiblingPageTemplate(ContentPage contentPage, String templateName, String layoutName, String templateTitle, String templateShortTitle) {
        log.debug("PageLayoutComponentImpl.newSiblingPageTemplate() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            BasePageElement page = pageOrTemplate instanceof BasePageElement ? (BasePageElement)pageOrTemplate : null;
            Folder folder = (Folder)pageOrTemplate.getParent();
            folder.checkAccess(JetspeedActions.EDIT);
            String newPageTemplatePath = folder.getPath() + (folder.getPath().endsWith("/") ? "" : "/") + templateName + ".tpsml";
            if (this.pageManager.pageTemplateExists(newPageTemplatePath)) {
                throw new IllegalArgumentException("Page template " + newPageTemplatePath + " exists");
            }
            PageTemplate newPageTemplate = this.pageManager.newPageTemplate(newPageTemplatePath);
            if (newPageTemplate.getRootFragment() instanceof Fragment) {
                Fragment rootFragment = (Fragment)newPageTemplate.getRootFragment();
                if (!PageLayoutComponentUtils.Utils.isNull(layoutName)) {
                    rootFragment.setName(layoutName);
                }
                rootFragment.getFragments().add(this.pageManager.newPageFragment());
            }
            if (!PageLayoutComponentUtils.Utils.isNull(templateTitle)) {
                newPageTemplate.setTitle(templateTitle);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(templateShortTitle)) {
                newPageTemplate.setShortTitle(templateShortTitle);
            }
            String defaultLayoutDecorator = null;
            String defaultPortletDecorator = null;
            if (page != null) {
                defaultLayoutDecorator = page.getDefaultDecorator("layout");
                if (defaultLayoutDecorator != null) {
                    newPageTemplate.setDefaultDecorator(defaultLayoutDecorator, "layout");
                }
                if ((defaultPortletDecorator = page.getDefaultDecorator("portlet")) != null) {
                    newPageTemplate.setDefaultDecorator(defaultPortletDecorator, "portlet");
                }
            }
            this.pageManager.updatePageTemplate(newPageTemplate);
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void newSiblingFragmentDefinition(ContentPage contentPage, String definitionName, String defId, String portletName, String definitionTitle, String definitionShortTitle) {
        log.debug("PageLayoutComponentImpl.newSiblingFragmentDefinition() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            Folder folder = (Folder)pageOrTemplate.getParent();
            folder.checkAccess(JetspeedActions.EDIT);
            String newFragmentDefinitionPath = folder.getPath() + (folder.getPath().endsWith("/") ? "" : "/") + definitionName + ".fpsml";
            if (this.pageManager.fragmentDefinitionExists(newFragmentDefinitionPath)) {
                throw new IllegalArgumentException("PageTemplate " + newFragmentDefinitionPath + " exists");
            }
            FragmentDefinition newFragmentDefinition = this.pageManager.newFragmentDefinition(newFragmentDefinitionPath);
            if (newFragmentDefinition.getRootFragment() instanceof Fragment) {
                Fragment rootFragment = (Fragment)newFragmentDefinition.getRootFragment();
                if (!PageLayoutComponentUtils.Utils.isNull(defId)) {
                    rootFragment.setId(defId);
                }
                if (!PageLayoutComponentUtils.Utils.isNull(portletName)) {
                    rootFragment.setType("portlet");
                    rootFragment.setName(portletName);
                }
            }
            if (!PageLayoutComponentUtils.Utils.isNull(definitionTitle)) {
                newFragmentDefinition.setTitle(definitionTitle);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(definitionShortTitle)) {
                newFragmentDefinition.setShortTitle(definitionShortTitle);
            }
            this.pageManager.updateFragmentDefinition(newFragmentDefinition);
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void remove(ContentPage contentPage) {
        log.debug("PageLayoutComponentImpl.remove() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplates = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            String documentName = pageOrTemplates.getName();
            Folder documentOrderingFolder = (Folder)pageOrTemplates.getParent();
            pageOrTemplates.checkAccess(JetspeedActions.EDIT);
            this.removePage(pageOrTemplates);
            documentOrderingFolder.checkAccess(JetspeedActions.EDIT);
            boolean update = this.removeDocumentOrder(documentOrderingFolder, documentName);
            if (update) {
                this.pageManager.updateFolder(documentOrderingFolder);
            }
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void removeFolder(ContentPage contentPage) {
        log.debug("PageLayoutComponentImpl.removeFolder() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            Folder folder = (Folder)pageOrTemplate.getParent();
            String documentName = folder.getName();
            Folder documentOrderingFolder = (Folder)folder.getParent();
            folder.checkAccess(JetspeedActions.EDIT);
            this.pageManager.removeFolder(folder);
            documentOrderingFolder.checkAccess(JetspeedActions.EDIT);
            boolean update = this.removeDocumentOrder(documentOrderingFolder, documentName);
            if (update) {
                this.pageManager.updateFolder(documentOrderingFolder);
            }
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void removeFragment(ContentPage contentPage, String fragmentId) {
        log.debug("PageLayoutComponentImpl.removeFragment() invoked");
        try {
            boolean update;
            String pageFragmentId;
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            ContentFragmentImpl[] parentContentFragmentImpl = new ContentFragmentImpl[]{null};
            ContentFragmentImpl contentFragmentImpl = contentPageImpl.getFragmentById(fragmentId, parentContentFragmentImpl);
            if (contentFragmentImpl.getDefinition() == null) {
                throw new IllegalArgumentException("Transient content fragments are not mutable");
            }
            if (contentFragmentImpl == null || !contentFragmentImpl.getDefinition().getPath().equals(contentPageImpl.getPath())) {
                throw new IllegalArgumentException("FragmentId and page not consistent");
            }
            if (parentContentFragmentImpl[0] != null && (!parentContentFragmentImpl[0].getDefinition().getPath().equals(contentPageImpl.getPageOrTemplate().getPath()) || parentContentFragmentImpl[0].isLocked())) {
                throw new IllegalArgumentException("Parent content fragment and page not consistent or locked");
            }
            boolean contentFragmentIsReference = contentFragmentImpl.getReference() != null;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            BaseFragmentElement fragment = pageOrTemplate.getFragmentById(pageFragmentId = contentFragmentIsReference ? contentFragmentImpl.getReference().getId() : contentFragmentImpl.getFragment().getId());
            if (fragment == null) {
                throw new IllegalArgumentException("Remove fragmentId and page not consistent");
            }
            fragment.checkAccess(JetspeedActions.EDIT);
            boolean bl = update = pageOrTemplate.removeFragmentById(pageFragmentId) != null;
            if (update) {
                this.updatePage(pageOrTemplate);
            }
            contentPageImpl.removeFragmentById(fragmentId);
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void updateContent(ContentPage contentPage, String contentType, Boolean inheritable) {
        log.debug("PageLayoutComponentImpl.updateContent() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            if (!(pageOrTemplate instanceof DynamicPage)) {
                throw new IllegalArgumentException("Content only supported on dynamic pages.");
            }
            DynamicPage dynamicPage = (DynamicPage)pageOrTemplate;
            dynamicPage.checkAccess(JetspeedActions.EDIT);
            boolean update = false;
            if (!PageLayoutComponentUtils.Utils.isNull(contentType) && !contentType.equals(dynamicPage.getContentType())) {
                dynamicPage.setContentType(contentType);
                update = true;
            }
            if (inheritable != null && inheritable.booleanValue() != dynamicPage.isInheritable()) {
                dynamicPage.setInheritable(inheritable.booleanValue());
                update = true;
            }
            if (update) {
                this.updatePage((BaseFragmentsElement)dynamicPage);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(contentType)) {
                contentPageImpl.setContentType(contentType);
            }
            if (inheritable != null) {
                contentPageImpl.setInheritable(inheritable);
            }
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void updateDecorator(ContentFragment contentFragment, String decoratorName) {
        this.updateDecorator(contentFragment, decoratorName, null, null);
    }

    public void updateDecorator(ContentFragment contentFragment, String decoratorName, String scope, String scopeValue) {
        log.debug("PageLayoutComponentImpl.updateDecorator() invoked");
        try {
            ContentFragmentImpl contentFragmentImpl = (ContentFragmentImpl)contentFragment;
            BaseFragmentElement fragment = this.lookupPageOrTemplateFragment(contentFragmentImpl, scope);
            boolean update = false;
            String string = decoratorName = !PageLayoutComponentUtils.Utils.isNull(decoratorName) ? decoratorName : null;
            if (decoratorName != null && !decoratorName.equals(fragment.getDecorator()) || decoratorName == null && fragment.getDecorator() != null) {
                fragment.setDecorator(scope, scopeValue, decoratorName);
                update = true;
            }
            if (update) {
                this.updatePageOrPageTemplateFragmentProperties(fragment, scope);
            }
            contentFragmentImpl.setDecorator(scope, scopeValue, decoratorName);
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void updateDefaultDecorator(ContentPage contentPage, String decoratorName, String fragmentType) {
        log.debug("PageLayoutComponentImpl.updateDefaultDecorator() invoked");
        try {
            if (PageLayoutComponentUtils.Utils.isNull(fragmentType)) {
                throw new IllegalArgumentException("Fragment type not specified.");
            }
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            if (!(pageOrTemplate instanceof BasePageElement)) {
                throw new IllegalArgumentException("Decorators only supported on pages.");
            }
            BasePageElement page = (BasePageElement)pageOrTemplate;
            BaseConcretePageElement concretePage = page instanceof BaseConcretePageElement ? (BaseConcretePageElement)page : null;
            page.checkAccess(JetspeedActions.EDIT);
            boolean update = false;
            String string = decoratorName = !PageLayoutComponentUtils.Utils.isNull(decoratorName) ? decoratorName : null;
            if (decoratorName != null && !decoratorName.equals(page.getDefaultDecorator(fragmentType)) || decoratorName == null && page.getDefaultDecorator(fragmentType) != null) {
                page.setDefaultDecorator(decoratorName, fragmentType);
                update = true;
            }
            if (update) {
                this.updatePage((BaseFragmentsElement)page);
            }
            HashMap<String, String> effectiveDefaultDecorators = new HashMap<String, String>();
            if (concretePage != null) {
                effectiveDefaultDecorators.put("layout", concretePage.getEffectiveDefaultDecorator("layout"));
                effectiveDefaultDecorators.put("portlet", concretePage.getEffectiveDefaultDecorator("portlet"));
            } else {
                String portletDefaultDecorator;
                String layoutDefaultDecorator = page.getDefaultDecorator("layout");
                if (layoutDefaultDecorator != null) {
                    effectiveDefaultDecorators.put("layout", layoutDefaultDecorator);
                }
                if ((portletDefaultDecorator = page.getDefaultDecorator("portlet")) != null) {
                    effectiveDefaultDecorators.put("portlet", portletDefaultDecorator);
                }
            }
            contentPageImpl.setEffectiveDefaultDecorators(effectiveDefaultDecorators);
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void updateFolderTitles(ContentPage contentPage, String title, String shortTitle) {
        log.debug("PageLayoutComponentImpl.updateFolderTitles() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            Folder folder = (Folder)pageOrTemplate.getParent();
            folder.checkAccess(JetspeedActions.EDIT);
            boolean update = false;
            if (!PageLayoutComponentUtils.Utils.isNull(title) && !title.equals(folder.getTitle())) {
                folder.setTitle(title);
                update = true;
            }
            if (!PageLayoutComponentUtils.Utils.isNull(shortTitle) && !shortTitle.equals(folder.getShortTitle())) {
                folder.setShortTitle(shortTitle);
                update = true;
            }
            if (update) {
                this.pageManager.updateFolder(folder);
            }
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void updateName(ContentFragment contentFragment, String name) {
        log.debug("PageLayoutComponentImpl.updateName() invoked");
        try {
            if (PageLayoutComponentUtils.Utils.isNull(name)) {
                throw new IllegalArgumentException("Fragment name not specified.");
            }
            ContentFragmentImpl contentFragmentImpl = (ContentFragmentImpl)contentFragment;
            if (contentFragmentImpl.isLocked()) {
                throw new IllegalArgumentException("Locked content fragment is not mutable");
            }
            if (contentFragmentImpl.getDefinition() == null) {
                throw new IllegalArgumentException("Transient content fragments are not mutable");
            }
            if (!contentFragmentImpl.getDefinition().getPath().equals(contentFragmentImpl.getPageOrTemplate().getPath())) {
                throw new IllegalArgumentException("Only page fragments can be modified");
            }
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentFragmentImpl.getPageOrTemplate().getPath());
            BaseFragmentElement foundFragment = pageOrTemplate.getFragmentById(contentFragmentImpl.getFragment().getId());
            if (!(foundFragment instanceof Fragment)) {
                throw new IllegalArgumentException("Fragment and page not consistent");
            }
            Fragment fragment = (Fragment)foundFragment;
            fragment.checkAccess(JetspeedActions.EDIT);
            boolean update = false;
            if (!name.equals(fragment.getName())) {
                fragment.setName(name);
                update = true;
            }
            if (update) {
                this.updatePage(pageOrTemplate);
            }
            contentFragmentImpl.setName(name);
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void updatePosition(ContentFragment contentFragment, float x, float y, float z, float width, float height) {
        this.updatePosition(contentFragment, x, y, z, width, height, null, null);
    }

    public void updatePosition(ContentFragment contentFragment, float x, float y, float z, float width, float height, String scope, String scopeValue) {
        log.debug("PageLayoutComponentImpl.updatePosition() invoked");
        try {
            ContentFragmentImpl contentFragmentImpl = (ContentFragmentImpl)contentFragment;
            BaseFragmentElement fragment = this.lookupPageOrTemplateFragment(contentFragmentImpl, scope);
            boolean update = false;
            if (!PageLayoutComponentUtils.Utils.isNull(x) && x != fragment.getLayoutX()) {
                fragment.setLayoutX(scope, scopeValue, x);
                update = true;
            }
            if (!PageLayoutComponentUtils.Utils.isNull(y) && y != fragment.getLayoutY()) {
                fragment.setLayoutY(scope, scopeValue, y);
                update = true;
            }
            if (!PageLayoutComponentUtils.Utils.isNull(z) && z != fragment.getLayoutZ()) {
                fragment.setLayoutZ(scope, scopeValue, z);
                update = true;
            }
            if (!PageLayoutComponentUtils.Utils.isNull(width) && width != fragment.getLayoutWidth()) {
                fragment.setLayoutWidth(scope, scopeValue, width);
                update = true;
            }
            if (!PageLayoutComponentUtils.Utils.isNull(height) && height != fragment.getLayoutHeight()) {
                fragment.setLayoutHeight(scope, scopeValue, height);
                update = true;
            }
            if (update) {
                this.updatePageOrPageTemplateFragmentProperties(fragment, scope);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(x)) {
                contentFragmentImpl.setLayoutX(scope, scopeValue, x);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(y)) {
                contentFragmentImpl.setLayoutY(scope, scopeValue, y);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(z)) {
                contentFragmentImpl.setLayoutZ(scope, scopeValue, z);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(width)) {
                contentFragmentImpl.setLayoutWidth(scope, scopeValue, width);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(height)) {
                contentFragmentImpl.setLayoutWidth(scope, scopeValue, height);
            }
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void updatePreferences(ContentFragment contentFragment, Map preferences) {
        log.debug("PageLayoutComponentImpl.updatePreferences() invoked");
        try {
            String pageFragmentId;
            ContentFragmentImpl contentFragmentImpl = (ContentFragmentImpl)contentFragment;
            if (contentFragmentImpl.getDefinition() == null) {
                throw new IllegalArgumentException("Transient content fragments are not mutable");
            }
            if (!contentFragmentImpl.getDefinition().getPath().equals(contentFragmentImpl.getPageOrTemplate().getPath())) {
                throw new IllegalArgumentException("Only page fragments can be modified");
            }
            boolean contentFragmentIsReference = contentFragmentImpl.getReference() != null;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentFragmentImpl.getPageOrTemplate().getPath());
            BaseFragmentElement fragment = pageOrTemplate.getFragmentById(pageFragmentId = contentFragmentIsReference ? contentFragmentImpl.getReference().getId() : contentFragmentImpl.getFragment().getId());
            if (fragment == null) {
                throw new IllegalArgumentException("Fragment and page not consistent");
            }
            fragment.checkAccess(JetspeedActions.EDIT);
            fragment.getPreferences().clear();
            if (preferences != null) {
                for (Map.Entry preferencesEntry : preferences.entrySet()) {
                    FragmentPreference preference = this.pageManager.newFragmentPreference();
                    preference.setName((String)preferencesEntry.getKey());
                    Object values = preferencesEntry.getValue();
                    if (values instanceof String) {
                        preference.getValueList().add((String)values);
                    } else if (values instanceof String[]) {
                        preference.getValueList().addAll(Arrays.asList((String[])values));
                    } else if (values instanceof FragmentPreference) {
                        FragmentPreference fragmentPreference = (FragmentPreference)values;
                        preference.setReadOnly(fragmentPreference.isReadOnly());
                        preference.getValueList().addAll(fragmentPreference.getValueList());
                    } else if (values instanceof PortletPreference) {
                        PortletPreference portletPreference = (PortletPreference)values;
                        preference.setReadOnly(portletPreference.isReadOnly());
                        String[] prefValues = portletPreference.getValues();
                        if (prefValues != null) {
                            preference.getValueList().addAll(Arrays.asList(prefValues));
                        }
                    } else {
                        throw new IllegalArgumentException("Unexpected preference value type");
                    }
                    fragment.getPreferences().add(preference);
                }
            }
            this.updatePage(pageOrTemplate);
            contentFragmentImpl.setPreferences(preferences);
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void updateProperty(ContentFragment contentFragment, String propName, String propValue) {
        this.updateProperty(contentFragment, propName, propValue, null, null);
    }

    public void updateProperty(ContentFragment contentFragment, String propName, String propValue, String scope, String scopeValue) {
        log.debug("PageLayoutComponentImpl.updateProperty() invoked");
        try {
            ContentFragmentImpl contentFragmentImpl = (ContentFragmentImpl)contentFragment;
            BaseFragmentElement fragment = this.lookupPageOrTemplateFragment(contentFragmentImpl, scope);
            propValue = !PageLayoutComponentUtils.Utils.isNull(propValue) ? propValue : null;
            String currentPropValue = fragment.getProperty(propName, scope, scopeValue);
            if (propValue == null && currentPropValue != null || propValue != null && !propValue.equals(currentPropValue)) {
                fragment.setProperty(propName, scope, scopeValue, propValue);
                this.updatePageOrPageTemplateFragmentProperties(fragment, scope);
            }
            contentFragmentImpl.setProperty(propName, scope, scopeValue, propValue);
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void updateRefId(ContentFragment contentFragment, String refId) {
        log.debug("PageLayoutComponentImpl.updateRefId() invoked");
        try {
            String pageFragmentId;
            boolean contentFragmentIsReference;
            ContentFragmentImpl contentFragmentImpl = (ContentFragmentImpl)contentFragment;
            if (contentFragmentImpl.getDefinition() == null) {
                throw new IllegalArgumentException("Transient content fragments are not mutable");
            }
            boolean bl = contentFragmentIsReference = contentFragmentImpl.getReference() != null;
            if (contentFragmentIsReference && !contentFragmentImpl.getReferenceDefinition().getPath().equals(contentFragmentImpl.getPageOrTemplate().getPath()) || !contentFragmentIsReference && !contentFragmentImpl.getDefinition().getPath().equals(contentFragmentImpl.getPageOrTemplate().getPath())) {
                throw new IllegalArgumentException("Only page fragment references can be modified");
            }
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentFragmentImpl.getPageOrTemplate().getPath());
            BaseFragmentElement fragment = pageOrTemplate.getFragmentById(pageFragmentId = contentFragmentIsReference ? contentFragmentImpl.getReference().getId() : contentFragmentImpl.getFragment().getId());
            if (fragment == null) {
                throw new IllegalArgumentException("Fragment and page not consistent");
            }
            if (!(fragment instanceof FragmentReference)) {
                throw new IllegalArgumentException("Fragment reference required");
            }
            FragmentReference fragmentReference = (FragmentReference)fragment;
            fragmentReference.checkAccess(JetspeedActions.EDIT);
            boolean update = false;
            if (!refId.equals(fragmentReference.getRefId())) {
                fragmentReference.setRefId(refId);
                update = true;
            }
            if (update) {
                this.updatePage(pageOrTemplate);
            }
            contentFragmentImpl.setRefId(refId);
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void updateRowColumn(ContentFragment contentFragment, int row, int column) {
        this.updateRowColumn(contentFragment, row, column, null, null);
    }

    public void updateRowColumn(ContentFragment contentFragment, int row, int column, String scope, String scopeValue) {
        log.debug("PageLayoutComponentImpl.updateRowColumn() invoked");
        try {
            ContentFragmentImpl contentFragmentImpl = (ContentFragmentImpl)contentFragment;
            BaseFragmentElement fragment = this.lookupPageOrTemplateFragment(contentFragmentImpl, scope);
            boolean update = false;
            if (!PageLayoutComponentUtils.Utils.isNull(row) && row != fragment.getLayoutRow()) {
                fragment.setLayoutRow(scope, scopeValue, row);
                update = true;
            }
            if (!PageLayoutComponentUtils.Utils.isNull(column) && column != fragment.getLayoutColumn()) {
                fragment.setLayoutColumn(scope, scopeValue, column);
                update = true;
            }
            if (update) {
                this.updatePageOrPageTemplateFragmentProperties(fragment, scope);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(row)) {
                contentFragmentImpl.setLayoutRow(scope, scopeValue, row);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(column)) {
                contentFragmentImpl.setLayoutColumn(scope, scopeValue, column);
            }
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void updateSecurityConstraints(ContentFragment contentFragment, SecurityConstraints constraints) {
        log.debug("PageLayoutComponentImpl.updateSecurityConstraints() invoked");
        try {
            String pageFragmentId;
            ContentFragmentImpl contentFragmentImpl = (ContentFragmentImpl)contentFragment;
            if (contentFragmentImpl.getDefinition() == null) {
                throw new IllegalArgumentException("Transient content fragments are not mutable");
            }
            if (!contentFragmentImpl.getDefinition().getPath().equals(contentFragmentImpl.getPageOrTemplate().getPath())) {
                throw new IllegalArgumentException("Only page fragments can be modified");
            }
            boolean contentFragmentIsReference = contentFragmentImpl.getReference() != null;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentFragmentImpl.getPageOrTemplate().getPath());
            BaseFragmentElement fragment = pageOrTemplate.getFragmentById(pageFragmentId = contentFragmentIsReference ? contentFragmentImpl.getReference().getId() : contentFragmentImpl.getFragment().getId());
            if (fragment == null) {
                throw new IllegalArgumentException("Fragment and page not consistent");
            }
            fragment.checkAccess(JetspeedActions.EDIT);
            fragment.setSecurityConstraints(fragment.newSecurityConstraints());
            if (constraints != null && !constraints.isEmpty()) {
                List constraintsConstraintsRefs;
                List constraintsConstraints;
                SecurityConstraints fragmentConstraints = fragment.newSecurityConstraints();
                String constraintsOwner = constraints.getOwner();
                if (constraintsOwner != null) {
                    fragmentConstraints.setOwner(constraintsOwner);
                }
                if ((constraintsConstraints = constraints.getSecurityConstraints()) != null && !constraintsConstraints.isEmpty()) {
                    ArrayList<SecurityConstraint> fragmentConstraintsConstraints = new ArrayList<SecurityConstraint>(constraintsConstraints.size());
                    for (SecurityConstraint constraint : constraintsConstraints) {
                        SecurityConstraint fragmentConstraintsConstraint = fragment.newSecurityConstraint();
                        fragmentConstraintsConstraint.setGroups(constraint.getGroups());
                        fragmentConstraintsConstraint.setPermissions(constraint.getPermissions());
                        fragmentConstraintsConstraint.setRoles(constraint.getRoles());
                        fragmentConstraintsConstraint.setUsers(constraint.getUsers());
                        fragmentConstraintsConstraints.add(fragmentConstraintsConstraint);
                    }
                    fragmentConstraints.setSecurityConstraints(fragmentConstraintsConstraints);
                }
                if ((constraintsConstraintsRefs = constraints.getSecurityConstraintsRefs()) != null && !constraintsConstraintsRefs.isEmpty()) {
                    ArrayList<String> fragmentConstraintsConstraintsRefs = new ArrayList<String>(constraintsConstraintsRefs.size());
                    Iterator constraintsRefsIter = constraintsConstraintsRefs.iterator();
                    while (constraintsRefsIter.hasNext()) {
                        fragmentConstraintsConstraintsRefs.add((String)constraintsRefsIter.next());
                    }
                    fragmentConstraints.setSecurityConstraintsRefs(fragmentConstraintsConstraintsRefs);
                }
                fragment.setSecurityConstraints(fragmentConstraints);
            }
            this.updatePage(pageOrTemplate);
            contentFragmentImpl.setSecurityConstraints(constraints);
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void updateStateMode(ContentFragment contentFragment, String portletState, String portletMode) {
        this.updateStateMode(contentFragment, portletState, portletMode, null, null);
    }

    public void updateStateMode(ContentFragment contentFragment, String portletState, String portletMode, String scope, String scopeValue) {
        log.debug("PageLayoutComponentImpl.updateStateMode() invoked");
        try {
            ContentFragmentImpl contentFragmentImpl = (ContentFragmentImpl)contentFragment;
            BaseFragmentElement fragment = this.lookupPageOrTemplateFragment(contentFragmentImpl, scope);
            boolean update = false;
            if (!PageLayoutComponentUtils.Utils.isNull(portletState) && !portletState.equals(fragment.getState())) {
                fragment.setState(scope, scopeValue, portletState);
                update = true;
            }
            if (!PageLayoutComponentUtils.Utils.isNull(portletMode) && !portletMode.equals(fragment.getMode())) {
                fragment.setMode(scope, scopeValue, portletMode);
                update = true;
            }
            if (update) {
                this.updatePageOrPageTemplateFragmentProperties(fragment, scope);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(portletState)) {
                contentFragmentImpl.setState(scope, scopeValue, portletState);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(portletMode)) {
                contentFragmentImpl.setMode(scope, scopeValue, portletMode);
            }
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    public void updateTitles(ContentPage contentPage, String title, String shortTitle) {
        log.debug("PageLayoutComponentImpl.updateTitles() invoked");
        try {
            ContentPageImpl contentPageImpl = (ContentPageImpl)contentPage;
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentPageImpl.getPageOrTemplate().getPath());
            pageOrTemplate.checkAccess(JetspeedActions.EDIT);
            boolean update = false;
            if (!PageLayoutComponentUtils.Utils.isNull(title) && !title.equals(pageOrTemplate.getTitle())) {
                pageOrTemplate.setTitle(title);
                update = true;
            }
            if (!PageLayoutComponentUtils.Utils.isNull(shortTitle) && !shortTitle.equals(pageOrTemplate.getShortTitle())) {
                pageOrTemplate.setShortTitle(shortTitle);
                update = true;
            }
            if (update) {
                this.updatePage(pageOrTemplate);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(title)) {
                contentPageImpl.setTitle(title);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(shortTitle)) {
                contentPageImpl.setShortTitle(shortTitle);
            }
        }
        catch (Exception e) {
            throw new PageLayoutComponentException("Unexpected exception: " + e, e);
        }
    }

    private void mergeContentPageAttributes(ContentPageImpl contentPageImpl, BaseFragmentsElement pageOrTemplate) {
        if (contentPageImpl != null && pageOrTemplate != null) {
            BasePageElement page;
            BasePageElement basePageElement = page = pageOrTemplate instanceof BasePageElement ? (BasePageElement)pageOrTemplate : null;
            if (pageOrTemplate.getMetadata() != null && pageOrTemplate.getMetadata().getFields() != null) {
                for (LocalizedField field : pageOrTemplate.getMetadata().getFields()) {
                    Locale fieldLocale = field.getLocale();
                    String fieldName = field.getName();
                    if (fieldName == null) continue;
                    boolean containsField = false;
                    Iterator containsFieldIterator = contentPageImpl.getMetadata().getFields().iterator();
                    while (!containsField && containsFieldIterator.hasNext()) {
                        LocalizedField testField = (LocalizedField)containsFieldIterator.next();
                        Locale testFieldLocale = testField.getLocale();
                        String testFieldName = testField.getName();
                        containsField = fieldName.equals(testFieldName) && (fieldLocale == null && testFieldLocale == null || fieldLocale != null && fieldLocale.equals(testFieldLocale));
                    }
                    if (containsField) continue;
                    contentPageImpl.getMetadata().getFields().add(new ContentLocalizedFieldImpl(fieldLocale, fieldName, field.getValue()));
                }
            }
            if (page != null) {
                String layoutDefaultDecorator = contentPageImpl.getDefaultDecorator("layout");
                String portletDefaultDecorator = contentPageImpl.getDefaultDecorator("portlet");
                HashMap<String, String> defaultDecorators = null;
                if (layoutDefaultDecorator == null && (layoutDefaultDecorator = page.getDefaultDecorator("layout")) != null) {
                    if (defaultDecorators == null) {
                        defaultDecorators = new HashMap<String, String>();
                    }
                    defaultDecorators.put("layout", layoutDefaultDecorator);
                    if (portletDefaultDecorator != null) {
                        defaultDecorators.put("portlet", portletDefaultDecorator);
                    }
                }
                if (portletDefaultDecorator == null && (portletDefaultDecorator = page.getDefaultDecorator("portlet")) != null) {
                    if (defaultDecorators == null) {
                        defaultDecorators = new HashMap();
                    }
                    defaultDecorators.put("portlet", portletDefaultDecorator);
                    if (layoutDefaultDecorator != null) {
                        defaultDecorators.put("layout", layoutDefaultDecorator);
                    }
                }
                if (defaultDecorators != null) {
                    contentPageImpl.setDefaultDecorators(defaultDecorators);
                }
            }
            if (contentPageImpl.getShortTitle() == null) {
                contentPageImpl.setShortTitle(pageOrTemplate.getShortTitle());
            }
            if (contentPageImpl.getSkin() == null && page != null) {
                contentPageImpl.setSkin(page.getSkin());
            }
            if (contentPageImpl.getTitle() == null) {
                contentPageImpl.setTitle(pageOrTemplate.getTitle());
            }
        }
    }

    private ContentFragmentImpl newContentFragment(String parentId, BaseFragmentsElement pageOrTemplate, Map fragmentDefinitions, BaseFragmentsElement definition, BaseFragmentElement fragment, boolean template) {
        ContentFragmentImpl contentFragmentImpl = null;
        String contentFragmentId = null;
        if (fragment instanceof Fragment) {
            Fragment fragmentFragment = (Fragment)fragment;
            contentFragmentId = parentId != null ? parentId + "__" + fragmentFragment.getId() : fragmentFragment.getId();
            contentFragmentImpl = this.newContentFragment(contentFragmentId, pageOrTemplate, fragmentDefinitions, definition, fragmentFragment, null, null, template, template);
            this.mergeContentFragmentAttributes(contentFragmentImpl, (BaseFragmentElement)fragmentFragment);
            this.setContentFragmentSecurityConstraints(contentFragmentImpl, (BaseFragmentElement)fragmentFragment);
        } else if (fragment instanceof PageFragment) {
            PageFragment pageFragmentFragment = (PageFragment)fragment;
            String string = contentFragmentId = parentId != null ? parentId + "__" + pageFragmentFragment.getId() : pageFragmentFragment.getId();
            if (definition != pageOrTemplate || template) {
                BaseFragmentElement pageRootFragment = pageOrTemplate.getRootFragment();
                if (pageRootFragment instanceof FragmentReference) {
                    FragmentReference fragmentReferenceFragment = (FragmentReference)pageRootFragment;
                    contentFragmentId = contentFragmentId + "__" + fragmentReferenceFragment.getId();
                    Fragment[] fragmentFragment = new Fragment[]{null};
                    contentFragmentImpl = this.newContentFragment(contentFragmentId, pageOrTemplate, fragmentDefinitions, pageOrTemplate, fragmentReferenceFragment, template, fragmentFragment);
                    this.mergeContentFragmentAttributes(contentFragmentImpl, (BaseFragmentElement)pageFragmentFragment);
                    this.mergeContentFragmentAttributes(contentFragmentImpl, (BaseFragmentElement)fragmentReferenceFragment);
                    this.setContentFragmentSecurityConstraints(contentFragmentImpl, (BaseFragmentElement)fragmentReferenceFragment);
                    if (fragmentFragment[0] != null) {
                        this.mergeContentFragmentAttributes(contentFragmentImpl, (BaseFragmentElement)fragmentFragment[0]);
                    } else {
                        contentFragmentImpl.setType("reference");
                    }
                } else if (pageRootFragment instanceof Fragment) {
                    Fragment fragmentFragment = (Fragment)pageRootFragment;
                    contentFragmentId = contentFragmentId + "__" + fragmentFragment.getId();
                    contentFragmentImpl = this.newContentFragment(contentFragmentId, pageOrTemplate, fragmentDefinitions, pageOrTemplate, fragmentFragment, null, null, false, false);
                    this.mergeContentFragmentAttributes(contentFragmentImpl, (BaseFragmentElement)pageFragmentFragment);
                    this.mergeContentFragmentAttributes(contentFragmentImpl, (BaseFragmentElement)fragmentFragment);
                    this.setContentFragmentSecurityConstraints(contentFragmentImpl, (BaseFragmentElement)fragmentFragment);
                }
                if (!contentFragmentImpl.getType().equals("layout")) {
                    ContentFragmentImpl layoutContentFragmentImpl = this.newContentFragment("", pageOrTemplate, null, null, null, null, false, true);
                    layoutContentFragmentImpl.setType("layout");
                    layoutContentFragmentImpl.setName(this.defaultLayoutPortletName);
                    layoutContentFragmentImpl.getFragments().add(contentFragmentImpl);
                    contentFragmentImpl = layoutContentFragmentImpl;
                }
            } else {
                contentFragmentImpl = this.newContentFragment(contentFragmentId, pageOrTemplate, definition, (BaseFragmentElement)pageFragmentFragment, null, null, template, true);
                contentFragmentImpl.setType("page");
                this.mergeContentFragmentAttributes(contentFragmentImpl, (BaseFragmentElement)pageFragmentFragment);
                this.setContentFragmentSecurityConstraints(contentFragmentImpl, (BaseFragmentElement)pageFragmentFragment);
            }
        } else if (fragment instanceof FragmentReference) {
            FragmentReference fragmentReferenceFragment = (FragmentReference)fragment;
            contentFragmentId = parentId != null ? parentId + "__" + fragmentReferenceFragment.getId() : fragmentReferenceFragment.getId();
            Fragment[] fragmentFragment = new Fragment[]{null};
            contentFragmentImpl = this.newContentFragment(contentFragmentId, pageOrTemplate, fragmentDefinitions, definition, fragmentReferenceFragment, template, fragmentFragment);
            this.mergeContentFragmentAttributes(contentFragmentImpl, (BaseFragmentElement)fragmentReferenceFragment);
            this.setContentFragmentSecurityConstraints(contentFragmentImpl, (BaseFragmentElement)fragmentReferenceFragment);
            if (fragmentFragment[0] != null) {
                this.mergeContentFragmentAttributes(contentFragmentImpl, (BaseFragmentElement)fragmentFragment[0]);
            } else {
                contentFragmentImpl.setType("reference");
            }
        }
        return contentFragmentImpl;
    }

    private ContentFragmentImpl newContentFragment(String parentId, BaseFragmentsElement pageOrTemplate, Map fragmentDefinitions, BaseFragmentsElement definition, FragmentReference fragmentReference, boolean template, Fragment[] fragmentFragment) {
        ContentFragmentImpl contentFragmentImpl = null;
        FragmentDefinition fragmentDefinition = fragmentDefinitions != null ? fragmentDefinitions.get(fragmentReference.getRefId()) : null;
        if (fragmentDefinition != null && fragmentDefinition.getRootFragment() instanceof Fragment) {
            fragmentFragment[0] = (Fragment)fragmentDefinition.getRootFragment();
            String contentFragmentId = parentId + "__" + fragmentFragment[0].getId();
            contentFragmentImpl = this.newContentFragment(contentFragmentId, pageOrTemplate, fragmentDefinitions, (BaseFragmentsElement)fragmentDefinition, fragmentFragment[0], definition, fragmentReference, template, true);
        } else {
            contentFragmentImpl = this.newContentFragment(parentId, pageOrTemplate, definition, (BaseFragmentElement)fragmentReference, null, null, template, true);
        }
        contentFragmentImpl.setRefId(fragmentReference.getRefId());
        return contentFragmentImpl;
    }

    private ContentFragmentImpl newContentFragment(String parentId, BaseFragmentsElement pageOrTemplate, BaseFragmentsElement definition, FragmentReference fragmentReference) {
        String contentFragmentId = parentId + "__" + fragmentReference.getId();
        ContentFragmentImpl contentFragmentImpl = this.newContentFragment(contentFragmentId, pageOrTemplate, pageOrTemplate, (BaseFragmentElement)fragmentReference, null, null, false, true);
        contentFragmentImpl.setType("reference");
        contentFragmentImpl.setRefId(fragmentReference.getRefId());
        this.mergeContentFragmentAttributes(contentFragmentImpl, (BaseFragmentElement)fragmentReference);
        this.setContentFragmentSecurityConstraints(contentFragmentImpl, (BaseFragmentElement)fragmentReference);
        return contentFragmentImpl;
    }

    private ContentFragmentImpl newContentFragment(String id, BaseFragmentsElement pageOrTemplate, Map fragmentDefinitions, BaseFragmentsElement definition, Fragment fragment, BaseFragmentsElement referenceDefinition, FragmentReference reference, boolean template, boolean locked) {
        ContentFragmentImpl contentFragmentImpl = this.newContentFragment(id, pageOrTemplate, definition, (BaseFragmentElement)fragment, referenceDefinition, reference, template, locked);
        contentFragmentImpl.setName(fragment.getName());
        contentFragmentImpl.setType(fragment.getType());
        List fragments = fragment.getFragments();
        if (fragments != null) {
            for (BaseFragmentElement childFragment : fragments) {
                ContentFragmentImpl newContentFragment = this.newContentFragment(id, pageOrTemplate, fragmentDefinitions, definition, childFragment, template);
                if (newContentFragment == null) continue;
                contentFragmentImpl.getFragments().add(newContentFragment);
            }
        }
        return contentFragmentImpl;
    }

    private ContentFragmentImpl newContentFragment(String id, BaseFragmentsElement pageOrTemplate, BaseFragmentsElement definition, BaseFragmentElement fragment, BaseFragmentsElement referenceDefinition, FragmentReference reference, boolean template, boolean locked) {
        ContentFragmentImpl contentFragmentImpl = new ContentFragmentImpl(this, id, pageOrTemplate, definition, fragment, referenceDefinition, reference, template, locked);
        log.debug("PageLayoutComponentImpl.newContentFragment(): constructed ContentFragment: id=" + id + ", template=" + template + ", locked=" + locked);
        return contentFragmentImpl;
    }

    private void mergeContentFragmentAttributes(ContentFragmentImpl contentFragmentImpl, BaseFragmentElement fragment) {
        if (contentFragmentImpl != null && fragment != null) {
            if (contentFragmentImpl.getDecorator() == null) {
                contentFragmentImpl.setDecorator(fragment.getDecorator());
            }
            if (contentFragmentImpl.getLayoutColumn() < 0) {
                contentFragmentImpl.setLayoutColumn(fragment.getLayoutColumn());
            }
            if (contentFragmentImpl.getLayoutHeight() < 0.0f) {
                contentFragmentImpl.setLayoutHeight(fragment.getLayoutHeight());
            }
            if (contentFragmentImpl.getLayoutRow() < 0) {
                contentFragmentImpl.setLayoutRow(fragment.getLayoutRow());
            }
            if (contentFragmentImpl.getLayoutSizes() == null) {
                contentFragmentImpl.setLayoutSizes(fragment.getLayoutSizes());
            }
            if (contentFragmentImpl.getLayoutX() < 0.0f) {
                contentFragmentImpl.setLayoutX(fragment.getLayoutX());
            }
            if (contentFragmentImpl.getLayoutY() < 0.0f) {
                contentFragmentImpl.setLayoutY(fragment.getLayoutY());
            }
            if (contentFragmentImpl.getLayoutZ() < 0.0f) {
                contentFragmentImpl.setLayoutZ(fragment.getLayoutZ());
            }
            if (contentFragmentImpl.getLayoutWidth() < 0.0f) {
                contentFragmentImpl.setLayoutWidth(fragment.getLayoutWidth());
            }
            if (fragment.getProperties() != null) {
                Iterator propertiesIter = fragment.getProperties().iterator();
                while (propertiesIter.hasNext()) {
                    boolean foundProperty = false;
                    FragmentProperty fragmentProperty = (FragmentProperty)propertiesIter.next();
                    String name = fragmentProperty.getName();
                    String scope = fragmentProperty.getScope();
                    String scopeValue = fragmentProperty.getScopeValue();
                    Iterator scanPropertiesIter = contentFragmentImpl.getProperties().iterator();
                    while (!foundProperty && scanPropertiesIter.hasNext()) {
                        FragmentProperty scanFragmentProperty = (FragmentProperty)scanPropertiesIter.next();
                        String scanName = scanFragmentProperty.getName();
                        if (!name.equals(scanName)) continue;
                        String scanScope = scanFragmentProperty.getScope();
                        if (scope == null && scanScope == null) {
                            foundProperty = true;
                            continue;
                        }
                        if (scope == null || !scope.equals(scanScope)) continue;
                        String scanScopeValue = scanFragmentProperty.getScopeValue();
                        foundProperty = scopeValue != null && scopeValue.equals(scanScopeValue);
                    }
                    if (foundProperty) continue;
                    contentFragmentImpl.getProperties().add(new ContentFragmentPropertyImpl(name, scope, scopeValue, fragmentProperty.getValue()));
                }
            }
            if (contentFragmentImpl.getMode() == null) {
                contentFragmentImpl.setMode(fragment.getMode());
            }
            if (fragment.getPreferences() != null) {
                for (FragmentPreference preference : fragment.getPreferences()) {
                    String preferenceName = preference.getName();
                    if (preferenceName == null) continue;
                    boolean containsPreference = false;
                    Iterator containsPreferenceIter = contentFragmentImpl.getPreferences().iterator();
                    while (!containsPreference && containsPreferenceIter.hasNext()) {
                        containsPreference = preferenceName.equals(((FragmentPreference)containsPreferenceIter.next()).getName());
                    }
                    if (containsPreference) continue;
                    contentFragmentImpl.getPreferences().add(new ContentFragmentPreferenceImpl(preferenceName, preference.isReadOnly(), preference.getValueList()));
                }
            }
            if (contentFragmentImpl.getShortTitle() == null) {
                contentFragmentImpl.setShortTitle(fragment.getShortTitle());
            }
            if (contentFragmentImpl.getSkin() == null) {
                contentFragmentImpl.setSkin(fragment.getSkin());
            }
            if (contentFragmentImpl.getState() == null) {
                contentFragmentImpl.setState(fragment.getState());
            }
            if (contentFragmentImpl.getTitle() == null) {
                contentFragmentImpl.setTitle(fragment.getTitle());
            }
        }
    }

    private void setContentFragmentSecurityConstraints(ContentFragmentImpl contentFragmentImpl, BaseFragmentElement fragment) {
        SecurityConstraints fragmentConstraints;
        if (contentFragmentImpl != null && fragment != null && (fragmentConstraints = fragment.getSecurityConstraints()) != null && !fragmentConstraints.isEmpty()) {
            String contentConstraintsOwner = fragmentConstraints.getOwner();
            ArrayList<ContentSecurityConstraint> contentConstraintsConstraints = null;
            List fragmentConstraintsConstraints = fragmentConstraints.getSecurityConstraints();
            if (fragmentConstraintsConstraints != null && !fragmentConstraintsConstraints.isEmpty()) {
                contentConstraintsConstraints = new ArrayList<ContentSecurityConstraint>(fragmentConstraintsConstraints.size());
                for (SecurityConstraint fragmentConstraint : fragmentConstraintsConstraints) {
                    contentConstraintsConstraints.add(new ContentSecurityConstraint(false, fragmentConstraint.getGroups(), fragmentConstraint.getPermissions(), fragmentConstraint.getRoles(), fragmentConstraint.getUsers()));
                }
            }
            ArrayList<String> contentConstraintsConstraintsRefs = null;
            List fragmentConstraintsConstraintsRefs = fragmentConstraints.getSecurityConstraintsRefs();
            if (fragmentConstraintsConstraintsRefs != null && !fragmentConstraintsConstraintsRefs.isEmpty()) {
                contentConstraintsConstraintsRefs = new ArrayList<String>(fragmentConstraintsConstraintsRefs.size());
                Iterator constraintsRefsIter = fragmentConstraintsConstraintsRefs.iterator();
                while (constraintsRefsIter.hasNext()) {
                    contentConstraintsConstraintsRefs.add((String)constraintsRefsIter.next());
                }
            }
            ContentSecurityConstraints contentConstraints = new ContentSecurityConstraints(false, contentConstraintsOwner, contentConstraintsConstraints, contentConstraintsConstraintsRefs);
            contentFragmentImpl.setSecurityConstraints(contentConstraints);
        }
    }

    private boolean shiftDocumentOrder(Folder folder, String documentName, String documentType, boolean decrement) {
        ArrayList<String> documentOrder = folder.getDocumentOrder();
        if (documentOrder == null) {
            documentOrder = new ArrayList<String>(4);
            folder.setDocumentOrder(documentOrder);
        }
        ListIterator orderIter = decrement ? documentOrder.listIterator() : documentOrder.listIterator(documentOrder.size());
        String lastOrderedDocumentName = null;
        int lastOrderedDocumentIndex = -1;
        while (decrement ? orderIter.hasNext() : orderIter.hasPrevious()) {
            int orderedDocumentIndex = decrement ? orderIter.nextIndex() : orderIter.previousIndex();
            String orderedDocumentName = (String)(decrement ? orderIter.next() : orderIter.previous());
            if (orderedDocumentName.equals(documentName)) {
                boolean update = false;
                if (lastOrderedDocumentIndex != -1) {
                    documentOrder.set(orderedDocumentIndex, lastOrderedDocumentName);
                    documentOrder.set(lastOrderedDocumentIndex, orderedDocumentName);
                    update = true;
                }
                return update;
            }
            if ((documentType == null || !orderedDocumentName.endsWith(documentType)) && (documentType != null || orderedDocumentName.indexOf(46) != -1)) continue;
            lastOrderedDocumentIndex = orderedDocumentIndex;
            lastOrderedDocumentName = orderedDocumentName;
        }
        documentOrder.add(documentName);
        return true;
    }

    private boolean removeDocumentOrder(Folder folder, String documentName) {
        List documentOrder = folder.getDocumentOrder();
        if (documentOrder != null) {
            Iterator orderIter = documentOrder.iterator();
            while (orderIter.hasNext()) {
                String orderedDocumentName = (String)orderIter.next();
                if (!orderedDocumentName.equals(documentName)) continue;
                orderIter.remove();
                return true;
            }
        }
        return false;
    }

    private BaseFragmentElement lookupPageOrTemplateFragment(ContentFragmentImpl contentFragmentImpl, String scope) throws PageNotFoundException, NodeException {
        boolean userScopedUpdate;
        if (contentFragmentImpl.getDefinition() == null) {
            throw new IllegalArgumentException("Transient content fragments are not mutable");
        }
        String contentPageOrTemplatePath = contentFragmentImpl.getPageOrTemplate().getPath();
        String contentPageOrTemplateDefinitionPath = contentFragmentImpl.getDefinition().getPath();
        boolean contentFragmentPageDefinition = false;
        boolean contentFragmentPageReference = false;
        boolean contentFragmentInPage = false;
        if (!contentFragmentImpl.isTemplate()) {
            contentFragmentPageDefinition = contentPageOrTemplateDefinitionPath.equals(contentPageOrTemplatePath);
            contentFragmentPageReference = contentFragmentImpl.getDefinition() instanceof FragmentDefinition && !contentPageOrTemplateDefinitionPath.equals(contentPageOrTemplatePath) && contentFragmentImpl.getReferenceDefinition() != null && contentFragmentImpl.getReferenceDefinition().getPath().equals(contentPageOrTemplatePath) && contentFragmentImpl.getReference() != null;
            contentFragmentInPage = contentFragmentPageDefinition || contentFragmentPageReference;
        }
        boolean contentFragmentTemplateDefinition = false;
        boolean contentFragmentTemplateReference = false;
        boolean contentFragmentInTemplate = false;
        if (!contentFragmentInPage) {
            contentFragmentTemplateDefinition = contentFragmentImpl.getDefinition() instanceof PageTemplate;
            contentFragmentTemplateReference = contentFragmentImpl.getDefinition() instanceof FragmentDefinition && contentFragmentImpl.getReferenceDefinition() instanceof PageTemplate && contentFragmentImpl.getReference() != null;
            contentFragmentInTemplate = contentFragmentTemplateDefinition || contentFragmentTemplateReference;
        }
        boolean bl = userScopedUpdate = scope != null && scope.equals("user");
        if (!(contentFragmentInPage || userScopedUpdate && contentFragmentInTemplate)) {
            if (userScopedUpdate) {
                throw new IllegalArgumentException("Only page fragments, fragment references, template fragments, and template references are user scope mutable");
            }
            throw new IllegalArgumentException("Only page fragments and fragment references are mutable");
        }
        BaseFragmentElement fragment = null;
        if (contentFragmentInPage) {
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate(contentFragmentImpl.getPageOrTemplate().getPath());
            String pageFragmentId = contentFragmentPageDefinition ? contentFragmentImpl.getFragment().getId() : contentFragmentImpl.getReference().getId();
            fragment = pageOrTemplate.getFragmentById(pageFragmentId);
        } else if (contentFragmentInTemplate) {
            String pageTemplatePath = contentFragmentTemplateDefinition ? contentFragmentImpl.getDefinition().getPath() : contentFragmentImpl.getReferenceDefinition().getPath();
            PageTemplate pageTemplate = this.pageManager.getPageTemplate(pageTemplatePath);
            String pageTemplateFragmentId = contentFragmentTemplateDefinition ? contentFragmentImpl.getFragment().getId() : contentFragmentImpl.getReference().getId();
            fragment = pageTemplate.getFragmentById(pageTemplateFragmentId);
        }
        if (fragment == null) {
            throw new IllegalArgumentException("Fragment and page not consistent");
        }
        boolean checkEditAccess = scope == null || !scope.equals("user");
        fragment.checkAccess(checkEditAccess ? JetspeedActions.EDIT : JetspeedActions.VIEW);
        return fragment;
    }

    private void updatePageOrPageTemplateFragmentProperties(BaseFragmentElement fragment, String scope) throws PageNotUpdatedException, NodeException {
        this.pageManager.updateFragmentProperties(fragment, scope);
    }

    private BaseFragmentsElement getPageOrTemplate(String path) throws PageNotFoundException, NodeException {
        if (path.endsWith(".psml")) {
            return this.pageManager.getPage(path);
        }
        if (path.endsWith(".dpsml")) {
            return this.pageManager.getDynamicPage(path);
        }
        if (path.endsWith(".tpsml")) {
            return this.pageManager.getPageTemplate(path);
        }
        if (path.endsWith(".fpsml")) {
            return this.pageManager.getFragmentDefinition(path);
        }
        throw new PageNotFoundException("Unable to classify page or template path by type: " + path);
    }

    private void updatePage(BaseFragmentsElement pageOrTemplate) throws NodeException, PageNotUpdatedException {
        if (pageOrTemplate instanceof Page) {
            this.pageManager.updatePage((Page)pageOrTemplate);
            return;
        }
        if (pageOrTemplate instanceof DynamicPage) {
            this.pageManager.updateDynamicPage((DynamicPage)pageOrTemplate);
            return;
        }
        if (pageOrTemplate instanceof PageTemplate) {
            this.pageManager.updatePageTemplate((PageTemplate)pageOrTemplate);
            return;
        }
        if (pageOrTemplate instanceof FragmentDefinition) {
            this.pageManager.updateFragmentDefinition((FragmentDefinition)pageOrTemplate);
            return;
        }
        throw new PageNotUpdatedException("Unable to classify page by type: " + (pageOrTemplate != null ? pageOrTemplate.getClass().getName() : "null"));
    }

    private void removePage(BaseFragmentsElement pageOrTemplate) throws NodeException, PageNotRemovedException {
        if (pageOrTemplate instanceof Page) {
            this.pageManager.removePage((Page)pageOrTemplate);
            return;
        }
        if (pageOrTemplate instanceof DynamicPage) {
            this.pageManager.removeDynamicPage((DynamicPage)pageOrTemplate);
            return;
        }
        if (pageOrTemplate instanceof PageTemplate) {
            this.pageManager.removePageTemplate((PageTemplate)pageOrTemplate);
            return;
        }
        if (pageOrTemplate instanceof FragmentDefinition) {
            this.pageManager.removeFragmentDefinition((FragmentDefinition)pageOrTemplate);
            return;
        }
        throw new PageNotRemovedException("Unable to classify page by type: " + (pageOrTemplate != null ? pageOrTemplate.getClass().getName() : "null"));
    }
}

