/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.maven.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.jetspeed.maven.utils.FileEntry;

public class FileEntryCollection {
    private ZipFile zipFile;
    private File folder;

    public FileEntryCollection(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public FileEntryCollection(File folder) {
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("Folder not found: " + folder);
        }
        this.folder = folder;
    }

    public String getName() {
        if (this.zipFile != null) {
            return this.zipFile.getName();
        }
        return this.folder.getPath();
    }

    public Enumeration<? extends FileEntry> entries() {
        if (this.zipFile != null) {
            return new ZipFileEntryEnumeration(this.zipFile.entries());
        }
        return new FolderFileEntryEnumeration(this.folder);
    }

    public InputStream getInputStream(FileEntry entry) throws IOException {
        if (this.zipFile != null) {
            return this.zipFile.getInputStream((ZipEntry)entry.getEntryObject());
        }
        return new FileInputStream((File)entry.getEntryObject());
    }

    private static class FolderFileEntryEnumeration
    implements Enumeration<FileEntry> {
        private File folder;
        private List<String> entryNames;
        private Iterator<String> entryNameIterator;

        public FolderFileEntryEnumeration(File folder) {
            this.folder = folder;
            this.entryNames = new LinkedList<String>();
            this.fillEntryNames(folder.getPath(), folder, this.entryNames);
            this.entryNameIterator = this.entryNames.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.entryNameIterator.hasNext();
        }

        @Override
        public FileEntry nextElement() {
            String entryName = this.entryNameIterator.next();
            return new FileEntry(new File(this.folder, entryName), entryName);
        }

        private void fillEntryNames(String basePath, File folder, List<String> entryNames) {
            File[] children = folder.listFiles();
            if (children != null) {
                for (File child : children) {
                    String name = child.getPath();
                    if (!name.startsWith(basePath)) {
                        throw new IllegalStateException("Child file path does not starts with base path. (" + name + ", " + basePath + ")");
                    }
                    name = name.substring(basePath.length());
                    if (!"/".equals(File.separator)) {
                        name = name.replace(File.separator, "/");
                    }
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    entryNames.add(name);
                    if (!child.isDirectory()) continue;
                    this.fillEntryNames(basePath, child, entryNames);
                }
            }
        }
    }

    private static class ZipFileEntryEnumeration
    implements Enumeration<FileEntry> {
        private Enumeration<? extends ZipEntry> zipEntries;

        public ZipFileEntryEnumeration(Enumeration<? extends ZipEntry> zipEntries) {
            this.zipEntries = zipEntries;
        }

        @Override
        public boolean hasMoreElements() {
            return this.zipEntries.hasMoreElements();
        }

        @Override
        public FileEntry nextElement() {
            return new FileEntry(this.zipEntries.nextElement());
        }
    }
}

