/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.deploy;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class JetspeedWebApplicationRewriter {
    public static final String JETSPEED_CONTAINER = "JetspeedContainer";
    public static final String JETSPEED_SERVLET_CLASS = "org.apache.jetspeed.container.JetspeedContainerServlet";
    public static final String JETSPEED_SERVLET_DISPLAY_NAME = "Jetspeed Container";
    public static final String JETSPEED_SERVLET_DESCRIPTION = "MVC Servlet for Jetspeed Portlet Applications";
    public static final String NAMESPACE_PREFIX = "js";
    protected static final String WEB_XML_PATH = "WEB-INF/web.xml";
    private Document document;
    private String namespace;
    private String prefix;
    private Element root;
    private String portletApplication;
    private boolean changed = false;
    private boolean portletTaglibAdded = false;
    private boolean portlet20TaglibAdded = false;
    private XPath xpath;

    public JetspeedWebApplicationRewriter(Document doc, String portletApplication) {
        this(doc);
        this.portletApplication = portletApplication;
    }

    public JetspeedWebApplicationRewriter(Document doc) {
        this.document = doc;
        this.root = doc.getDocumentElement();
        this.namespace = this.root.getNamespaceURI();
        this.xpath = XPathFactory.newInstance().newXPath();
        if (this.namespace != null && this.namespace.length() > 0) {
            this.prefix = "js:";
            this.xpath.setNamespaceContext(new XPathNamespaceContext(NAMESPACE_PREFIX, this.namespace));
        } else {
            this.prefix = "";
            this.xpath.setNamespaceContext(new XPathNamespaceContext(""));
        }
    }

    public void processWebXML() throws Exception {
        try {
            Element root = this.document.getDocumentElement();
            Object jetspeedServlet = this.xpath.evaluate(this.getJetspeedServletXPath(), this.document, XPathConstants.NODE);
            Object jetspeedServletMapping = this.xpath.evaluate(this.getJetspeedServletMappingXPath(), this.document, XPathConstants.NODE);
            Object portletTaglib = this.xpath.evaluate(this.getPortletTagLibXPath(), this.document, XPathConstants.NODE);
            Object portlet20Taglib = this.xpath.evaluate(this.getPortlet20TagLibXPath(), this.document, XPathConstants.NODE);
            if (!this.document.hasChildNodes()) {
                root = this.document.createElement("web-app");
                this.document.appendChild(root);
            }
            if (jetspeedServlet == null) {
                this.insertJetspeedServlet(root);
                this.changed = true;
            } else if (jetspeedServlet instanceof Element) {
                Element jetspeedServletElement = (Element)((Element)jetspeedServlet).getParentNode();
                if (null == this.xpath.evaluate(this.prefix + "init-param/" + this.prefix + "param-name[contains(child::text(), \"contextName\")]", jetspeedServletElement, XPathConstants.NODE)) {
                    this.insertContextNameParam(jetspeedServletElement);
                }
                if (null == this.xpath.evaluate(this.prefix + "load-on-startup", jetspeedServletElement, XPathConstants.NODE)) {
                    this.insertLoadOnStartup(jetspeedServletElement);
                }
            }
            if (jetspeedServletMapping == null) {
                this.insertJetspeedServletMapping(root);
                this.changed = true;
            }
            if (portletTaglib == null) {
                this.insertPortletTagLib(root);
                this.changed = true;
                this.portletTaglibAdded = true;
            }
            if (portlet20Taglib == null) {
                this.insertPortlet20TagLib(root);
                this.changed = true;
                this.portlet20TaglibAdded = true;
            }
        }
        catch (Exception e) {
            throw new Exception("Unable to process web.xml for infusion " + e.toString(), e);
        }
    }

    protected void insertContextNameParam(Element jetspeedServletElement) {
        String namespace = jetspeedServletElement.getNamespaceURI();
        Element init2Param = jetspeedServletElement.getOwnerDocument().createElementNS(namespace, "init-param");
        jetspeedServletElement.appendChild(init2Param);
        Element param2Name = jetspeedServletElement.getOwnerDocument().createElementNS(namespace, "param-name");
        param2Name.setTextContent("contextName");
        Element param2Value = jetspeedServletElement.getOwnerDocument().createElementNS(namespace, "param-value");
        param2Value.setTextContent(this.portletApplication);
        init2Param.appendChild(param2Name);
        init2Param.appendChild(param2Value);
    }

    protected void insertLoadOnStartup(Element jetspeedServletElement) {
        String namespace = jetspeedServletElement.getNamespaceURI();
        Element loadOnStartup = jetspeedServletElement.getOwnerDocument().createElementNS(namespace, "load-on-startup");
        loadOnStartup.setTextContent("0");
        jetspeedServletElement.appendChild(loadOnStartup);
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void insertElementCorrectly(Element root, Element toInsert, String[] elementsBefore) {
        NodeList allChildren = root.getChildNodes();
        List<String> elementsBeforeList = Arrays.asList(elementsBefore);
        Node insertBefore = null;
        for (int i = 0; i < allChildren.getLength(); ++i) {
            Node node = allChildren.item(i);
            if (insertBefore == null) {
                insertBefore = node;
            }
            if (node.getNodeType() != 1) continue;
            if (!elementsBeforeList.contains(node.getNodeName())) break;
            insertBefore = null;
        }
        if (insertBefore == null) {
            root.appendChild(toInsert);
        } else {
            root.insertBefore(toInsert, insertBefore);
        }
    }

    protected String getNamespacePrefix() {
        return this.prefix;
    }

    public boolean isPortletTaglibAdded() {
        return this.portletTaglibAdded;
    }

    public boolean isPortlet20TaglibAdded() {
        return this.portlet20TaglibAdded;
    }

    protected XPath getXPath() {
        return this.xpath;
    }

    protected abstract String getJetspeedServletXPath();

    protected abstract String getJetspeedServletMappingXPath();

    protected abstract String getPortletTagLibXPath();

    protected abstract String getPortlet20TagLibXPath();

    protected abstract void insertJetspeedServlet(Element var1) throws Exception;

    protected abstract void insertJetspeedServletMapping(Element var1) throws Exception;

    protected abstract void insertPortletTagLib(Element var1) throws Exception;

    protected abstract void insertPortlet20TagLib(Element var1) throws Exception;

    private static class XPathNamespaceContext
    implements NamespaceContext {
        private String namespaceURI;
        private String prefix;

        public XPathNamespaceContext(String prefix) {
            this(prefix, "http://www.w3.org/XML/1998/namespace");
        }

        public XPathNamespaceContext(String prefix, String namespaceURI) {
            this.prefix = prefix;
            this.namespaceURI = namespaceURI;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new NullPointerException("Null prefix");
            }
            if (this.prefix.equals(prefix)) {
                return this.namespaceURI;
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            return "";
        }

        @Override
        public String getPrefix(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException();
        }
    }
}

