/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jetspeed.tools.deploy.Deploy;
import org.apache.jetspeed.tools.deploy.JetspeedContextRewriter;
import org.apache.jetspeed.tools.deploy.JetspeedWebApplicationRewriterFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JetspeedDeploy
implements Deploy {
    private final byte[] buffer;

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            JetspeedDeploy.printUsage();
            System.exit(1);
            return;
        }
        boolean stripLoggers = false;
        String version = null;
        for (int i = 0; i < args.length - 3; ++i) {
            String option = args[i];
            if (option.equals("-s")) {
                stripLoggers = true;
                continue;
            }
            if (option.equals("-v") && i < args.length - 4) {
                version = args[i + 1];
                ++i;
                continue;
            }
            JetspeedDeploy.printUsage();
            System.exit(1);
            return;
        }
        new JetspeedDeploy(args[args.length - 3], args[args.length - 2], args[args.length - 1], stripLoggers, version);
    }

    private static void printUsage() {
        System.out.println("Usage: java -jar jetspeed-deploy-tools-<version>.jar [options] INPUT OUTPUT CONTEXT");
        System.out.println("Options:");
        System.out.println("  -s: stripLoggers - remove commons-logging[version].jar and/or log4j[version].jar from war");
        System.out.println("                     (required when targetting application servers like JBoss)");
        System.out.println("  -v VERSION: force servlet specification version to handle web.xml");
        System.out.println("                     (default will automatically determine version)");
    }

    public JetspeedDeploy(String inputName, String outputName, String contextName, boolean stripLoggers) throws Exception {
        this(inputName, outputName, contextName, stripLoggers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JetspeedDeploy(String inputName, String outputName, String contextName, boolean stripLoggers, String forcedVersion) throws Exception {
        block53: {
            block52: {
                block51: {
                    block46: {
                        super();
                        this.buffer = new byte[4096];
                        tempFile = null;
                        jin = null;
                        jout = null;
                        srcChannel = null;
                        dstChannel = null;
                        try {
                            portletApplicationName = contextName;
                            tempFile = File.createTempFile(portletApplicationName, "");
                            tempFile.deleteOnExit();
                            jin = new JarFile(inputName);
                            jout = new JarOutputStream(new FileOutputStream(tempFile));
                            webXml = null;
                            portletXml = null;
                            contextXml = null;
                            taglibFound = false;
                            taglib2Found = false;
                            zipEntries = jin.entries();
                            while (zipEntries.hasMoreElements()) {
                                block44: {
                                    block45: {
                                        src = zipEntries.nextElement();
                                        source = jin.getInputStream(src);
                                        try {
                                            target = src.getName();
                                            if ("WEB-INF/web.xml".equals(target)) {
                                                System.out.println("Found web.xml");
                                                webXml = this.parseXml(source);
                                                break block44;
                                            }
                                            if ("WEB-INF/portlet.xml".equals(target)) {
                                                System.out.println("Found WEB-INF/portlet.xml");
                                                portletXml = this.parseXml(source);
                                                break block44;
                                            }
                                            if ("META-INF/context.xml".equals(target)) {
                                                System.out.println("Found META-INF/context.xml");
                                                contextXml = this.parseXml(source);
                                                break block44;
                                            }
                                            if (stripLoggers && target.endsWith(".jar") && (target.startsWith("WEB-INF/lib/commons-logging") || target.startsWith("WEB-INF/lib/log4j"))) {
                                                System.out.println("Stripping logger " + target);
                                                var22_21 = null;
                                                break block45;
                                            }
                                            if ("WEB-INF/tld/portlet.tld".equals(target)) {
                                                System.out.println("Warning: WEB-INF/tld/portlet.tld already provided, won't be replaced.");
                                                taglibFound = true;
                                            } else if ("WEB-INF/tld/portlet_2_0.tld".equals(target)) {
                                                System.out.println("Warning: WEB-INF/tld/portlet_2_0.tld already provided, won't be replaced.");
                                                taglib2Found = true;
                                            }
                                            this.addFile(target, source, (JarOutputStream)jout, src.getTime());
                                            break block44;
                                        }
                                        catch (Throwable var21_22) {
                                            var22_21 = null;
                                            source.close();
                                            throw var21_22;
                                        }
                                    }
                                    source.close();
                                    continue;
                                }
                                var22_21 = null;
                                source.close();
                            }
                            if (webXml == null) {
                                throw new IllegalArgumentException("WEB-INF/web.xml");
                            }
                            if (portletXml == null) {
                                throw new IllegalArgumentException("WEB-INF/portlet.xml");
                            }
                            webRewriterFactory = new JetspeedWebApplicationRewriterFactory();
                            webRewriter = webRewriterFactory.getInstance(webXml, portletApplicationName, forcedVersion);
                            webRewriter.processWebXML();
                            contextRewriter = new JetspeedContextRewriter(contextXml, portletApplicationName);
                            contextRewriter.processContextXML();
                            this.addFile("WEB-INF/web.xml", webXml, (JarOutputStream)jout);
                            this.addFile("WEB-INF/portlet.xml", portletXml, (JarOutputStream)jout);
                            this.addFile("META-INF/context.xml", contextXml, (JarOutputStream)jout);
                            if (!taglibFound) {
                                System.out.println("Attempting to add portlet.tld to war...");
                                is = this.getClass().getResourceAsStream("/org/apache/jetspeed/tools/deploy/portlet.tld");
                                if (is == null) {
                                    System.out.println("Failed to find portlet.tld in classpath");
                                } else {
                                    System.out.println("Adding portlet.tld to war...");
                                    try {
                                        this.addFile("WEB-INF/tld/portlet.tld", is, (JarOutputStream)jout, 0L);
                                        var25_25 = null;
                                    }
                                    catch (Throwable var24_27) {
                                        var25_26 = null;
                                        is.close();
                                        throw var24_27;
                                    }
                                    is.close();
                                }
                            }
                            if (!taglib2Found) {
                                System.out.println("Attempting to add portlet_2_0.tld to war...");
                                is = this.getClass().getResourceAsStream("/org/apache/jetspeed/tools/deploy/portlet_2_0.tld");
                                if (is == null) {
                                    System.out.println("Failed to find portlet_2_0.tld in classpath");
                                } else {
                                    System.out.println("Adding portlet_2_0.tld to war...");
                                    try {
                                        this.addFile("WEB-INF/tld/portlet_2_0.tld", is, (JarOutputStream)jout, 0L);
                                        var27_28 = null;
                                    }
                                    catch (Throwable var26_30) {
                                        var27_29 = null;
                                        is.close();
                                        throw var26_30;
                                    }
                                    is.close();
                                }
                            }
                            jout.close();
                            jin.close();
                            jin = null;
                            jout = null;
                            System.out.println("Creating war " + outputName + " ...");
                            System.out.flush();
                            srcChannel = new FileInputStream(tempFile).getChannel();
                            dstChannel = new FileOutputStream(outputName).getChannel();
                            dstChannel.transferFrom((ReadableByteChannel)srcChannel, 0L, srcChannel.size());
                            srcChannel.close();
                            srcChannel = null;
                            dstChannel.close();
                            dstChannel = null;
                            tempFile.delete();
                            tempFile = null;
                            System.out.println("War " + outputName + " created");
                            System.out.flush();
                            var29_31 = null;
                            if (srcChannel == null) break block46;
                        }
                        catch (Throwable var28_35) {
                            var29_32 = null;
                            if (srcChannel != null && srcChannel.isOpen()) {
                                try {
                                    srcChannel.close();
                                }
                                catch (IOException e1) {
                                    // empty catch block
                                }
                            }
                            if (dstChannel != null && dstChannel.isOpen()) {
                                try {
                                    dstChannel.close();
                                }
                                catch (IOException e1) {
                                    // empty catch block
                                }
                            }
                            if (jin != null) {
                                try {
                                    jin.close();
                                    jin = null;
                                }
                                catch (IOException e1) {
                                    // empty catch block
                                }
                            }
                            if (jout != null) {
                                try {
                                    jout.close();
                                    jout = null;
                                }
                                catch (IOException e1) {
                                    // empty catch block
                                }
                            }
                            if (tempFile == null) throw var28_35;
                            if (tempFile.exists() == false) throw var28_35;
                            tempFile.delete();
                            throw var28_35;
                        }
                        if (srcChannel.isOpen()) {
                            ** try [egrp 4[TRYBLOCK] [9 : 825->833)] { 
lbl175:
                            // 1 sources

                            srcChannel.close();
                            break block46;
lbl177:
                            // 1 sources

                            catch (IOException e1) {
                                // empty catch block
                            }
                        }
                    }
                    if (dstChannel != null && dstChannel.isOpen()) {
                        ** try [egrp 5[TRYBLOCK] [10 : 848->856)] { 
lbl182:
                        // 1 sources

                        dstChannel.close();
                        break block51;
lbl184:
                        // 1 sources

                        catch (IOException e1) {
                            // empty catch block
                        }
                    }
                }
                if (jin != null) {
                    ** try [egrp 6[TRYBLOCK] [11 : 863->874)] { 
lbl189:
                    // 1 sources

                    jin.close();
                    jin = null;
                    break block52;
lbl192:
                    // 1 sources

                    catch (IOException e1) {
                        // empty catch block
                    }
                }
            }
            if (jout != null) {
                ** try [egrp 7[TRYBLOCK] [12 : 881->892)] { 
lbl197:
                // 1 sources

                jout.close();
                jout = null;
                break block53;
lbl200:
                // 1 sources

                catch (IOException e1) {
                    // empty catch block
                }
            }
        }
        if (tempFile == null) return;
        if (tempFile.exists() == false) return;
        tempFile.delete();
    }

    protected Document parseXml(InputStream source) throws Exception {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.equals("http://java.sun.com/dtd/web-app_2_3.dtd")) {
                    return new InputSource(this.getClass().getResourceAsStream("web-app_2_3.dtd"));
                }
                return null;
            }
        });
        Document document = builder.parse(source);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFile(String path, InputStream source, JarOutputStream jos, long fileTime) throws IOException {
        ZipEntry ze = new ZipEntry(path);
        if (fileTime > 0L) {
            ze.setTime(fileTime);
        }
        jos.putNextEntry(ze);
        try {
            int count;
            while ((count = source.read(this.buffer)) > 0) {
                jos.write(this.buffer, 0, count);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            jos.closeEntry();
            throw throwable;
        }
        jos.closeEntry();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addFile(String path, Document source, JarOutputStream jos) throws IOException {
        if (source == null) return;
        try {
            try {
                jos.putNextEntry(new ZipEntry(path));
                DOMSource domSource = new DOMSource(source);
                StreamResult streamResult = new StreamResult(jos);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("method", "xml");
                if (source.getDoctype() != null) {
                    transformer.setOutputProperty("doctype-public", source.getDoctype().getPublicId());
                    transformer.setOutputProperty("doctype-system", source.getDoctype().getSystemId());
                }
                transformer.setOutputProperty("media-type", "text/xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(domSource, streamResult);
            }
            catch (TransformerConfigurationException e) {
                throw new IOException(e.getMessage());
            }
            catch (TransformerException e) {
                throw new IOException(e.getMessage());
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            jos.closeEntry();
            throw throwable;
        }
        jos.closeEntry();
    }
}

